/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.restcomm.connect.commons.common.http.CustomHttpClientBuilder;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.configuration.sets.MainConfigurationSet;
import org.restcomm.connect.commons.faulttolerance.RestcommUntypedActor;
import org.restcomm.connect.commons.util.StringUtils;
import org.restcomm.connect.http.client.DownloaderResponse;
import org.restcomm.connect.http.client.HttpRequestDescriptor;
import org.restcomm.connect.http.client.HttpResponseDescriptor;
import org.xml.sax.InputSource;

public final class Downloader
extends RestcommUntypedActor {
    public static final int LOGGED_RESPONSE_MAX_SIZE = 100;
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));

    public HttpResponseDescriptor fetch(HttpRequestDescriptor descriptor) throws IllegalArgumentException, IOException, URISyntaxException, XMLStreamException {
        int code = -1;
        HttpUriRequest request = null;
        CloseableHttpResponse response = null;
        HttpRequestDescriptor temp = descriptor;
        CloseableHttpClient client = null;
        HttpResponseDescriptor responseDescriptor = null;
        HttpResponseDescriptor rawResponseDescriptor = null;
        try {
            do {
                client = (CloseableHttpClient)CustomHttpClientBuilder.build((MainConfigurationSet)RestcommConfiguration.getInstance().getMain());
                request = this.request(temp);
                request.setHeader("http.protocol.content-charset", "UTF-8");
                response = client.execute(request);
                code = response.getStatusLine().getStatusCode();
                if (this.isRedirect(code)) {
                    Header header = response.getFirstHeader("Location");
                    if (header == null) break;
                    String location = header.getValue();
                    URI uri = URI.create(location);
                    temp = new HttpRequestDescriptor(uri, temp.getMethod(), temp.getParameters());
                    continue;
                }
                rawResponseDescriptor = this.response((HttpRequest)request, (HttpResponse)response);
                responseDescriptor = this.validateXML(rawResponseDescriptor);
            } while (this.isRedirect(code));
            if (this.isHttpError(code)) {
                String requestUrl = request.getRequestLine().getUri();
                String errorReason = response.getStatusLine().getReasonPhrase();
                String httpErrorMessage = String.format("Problem while fetching http resource: %s \n Http status code: %d \n Http status message: %s", requestUrl, code, errorReason);
                this.logger.warning(httpErrorMessage);
            }
        }
        catch (Exception e) {
            this.logger.warning("Problem while trying to download RCML from {}, exception: {}", (Object)request.getRequestLine(), (Object)e);
            String statusInfo = "n/a";
            String responseInfo = "n/a";
            if (response != null) {
                statusInfo = response.getStatusLine().toString();
                if (rawResponseDescriptor != null) {
                    int truncatedSize = (int)Math.min(rawResponseDescriptor.getContentLength(), 100L);
                    if (rawResponseDescriptor.getContentAsString() != null) {
                        responseInfo = String.format("%s %s", rawResponseDescriptor.getContentAsString().substring(0, truncatedSize), rawResponseDescriptor.getContentLength() < 100L ? "" : "...");
                    }
                }
            }
            this.logger.warning(String.format("Problem while trying to download RCML. URL: %s, Status: %s, Response: %s ", request.getRequestLine(), statusInfo, responseInfo));
            throw e;
        }
        finally {
            response.close();
            HttpClientUtils.closeQuietly((HttpClient)client);
            client = null;
        }
        return responseDescriptor;
    }

    private boolean isRedirect(int code) {
        return 301 == code || 302 == code || 303 == code || 307 == code;
    }

    private boolean isHttpError(int code) {
        return code >= 400;
    }

    private HttpResponseDescriptor validateXML(HttpResponseDescriptor descriptor) throws XMLStreamException {
        if (descriptor.getContentLength() > 0L) {
            try {
                String xml = descriptor.getContentAsString().trim().replaceAll("&([^;]+(?!(?:\\w|;)))", "&amp;$1");
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.parse(new InputSource(new ByteArrayInputStream(xml.getBytes("utf-8"))));
                return descriptor;
            }
            catch (Exception e) {
                throw new XMLStreamException("Error parsing the RCML:" + e);
            }
        }
        return descriptor;
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (HttpRequestDescriptor.class.equals(klass)) {
            HttpRequestDescriptor request = (HttpRequestDescriptor)message;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("New HttpRequestDescriptor, method: " + request.getMethod() + " URI: " + request.getUri() + " parameters: " + request.getParametersAsString());
            }
            DownloaderResponse response = null;
            try {
                response = new DownloaderResponse(this.fetch(request));
            }
            catch (Exception exception) {
                response = new DownloaderResponse(exception, "Problem while trying to download RCML");
            }
            if (sender != null && !sender.isTerminated()) {
                sender.tell((Object)response, self);
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info("DownloaderResponse wont be send because sender is :" + (sender.isTerminated() ? "terminated" : "null"));
            }
        }
    }

    public HttpUriRequest request(HttpRequestDescriptor descriptor) throws IllegalArgumentException, URISyntaxException, UnsupportedEncodingException {
        URI uri = descriptor.getUri();
        String method = descriptor.getMethod();
        if ("GET".equalsIgnoreCase(method)) {
            String query = descriptor.getParametersAsString();
            URI result = null;
            result = query != null && !query.isEmpty() ? new URIBuilder().setScheme(uri.getScheme()).setHost(uri.getHost()).setPort(uri.getPort()).setPath(uri.getPath()).setQuery(query).build() : uri;
            return new HttpGet(result);
        }
        if ("POST".equalsIgnoreCase(method)) {
            List<NameValuePair> parameters = descriptor.getParameters();
            HttpPost post = new HttpPost(uri);
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, "UTF-8"));
            return post;
        }
        throw new IllegalArgumentException(method + " is not a supported downloader method.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponseDescriptor response(HttpRequest request, HttpResponse response) throws IOException {
        HttpResponseDescriptor.Builder builder = HttpResponseDescriptor.builder();
        URI uri = URI.create(request.getRequestLine().getUri());
        builder.setURI(uri);
        builder.setStatusCode(response.getStatusLine().getStatusCode());
        builder.setStatusDescription(response.getStatusLine().getReasonPhrase());
        builder.setHeaders(response.getAllHeaders());
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (InputStream stream = entity.getContent();){
                Header contentType;
                Header contentEncoding = entity.getContentEncoding();
                if (contentEncoding != null) {
                    builder.setContentEncoding(contentEncoding.getValue());
                }
                if ((contentType = entity.getContentType()) != null) {
                    builder.setContentType(contentType.getValue());
                }
                builder.setContent(StringUtils.toString((InputStream)stream));
                builder.setContentLength(entity.getContentLength());
                builder.setIsChunked(entity.isChunked());
            }
        }
        return builder.build();
    }

    public void postStop() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Downloader at post stop");
        }
        super.postStop();
    }
}

