/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.client.rcmlserver.resolver;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class RcmlserverResolver {
    protected static Logger logger = Logger.getLogger(RcmlserverResolver.class);
    static RcmlserverResolver singleton;
    String rvdOrigin;
    String filterPrefix;
    static final String DEFAULT_FILTER_PREFIX = "/restcomm-rvd/";

    public static RcmlserverResolver getInstance(String rvdOrigin, String apiPath, boolean reinit) {
        if (singleton == null || reinit) {
            singleton = new RcmlserverResolver(rvdOrigin, apiPath);
        }
        return singleton;
    }

    public static RcmlserverResolver getInstance(String rvdOrigin, String apiPath) {
        return RcmlserverResolver.getInstance(rvdOrigin, apiPath, false);
    }

    public RcmlserverResolver(String rvdOrigin, String apiPath) {
        this.rvdOrigin = rvdOrigin;
        if (!StringUtils.isEmpty((String)apiPath)) {
            Pattern pattern = Pattern.compile("/([^/]*)((/.*)|$)");
            Matcher matcher = pattern.matcher(apiPath);
            this.filterPrefix = matcher.matches() && matcher.group(1) != null ? "/" + matcher.group(1) + "/" : DEFAULT_FILTER_PREFIX;
            logger.info((Object)("RcmlserverResolver initialized. Urls starting with '" + this.filterPrefix + "' will get prepended with '" + (rvdOrigin == null ? "" : rvdOrigin) + "'"));
        } else {
            this.filterPrefix = null;
        }
    }

    public URI resolveRelative(URI uri) {
        if (uri != null && this.rvdOrigin != null && this.filterPrefix != null) {
            if (uri.isAbsolute()) {
                return uri;
            }
            try {
                String uriString = uri.toString();
                if (uriString.startsWith(this.filterPrefix)) {
                    return new URI(this.rvdOrigin + uri.toString());
                }
            }
            catch (URISyntaxException e) {
                logger.error((Object)("Cannot resolve uri: " + uri.toString() + ". Ignoring..."), (Throwable)e);
            }
        }
        return uri;
    }
}

