/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.annotations.concurrency.ThreadSafe;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.dao.entities.CallDetailRecordList;
import org.restcomm.connect.http.converter.AbstractConverter;

@ThreadSafe
public final class CallDetailRecordListConverter
extends AbstractConverter
implements JsonSerializer<CallDetailRecordList> {
    Integer page;
    Integer pageSize;
    Integer total;
    String pathUri;

    public CallDetailRecordListConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return CallDetailRecordList.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        CallDetailRecordList list = (CallDetailRecordList)object;
        writer.startNode("Calls");
        writer.addAttribute("page", String.valueOf(this.page));
        writer.addAttribute("numpages", String.valueOf(this.getTotalPages()));
        writer.addAttribute("pagesize", String.valueOf(this.pageSize));
        writer.addAttribute("total", String.valueOf(this.getTotalPages()));
        writer.addAttribute("start", this.getFirstIndex());
        writer.addAttribute("end", this.getLastIndex(list));
        writer.addAttribute("uri", this.pathUri);
        writer.addAttribute("firstpageuri", this.getFirstPageUri());
        writer.addAttribute("previouspageuri", this.getPreviousPageUri());
        writer.addAttribute("nextpageuri", this.getNextPageUri(list));
        writer.addAttribute("lastpageuri", this.getLastPageUri());
        for (CallDetailRecord cdr : list.getCallDetailRecords()) {
            context.convertAnother((Object)cdr);
        }
        writer.endNode();
    }

    public JsonObject serialize(CallDetailRecordList cdrList, Type type, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        JsonArray array = new JsonArray();
        for (CallDetailRecord cdr : cdrList.getCallDetailRecords()) {
            array.add(context.serialize((Object)cdr));
        }
        if (this.total != null && this.pageSize != null && this.page != null) {
            result.addProperty("page", (Number)this.page);
            result.addProperty("num_pages", (Number)this.getTotalPages());
            result.addProperty("page_size", (Number)this.pageSize);
            result.addProperty("total", (Number)this.total);
            result.addProperty("start", this.getFirstIndex());
            result.addProperty("end", this.getLastIndex(cdrList));
            result.addProperty("uri", this.pathUri);
            result.addProperty("first_page_uri", this.getFirstPageUri());
            result.addProperty("previous_page_uri", this.getPreviousPageUri());
            result.addProperty("next_page_uri", this.getNextPageUri(cdrList));
            result.addProperty("last_page_uri", this.getLastPageUri());
        }
        result.add("calls", (JsonElement)array);
        return result;
    }

    private int getTotalPages() {
        return this.total / this.pageSize;
    }

    private String getFirstIndex() {
        return String.valueOf(this.page * this.pageSize);
    }

    private String getLastIndex(CallDetailRecordList list) {
        return String.valueOf(this.page.intValue() == this.getTotalPages() ? this.page * this.pageSize + list.getCallDetailRecords().size() : this.pageSize - 1 + this.page * this.pageSize);
    }

    private String getFirstPageUri() {
        return this.pathUri + "?Page=0&PageSize=" + this.pageSize;
    }

    private String getPreviousPageUri() {
        return this.page == 0 ? "null" : this.pathUri + "?Page=" + (this.page - 1) + "&PageSize=" + this.pageSize;
    }

    private String getNextPageUri(CallDetailRecordList list) {
        String lastSid = this.page.intValue() == this.getTotalPages() ? "null" : ((CallDetailRecord)list.getCallDetailRecords().get(this.pageSize - 1)).getSid().toString();
        return this.page.intValue() == this.getTotalPages() ? "null" : this.pathUri + "?Page=" + (this.page + 1) + "&PageSize=" + this.pageSize + "&AfterSid=" + lastSid;
    }

    private String getLastPageUri() {
        return this.pathUri + "?Page=" + this.getTotalPages() + "&PageSize=" + this.pageSize;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setCount(Integer count) {
        this.total = count;
    }

    public void setPathUri(String pathUri) {
        this.pathUri = pathUri;
    }
}

