/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.restcomm.connect.commons.Version;
import org.restcomm.connect.commons.util.UriUtils;
import org.restcomm.connect.http.converter.AbstractConverter;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.MonitoringServiceResponse;

public class MonitoringServiceConverter
extends AbstractConverter
implements JsonSerializer<MonitoringServiceResponse> {
    private String dateTimeNow;

    public MonitoringServiceConverter(Configuration configuration) {
        super(configuration);
        DateTime now = DateTime.now();
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy kk:mm:ss");
        this.dateTimeNow = fmt.print((ReadableInstant)now);
    }

    @Override
    public boolean canConvert(Class klass) {
        return MonitoringServiceResponse.class.equals((Object)klass);
    }

    public JsonElement serialize(MonitoringServiceResponse monitoringServiceResponse, Type typeOfSrc, JsonSerializationContext context) {
        Map countersMap = monitoringServiceResponse.getCountersMap();
        Map durationMap = monitoringServiceResponse.getDurationMap();
        JsonObject result = new JsonObject();
        JsonObject metrics = new JsonObject();
        JsonArray callsArray = new JsonArray();
        result.addProperty("DateTime", this.dateTimeNow);
        result.addProperty("InstanceId", monitoringServiceResponse.getInstanceId().getId().toString());
        result.addProperty("Version", Version.getVersion());
        result.addProperty("Revision", Version.getRevision());
        for (String counter : countersMap.keySet()) {
            metrics.addProperty(counter, (Number)countersMap.get(counter));
        }
        for (String durationKey : durationMap.keySet()) {
            metrics.addProperty(durationKey, (Number)durationMap.get(durationKey));
        }
        result.add("Metrics", (JsonElement)metrics);
        if (monitoringServiceResponse.isWithCallDetailsList()) {
            if (monitoringServiceResponse.getCallDetailsList() != null && monitoringServiceResponse.getCallDetailsList().size() > 0) {
                for (CallInfo callInfo : monitoringServiceResponse.getCallDetailsList()) {
                    callsArray.add(context.serialize((Object)callInfo));
                }
            }
            result.add("LiveCallDetails", (JsonElement)callsArray);
        } else {
            result.addProperty("LiveCallDetails", UriUtils.resolve((URI)monitoringServiceResponse.getCallDetailsUrl()).toString());
        }
        return result;
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        MonitoringServiceResponse monitoringServiceResponse = (MonitoringServiceResponse)object;
        Map durationMap = monitoringServiceResponse.getDurationMap();
        Map countersMap = monitoringServiceResponse.getCountersMap();
        Iterator counterIterator = countersMap.keySet().iterator();
        Iterator durationIterator = durationMap.keySet().iterator();
        writer.startNode("DateTime");
        writer.setValue(this.dateTimeNow);
        writer.endNode();
        writer.startNode("InstanceId");
        writer.setValue(monitoringServiceResponse.getInstanceId().getId().toString());
        writer.endNode();
        writer.startNode("Version");
        writer.setValue(Version.getVersion());
        writer.endNode();
        writer.startNode("Revision");
        writer.setValue(Version.getRevision());
        writer.endNode();
        writer.startNode("Metrics");
        while (counterIterator.hasNext()) {
            String counter = (String)counterIterator.next();
            writer.startNode(counter);
            writer.setValue(String.valueOf(countersMap.get(counter)));
            writer.endNode();
        }
        while (durationIterator.hasNext()) {
            String durationKey = (String)durationIterator.next();
            writer.startNode(durationKey);
            writer.setValue(String.valueOf(durationMap.get(durationKey)));
            writer.endNode();
        }
        writer.endNode();
        if (monitoringServiceResponse.isWithCallDetailsList()) {
            if (monitoringServiceResponse.getCallDetailsList() != null && monitoringServiceResponse.getCallDetailsList().size() > 0) {
                writer.startNode("LiveCallDetails");
                for (CallInfo callInfo : monitoringServiceResponse.getCallDetailsList()) {
                    context.convertAnother((Object)callInfo);
                }
                writer.endNode();
            } else {
                writer.startNode("LiveCallDetails");
                writer.setValue(UriUtils.resolve((URI)monitoringServiceResponse.getCallDetailsUrl()).toString());
                writer.endNode();
            }
        }
    }
}

