/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.http.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.VersionEntity;
import org.restcomm.connect.http.converter.AbstractConverter;

public class VersionConverter
extends AbstractConverter
implements JsonSerializer<VersionEntity> {
    public VersionConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return VersionEntity.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        VersionEntity versionEntity = (VersionEntity)object;
        String version = versionEntity.getVersion();
        String revision = versionEntity.getRevision();
        String name = versionEntity.getName();
        String date = versionEntity.getDate();
        writer.startNode("Name");
        writer.setValue(name + " Restcomm");
        writer.endNode();
        writer.startNode("Version");
        writer.setValue(version);
        writer.endNode();
        writer.startNode("Revision");
        writer.setValue(revision);
        writer.endNode();
        writer.startNode("Date");
        writer.setValue(date);
        writer.endNode();
    }

    public JsonElement serialize(VersionEntity versionEntity, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject result = new JsonObject();
        result.addProperty("Name", versionEntity.getName() + " Restcomm");
        result.addProperty("Version", versionEntity.getVersion());
        result.addProperty("Revision", versionEntity.getRevision());
        result.addProperty("Date", versionEntity.getDate());
        return result;
    }
}

