/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.interpreter;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import java.net.URI;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.interpreter.SubVoiceInterpreter;

public final class SubVoiceInterpreterBuilder {
    private final ActorSystem system;
    private Configuration configuration;
    private DaoManager storage;
    private ActorRef calls;
    private ActorRef conferences;
    private ActorRef sms;
    private Sid account;
    private Sid phone;
    private String version;
    private URI url;
    private String method;
    private URI fallbackUrl;
    private String fallbackMethod;
    private URI statusCallback;
    private String statusCallbackMethod;
    private String emailAddress;
    private Boolean hangupOnEnd = false;

    public SubVoiceInterpreterBuilder(ActorSystem system) {
        this.system = system;
    }

    public ActorRef build() {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SubVoiceInterpreter(SubVoiceInterpreterBuilder.this.configuration, SubVoiceInterpreterBuilder.this.account, SubVoiceInterpreterBuilder.this.phone, SubVoiceInterpreterBuilder.this.version, SubVoiceInterpreterBuilder.this.url, SubVoiceInterpreterBuilder.this.method, SubVoiceInterpreterBuilder.this.fallbackUrl, SubVoiceInterpreterBuilder.this.fallbackMethod, SubVoiceInterpreterBuilder.this.statusCallback, SubVoiceInterpreterBuilder.this.statusCallbackMethod, SubVoiceInterpreterBuilder.this.emailAddress, SubVoiceInterpreterBuilder.this.calls, SubVoiceInterpreterBuilder.this.conferences, SubVoiceInterpreterBuilder.this.sms, SubVoiceInterpreterBuilder.this.storage, SubVoiceInterpreterBuilder.this.hangupOnEnd);
            }
        }));
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setStorage(DaoManager storage) {
        this.storage = storage;
    }

    public void setCallManager(ActorRef calls) {
        this.calls = calls;
    }

    public void setConferenceManager(ActorRef conferences) {
        this.conferences = conferences;
    }

    public void setSmsService(ActorRef sms) {
        this.sms = sms;
    }

    public void setAccount(Sid account) {
        this.account = account;
    }

    public void setPhone(Sid phone) {
        this.phone = phone;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
    }

    public void setFallbackMethod(String fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
    }

    public void setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
    }

    public void setStatusCallbackMethod(String statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setHangupOnEnd(Boolean hangupOnEnd) {
        this.hangupOnEnd = hangupOnEnd;
    }
}

