/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.interpreter;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import java.net.URI;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.interpreter.VoiceInterpreter;

public final class VoiceInterpreterBuilder {
    private final ActorSystem system;
    private Configuration configuration;
    private DaoManager storage;
    private ActorRef calls;
    private ActorRef conferences;
    private ActorRef bridges;
    private ActorRef sms;
    private Sid account;
    private Sid phone;
    private String version;
    private URI url;
    private String method;
    private URI fallbackUrl;
    private String fallbackMethod;
    private URI statusCallback;
    private String statusCallbackMethod;
    private String emailAddress;
    private ActorRef monitoring;
    private String rcml;

    public VoiceInterpreterBuilder(ActorSystem system) {
        this.system = system;
    }

    public ActorRef build() {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new VoiceInterpreter(VoiceInterpreterBuilder.this.configuration, VoiceInterpreterBuilder.this.account, VoiceInterpreterBuilder.this.phone, VoiceInterpreterBuilder.this.version, VoiceInterpreterBuilder.this.url, VoiceInterpreterBuilder.this.method, VoiceInterpreterBuilder.this.fallbackUrl, VoiceInterpreterBuilder.this.fallbackMethod, VoiceInterpreterBuilder.this.statusCallback, VoiceInterpreterBuilder.this.statusCallbackMethod, VoiceInterpreterBuilder.this.emailAddress, VoiceInterpreterBuilder.this.calls, VoiceInterpreterBuilder.this.conferences, VoiceInterpreterBuilder.this.bridges, VoiceInterpreterBuilder.this.sms, VoiceInterpreterBuilder.this.storage, VoiceInterpreterBuilder.this.monitoring, VoiceInterpreterBuilder.this.rcml);
            }
        }));
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setStorage(DaoManager storage) {
        this.storage = storage;
    }

    public void setCallManager(ActorRef calls) {
        this.calls = calls;
    }

    public void setConferenceManager(ActorRef conferences) {
        this.conferences = conferences;
    }

    public void setBridgeManager(ActorRef bridges) {
        this.bridges = bridges;
    }

    public void setSmsService(ActorRef sms) {
        this.sms = sms;
    }

    public void setAccount(Sid account) {
        this.account = account;
    }

    public void setPhone(Sid phone) {
        this.phone = phone;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
    }

    public void setFallbackMethod(String fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
    }

    public void setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
    }

    public void setStatusCallbackMethod(String statusCallbackMethod) {
        this.statusCallbackMethod = statusCallbackMethod;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMonitoring(ActorRef monitoring) {
        this.monitoring = monitoring;
    }

    public void setRcml(String rcml) {
        this.rcml = rcml;
    }
}

