/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.interpreter;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.joda.time.DateTime;
import org.restcomm.connect.asr.AsrInfo;
import org.restcomm.connect.asr.AsrRequest;
import org.restcomm.connect.asr.AsrResponse;
import org.restcomm.connect.asr.GetAsrInfo;
import org.restcomm.connect.asr.ISpeechAsr;
import org.restcomm.connect.commons.cache.DiskCacheFactory;
import org.restcomm.connect.commons.cache.DiskCacheRequest;
import org.restcomm.connect.commons.cache.DiskCacheResponse;
import org.restcomm.connect.commons.cache.HashGenerator;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.util.UriUtils;
import org.restcomm.connect.commons.util.WavUtils;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.NotificationsDao;
import org.restcomm.connect.dao.RecordingsDao;
import org.restcomm.connect.dao.SmsMessagesDao;
import org.restcomm.connect.dao.TranscriptionsDao;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.dao.entities.Recording;
import org.restcomm.connect.dao.entities.SmsMessage;
import org.restcomm.connect.dao.entities.Transcription;
import org.restcomm.connect.email.EmailService;
import org.restcomm.connect.email.api.EmailRequest;
import org.restcomm.connect.email.api.EmailResponse;
import org.restcomm.connect.email.api.Mail;
import org.restcomm.connect.fax.FaxRequest;
import org.restcomm.connect.fax.InterfaxService;
import org.restcomm.connect.http.client.Downloader;
import org.restcomm.connect.http.client.DownloaderResponse;
import org.restcomm.connect.http.client.HttpRequestDescriptor;
import org.restcomm.connect.http.client.HttpResponseDescriptor;
import org.restcomm.connect.interpreter.StartGathering;
import org.restcomm.connect.interpreter.StopInterpreter;
import org.restcomm.connect.interpreter.rcml.Attribute;
import org.restcomm.connect.interpreter.rcml.GetNextVerb;
import org.restcomm.connect.interpreter.rcml.Parser;
import org.restcomm.connect.interpreter.rcml.ParserFailed;
import org.restcomm.connect.interpreter.rcml.Tag;
import org.restcomm.connect.mscontrol.api.messages.Collect;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupResponse;
import org.restcomm.connect.mscontrol.api.messages.Play;
import org.restcomm.connect.mscontrol.api.messages.Record;
import org.restcomm.connect.sms.api.CreateSmsSession;
import org.restcomm.connect.sms.api.DestroySmsSession;
import org.restcomm.connect.sms.api.SmsServiceResponse;
import org.restcomm.connect.sms.api.SmsSessionAttribute;
import org.restcomm.connect.sms.api.SmsSessionInfo;
import org.restcomm.connect.sms.api.SmsSessionRequest;
import org.restcomm.connect.sms.api.SmsSessionResponse;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.CallManagerResponse;
import org.restcomm.connect.telephony.api.CallStateChanged;
import org.restcomm.connect.telephony.api.GetCallInfo;
import org.restcomm.connect.telephony.api.Hangup;
import org.restcomm.connect.telephony.api.Reject;
import org.restcomm.connect.tts.api.GetSpeechSynthesizerInfo;
import org.restcomm.connect.tts.api.SpeechSynthesizerInfo;
import org.restcomm.connect.tts.api.SpeechSynthesizerRequest;
import org.restcomm.connect.tts.api.SpeechSynthesizerResponse;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public abstract class BaseVoiceInterpreter
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    static final int ERROR_NOTIFICATION = 0;
    static final int WARNING_NOTIFICATION = 1;
    static final Pattern PATTERN = Pattern.compile("[\\*#0-9]{1,12}");
    static String EMAIL_SENDER = "restcomm@restcomm.org";
    final State uninitialized;
    final State acquiringAsrInfo;
    final State acquiringSynthesizerInfo;
    final State acquiringCallInfo;
    final State playingRejectionPrompt;
    final State pausing;
    final State caching;
    final State checkingCache;
    final State playing;
    final State synthesizing;
    final State redirecting;
    final State faxing;
    final State processingGatherChildren;
    final State gathering;
    final State finishGathering;
    final State creatingRecording;
    final State finishRecording;
    final State creatingSmsSession;
    final State sendingSms;
    final State hangingUp;
    final State sendingEmail;
    FiniteStateMachine fsm = null;
    Configuration configuration = null;
    private ActorRef cache;
    String cachePath = null;
    ActorRef downloader = null;
    ActorRef mailerNotify = null;
    ActorRef mailerService = null;
    ActorRef callManager = null;
    ActorRef conferenceManager = null;
    private ActorRef asrService;
    int outstandingAsrRequests;
    private ActorRef faxService;
    ActorRef smsService = null;
    Map<Sid, ActorRef> smsSessions = null;
    DaoManager storage = null;
    private ActorRef synthesizer;
    AsrInfo asrInfo = null;
    SpeechSynthesizerInfo synthesizerInfo = null;
    ActorRef call = null;
    CallInfo callInfo = null;
    CallStateChanged.State callState = null;
    Integer outboundCallResponse = null;
    CallDetailRecord callRecord = null;
    ActorRef outboundCall = null;
    CallInfo outboundCallInfo = null;
    List<Tag> gatherChildren = null;
    List<URI> gatherPrompts = null;
    Sid recordingSid = null;
    URI recordingUri = null;
    URI publicRecordingUri = null;
    Sid accountId;
    Sid phoneId;
    String version;
    URI url;
    String method;
    URI fallbackUrl;
    String fallbackMethod;
    URI statusCallback;
    String statusCallbackMethod;
    String emailAddress;
    HttpRequestDescriptor request;
    HttpRequestDescriptor requestCallback;
    HttpResponseDescriptor response;
    ActorRef parser;
    Tag verb;
    Tag gatherVerb;
    Boolean processingGather = false;
    Boolean dtmfReceived = false;
    String finishOnKey;
    int numberOfDigits = Short.MAX_VALUE;
    StringBuffer collectedDigits;
    ActorRef monitoring;
    final Set<Transition> transitions = new HashSet<Transition>();

    public BaseVoiceInterpreter() {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.acquiringAsrInfo = new State("acquiring asr info", (Action)new AcquiringAsrInfo(source), null);
        this.acquiringSynthesizerInfo = new State("acquiring tts info", (Action)new AcquiringSpeechSynthesizerInfo(source), null);
        this.acquiringCallInfo = new State("acquiring call info", (Action)new AcquiringCallInfo(source), null);
        this.playingRejectionPrompt = new State("playing rejection prompt", (Action)new PlayingRejectionPrompt(source), null);
        this.pausing = new State("pausing", (Action)new Pausing(source), null);
        this.caching = new State("caching", (Action)new Caching(source), null);
        this.checkingCache = new State("checkingCache", (Action)new CheckCache(source), null);
        this.playing = new State("playing", (Action)new Playing(source), null);
        this.synthesizing = new State("synthesizing", (Action)new Synthesizing(source), null);
        this.redirecting = new State("redirecting", (Action)new Redirecting(source), null);
        this.faxing = new State("faxing", (Action)new Faxing(source), null);
        this.gathering = new State("gathering", (Action)new Gathering(source), null);
        this.processingGatherChildren = new State("processing gather children", (Action)new ProcessingGatherChildren(source), null);
        this.finishGathering = new State("finish gathering", (Action)new FinishGathering(source), null);
        this.creatingRecording = new State("creating recording", (Action)new CreatingRecording(source), null);
        this.finishRecording = new State("finish recording", (Action)new FinishRecording(source), null);
        this.creatingSmsSession = new State("creating sms session", (Action)new CreatingSmsSession(source), null);
        this.sendingSms = new State("sending sms", (Action)new SendingSms(source), null);
        this.hangingUp = new State("hanging up", (Action)new HangingUp(source), null);
        this.sendingEmail = new State("sending Email", (Action)new SendingEmail(source), null);
        this.transitions.add(new Transition(this.uninitialized, this.acquiringAsrInfo));
        this.transitions.add(new Transition(this.acquiringAsrInfo, this.acquiringSynthesizerInfo));
        this.transitions.add(new Transition(this.acquiringSynthesizerInfo, this.acquiringCallInfo));
        this.transitions.add(new Transition(this.pausing, this.hangingUp));
        this.transitions.add(new Transition(this.playingRejectionPrompt, this.hangingUp));
        this.transitions.add(new Transition(this.faxing, this.faxing));
        this.transitions.add(new Transition(this.faxing, this.caching));
        this.transitions.add(new Transition(this.faxing, this.pausing));
        this.transitions.add(new Transition(this.faxing, this.redirecting));
        this.transitions.add(new Transition(this.faxing, this.synthesizing));
        this.transitions.add(new Transition(this.faxing, this.processingGatherChildren));
        this.transitions.add(new Transition(this.faxing, this.creatingRecording));
        this.transitions.add(new Transition(this.faxing, this.creatingSmsSession));
        this.transitions.add(new Transition(this.faxing, this.hangingUp));
        this.transitions.add(new Transition(this.sendingEmail, this.sendingEmail));
        this.transitions.add(new Transition(this.sendingEmail, this.caching));
        this.transitions.add(new Transition(this.sendingEmail, this.pausing));
        this.transitions.add(new Transition(this.sendingEmail, this.redirecting));
        this.transitions.add(new Transition(this.sendingEmail, this.synthesizing));
        this.transitions.add(new Transition(this.sendingEmail, this.processingGatherChildren));
        this.transitions.add(new Transition(this.sendingEmail, this.creatingRecording));
        this.transitions.add(new Transition(this.sendingEmail, this.creatingSmsSession));
        this.transitions.add(new Transition(this.sendingEmail, this.hangingUp));
        this.transitions.add(new Transition(this.caching, this.faxing));
        this.transitions.add(new Transition(this.caching, this.sendingEmail));
        this.transitions.add(new Transition(this.caching, this.playing));
        this.transitions.add(new Transition(this.caching, this.caching));
        this.transitions.add(new Transition(this.caching, this.pausing));
        this.transitions.add(new Transition(this.caching, this.redirecting));
        this.transitions.add(new Transition(this.caching, this.synthesizing));
        this.transitions.add(new Transition(this.caching, this.processingGatherChildren));
        this.transitions.add(new Transition(this.caching, this.creatingRecording));
        this.transitions.add(new Transition(this.caching, this.creatingSmsSession));
        this.transitions.add(new Transition(this.caching, this.hangingUp));
        this.transitions.add(new Transition(this.checkingCache, this.synthesizing));
        this.transitions.add(new Transition(this.checkingCache, this.playing));
        this.transitions.add(new Transition(this.checkingCache, this.checkingCache));
        this.transitions.add(new Transition(this.playing, this.hangingUp));
        this.transitions.add(new Transition(this.synthesizing, this.faxing));
        this.transitions.add(new Transition(this.synthesizing, this.sendingEmail));
        this.transitions.add(new Transition(this.synthesizing, this.pausing));
        this.transitions.add(new Transition(this.synthesizing, this.checkingCache));
        this.transitions.add(new Transition(this.synthesizing, this.caching));
        this.transitions.add(new Transition(this.synthesizing, this.redirecting));
        this.transitions.add(new Transition(this.synthesizing, this.processingGatherChildren));
        this.transitions.add(new Transition(this.synthesizing, this.creatingRecording));
        this.transitions.add(new Transition(this.synthesizing, this.creatingSmsSession));
        this.transitions.add(new Transition(this.synthesizing, this.synthesizing));
        this.transitions.add(new Transition(this.synthesizing, this.hangingUp));
        this.transitions.add(new Transition(this.redirecting, this.faxing));
        this.transitions.add(new Transition(this.redirecting, this.sendingEmail));
        this.transitions.add(new Transition(this.redirecting, this.pausing));
        this.transitions.add(new Transition(this.redirecting, this.checkingCache));
        this.transitions.add(new Transition(this.redirecting, this.caching));
        this.transitions.add(new Transition(this.redirecting, this.synthesizing));
        this.transitions.add(new Transition(this.redirecting, this.redirecting));
        this.transitions.add(new Transition(this.redirecting, this.processingGatherChildren));
        this.transitions.add(new Transition(this.redirecting, this.creatingRecording));
        this.transitions.add(new Transition(this.redirecting, this.creatingSmsSession));
        this.transitions.add(new Transition(this.redirecting, this.hangingUp));
        this.transitions.add(new Transition(this.creatingRecording, this.finishRecording));
        this.transitions.add(new Transition(this.creatingRecording, this.hangingUp));
        this.transitions.add(new Transition(this.finishRecording, this.faxing));
        this.transitions.add(new Transition(this.finishRecording, this.sendingEmail));
        this.transitions.add(new Transition(this.finishRecording, this.pausing));
        this.transitions.add(new Transition(this.finishRecording, this.checkingCache));
        this.transitions.add(new Transition(this.finishRecording, this.caching));
        this.transitions.add(new Transition(this.finishRecording, this.synthesizing));
        this.transitions.add(new Transition(this.finishRecording, this.redirecting));
        this.transitions.add(new Transition(this.finishRecording, this.processingGatherChildren));
        this.transitions.add(new Transition(this.finishRecording, this.creatingRecording));
        this.transitions.add(new Transition(this.finishRecording, this.creatingSmsSession));
        this.transitions.add(new Transition(this.finishRecording, this.hangingUp));
        this.transitions.add(new Transition(this.processingGatherChildren, this.processingGatherChildren));
        this.transitions.add(new Transition(this.processingGatherChildren, this.gathering));
        this.transitions.add(new Transition(this.processingGatherChildren, this.synthesizing));
        this.transitions.add(new Transition(this.processingGatherChildren, this.hangingUp));
        this.transitions.add(new Transition(this.gathering, this.finishGathering));
        this.transitions.add(new Transition(this.gathering, this.hangingUp));
        this.transitions.add(new Transition(this.finishGathering, this.faxing));
        this.transitions.add(new Transition(this.finishGathering, this.sendingEmail));
        this.transitions.add(new Transition(this.finishGathering, this.pausing));
        this.transitions.add(new Transition(this.finishGathering, this.checkingCache));
        this.transitions.add(new Transition(this.finishGathering, this.caching));
        this.transitions.add(new Transition(this.finishGathering, this.synthesizing));
        this.transitions.add(new Transition(this.finishGathering, this.redirecting));
        this.transitions.add(new Transition(this.finishGathering, this.processingGatherChildren));
        this.transitions.add(new Transition(this.finishGathering, this.creatingRecording));
        this.transitions.add(new Transition(this.finishGathering, this.creatingSmsSession));
        this.transitions.add(new Transition(this.finishGathering, this.hangingUp));
        this.transitions.add(new Transition(this.creatingSmsSession, this.sendingSms));
        this.transitions.add(new Transition(this.creatingSmsSession, this.hangingUp));
        this.transitions.add(new Transition(this.sendingSms, this.faxing));
        this.transitions.add(new Transition(this.sendingSms, this.sendingEmail));
        this.transitions.add(new Transition(this.sendingSms, this.pausing));
        this.transitions.add(new Transition(this.sendingSms, this.caching));
        this.transitions.add(new Transition(this.sendingSms, this.synthesizing));
        this.transitions.add(new Transition(this.sendingSms, this.redirecting));
        this.transitions.add(new Transition(this.sendingSms, this.processingGatherChildren));
        this.transitions.add(new Transition(this.sendingSms, this.creatingRecording));
        this.transitions.add(new Transition(this.sendingSms, this.creatingSmsSession));
        this.transitions.add(new Transition(this.sendingSms, this.hangingUp));
    }

    public abstract void onReceive(Object var1) throws Exception;

    abstract List<NameValuePair> parameters();

    public ActorRef getAsrService() {
        if (this.asrService == null || this.asrService != null && this.asrService.isTerminated()) {
            this.asrService = this.asr(this.configuration.subset("speech-recognizer"));
        }
        return this.asrService;
    }

    ActorRef asr(final Configuration configuration) {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return new ISpeechAsr(configuration);
            }
        }));
    }

    void asrResponse(Object message) {
        Class<?> klass = message.getClass();
        if (AsrResponse.class.equals(klass)) {
            AsrResponse response = (AsrResponse)message;
            Transcription transcription = (Transcription)response.attributes().get("transcription");
            if (response.succeeded()) {
                transcription = transcription.setStatus(Transcription.Status.COMPLETED);
                transcription = transcription.setTranscriptionText((String)response.get());
            } else {
                transcription = transcription.setStatus(Transcription.Status.FAILED);
            }
            TranscriptionsDao transcriptions = this.storage.getTranscriptionsDao();
            transcriptions.updateTranscription(transcription);
            Object attribute = response.attributes().get("callback");
            if (attribute != null) {
                URI callback = (URI)attribute;
                List<NameValuePair> parameters = this.parameters();
                this.request = new HttpRequestDescriptor(callback, "POST", parameters);
                this.downloader.tell((Object)this.request, null);
            }
            --this.outstandingAsrRequests;
            this.postCleanup();
        }
    }

    public ActorRef getFaxService() {
        if (this.faxService == null || this.faxService != null && this.faxService.isTerminated()) {
            this.faxService = this.fax(this.configuration.subset("fax-service"));
        }
        return this.faxService;
    }

    ActorRef fax(final Configuration configuration) {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return new InterfaxService(configuration);
            }
        }));
    }

    void callback(boolean ask) {
        if (this.statusCallback != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("About to execute statusCallback: " + this.statusCallback.toString());
            }
            if (this.statusCallbackMethod == null) {
                this.statusCallbackMethod = "POST";
            }
            List<NameValuePair> parameters = this.parameters();
            this.requestCallback = new HttpRequestDescriptor(this.statusCallback, this.statusCallbackMethod, parameters);
            if (!ask) {
                this.downloader.tell((Object)this.requestCallback, null);
            } else if (ask) {
                Timeout timeout = new Timeout(Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
                Future future = Patterns.ask((ActorRef)this.downloader, (Object)this.requestCallback, (Timeout)timeout);
                DownloaderResponse downloaderResponse = null;
                try {
                    downloaderResponse = (DownloaderResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
                }
                catch (Exception e) {
                    this.logger.error("Exception during callback with ask pattern");
                }
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("status callback is null");
        }
    }

    void callback() {
        this.callback(false);
    }

    public ActorRef getCache() {
        if (this.cache == null || this.cache != null && this.cache.isTerminated()) {
            Configuration runtime = this.configuration.subset("runtime-settings");
            String path = runtime.getString("cache-path");
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            this.cachePath = path = path + this.accountId.toString();
            String uri = runtime.getString("cache-uri");
            if (!uri.endsWith("/")) {
                uri = uri + "/";
            }
            try {
                uri = UriUtils.resolve((URI)new URI(uri)).toString();
            }
            catch (URISyntaxException e) {
                this.logger.error("URISyntaxException while trying to resolve Cache URI: " + e);
            }
            uri = uri + this.accountId.toString();
            this.cache = this.cache(path, uri);
        }
        return this.cache;
    }

    ActorRef cache(final String path, final String uri) {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new DiskCacheFactory(BaseVoiceInterpreter.this.configuration).getDiskCache(path, uri);
            }
        }));
    }

    ActorRef downloader() {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Downloader();
            }
        }));
    }

    String e164(String number) {
        if (this.configuration.subset("runtime-settings").getBoolean("normalize-numbers-for-outbound-calls")) {
            PhoneNumberUtil numbersUtil = PhoneNumberUtil.getInstance();
            try {
                Phonenumber.PhoneNumber result = numbersUtil.parse(number, "US");
                return numbersUtil.format(result, PhoneNumberUtil.PhoneNumberFormat.E164);
            }
            catch (NumberParseException ignored) {
                return number;
            }
        }
        return number;
    }

    void invalidVerb(Tag verb) {
        ActorRef self = this.self();
        GetNextVerb next = GetNextVerb.instance();
        this.parser.tell((Object)next, self);
    }

    ActorRef mailer(final Configuration configuration) {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return new EmailService(configuration);
            }
        }));
    }

    private Notification notification(int log, int error, String message) {
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(this.accountId);
        builder.setCallSid(this.callInfo.sid());
        builder.setApiVersion(this.version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        try {
            base = UriUtils.resolve((URI)new URI(base)).toString();
        }
        catch (URISyntaxException e) {
            this.logger.error("URISyntaxException when trying to resolve Error-Dictionary URI: " + e);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        URI info = URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        if (this.request != null) {
            builder.setRequestUrl(this.request.getUri());
            builder.setRequestMethod(this.request.getMethod());
            builder.setRequestVariables(this.request.getParametersAsString());
        }
        if (this.response != null) {
            builder.setResponseHeaders(this.response.getHeadersAsString());
            String type = this.response.getContentType();
            if (type.contains("text/xml") || type.contains("application/xml") || type.contains("text/html")) {
                try {
                    builder.setResponseBody(this.response.getContentAsString());
                }
                catch (IOException exception) {
                    this.logger.error("There was an error while reading the contents of the resource located @ " + this.url.toString(), (Object)exception);
                }
            }
        }
        buffer = new StringBuilder();
        buffer.append("/").append(this.version).append("/Accounts/");
        buffer.append(this.accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    ActorRef parser(final String xml) {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws IOException {
                return new Parser(xml, BaseVoiceInterpreter.this.self());
            }
        }));
    }

    void postCleanup() {
        if (this.smsSessions.isEmpty() && this.outstandingAsrRequests == 0) {
            UntypedActorContext context = this.getContext();
            context.stop(this.self());
        }
        if (this.downloader != null && !this.downloader.isTerminated()) {
            this.getContext().stop(this.downloader);
        }
    }

    void sendMail(Notification notification) {
        if (this.emailAddress == null || this.emailAddress.isEmpty()) {
            return;
        }
        String EMAIL_SUBJECT = "RestComm Error Notification - Attention Required";
        StringBuilder buffer = new StringBuilder();
        buffer.append("<strong>").append("Sid: ").append("</strong></br>");
        buffer.append(notification.getSid().toString()).append("</br>");
        buffer.append("<strong>").append("Account Sid: ").append("</strong></br>");
        buffer.append(notification.getAccountSid().toString()).append("</br>");
        buffer.append("<strong>").append("Call Sid: ").append("</strong></br>");
        buffer.append(notification.getCallSid().toString()).append("</br>");
        buffer.append("<strong>").append("API Version: ").append("</strong></br>");
        buffer.append(notification.getApiVersion()).append("</br>");
        buffer.append("<strong>").append("Log: ").append("</strong></br>");
        buffer.append(notification.getLog() == 0 ? "ERROR" : "WARNING").append("</br>");
        buffer.append("<strong>").append("Error Code: ").append("</strong></br>");
        buffer.append(notification.getErrorCode()).append("</br>");
        buffer.append("<strong>").append("More Information: ").append("</strong></br>");
        buffer.append(notification.getMoreInfo().toString()).append("</br>");
        buffer.append("<strong>").append("Message Text: ").append("</strong></br>");
        buffer.append(notification.getMessageText()).append("</br>");
        buffer.append("<strong>").append("Message Date: ").append("</strong></br>");
        buffer.append(notification.getMessageDate().toString()).append("</br>");
        buffer.append("<strong>").append("Request URL: ").append("</strong></br>");
        buffer.append(notification.getRequestUrl().toString()).append("</br>");
        buffer.append("<strong>").append("Request Method: ").append("</strong></br>");
        buffer.append(notification.getRequestMethod()).append("</br>");
        buffer.append("<strong>").append("Request Variables: ").append("</strong></br>");
        buffer.append(notification.getRequestVariables()).append("</br>");
        buffer.append("<strong>").append("Response Headers: ").append("</strong></br>");
        buffer.append(notification.getResponseHeaders()).append("</br>");
        buffer.append("<strong>").append("Response Body: ").append("</strong></br>");
        buffer.append(notification.getResponseBody()).append("</br>");
        Mail emailMsg = new Mail(EMAIL_SENDER, this.emailAddress, "RestComm Error Notification - Attention Required", buffer.toString());
        if (this.mailerNotify == null) {
            this.mailerNotify = this.mailer(this.configuration.subset("smtp-notify"));
        }
        this.mailerNotify.tell((Object)new EmailRequest(emailMsg), this.self());
    }

    void smsResponse(Object message) {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        if (SmsSessionResponse.class.equals(klass)) {
            SmsSessionResponse response = (SmsSessionResponse)message;
            SmsSessionInfo info = response.info();
            SmsMessage record = (SmsMessage)info.attributes().get("record");
            if (response.succeeded()) {
                DateTime now = DateTime.now();
                record = record.setDateSent(now);
                record = record.setStatus(SmsMessage.Status.SENT);
            } else {
                record = record.setStatus(SmsMessage.Status.FAILED);
            }
            SmsMessagesDao messages = this.storage.getSmsMessagesDao();
            messages.updateSmsMessage(record);
            Object attribute = info.attributes().get("callback");
            if (attribute != null) {
                URI callback = (URI)attribute;
                List<NameValuePair> parameters = this.parameters();
                this.request = new HttpRequestDescriptor(callback, "POST", parameters);
                this.downloader.tell((Object)this.request, null);
            }
            ActorRef session = this.smsSessions.remove(record.getSid());
            DestroySmsSession destroy = new DestroySmsSession(session);
            this.smsService.tell((Object)destroy, self);
        }
    }

    public ActorRef getSynthesizer() {
        if (this.synthesizer == null || this.synthesizer != null && this.synthesizer.isTerminated()) {
            String ttsEngine = this.configuration.subset("speech-synthesizer").getString("[@active]");
            Configuration ttsConf = this.configuration.subset(ttsEngine);
            this.synthesizer = this.tts(ttsConf);
        }
        return this.synthesizer;
    }

    ActorRef tts(final Configuration ttsConf) {
        final String classpath = ttsConf.getString("[@class]");
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return (UntypedActor)Class.forName(classpath).getConstructor(Configuration.class).newInstance(ttsConf);
            }
        }));
    }

    String hash(Object message) {
        Map<String, String> details = this.getSynthesizeDetails(message);
        if (details == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Cannot generate hash, details are null");
            }
            return null;
        }
        String voice = details.get("voice");
        String language = details.get("language");
        String text = details.get("text");
        return HashGenerator.hashMessage((String)voice, (String)language, (String)text);
    }

    Map<String, String> getSynthesizeDetails(Object message) {
        Class<?> klass = message.getClass();
        HashMap<String, String> details = new HashMap<String, String>();
        if (!Tag.class.equals(klass)) {
            return null;
        }
        this.verb = (Tag)message;
        if (!"Say".equals(this.verb.name())) {
            return null;
        }
        String voice = "man";
        Attribute attribute = this.verb.attribute("voice");
        if (attribute != null) {
            voice = attribute.value();
            if (voice != null && !voice.isEmpty()) {
                if (!"man".equals(voice) && !"woman".equals(voice)) {
                    Notification notification = this.notification(1, 13511, voice + " is an invalid voice value.");
                    NotificationsDao notifications = this.storage.getNotificationsDao();
                    notifications.addNotification(notification);
                    voice = "man";
                }
            } else {
                voice = "man";
            }
        }
        String language = "en";
        attribute = this.verb.attribute("language");
        if (attribute != null) {
            language = attribute.value();
            if (language != null && !language.isEmpty()) {
                if (!this.synthesizerInfo.languages().contains(language)) {
                    language = "en";
                }
            } else {
                language = "en";
            }
        }
        String text = this.verb.text();
        details.put("voice", voice);
        details.put("language", language);
        details.put("text", text);
        return details;
    }

    final class SendingSms
    extends AbstractAction {
        public SendingSms(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String action;
            URI uri;
            URI base;
            URI target;
            String callback;
            SmsServiceResponse response = (SmsServiceResponse)message;
            ActorRef session = (ActorRef)response.get();
            NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
            String from = BaseVoiceInterpreter.this.callInfo.to();
            Attribute attribute = BaseVoiceInterpreter.this.verb.attribute("from");
            if (attribute != null && (from = attribute.value()) != null && !from.isEmpty() && (from = BaseVoiceInterpreter.this.e164(from)) == null) {
                from = BaseVoiceInterpreter.this.verb.attribute("from").value();
                Notification notification = BaseVoiceInterpreter.this.notification(0, 14102, from + " is an invalid 'from' phone number.");
                notifications.addNotification(notification);
                BaseVoiceInterpreter.this.sendMail(notification);
                BaseVoiceInterpreter.this.smsService.tell((Object)new DestroySmsSession(session), this.source);
                StopInterpreter stop = new StopInterpreter();
                this.source.tell((Object)stop, this.source);
                return;
            }
            String to = BaseVoiceInterpreter.this.callInfo.from();
            attribute = BaseVoiceInterpreter.this.verb.attribute("to");
            if (attribute != null && (to = attribute.value()) != null && !to.isEmpty() && (to = BaseVoiceInterpreter.this.e164(to)) == null) {
                to = BaseVoiceInterpreter.this.verb.attribute("to").value();
                Notification notification = BaseVoiceInterpreter.this.notification(0, 14101, to + " is an invalid 'to' phone number.");
                notifications.addNotification(notification);
                BaseVoiceInterpreter.this.sendMail(notification);
                BaseVoiceInterpreter.this.smsService.tell((Object)new DestroySmsSession(session), this.source);
                StopInterpreter stop = new StopInterpreter();
                this.source.tell((Object)stop, this.source);
                return;
            }
            String body = BaseVoiceInterpreter.this.verb.text();
            if (body == null || body.isEmpty()) {
                Notification notification = BaseVoiceInterpreter.this.notification(0, 14103, body + " is an invalid SMS body.");
                notifications.addNotification(notification);
                BaseVoiceInterpreter.this.sendMail(notification);
                BaseVoiceInterpreter.this.smsService.tell((Object)new DestroySmsSession(session), this.source);
                StopInterpreter stop = new StopInterpreter();
                this.source.tell((Object)stop, this.source);
                return;
            }
            session.tell((Object)new Observe(this.source), this.source);
            attribute = BaseVoiceInterpreter.this.verb.attribute("statusCallback");
            if (attribute != null && (callback = attribute.value()) != null && !callback.isEmpty()) {
                target = null;
                try {
                    target = URI.create(callback);
                }
                catch (Exception exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(0, 14105, callback + " is an invalid URI.");
                    notifications.addNotification(notification);
                    BaseVoiceInterpreter.this.sendMail(notification);
                    BaseVoiceInterpreter.this.smsService.tell((Object)new DestroySmsSession(session), this.source);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                base = BaseVoiceInterpreter.this.request.getUri();
                uri = UriUtils.resolve((URI)base, (URI)target);
                session.tell((Object)new SmsSessionAttribute("callback", (Object)uri), this.source);
            }
            Sid sid = Sid.generate((Sid.Type)Sid.Type.SMS_MESSAGE);
            SmsMessage.Builder builder = SmsMessage.builder();
            builder.setSid(sid);
            builder.setAccountSid(BaseVoiceInterpreter.this.accountId);
            builder.setApiVersion(BaseVoiceInterpreter.this.version);
            builder.setRecipient(to);
            builder.setSender(from);
            builder.setBody(body);
            builder.setDirection(SmsMessage.Direction.OUTBOUND_REPLY);
            builder.setStatus(SmsMessage.Status.SENDING);
            builder.setPrice(new BigDecimal("0.00"));
            StringBuilder buffer = new StringBuilder();
            buffer.append("/").append(BaseVoiceInterpreter.this.version).append("/Accounts/");
            buffer.append(BaseVoiceInterpreter.this.accountId.toString()).append("/SMS/Messages/");
            buffer.append(sid.toString());
            uri = URI.create(buffer.toString());
            builder.setUri(uri);
            SmsMessage record = builder.build();
            SmsMessagesDao messages = BaseVoiceInterpreter.this.storage.getSmsMessagesDao();
            messages.addSmsMessage(record);
            session.tell((Object)new SmsSessionAttribute("record", (Object)record), this.source);
            SmsSessionRequest sms = new SmsSessionRequest(from, to, body, null);
            session.tell((Object)sms, this.source);
            BaseVoiceInterpreter.this.smsSessions.put(sid, session);
            attribute = BaseVoiceInterpreter.this.verb.attribute("action");
            if (attribute != null && (action = attribute.value()) != null && !action.isEmpty()) {
                target = null;
                try {
                    target = URI.create(action);
                }
                catch (Exception exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(0, 11100, action + " is an invalid URI.");
                    notifications.addNotification(notification);
                    BaseVoiceInterpreter.this.sendMail(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                base = BaseVoiceInterpreter.this.request.getUri();
                uri = UriUtils.resolve((URI)base, (URI)target);
                String method = "POST";
                attribute = BaseVoiceInterpreter.this.verb.attribute("method");
                if (attribute != null) {
                    method = attribute.value();
                    if (method != null && !method.isEmpty()) {
                        if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                            Notification notification = BaseVoiceInterpreter.this.notification(1, 14104, method + " is not a valid HTTP method for <Sms>");
                            notifications.addNotification(notification);
                            method = "POST";
                        }
                    } else {
                        method = "POST";
                    }
                }
                List<NameValuePair> parameters = BaseVoiceInterpreter.this.parameters();
                String status = SmsMessage.Status.SENDING.toString();
                parameters.add((NameValuePair)new BasicNameValuePair("SmsStatus", status));
                BaseVoiceInterpreter.this.request = new HttpRequestDescriptor(uri, method, parameters);
                BaseVoiceInterpreter.this.downloader.tell((Object)BaseVoiceInterpreter.this.request, this.source);
                return;
            }
            GetNextVerb next = GetNextVerb.instance();
            BaseVoiceInterpreter.this.parser.tell((Object)next, this.source);
        }
    }

    final class CreatingSmsSession
    extends AbstractAction {
        public CreatingSmsSession(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                BaseVoiceInterpreter.this.verb = (Tag)message;
            }
            BaseVoiceInterpreter.this.smsService.tell((Object)new CreateSmsSession(BaseVoiceInterpreter.this.callInfo.from(), BaseVoiceInterpreter.this.callInfo.to(), BaseVoiceInterpreter.this.accountId.toString(), false), this.source);
        }
    }

    final class FinishRecording
    extends AbstractAction {
        public FinishRecording(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String value;
            Class<?> klass = message.getClass();
            if (CallStateChanged.class.equals(klass)) {
                CallStateChanged event = (CallStateChanged)message;
                BaseVoiceInterpreter.this.callState = event.state();
                BaseVoiceInterpreter.this.callRecord = BaseVoiceInterpreter.this.callRecord.setStatus(BaseVoiceInterpreter.this.callState.toString());
                DateTime end = DateTime.now();
                BaseVoiceInterpreter.this.callRecord = BaseVoiceInterpreter.this.callRecord.setEndTime(end);
                int seconds = (int)(end.getMillis() - BaseVoiceInterpreter.this.callRecord.getStartTime().getMillis()) / 1000;
                BaseVoiceInterpreter.this.callRecord = BaseVoiceInterpreter.this.callRecord.setDuration(Integer.valueOf(seconds));
                CallDetailRecordsDao records = BaseVoiceInterpreter.this.storage.getCallDetailRecordsDao();
                records.updateCallDetailRecord(BaseVoiceInterpreter.this.callRecord);
            }
            NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
            Double duration = WavUtils.getAudioDuration((URI)BaseVoiceInterpreter.this.recordingUri);
            if (duration.equals(0.0)) {
                DateTime end = DateTime.now();
                duration = new Double((end.getMillis() - BaseVoiceInterpreter.this.callRecord.getStartTime().getMillis()) / 1000L);
            } else if (BaseVoiceInterpreter.this.logger.isDebugEnabled()) {
                BaseVoiceInterpreter.this.logger.debug("File already exists, length: " + new File(BaseVoiceInterpreter.this.recordingUri).length());
            }
            Recording.Builder builder = Recording.builder();
            builder.setSid(BaseVoiceInterpreter.this.recordingSid);
            builder.setAccountSid(BaseVoiceInterpreter.this.accountId);
            builder.setCallSid(BaseVoiceInterpreter.this.callInfo.sid());
            builder.setDuration(duration.doubleValue());
            builder.setApiVersion(BaseVoiceInterpreter.this.version);
            StringBuilder buffer = new StringBuilder();
            buffer.append("/").append(BaseVoiceInterpreter.this.version).append("/Accounts/").append(BaseVoiceInterpreter.this.accountId.toString());
            buffer.append("/Recordings/").append(BaseVoiceInterpreter.this.recordingSid.toString());
            builder.setUri(URI.create(buffer.toString()));
            Recording recording = builder.build();
            RecordingsDao recordings = BaseVoiceInterpreter.this.storage.getRecordingsDao();
            recordings.addRecording(recording);
            URI transcribeCallback = null;
            Attribute attribute = BaseVoiceInterpreter.this.verb.attribute("transcribeCallback");
            if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                try {
                    transcribeCallback = URI.create(value);
                }
                catch (Exception exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(0, 11100, transcribeCallback + " is an invalid URI.");
                    notifications.addNotification(notification);
                    BaseVoiceInterpreter.this.sendMail(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
            }
            boolean transcribe = false;
            if (transcribeCallback != null) {
                transcribe = true;
            } else {
                String value2;
                attribute = BaseVoiceInterpreter.this.verb.attribute("transcribe");
                if (attribute != null && (value2 = attribute.value()) != null && !value2.isEmpty()) {
                    transcribe = Boolean.parseBoolean(value2);
                }
            }
            if (transcribe) {
                Sid sid = Sid.generate((Sid.Type)Sid.Type.TRANSCRIPTION);
                Transcription.Builder otherBuilder = Transcription.builder();
                otherBuilder.setSid(sid);
                otherBuilder.setAccountSid(BaseVoiceInterpreter.this.accountId);
                otherBuilder.setStatus(Transcription.Status.IN_PROGRESS);
                otherBuilder.setRecordingSid(BaseVoiceInterpreter.this.recordingSid);
                otherBuilder.setDuration(duration.doubleValue());
                otherBuilder.setPrice(new BigDecimal("0.00"));
                buffer = new StringBuilder();
                buffer.append("/").append(BaseVoiceInterpreter.this.version).append("/Accounts/").append(BaseVoiceInterpreter.this.accountId.toString());
                buffer.append("/Transcriptions/").append(sid.toString());
                URI uri = URI.create(buffer.toString());
                otherBuilder.setUri(uri);
                Transcription transcription = otherBuilder.build();
                TranscriptionsDao transcriptions = BaseVoiceInterpreter.this.storage.getTranscriptionsDao();
                transcriptions.addTranscription(transcription);
                try {
                    HashMap<String, URI> attributes = new HashMap<String, URI>();
                    attributes.put("callback", transcribeCallback);
                    attributes.put("transcription", (URI)transcription);
                    BaseVoiceInterpreter.this.getAsrService().tell((Object)new AsrRequest(new File(BaseVoiceInterpreter.this.recordingUri), "en", attributes), this.source);
                    ++BaseVoiceInterpreter.this.outstandingAsrRequests;
                }
                catch (Exception exception) {
                    BaseVoiceInterpreter.this.logger.error(exception.getMessage(), (Object)exception);
                }
            }
            String action = null;
            attribute = BaseVoiceInterpreter.this.verb.attribute("action");
            if (attribute != null && (action = attribute.value()) != null && !action.isEmpty()) {
                URI target = null;
                try {
                    target = URI.create(action);
                }
                catch (Exception exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(0, 11100, action + " is an invalid URI.");
                    notifications.addNotification(notification);
                    BaseVoiceInterpreter.this.sendMail(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                URI base = BaseVoiceInterpreter.this.request.getUri();
                URI uri = UriUtils.resolve((URI)base, (URI)target);
                String method = "POST";
                attribute = BaseVoiceInterpreter.this.verb.attribute("method");
                if (attribute != null) {
                    method = attribute.value();
                    if (method != null && !method.isEmpty()) {
                        if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                            Notification notification = BaseVoiceInterpreter.this.notification(1, 13610, method + " is not a valid HTTP method for <Record>");
                            notifications.addNotification(notification);
                            method = "POST";
                        }
                    } else {
                        method = "POST";
                    }
                }
                List<NameValuePair> parameters = BaseVoiceInterpreter.this.parameters();
                boolean amazonS3Enabled = BaseVoiceInterpreter.this.configuration.subset("amazon-s3").getBoolean("enabled");
                if (amazonS3Enabled) {
                    parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", recording.getFileUri().toURL().toString()));
                    parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", recording.getFileUri().toURL().toString()));
                } else {
                    String httpRecordingUri = BaseVoiceInterpreter.this.configuration.subset("runtime-settings").getString("recordings-uri");
                    if (!httpRecordingUri.endsWith("/")) {
                        httpRecordingUri = httpRecordingUri + "/";
                    }
                    httpRecordingUri = httpRecordingUri + BaseVoiceInterpreter.this.recordingSid.toString() + ".wav";
                    URI publicRecordingUri = UriUtils.resolve((URI)new URI(httpRecordingUri));
                    parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", BaseVoiceInterpreter.this.recordingUri.toString()));
                    parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", publicRecordingUri.toString()));
                }
                parameters.add((NameValuePair)new BasicNameValuePair("RecordingDuration", Double.toString(duration)));
                if (MediaGroupResponse.class.equals(klass)) {
                    MediaGroupResponse response = (MediaGroupResponse)message;
                    parameters.add((NameValuePair)new BasicNameValuePair("Digits", (String)response.get()));
                    BaseVoiceInterpreter.this.request = new HttpRequestDescriptor(uri, method, parameters);
                    if (BaseVoiceInterpreter.this.logger.isInfoEnabled()) {
                        BaseVoiceInterpreter.this.logger.info("About to execute Record action to: " + uri);
                    }
                    BaseVoiceInterpreter.this.downloader.tell((Object)BaseVoiceInterpreter.this.request, BaseVoiceInterpreter.this.self());
                    BaseVoiceInterpreter.this.recordingSid = null;
                    BaseVoiceInterpreter.this.recordingUri = null;
                    return;
                }
                if (CallStateChanged.class.equals(klass)) {
                    parameters.add((NameValuePair)new BasicNameValuePair("Digits", "hangup"));
                    BaseVoiceInterpreter.this.request = new HttpRequestDescriptor(uri, method, parameters);
                    if (BaseVoiceInterpreter.this.logger.isInfoEnabled()) {
                        BaseVoiceInterpreter.this.logger.info("About to execute Record action to: " + uri);
                    }
                    BaseVoiceInterpreter.this.downloader.tell((Object)BaseVoiceInterpreter.this.request, BaseVoiceInterpreter.this.self());
                    BaseVoiceInterpreter.this.recordingSid = null;
                    BaseVoiceInterpreter.this.recordingUri = null;
                }
            }
            if (CallStateChanged.class.equals(klass)) {
                if (action == null || action.isEmpty()) {
                    this.source.tell((Object)new StopInterpreter(), this.source);
                }
            } else {
                GetNextVerb next = GetNextVerb.instance();
                BaseVoiceInterpreter.this.parser.tell((Object)next, this.source);
            }
            BaseVoiceInterpreter.this.recordingSid = null;
            BaseVoiceInterpreter.this.recordingUri = null;
        }
    }

    final class CreatingRecording
    extends AbstractAction {
        public CreatingRecording(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String value;
            String value2;
            String value3;
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                BaseVoiceInterpreter.this.verb = (Tag)message;
            }
            NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
            String finishOnKey = "1234567890*#";
            Attribute attribute = BaseVoiceInterpreter.this.verb.attribute("finishOnKey");
            if (attribute != null) {
                finishOnKey = attribute.value();
                if (finishOnKey != null && !finishOnKey.isEmpty()) {
                    if (!PATTERN.matcher(finishOnKey).matches()) {
                        Notification notification = BaseVoiceInterpreter.this.notification(1, 13613, finishOnKey + " is not a valid finishOnKey value");
                        notifications.addNotification(notification);
                        finishOnKey = "1234567890*#";
                    }
                } else {
                    finishOnKey = "1234567890*#";
                }
            }
            boolean playBeep = true;
            attribute = BaseVoiceInterpreter.this.verb.attribute("playBeep");
            if (attribute != null && (value3 = attribute.value()) != null && !value3.isEmpty()) {
                playBeep = Boolean.parseBoolean(value3);
            }
            int maxLength = 3600;
            attribute = BaseVoiceInterpreter.this.verb.attribute("maxLength");
            if (attribute != null && (value2 = attribute.value()) != null && !value2.isEmpty()) {
                try {
                    maxLength = Integer.parseInt(value2);
                }
                catch (NumberFormatException exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(1, 13612, maxLength + " is not a valid maxLength value");
                    notifications.addNotification(notification);
                }
            }
            int timeout = 5;
            attribute = BaseVoiceInterpreter.this.verb.attribute("timeout");
            if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                try {
                    timeout = Integer.parseInt(value);
                }
                catch (NumberFormatException exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(1, 13612, timeout + " is not a valid timeout value");
                    notifications.addNotification(notification);
                }
            }
            BaseVoiceInterpreter.this.recordingSid = Sid.generate((Sid.Type)Sid.Type.RECORDING);
            String path = BaseVoiceInterpreter.this.configuration.subset("runtime-settings").getString("recordings-path");
            String httpRecordingUri = BaseVoiceInterpreter.this.configuration.subset("runtime-settings").getString("recordings-uri");
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            if (!httpRecordingUri.endsWith("/")) {
                httpRecordingUri = httpRecordingUri + "/";
            }
            path = path + BaseVoiceInterpreter.this.recordingSid.toString() + ".wav";
            httpRecordingUri = httpRecordingUri + BaseVoiceInterpreter.this.recordingSid.toString() + ".wav";
            BaseVoiceInterpreter.this.recordingUri = URI.create(path);
            try {
                BaseVoiceInterpreter.this.publicRecordingUri = UriUtils.resolve((URI)new URI(httpRecordingUri));
            }
            catch (URISyntaxException e) {
                BaseVoiceInterpreter.this.logger.error("URISyntaxException when trying to resolve Recording URI: " + e);
            }
            Record record = null;
            if (playBeep) {
                ArrayList<URI> prompts = new ArrayList<URI>(1);
                path = BaseVoiceInterpreter.this.configuration.subset("runtime-settings").getString("prompts-uri");
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                path = path + "beep.wav";
                try {
                    prompts.add(UriUtils.resolve((URI)new URI(path)));
                }
                catch (Exception exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(0, 12400, exception.getMessage());
                    notifications.addNotification(notification);
                    BaseVoiceInterpreter.this.sendMail(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                record = new Record(BaseVoiceInterpreter.this.recordingUri, prompts, timeout, maxLength, finishOnKey);
            } else {
                record = new Record(BaseVoiceInterpreter.this.recordingUri, timeout, maxLength, finishOnKey);
            }
            BaseVoiceInterpreter.this.call.tell((Object)record, this.source);
        }
    }

    final class FinishGathering
    extends AbstractGatherAction {
        public FinishGathering(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String action;
            NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
            Attribute attribute = BaseVoiceInterpreter.this.verb.attribute("action");
            String digits = BaseVoiceInterpreter.this.collectedDigits.toString();
            BaseVoiceInterpreter.this.collectedDigits = new StringBuffer();
            if (BaseVoiceInterpreter.this.logger.isInfoEnabled()) {
                BaseVoiceInterpreter.this.logger.info("Digits collected: " + digits);
            }
            if (digits.equals(BaseVoiceInterpreter.this.finishOnKey)) {
                digits = "";
            }
            if (BaseVoiceInterpreter.this.logger.isDebugEnabled()) {
                BaseVoiceInterpreter.this.logger.debug("Digits collected : " + digits);
            }
            if (attribute != null && digits != null && !digits.trim().isEmpty() && (action = attribute.value()) != null && !action.isEmpty()) {
                URI target = null;
                try {
                    target = URI.create(action);
                }
                catch (Exception exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(0, 11100, action + " is an invalid URI.");
                    notifications.addNotification(notification);
                    BaseVoiceInterpreter.this.sendMail(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                URI base = BaseVoiceInterpreter.this.request.getUri();
                URI uri = UriUtils.resolve((URI)base, (URI)target);
                String method = "POST";
                attribute = BaseVoiceInterpreter.this.verb.attribute("method");
                if (attribute != null) {
                    method = attribute.value();
                    if (method != null && !method.isEmpty()) {
                        if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                            Notification notification = BaseVoiceInterpreter.this.notification(1, 14104, method + " is not a valid HTTP method for <Gather>");
                            notifications.addNotification(notification);
                            method = "POST";
                        }
                    } else {
                        method = "POST";
                    }
                }
                if (digits.endsWith(BaseVoiceInterpreter.this.finishOnKey)) {
                    int finishOnKeyIndex = digits.lastIndexOf(BaseVoiceInterpreter.this.finishOnKey);
                    digits = digits.substring(0, finishOnKeyIndex);
                }
                List<NameValuePair> parameters = BaseVoiceInterpreter.this.parameters();
                parameters.add((NameValuePair)new BasicNameValuePair("Digits", digits));
                BaseVoiceInterpreter.this.request = new HttpRequestDescriptor(uri, method, parameters);
                BaseVoiceInterpreter.this.downloader.tell((Object)BaseVoiceInterpreter.this.request, this.source);
                return;
            }
            if (BaseVoiceInterpreter.this.logger.isInfoEnabled()) {
                BaseVoiceInterpreter.this.logger.info("Attribute, Action or Digits is null, FinishGathering failed, moving to the next available verb");
            }
            GetNextVerb next = GetNextVerb.instance();
            BaseVoiceInterpreter.this.parser.tell((Object)next, this.source);
        }
    }

    final class Gathering
    extends AbstractGatherAction {
        public Gathering(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String value;
            String value2;
            NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
            BaseVoiceInterpreter.this.finishOnKey = this.finishOnKey(BaseVoiceInterpreter.this.verb);
            Attribute attribute = BaseVoiceInterpreter.this.verb.attribute("numDigits");
            if (attribute != null && (value2 = attribute.value()) != null && !value2.isEmpty()) {
                try {
                    BaseVoiceInterpreter.this.numberOfDigits = Integer.parseInt(value2);
                }
                catch (NumberFormatException exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(1, 13314, BaseVoiceInterpreter.this.numberOfDigits + " is not a valid numDigits value");
                    notifications.addNotification(notification);
                }
            }
            int timeout = 5;
            attribute = BaseVoiceInterpreter.this.verb.attribute("timeout");
            if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                try {
                    timeout = Integer.parseInt(value);
                }
                catch (NumberFormatException exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(1, 13313, timeout + " is not a valid timeout value");
                    notifications.addNotification(notification);
                }
            }
            Collect collect = new Collect(BaseVoiceInterpreter.this.gatherPrompts, null, timeout, BaseVoiceInterpreter.this.finishOnKey, BaseVoiceInterpreter.this.numberOfDigits);
            BaseVoiceInterpreter.this.call.tell((Object)collect, this.source);
            BaseVoiceInterpreter.this.gatherChildren = null;
            BaseVoiceInterpreter.this.gatherPrompts = null;
            BaseVoiceInterpreter.this.dtmfReceived = false;
            BaseVoiceInterpreter.this.collectedDigits = new StringBuffer("");
        }
    }

    final class ProcessingGatherChildren
    extends AbstractGatherAction {
        public ProcessingGatherChildren(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            BaseVoiceInterpreter.this.processingGather = true;
            Class<?> klass = message.getClass();
            NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
            if (SpeechSynthesizerResponse.class.equals(klass)) {
                SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
                DiskCacheRequest request = new DiskCacheRequest((URI)response.get());
                BaseVoiceInterpreter.this.getCache().tell((Object)request, this.source);
            } else {
                if (Tag.class.equals(klass)) {
                    BaseVoiceInterpreter.this.verb = (Tag)message;
                    BaseVoiceInterpreter.this.gatherPrompts = new ArrayList<URI>();
                    BaseVoiceInterpreter.this.gatherChildren = new ArrayList<Tag>(BaseVoiceInterpreter.this.verb.children());
                } else if (DiskCacheResponse.class.equals(klass)) {
                    int loop;
                    URI uri;
                    block35: {
                        String number;
                        if (BaseVoiceInterpreter.this.gatherPrompts == null) {
                            BaseVoiceInterpreter.this.gatherPrompts = new ArrayList<URI>();
                        }
                        if (BaseVoiceInterpreter.this.gatherChildren == null) {
                            BaseVoiceInterpreter.this.gatherChildren = new ArrayList<Tag>(BaseVoiceInterpreter.this.verb.children());
                        }
                        DiskCacheResponse response = (DiskCacheResponse)message;
                        uri = (URI)response.get();
                        Tag child = null;
                        if (!BaseVoiceInterpreter.this.gatherChildren.isEmpty()) {
                            child = BaseVoiceInterpreter.this.gatherChildren.remove(0);
                        }
                        loop = 1;
                        Attribute attribute = null;
                        if (child != null) {
                            attribute = child.attribute("loop");
                        }
                        if (attribute != null && (number = attribute.value()) != null && !number.isEmpty()) {
                            try {
                                loop = Integer.parseInt(number);
                            }
                            catch (NumberFormatException ignored) {
                                Notification notification = null;
                                if (!"Say".equals(child.name())) break block35;
                                notification = BaseVoiceInterpreter.this.notification(1, 13322, loop + " is an invalid loop value.");
                                notifications.addNotification(notification);
                            }
                        }
                    }
                    for (int counter = 0; counter < loop; ++counter) {
                        BaseVoiceInterpreter.this.gatherPrompts.add(uri);
                    }
                }
                for (int index = 0; index < BaseVoiceInterpreter.this.gatherChildren.size(); ++index) {
                    String path;
                    String number;
                    Tag child = BaseVoiceInterpreter.this.gatherChildren.get(index);
                    if ("Play".equals(child.name())) {
                        String text = child.text();
                        if (text == null || text.isEmpty()) continue;
                        URI target = null;
                        try {
                            target = URI.create(text);
                        }
                        catch (Exception exception) {
                            Notification notification = BaseVoiceInterpreter.this.notification(0, 13325, text + " is an invalid URI.");
                            notifications.addNotification(notification);
                            BaseVoiceInterpreter.this.sendMail(notification);
                            StopInterpreter stop = new StopInterpreter();
                            this.source.tell((Object)stop, this.source);
                            return;
                        }
                        URI base = BaseVoiceInterpreter.this.request.getUri();
                        URI uri = UriUtils.resolve((URI)base, (URI)target);
                        DiskCacheRequest request = new DiskCacheRequest(uri);
                        BaseVoiceInterpreter.this.getCache().tell((Object)request, this.source);
                        break;
                    }
                    if ("Say".equals(child.name())) {
                        String text;
                        String voice = "man";
                        Attribute attribute = child.attribute("voice");
                        if (attribute != null) {
                            voice = attribute.value();
                            if (voice != null && !voice.isEmpty()) {
                                if (!"man".equals(voice) && !"woman".equals(voice)) {
                                    Notification notification = BaseVoiceInterpreter.this.notification(1, 13321, voice + " is an invalid voice value.");
                                    notifications.addNotification(notification);
                                    voice = "man";
                                }
                            } else {
                                voice = "man";
                            }
                        }
                        String language = "en";
                        attribute = child.attribute("language");
                        if (attribute != null) {
                            language = attribute.value();
                            if (language != null && !language.isEmpty()) {
                                if (!BaseVoiceInterpreter.this.synthesizerInfo.languages().contains(language)) {
                                    language = "en";
                                }
                            } else {
                                language = "en";
                            }
                        }
                        if ((text = child.text()) == null || text.isEmpty()) continue;
                        String hash = BaseVoiceInterpreter.this.hash(child);
                        DiskCacheRequest request = new DiskCacheRequest(hash);
                        BaseVoiceInterpreter.this.getCache().tell((Object)request, this.source);
                        break;
                    }
                    if (!"Pause".equals(child.name())) continue;
                    int length = 1;
                    Attribute attribute = child.attribute("length");
                    if (attribute != null && (number = attribute.value()) != null && !number.isEmpty()) {
                        try {
                            length = Integer.parseInt(number);
                        }
                        catch (NumberFormatException ignored) {
                            // empty catch block
                        }
                    }
                    if (!(path = BaseVoiceInterpreter.this.configuration.subset("runtime-settings").getString("prompts-uri")).endsWith("/")) {
                        path = path + "/";
                    }
                    path = path + "one-second-silence.wav";
                    URI uri = UriUtils.resolve((URI)new URI(path));
                    for (int counter = 0; counter < length; ++counter) {
                        BaseVoiceInterpreter.this.gatherPrompts.add(uri);
                    }
                }
                if (!BaseVoiceInterpreter.this.gatherChildren.isEmpty()) {
                    Tag child = null;
                    do {
                        if ((child = BaseVoiceInterpreter.this.gatherChildren.get(0)) == null || !"Pause".equals(child.name())) continue;
                        BaseVoiceInterpreter.this.gatherChildren.remove(0);
                    } while ("Pause".equals(child.name()));
                }
                if (BaseVoiceInterpreter.this.gatherChildren.isEmpty()) {
                    if (BaseVoiceInterpreter.this.gatherVerb != null) {
                        BaseVoiceInterpreter.this.verb = BaseVoiceInterpreter.this.gatherVerb;
                    }
                    StartGathering start = StartGathering.instance();
                    this.source.tell((Object)start, this.source);
                    BaseVoiceInterpreter.this.processingGather = false;
                }
            }
        }
    }

    abstract class AbstractGatherAction
    extends AbstractAction {
        public AbstractGatherAction(ActorRef source) {
            super(source);
        }

        protected String finishOnKey(Tag container) {
            String finishOnKey = "#";
            Attribute attribute = container.attribute("finishOnKey");
            if (attribute != null) {
                finishOnKey = attribute.value();
                if (finishOnKey != null && !finishOnKey.isEmpty()) {
                    if (!PATTERN.matcher(finishOnKey).matches()) {
                        NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
                        Notification notification = BaseVoiceInterpreter.this.notification(1, 13310, finishOnKey + " is not a valid finishOnKey value");
                        notifications.addNotification(notification);
                        finishOnKey = "#";
                    }
                } else {
                    finishOnKey = "#";
                }
            }
            return finishOnKey;
        }
    }

    final class Redirecting
    extends AbstractAction {
        public Redirecting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String text;
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                BaseVoiceInterpreter.this.verb = (Tag)message;
            }
            NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
            String method = "POST";
            Attribute attribute = BaseVoiceInterpreter.this.verb.attribute("method");
            if (attribute != null) {
                method = attribute.value();
                if (method != null && !method.isEmpty()) {
                    if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                        Notification notification = BaseVoiceInterpreter.this.notification(1, 13710, method + " is not a valid HTTP method for <Redirect>");
                        notifications.addNotification(notification);
                        method = "POST";
                    }
                } else {
                    method = "POST";
                }
            }
            if ((text = BaseVoiceInterpreter.this.verb.text()) != null && !text.isEmpty()) {
                URI target = null;
                try {
                    target = URI.create(text);
                }
                catch (Exception exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(0, 11100, text + " is an invalid URI.");
                    notifications.addNotification(notification);
                    BaseVoiceInterpreter.this.sendMail(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                URI base = BaseVoiceInterpreter.this.request.getUri();
                URI uri = UriUtils.resolve((URI)base, (URI)target);
                List<NameValuePair> parameters = BaseVoiceInterpreter.this.parameters();
                BaseVoiceInterpreter.this.request = new HttpRequestDescriptor(uri, method, parameters);
                BaseVoiceInterpreter.this.downloader.tell((Object)BaseVoiceInterpreter.this.request, this.source);
            } else {
                GetNextVerb next = GetNextVerb.instance();
                BaseVoiceInterpreter.this.parser.tell((Object)next, this.source);
            }
        }
    }

    final class HangingUp
    extends AbstractAction {
        public HangingUp(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                BaseVoiceInterpreter.this.verb = (Tag)message;
            }
            if (ParserFailed.class.equals(klass)) {
                BaseVoiceInterpreter.this.call.tell((Object)new Hangup("Problem_to_parse_downloaded_RCML"), this.source);
            } else if (CallManagerResponse.class.equals(klass)) {
                String reason = ((CallManagerResponse)message).cause().getMessage().replaceAll("\\s", "_");
                BaseVoiceInterpreter.this.call.tell((Object)new Hangup(reason), this.source);
            } else if (message instanceof SmsServiceResponse) {
                BaseVoiceInterpreter.this.call.tell((Object)new Hangup(((SmsServiceResponse)message).cause().getMessage()), BaseVoiceInterpreter.this.self());
            } else if (Tag.class.equals(klass) && "Hangup".equals(BaseVoiceInterpreter.this.verb.name())) {
                Integer sipResponse = BaseVoiceInterpreter.this.outboundCallResponse != null ? BaseVoiceInterpreter.this.outboundCallResponse : 487;
                BaseVoiceInterpreter.this.call.tell((Object)new Hangup(sipResponse), this.source);
            } else {
                BaseVoiceInterpreter.this.call.tell((Object)new Hangup(BaseVoiceInterpreter.this.outboundCallResponse), this.source);
            }
        }
    }

    final class Synthesizing
    extends AbstractAction {
        public Synthesizing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Map<String, String> details;
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                BaseVoiceInterpreter.this.verb = (Tag)message;
            }
            if ((details = BaseVoiceInterpreter.this.getSynthesizeDetails(BaseVoiceInterpreter.this.verb)) != null && !details.isEmpty() && details.get("text") != null) {
                String voice = details.get("voice");
                String language = details.get("language");
                String text = details.get("text");
                SpeechSynthesizerRequest synthesize = new SpeechSynthesizerRequest(voice, language, text);
                BaseVoiceInterpreter.this.getSynthesizer().tell((Object)synthesize, this.source);
            } else {
                GetNextVerb next = GetNextVerb.instance();
                BaseVoiceInterpreter.this.parser.tell((Object)next, this.source);
            }
        }
    }

    final class Playing
    extends AbstractAction {
        public Playing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (DiskCacheResponse.class.equals(klass)) {
                int loop;
                block5: {
                    String number;
                    loop = 1;
                    Attribute attribute = BaseVoiceInterpreter.this.verb.attribute("loop");
                    if (attribute != null && (number = attribute.value()) != null && !number.isEmpty()) {
                        try {
                            loop = Integer.parseInt(number);
                        }
                        catch (NumberFormatException ignored) {
                            NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
                            Notification notification = null;
                            if ("Say".equals(BaseVoiceInterpreter.this.verb.name())) {
                                notification = BaseVoiceInterpreter.this.notification(1, 13510, loop + " is an invalid loop value.");
                                notifications.addNotification(notification);
                            }
                            if (!"Play".equals(BaseVoiceInterpreter.this.verb.name())) break block5;
                            notification = BaseVoiceInterpreter.this.notification(1, 13410, loop + " is an invalid loop value.");
                            notifications.addNotification(notification);
                        }
                    }
                }
                DiskCacheResponse response = (DiskCacheResponse)message;
                Play play = new Play((URI)response.get(), loop);
                BaseVoiceInterpreter.this.call.tell((Object)play, this.source);
            }
        }
    }

    final class Caching
    extends AbstractAction {
        public Caching(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (SpeechSynthesizerResponse.class.equals(klass)) {
                SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
                DiskCacheRequest request = new DiskCacheRequest((URI)response.get());
                BaseVoiceInterpreter.this.getCache().tell((Object)request, this.source);
            } else if (Tag.class.equals(klass)) {
                String text;
                if (Tag.class.equals(klass)) {
                    BaseVoiceInterpreter.this.verb = (Tag)message;
                }
                if ((text = BaseVoiceInterpreter.this.verb.text()) != null && !text.isEmpty()) {
                    URI target = null;
                    try {
                        target = URI.create(text);
                    }
                    catch (Exception exception) {
                        Notification notification = BaseVoiceInterpreter.this.notification(0, 11100, text + " is an invalid URI.");
                        NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
                        notifications.addNotification(notification);
                        BaseVoiceInterpreter.this.sendMail(notification);
                        StopInterpreter stop = new StopInterpreter();
                        this.source.tell((Object)stop, this.source);
                        return;
                    }
                    URI base = BaseVoiceInterpreter.this.request.getUri();
                    URI uri = UriUtils.resolve((URI)base, (URI)target);
                    DiskCacheRequest request = new DiskCacheRequest(uri);
                    BaseVoiceInterpreter.this.getCache().tell((Object)request, this.source);
                } else {
                    GetNextVerb next = GetNextVerb.instance();
                    BaseVoiceInterpreter.this.parser.tell((Object)next, this.source);
                }
            }
        }
    }

    final class CheckCache
    extends AbstractAction {
        public CheckCache(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                BaseVoiceInterpreter.this.verb = (Tag)message;
            }
            String hash = BaseVoiceInterpreter.this.hash(BaseVoiceInterpreter.this.verb);
            DiskCacheRequest request = new DiskCacheRequest(hash);
            if (BaseVoiceInterpreter.this.logger.isErrorEnabled()) {
                BaseVoiceInterpreter.this.logger.info("Checking cache for hash: " + hash);
            }
            BaseVoiceInterpreter.this.getCache().tell((Object)request, this.source);
        }
    }

    final class Pausing
    extends AbstractAction {
        public Pausing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String number;
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                BaseVoiceInterpreter.this.verb = (Tag)message;
            }
            int length = 1;
            Attribute attribute = BaseVoiceInterpreter.this.verb.attribute("length");
            if (attribute != null && (number = attribute.value()) != null && !number.isEmpty()) {
                try {
                    length = Integer.parseInt(number);
                }
                catch (NumberFormatException exception) {
                    Notification notification = BaseVoiceInterpreter.this.notification(1, 13910, "Invalid length value.");
                    NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
                    notifications.addNotification(notification);
                }
            }
            UntypedActorContext context = BaseVoiceInterpreter.this.getContext();
            context.setReceiveTimeout((Duration)Duration.create((long)length, (TimeUnit)TimeUnit.SECONDS));
        }
    }

    final class Faxing
    extends AbstractAction {
        public Faxing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            DiskCacheResponse response = (DiskCacheResponse)message;
            String from = BaseVoiceInterpreter.this.callInfo.to();
            Attribute attribute = BaseVoiceInterpreter.this.verb.attribute("from");
            if (attribute != null && (from = attribute.value()) != null && from.isEmpty() && (from = BaseVoiceInterpreter.this.e164(from)) == null) {
                from = BaseVoiceInterpreter.this.verb.attribute("from").value();
                StopInterpreter stop = new StopInterpreter();
                this.source.tell((Object)stop, this.source);
                return;
            }
            String to = BaseVoiceInterpreter.this.callInfo.from();
            attribute = BaseVoiceInterpreter.this.verb.attribute("to");
            if (attribute != null && (to = attribute.value()) != null && !to.isEmpty() && (to = BaseVoiceInterpreter.this.e164(to)) == null) {
                to = BaseVoiceInterpreter.this.verb.attribute("to").value();
                StopInterpreter stop = new StopInterpreter();
                this.source.tell((Object)stop, this.source);
                return;
            }
            String uri = ((URI)response.get()).toString();
            int offset = uri.lastIndexOf("/");
            String path = BaseVoiceInterpreter.this.cachePath + "/" + uri.substring(offset + 1, uri.length());
            FaxRequest fax = new FaxRequest(to, new File(path));
            BaseVoiceInterpreter.this.getFaxService().tell((Object)fax, this.source);
        }
    }

    final class PlayingRejectionPrompt
    extends AbstractAction {
        public PlayingRejectionPrompt(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String path = BaseVoiceInterpreter.this.configuration.subset("runtime-settings").getString("prompts-uri");
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path + "reject.wav";
            URI uri = null;
            try {
                uri = UriUtils.resolve((URI)new URI(path));
            }
            catch (Exception exception) {
                Notification notification = BaseVoiceInterpreter.this.notification(0, 12400, exception.getMessage());
                NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
                notifications.addNotification(notification);
                BaseVoiceInterpreter.this.sendMail(notification);
                StopInterpreter stop = new StopInterpreter();
                this.source.tell((Object)stop, this.source);
                return;
            }
            Play play = new Play(uri, 1);
            BaseVoiceInterpreter.this.call.tell((Object)play, this.source);
        }
    }

    final class Rejecting
    extends AbstractAction {
        public Rejecting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                BaseVoiceInterpreter.this.verb = (Tag)message;
            }
            String reason = "rejected";
            Attribute attribute = BaseVoiceInterpreter.this.verb.attribute("reason");
            if (attribute != null) {
                reason = attribute.value();
                reason = reason != null && !reason.isEmpty() ? ("rejected".equalsIgnoreCase(reason) ? "rejected" : ("busy".equalsIgnoreCase(reason) ? "busy" : "rejected")) : "rejected";
            }
            BaseVoiceInterpreter.this.call.tell((Object)new Reject(reason), this.source);
        }
    }

    final class NotFound
    extends AbstractAction {
        public NotFound(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            DownloaderResponse response = (DownloaderResponse)message;
            if (BaseVoiceInterpreter.this.logger.isDebugEnabled()) {
                BaseVoiceInterpreter.this.logger.debug("response succeeded " + response.succeeded() + ", statusCode " + ((HttpResponseDescriptor)response.get()).getStatusCode());
            }
            Notification notification = BaseVoiceInterpreter.this.notification(1, 21402, "URL Not Found : " + ((HttpResponseDescriptor)response.get()).getURI());
            NotificationsDao notifications = BaseVoiceInterpreter.this.storage.getNotificationsDao();
            notifications.addNotification(notification);
            BaseVoiceInterpreter.this.call.tell((Object)new org.restcomm.connect.telephony.api.NotFound(), this.source);
        }
    }

    final class AcquiringCallInfo
    extends AbstractAction {
        public AcquiringCallInfo(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
            BaseVoiceInterpreter.this.synthesizerInfo = (SpeechSynthesizerInfo)response.get();
            BaseVoiceInterpreter.this.call.tell((Object)new GetCallInfo(), this.source);
        }
    }

    final class AcquiringSpeechSynthesizerInfo
    extends AbstractAction {
        public AcquiringSpeechSynthesizerInfo(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            AsrResponse response = (AsrResponse)message;
            BaseVoiceInterpreter.this.asrInfo = (AsrInfo)response.get();
            BaseVoiceInterpreter.this.getSynthesizer().tell((Object)new GetSpeechSynthesizerInfo(), this.source);
        }
    }

    final class AcquiringAsrInfo
    extends AbstractAction {
        public AcquiringAsrInfo(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            BaseVoiceInterpreter.this.getAsrService().tell((Object)new GetAsrInfo(), this.source);
        }
    }

    abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }

    private final class SendingEmail
    extends AbstractAction {
        public SendingEmail(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Tag verb = (Tag)message;
            Attribute attribute = verb.attribute("from");
            if (attribute == null) {
                Exception error = new Exception("From attribute was not defined");
                this.source.tell((Object)new EmailResponse((Throwable)error, error.getMessage()), this.source);
                return;
            }
            String from = attribute.value();
            attribute = verb.attribute("to");
            if (attribute == null) {
                Exception error = new Exception("To attribute was not defined");
                this.source.tell((Object)new EmailResponse((Throwable)error, error.getMessage()), this.source);
                return;
            }
            String to = attribute.value();
            String cc = "";
            attribute = verb.attribute("cc");
            if (attribute != null) {
                cc = attribute.value();
            }
            String bcc = "";
            attribute = verb.attribute("bcc");
            if (attribute != null) {
                bcc = attribute.value();
            }
            String subject = (attribute = verb.attribute("subject")) != null ? attribute.value() : "Restcomm Email Service";
            Mail emailMsg = new Mail(from, to, subject, verb.text(), cc, bcc);
            if (BaseVoiceInterpreter.this.mailerService == null) {
                BaseVoiceInterpreter.this.mailerService = BaseVoiceInterpreter.this.mailer(BaseVoiceInterpreter.this.configuration.subset("smtp-service"));
            }
            BaseVoiceInterpreter.this.mailerService.tell((Object)new EmailRequest(emailMsg), BaseVoiceInterpreter.this.self());
        }
    }
}

