/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.interpreter;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.cache.DiskCacheFactory;
import org.restcomm.connect.commons.cache.DiskCacheRequest;
import org.restcomm.connect.commons.cache.DiskCacheResponse;
import org.restcomm.connect.commons.cache.HashGenerator;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.NotificationsDao;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.email.EmailService;
import org.restcomm.connect.email.api.EmailRequest;
import org.restcomm.connect.email.api.Mail;
import org.restcomm.connect.http.client.Downloader;
import org.restcomm.connect.http.client.DownloaderResponse;
import org.restcomm.connect.http.client.HttpRequestDescriptor;
import org.restcomm.connect.http.client.HttpResponseDescriptor;
import org.restcomm.connect.interpreter.StartInterpreter;
import org.restcomm.connect.interpreter.StopInterpreter;
import org.restcomm.connect.interpreter.rcml.Attribute;
import org.restcomm.connect.interpreter.rcml.End;
import org.restcomm.connect.interpreter.rcml.GetNextVerb;
import org.restcomm.connect.interpreter.rcml.Parser;
import org.restcomm.connect.interpreter.rcml.Tag;
import org.restcomm.connect.mscontrol.api.messages.CreateMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupResponse;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupStateChanged;
import org.restcomm.connect.mscontrol.api.messages.MediaServerControllerResponse;
import org.restcomm.connect.mscontrol.api.messages.Play;
import org.restcomm.connect.mscontrol.api.messages.StartMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.StopMediaGroup;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.CallStateChanged;
import org.restcomm.connect.telephony.api.DestroyWaitUrlConfMediaGroup;
import org.restcomm.connect.tts.api.GetSpeechSynthesizerInfo;
import org.restcomm.connect.tts.api.SpeechSynthesizerInfo;
import org.restcomm.connect.tts.api.SpeechSynthesizerRequest;
import org.restcomm.connect.tts.api.SpeechSynthesizerResponse;

public class ConfVoiceInterpreter
extends UntypedActor {
    private static final int ERROR_NOTIFICATION = 0;
    private static final int WARNING_NOTIFICATION = 1;
    static String EMAIL_SENDER;
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final State uninitialized;
    private final State acquiringSynthesizerInfo;
    private final State downloadingRcml;
    private final State initializingConfMediaGroup;
    private final State acquiringConfMediaGroup;
    private final State ready;
    private final State notFound;
    private final State caching;
    private final State checkingCache;
    private final State playing;
    private final State synthesizing;
    private final State redirecting;
    private final State finished;
    private final FiniteStateMachine fsm;
    private final Configuration configuration;
    private final ActorRef cache;
    private final String cachePath;
    private final ActorRef downloader;
    private ActorRef mailerNotify = null;
    private final DaoManager storage;
    private final ActorRef synthesizer;
    private SpeechSynthesizerInfo synthesizerInfo;
    private ActorRef conference;
    private ActorRef conferenceMediaGroup;
    private CallInfo callInfo;
    private CallStateChanged.State callState;
    private CallDetailRecord callRecord;
    private final Sid accountId;
    private final String version;
    private final URI url;
    private final String method;
    private final String emailAddress;
    private HttpRequestDescriptor request;
    private HttpResponseDescriptor response;
    private DownloaderResponse downloaderResponse;
    private ActorRef parser;
    private ActorRef source = this.self();
    private Tag verb;
    private ActorRef originalInterpreter;

    public ConfVoiceInterpreter(Configuration configuration, Sid account, String version, URI url, String method, String emailAddress, ActorRef conference, DaoManager storage, CallInfo callInfo) {
        this.uninitialized = new State("uninitialized", null, null);
        this.acquiringSynthesizerInfo = new State("acquiring tts info", (Action)new AcquiringSpeechSynthesizerInfo(this.source), null);
        this.acquiringConfMediaGroup = new State("acquiring call media group", (Action)new AcquiringConferenceMediaGroup(this.source), null);
        this.downloadingRcml = new State("downloading rcml", (Action)new DownloadingRcml(this.source), null);
        this.initializingConfMediaGroup = new State("initializing call media group", (Action)new InitializingConferenceMediaGroup(this.source), null);
        this.ready = new State("ready", (Action)new Ready(this.source), null);
        this.notFound = new State("notFound", (Action)new NotFound(this.source), null);
        this.caching = new State("caching", (Action)new Caching(this.source), null);
        this.checkingCache = new State("checkingCache", (Action)new CheckCache(this.source), null);
        this.playing = new State("playing", (Action)new Playing(this.source), null);
        this.synthesizing = new State("synthesizing", (Action)new Synthesizing(this.source), null);
        this.redirecting = new State("redirecting", (Action)new Redirecting(this.source), null);
        this.finished = new State("finished", (Action)new Finished(this.source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.acquiringSynthesizerInfo));
        transitions.add(new Transition(this.uninitialized, this.finished));
        transitions.add(new Transition(this.acquiringSynthesizerInfo, this.finished));
        transitions.add(new Transition(this.acquiringSynthesizerInfo, this.downloadingRcml));
        transitions.add(new Transition(this.acquiringConfMediaGroup, this.initializingConfMediaGroup));
        transitions.add(new Transition(this.acquiringConfMediaGroup, this.finished));
        transitions.add(new Transition(this.initializingConfMediaGroup, this.downloadingRcml));
        transitions.add(new Transition(this.initializingConfMediaGroup, this.checkingCache));
        transitions.add(new Transition(this.initializingConfMediaGroup, this.caching));
        transitions.add(new Transition(this.initializingConfMediaGroup, this.synthesizing));
        transitions.add(new Transition(this.initializingConfMediaGroup, this.redirecting));
        transitions.add(new Transition(this.initializingConfMediaGroup, this.finished));
        transitions.add(new Transition(this.initializingConfMediaGroup, this.ready));
        transitions.add(new Transition(this.downloadingRcml, this.ready));
        transitions.add(new Transition(this.downloadingRcml, this.notFound));
        transitions.add(new Transition(this.downloadingRcml, this.finished));
        transitions.add(new Transition(this.downloadingRcml, this.acquiringConfMediaGroup));
        transitions.add(new Transition(this.ready, this.checkingCache));
        transitions.add(new Transition(this.ready, this.caching));
        transitions.add(new Transition(this.ready, this.synthesizing));
        transitions.add(new Transition(this.ready, this.redirecting));
        transitions.add(new Transition(this.ready, this.finished));
        transitions.add(new Transition(this.caching, this.playing));
        transitions.add(new Transition(this.caching, this.caching));
        transitions.add(new Transition(this.caching, this.redirecting));
        transitions.add(new Transition(this.caching, this.synthesizing));
        transitions.add(new Transition(this.caching, this.finished));
        transitions.add(new Transition(this.checkingCache, this.synthesizing));
        transitions.add(new Transition(this.checkingCache, this.playing));
        transitions.add(new Transition(this.checkingCache, this.checkingCache));
        transitions.add(new Transition(this.playing, this.ready));
        transitions.add(new Transition(this.playing, this.finished));
        transitions.add(new Transition(this.synthesizing, this.checkingCache));
        transitions.add(new Transition(this.synthesizing, this.caching));
        transitions.add(new Transition(this.synthesizing, this.redirecting));
        transitions.add(new Transition(this.synthesizing, this.synthesizing));
        transitions.add(new Transition(this.synthesizing, this.finished));
        transitions.add(new Transition(this.redirecting, this.ready));
        transitions.add(new Transition(this.redirecting, this.checkingCache));
        transitions.add(new Transition(this.redirecting, this.caching));
        transitions.add(new Transition(this.redirecting, this.synthesizing));
        transitions.add(new Transition(this.redirecting, this.redirecting));
        transitions.add(new Transition(this.redirecting, this.finished));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.accountId = account;
        this.version = version;
        this.url = url;
        this.method = method;
        this.emailAddress = emailAddress;
        this.configuration = configuration;
        this.storage = storage;
        this.synthesizer = this.tts(configuration.subset("speech-synthesizer"));
        Configuration runtime = configuration.subset("runtime-settings");
        String path = runtime.getString("cache-path");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        this.cachePath = path = path + this.accountId.toString();
        String uri = runtime.getString("cache-uri");
        if (!uri.endsWith("/")) {
            uri = uri + "/";
        }
        uri = uri + this.accountId.toString();
        this.cache = this.cache(path, uri);
        this.downloader = this.downloader();
        this.callInfo = callInfo;
        this.conference = conference;
    }

    private ActorRef cache(final String path, final String uri) {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new DiskCacheFactory(ConfVoiceInterpreter.this.configuration).getDiskCache(path, uri);
            }
        }));
    }

    private ActorRef downloader() {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Downloader();
            }
        }));
    }

    private String e164(String number) {
        PhoneNumberUtil numbersUtil = PhoneNumberUtil.getInstance();
        try {
            Phonenumber.PhoneNumber result = numbersUtil.parse(number, "US");
            return numbersUtil.format(result, PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        catch (NumberParseException ignored) {
            return number;
        }
    }

    private void invalidVerb(Tag verb) {
        ActorRef self = this.self();
        GetNextVerb next = GetNextVerb.instance();
        this.parser.tell((Object)next, self);
    }

    ActorRef mailer(final Configuration configuration) {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return new EmailService(configuration);
            }
        }));
    }

    private Notification notification(int log, int error, String message) {
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(this.accountId);
        builder.setCallSid(this.callInfo.sid());
        builder.setApiVersion(this.version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        URI info = URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        if (this.request != null) {
            builder.setRequestUrl(this.request.getUri());
            builder.setRequestMethod(this.request.getMethod());
            builder.setRequestVariables(this.request.getParametersAsString());
        }
        if (this.response != null) {
            builder.setResponseHeaders(this.response.getHeadersAsString());
            String type = this.response.getContentType();
            if (type.contains("text/xml") || type.contains("application/xml") || type.contains("text/html")) {
                try {
                    builder.setResponseBody(this.response.getContentAsString());
                }
                catch (IOException exception) {
                    this.logger.error("There was an error while reading the contents of the resource located @ " + this.url.toString(), (Object)exception);
                }
            }
        }
        buffer = new StringBuilder();
        buffer.append("/").append(this.version).append("/Accounts/");
        buffer.append(this.accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        State state = this.fsm.state();
        ActorRef sender = this.sender();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** ConfVoiceInterpreter's Current State: " + state.toString());
            this.logger.info(" ********** ConfVoiceInterpreter's Processing Message: " + klass.getName());
        }
        if (StartInterpreter.class.equals(klass)) {
            this.originalInterpreter = sender;
            this.fsm.transition(message, this.acquiringSynthesizerInfo);
        } else if (SpeechSynthesizerResponse.class.equals(klass)) {
            if (this.acquiringSynthesizerInfo.equals((Object)state)) {
                this.fsm.transition(message, this.downloadingRcml);
            } else if (this.synthesizing.equals((Object)state)) {
                SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
                if (response.succeeded()) {
                    this.fsm.transition(message, this.caching);
                } else {
                    this.fsm.transition(message, this.finished);
                }
            }
        } else if (MediaServerControllerResponse.class.equals(klass)) {
            if (this.acquiringConfMediaGroup.equals((Object)state)) {
                this.fsm.transition(message, this.initializingConfMediaGroup);
            }
        } else if (DownloaderResponse.class.equals(klass)) {
            this.downloaderResponse = (DownloaderResponse)message;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("response succeeded " + this.downloaderResponse.succeeded() + ", statusCode " + ((HttpResponseDescriptor)this.downloaderResponse.get()).getStatusCode());
            }
            if (this.downloaderResponse.succeeded() && 200 == ((HttpResponseDescriptor)this.downloaderResponse.get()).getStatusCode()) {
                this.fsm.transition(message, this.acquiringConfMediaGroup);
            } else if (this.downloaderResponse.succeeded() && 404 == ((HttpResponseDescriptor)this.downloaderResponse.get()).getStatusCode()) {
                this.fsm.transition(message, this.notFound);
            }
        } else if (MediaGroupStateChanged.class.equals(klass)) {
            MediaGroupStateChanged event = (MediaGroupStateChanged)message;
            if (MediaGroupStateChanged.State.ACTIVE == event.state()) {
                if (this.initializingConfMediaGroup.equals((Object)state)) {
                    this.fsm.transition(message, this.ready);
                } else if (this.ready.equals((Object)state)) {
                    if ("Play".equals(this.verb.name())) {
                        this.fsm.transition(message, this.caching);
                    } else if ("Say".equals(this.verb.name())) {
                        this.fsm.transition(message, this.checkingCache);
                    } else {
                        this.invalidVerb(this.verb);
                    }
                }
            } else if (MediaGroupStateChanged.State.INACTIVE == event.state()) {
                if (this.acquiringConfMediaGroup.equals((Object)state)) {
                    this.fsm.transition(message, this.initializingConfMediaGroup);
                } else if (!this.finished.equals((Object)state)) {
                    this.fsm.transition(message, this.finished);
                }
            }
        } else if (DiskCacheResponse.class.equals(klass)) {
            DiskCacheResponse response = (DiskCacheResponse)message;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("DiskCacheResponse " + response.succeeded() + " error=" + response.error());
            }
            if (response.succeeded()) {
                if ((this.caching.equals((Object)state) || this.checkingCache.equals((Object)state)) && ("Play".equals(this.verb.name()) || "Say".equals(this.verb.name()))) {
                    this.fsm.transition(message, this.playing);
                }
            } else if (this.checkingCache.equals((Object)state)) {
                this.fsm.transition(message, this.synthesizing);
            } else {
                this.fsm.transition(message, this.finished);
            }
        } else if (Tag.class.equals(klass)) {
            this.verb = (Tag)message;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ConfVoiceInterpreter verb = " + this.verb.name());
            }
            if ("Dial".equals(this.verb.name())) {
                this.originalInterpreter.tell((Object)new Exception("Dial verb not supported"), this.source);
            }
            if ("Play".equals(this.verb.name())) {
                this.fsm.transition(message, this.caching);
            } else if ("Say".equals(this.verb.name())) {
                this.fsm.transition(message, this.checkingCache);
            } else {
                this.invalidVerb(this.verb);
            }
        } else if (End.class.equals(klass)) {
            this.fsm.transition(message, this.finished);
        } else if (MediaGroupResponse.class.equals(klass)) {
            MediaGroupResponse response = (MediaGroupResponse)message;
            if (response.succeeded()) {
                if (this.playing.equals((Object)state)) {
                    this.fsm.transition(message, this.ready);
                }
            } else {
                this.originalInterpreter.tell(message, this.source);
            }
        } else if (StopInterpreter.class.equals(klass)) {
            this.fsm.transition(message, this.finished);
        } else if (message instanceof ReceiveTimeout) {
            // empty if block
        }
    }

    private List<NameValuePair> parameters() {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        String callSid = this.callInfo.sid().toString();
        parameters.add((NameValuePair)new BasicNameValuePair("CallSid", callSid));
        String accountSid = this.accountId.toString();
        parameters.add((NameValuePair)new BasicNameValuePair("AccountSid", accountSid));
        String from = this.e164(this.callInfo.from());
        parameters.add((NameValuePair)new BasicNameValuePair("From", from));
        String to = this.e164(this.callInfo.to());
        parameters.add((NameValuePair)new BasicNameValuePair("To", to));
        parameters.add((NameValuePair)new BasicNameValuePair("ApiVersion", this.version));
        String direction = this.callInfo.direction();
        parameters.add((NameValuePair)new BasicNameValuePair("Direction", direction));
        String callerName = this.callInfo.fromName();
        parameters.add((NameValuePair)new BasicNameValuePair("CallerName", callerName));
        String forwardedFrom = this.callInfo.forwardedFrom();
        parameters.add((NameValuePair)new BasicNameValuePair("ForwardedFrom", forwardedFrom));
        return parameters;
    }

    private ActorRef parser(final String xml) {
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Parser(xml, ConfVoiceInterpreter.this.self());
            }
        }));
    }

    private void postCleanup() {
        ActorRef self = this.self();
        UntypedActorContext context = this.getContext();
        context.stop(self);
    }

    private URI resolve(URI base, URI uri) {
        if (base.equals(uri)) {
            return uri;
        }
        if (!uri.isAbsolute()) {
            return base.resolve(uri);
        }
        return uri;
    }

    private void sendMail(Notification notification) {
        if (this.emailAddress == null || this.emailAddress.isEmpty()) {
            return;
        }
        String EMAIL_SUBJECT = "RestComm Error Notification - Attention Required";
        StringBuilder buffer = new StringBuilder();
        buffer.append("<strong>").append("Sid: ").append("</strong></br>");
        buffer.append(notification.getSid().toString()).append("</br>");
        buffer.append("<strong>").append("Account Sid: ").append("</strong></br>");
        buffer.append(notification.getAccountSid().toString()).append("</br>");
        buffer.append("<strong>").append("Call Sid: ").append("</strong></br>");
        buffer.append(notification.getCallSid().toString()).append("</br>");
        buffer.append("<strong>").append("API Version: ").append("</strong></br>");
        buffer.append(notification.getApiVersion()).append("</br>");
        buffer.append("<strong>").append("Log: ").append("</strong></br>");
        buffer.append(notification.getLog() == 0 ? "ERROR" : "WARNING").append("</br>");
        buffer.append("<strong>").append("Error Code: ").append("</strong></br>");
        buffer.append(notification.getErrorCode()).append("</br>");
        buffer.append("<strong>").append("More Information: ").append("</strong></br>");
        buffer.append(notification.getMoreInfo().toString()).append("</br>");
        buffer.append("<strong>").append("Message Text: ").append("</strong></br>");
        buffer.append(notification.getMessageText()).append("</br>");
        buffer.append("<strong>").append("Message Date: ").append("</strong></br>");
        buffer.append(notification.getMessageDate().toString()).append("</br>");
        buffer.append("<strong>").append("Request URL: ").append("</strong></br>");
        buffer.append(notification.getRequestUrl().toString()).append("</br>");
        buffer.append("<strong>").append("Request Method: ").append("</strong></br>");
        buffer.append(notification.getRequestMethod()).append("</br>");
        buffer.append("<strong>").append("Request Variables: ").append("</strong></br>");
        buffer.append(notification.getRequestVariables()).append("</br>");
        buffer.append("<strong>").append("Response Headers: ").append("</strong></br>");
        buffer.append(notification.getResponseHeaders()).append("</br>");
        buffer.append("<strong>").append("Response Body: ").append("</strong></br>");
        buffer.append(notification.getResponseBody()).append("</br>");
        Mail emailMsg = new Mail(EMAIL_SENDER, this.emailAddress, "RestComm Error Notification - Attention Required", buffer.toString());
        if (this.mailerNotify == null) {
            this.mailerNotify = this.mailer(this.configuration.subset("smtp-notify"));
        }
        this.mailerNotify.tell((Object)new EmailRequest(emailMsg), this.self());
    }

    private ActorRef tts(final Configuration configuration) {
        final String classpath = configuration.getString("[@class]");
        UntypedActorContext context = this.getContext();
        return context.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public Actor create() throws Exception {
                return (UntypedActor)Class.forName(classpath).getConstructor(Configuration.class).newInstance(configuration);
            }
        }));
    }

    private String hash(Object message) {
        Map<String, String> details = this.getSynthesizeDetails(message);
        if (details == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Cannot generate hash, details are null");
            }
            return null;
        }
        String voice = details.get("voice");
        String language = details.get("language");
        String text = details.get("text");
        return HashGenerator.hashMessage((String)voice, (String)language, (String)text);
    }

    private Map<String, String> getSynthesizeDetails(Object message) {
        Class<?> klass = message.getClass();
        HashMap<String, String> details = new HashMap<String, String>();
        if (!Tag.class.equals(klass)) {
            return null;
        }
        this.verb = (Tag)message;
        if (!"Say".equals(this.verb.name())) {
            return null;
        }
        String voice = "man";
        Attribute attribute = this.verb.attribute("voice");
        if (attribute != null) {
            voice = attribute.value();
            if (voice != null && !voice.isEmpty()) {
                if (!"man".equals(voice) && !"woman".equals(voice)) {
                    Notification notification = this.notification(1, 13511, voice + " is an invalid voice value.");
                    NotificationsDao notifications = this.storage.getNotificationsDao();
                    notifications.addNotification(notification);
                    voice = "man";
                }
            } else {
                voice = "man";
            }
        }
        String language = "en";
        attribute = this.verb.attribute("language");
        if (attribute != null) {
            language = attribute.value();
            if (language != null && !language.isEmpty()) {
                if (!this.synthesizerInfo.languages().contains(language)) {
                    language = "en";
                }
            } else {
                language = "en";
            }
        }
        String text = this.verb.text();
        details.put("voice", voice);
        details.put("language", language);
        details.put("text", text);
        return details;
    }

    public void postStop() {
        super.postStop();
    }

    private final class Finished
    extends AbstractAction {
        public Finished(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (ConfVoiceInterpreter.this.logger.isInfoEnabled()) {
                ConfVoiceInterpreter.this.logger.info("Finished called for ConfVoiceInterpreter");
            }
            StopMediaGroup stop = new StopMediaGroup();
            if (ConfVoiceInterpreter.this.conferenceMediaGroup != null) {
                ConfVoiceInterpreter.this.conferenceMediaGroup.tell((Object)stop, this.source);
                DestroyWaitUrlConfMediaGroup destroy = new DestroyWaitUrlConfMediaGroup(ConfVoiceInterpreter.this.conferenceMediaGroup);
                ConfVoiceInterpreter.this.conference.tell((Object)destroy, this.source);
            }
            UntypedActorContext context = ConfVoiceInterpreter.this.getContext();
            if (ConfVoiceInterpreter.this.mailerNotify != null) {
                context.stop(ConfVoiceInterpreter.this.mailerNotify);
            }
            context.stop(ConfVoiceInterpreter.this.downloader);
            context.stop(ConfVoiceInterpreter.this.cache);
            context.stop(ConfVoiceInterpreter.this.synthesizer);
            ConfVoiceInterpreter.this.postCleanup();
        }
    }

    private final class Redirecting
    extends AbstractAction {
        public Redirecting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String text;
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                ConfVoiceInterpreter.this.verb = (Tag)message;
            }
            NotificationsDao notifications = ConfVoiceInterpreter.this.storage.getNotificationsDao();
            String method = "POST";
            Attribute attribute = ConfVoiceInterpreter.this.verb.attribute("method");
            if (attribute != null) {
                method = attribute.value();
                if (method != null && !method.isEmpty()) {
                    if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                        Notification notification = ConfVoiceInterpreter.this.notification(1, 13710, method + " is not a valid HTTP method for <Redirect>");
                        notifications.addNotification(notification);
                        method = "POST";
                    }
                } else {
                    method = "POST";
                }
            }
            if ((text = ConfVoiceInterpreter.this.verb.text()) != null && !text.isEmpty()) {
                URI target = null;
                try {
                    target = URI.create(text);
                }
                catch (Exception exception) {
                    Notification notification = ConfVoiceInterpreter.this.notification(0, 11100, text + " is an invalid URI.");
                    notifications.addNotification(notification);
                    ConfVoiceInterpreter.this.sendMail(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                URI base = ConfVoiceInterpreter.this.request.getUri();
                URI uri = ConfVoiceInterpreter.this.resolve(base, target);
                List parameters = ConfVoiceInterpreter.this.parameters();
                ConfVoiceInterpreter.this.request = new HttpRequestDescriptor(uri, method, parameters);
                ConfVoiceInterpreter.this.downloader.tell((Object)ConfVoiceInterpreter.this.request, this.source);
            } else {
                GetNextVerb next = GetNextVerb.instance();
                ConfVoiceInterpreter.this.parser.tell((Object)next, this.source);
            }
        }
    }

    private final class Synthesizing
    extends AbstractAction {
        public Synthesizing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Map details;
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                ConfVoiceInterpreter.this.verb = (Tag)message;
            }
            if ((details = ConfVoiceInterpreter.this.getSynthesizeDetails(ConfVoiceInterpreter.this.verb)) != null && !details.isEmpty()) {
                String voice = (String)details.get("voice");
                String language = (String)details.get("language");
                String text = (String)details.get("text");
                SpeechSynthesizerRequest synthesize = new SpeechSynthesizerRequest(voice, language, text);
                ConfVoiceInterpreter.this.synthesizer.tell((Object)synthesize, this.source);
            } else {
                GetNextVerb next = GetNextVerb.instance();
                ConfVoiceInterpreter.this.parser.tell((Object)next, this.source);
            }
        }
    }

    private final class Playing
    extends AbstractAction {
        public Playing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (DiskCacheResponse.class.equals(klass)) {
                int loop;
                block5: {
                    String number;
                    loop = Integer.MAX_VALUE;
                    Attribute attribute = ConfVoiceInterpreter.this.verb.attribute("loop");
                    if (attribute != null && (number = attribute.value()) != null && !number.isEmpty()) {
                        try {
                            loop = Integer.parseInt(number);
                        }
                        catch (NumberFormatException ignored) {
                            NotificationsDao notifications = ConfVoiceInterpreter.this.storage.getNotificationsDao();
                            Notification notification = null;
                            if ("Say".equals(ConfVoiceInterpreter.this.verb.name())) {
                                notification = ConfVoiceInterpreter.this.notification(1, 13510, loop + " is an invalid loop value.");
                                notifications.addNotification(notification);
                            }
                            if (!"Play".equals(ConfVoiceInterpreter.this.verb.name())) break block5;
                            notification = ConfVoiceInterpreter.this.notification(1, 13410, loop + " is an invalid loop value.");
                            notifications.addNotification(notification);
                        }
                    }
                }
                DiskCacheResponse response = (DiskCacheResponse)message;
                Play play = new Play((URI)response.get(), loop);
                ConfVoiceInterpreter.this.conferenceMediaGroup.tell((Object)play, this.source);
            }
        }
    }

    private final class Caching
    extends AbstractAction {
        public Caching(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (SpeechSynthesizerResponse.class.equals(klass)) {
                SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
                DiskCacheRequest request = new DiskCacheRequest((URI)response.get());
                ConfVoiceInterpreter.this.cache.tell((Object)request, this.source);
            } else if (Tag.class.equals(klass) || MediaGroupStateChanged.class.equals(klass)) {
                String text;
                if (Tag.class.equals(klass)) {
                    ConfVoiceInterpreter.this.verb = (Tag)message;
                }
                if ((text = ConfVoiceInterpreter.this.verb.text()) != null && !text.isEmpty()) {
                    URI target = null;
                    try {
                        target = URI.create(text);
                    }
                    catch (Exception exception) {
                        Notification notification = ConfVoiceInterpreter.this.notification(0, 11100, text + " is an invalid URI.");
                        NotificationsDao notifications = ConfVoiceInterpreter.this.storage.getNotificationsDao();
                        notifications.addNotification(notification);
                        ConfVoiceInterpreter.this.sendMail(notification);
                        StopInterpreter stop = new StopInterpreter();
                        this.source.tell((Object)stop, this.source);
                        return;
                    }
                    URI base = ConfVoiceInterpreter.this.request.getUri();
                    URI uri = ConfVoiceInterpreter.this.resolve(base, target);
                    DiskCacheRequest request = new DiskCacheRequest(uri);
                    ConfVoiceInterpreter.this.cache.tell((Object)request, this.source);
                } else {
                    GetNextVerb next = GetNextVerb.instance();
                    ConfVoiceInterpreter.this.parser.tell((Object)next, this.source);
                }
            }
        }
    }

    private final class CheckCache
    extends AbstractAction {
        public CheckCache(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                ConfVoiceInterpreter.this.verb = (Tag)message;
            }
            String hash = ConfVoiceInterpreter.this.hash(ConfVoiceInterpreter.this.verb);
            DiskCacheRequest request = new DiskCacheRequest(hash);
            if (ConfVoiceInterpreter.this.logger.isInfoEnabled()) {
                ConfVoiceInterpreter.this.logger.info("Checking cache for hash: " + hash);
            }
            ConfVoiceInterpreter.this.cache.tell((Object)request, this.source);
        }
    }

    private final class NotFound
    extends AbstractAction {
        public NotFound(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            DownloaderResponse response = (DownloaderResponse)message;
            if (ConfVoiceInterpreter.this.logger.isDebugEnabled()) {
                ConfVoiceInterpreter.this.logger.debug("response succeeded " + response.succeeded() + ", statusCode " + ((HttpResponseDescriptor)response.get()).getStatusCode());
            }
            Notification notification = ConfVoiceInterpreter.this.notification(1, 21402, "URL Not Found : " + ((HttpResponseDescriptor)response.get()).getURI());
            NotificationsDao notifications = ConfVoiceInterpreter.this.storage.getNotificationsDao();
            notifications.addNotification(notification);
            ConfVoiceInterpreter.this.conference.tell((Object)new org.restcomm.connect.telephony.api.NotFound(), this.source);
        }
    }

    private final class Ready
    extends AbstractAction {
        public Ready(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (ConfVoiceInterpreter.this.parser == null) {
                ConfVoiceInterpreter.this.response = (HttpResponseDescriptor)ConfVoiceInterpreter.this.downloaderResponse.get();
                String type = ConfVoiceInterpreter.this.response.getContentType();
                if (type.contains("text/xml") || type.contains("application/xml") || type.contains("text/html")) {
                    ConfVoiceInterpreter.this.parser = ConfVoiceInterpreter.this.parser(ConfVoiceInterpreter.this.response.getContentAsString());
                } else if (type.contains("audio/wav") || type.contains("audio/wave") || type.contains("audio/x-wav")) {
                    ConfVoiceInterpreter.this.parser = ConfVoiceInterpreter.this.parser("<Play>" + ConfVoiceInterpreter.this.request.getUri() + "</Play>");
                } else if (type.contains("text/plain")) {
                    ConfVoiceInterpreter.this.parser = ConfVoiceInterpreter.this.parser("<Say>" + ConfVoiceInterpreter.this.response.getContentAsString() + "</Say>");
                } else {
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
            }
            GetNextVerb next = GetNextVerb.instance();
            ConfVoiceInterpreter.this.parser.tell((Object)next, this.source);
        }
    }

    private final class DownloadingRcml
    extends AbstractAction {
        public DownloadingRcml(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (SpeechSynthesizerResponse.class.equals(klass)) {
                SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
                ConfVoiceInterpreter.this.synthesizerInfo = (SpeechSynthesizerInfo)response.get();
                List parameters = ConfVoiceInterpreter.this.parameters();
                ConfVoiceInterpreter.this.request = new HttpRequestDescriptor(ConfVoiceInterpreter.this.url, ConfVoiceInterpreter.this.method, parameters);
                ConfVoiceInterpreter.this.downloader.tell((Object)ConfVoiceInterpreter.this.request, this.source);
            }
        }
    }

    private final class InitializingConferenceMediaGroup
    extends AbstractAction {
        public InitializingConferenceMediaGroup(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MediaServerControllerResponse response = (MediaServerControllerResponse)message;
            ConfVoiceInterpreter.this.conferenceMediaGroup = (ActorRef)response.get();
            ConfVoiceInterpreter.this.conferenceMediaGroup.tell((Object)new Observe(this.source), this.source);
            StartMediaGroup request = new StartMediaGroup();
            ConfVoiceInterpreter.this.conferenceMediaGroup.tell((Object)request, this.source);
        }
    }

    private final class AcquiringConferenceMediaGroup
    extends AbstractAction {
        public AcquiringConferenceMediaGroup(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            ConfVoiceInterpreter.this.conference.tell((Object)new CreateMediaGroup(), this.source);
        }
    }

    private final class AcquiringSpeechSynthesizerInfo
    extends AbstractAction {
        public AcquiringSpeechSynthesizerInfo(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            StartInterpreter request = (StartInterpreter)message;
            ConfVoiceInterpreter.this.conference = request.resource();
            ConfVoiceInterpreter.this.synthesizer.tell((Object)new GetSpeechSynthesizerInfo(), this.source);
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

