/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.interpreter;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import java.net.URI;
import org.apache.commons.configuration.Configuration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.interpreter.SmsInterpreter;

public final class SmsInterpreterBuilder {
    private final ActorSystem system;
    private Configuration configuration;
    private ActorRef service;
    private DaoManager storage;
    private Sid accountId;
    private String version;
    private URI url;
    private String method;
    private URI fallbackUrl;
    private String fallbackMethod;

    public SmsInterpreterBuilder(ActorSystem system) {
        this.system = system;
    }

    public ActorRef build() {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SmsInterpreter(SmsInterpreterBuilder.this.service, SmsInterpreterBuilder.this.configuration, SmsInterpreterBuilder.this.storage, SmsInterpreterBuilder.this.accountId, SmsInterpreterBuilder.this.version, SmsInterpreterBuilder.this.url, SmsInterpreterBuilder.this.method, SmsInterpreterBuilder.this.fallbackUrl, SmsInterpreterBuilder.this.fallbackMethod);
            }
        }));
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setSmsService(ActorRef service) {
        this.service = service;
    }

    public void setStorage(DaoManager storage) {
        this.storage = storage;
    }

    public void setAccount(Sid accountId) {
        this.accountId = accountId;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
    }

    public void setFallbackMethod(String fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
    }

    public void setVersion(String version) {
        this.version = version;
    }
}

