/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.interpreter;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActorContext;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.sip.SipServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.joda.time.DateTime;
import org.restcomm.connect.asr.AsrResponse;
import org.restcomm.connect.commons.cache.DiskCacheResponse;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.NotificationsDao;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.fax.FaxResponse;
import org.restcomm.connect.http.client.DownloaderResponse;
import org.restcomm.connect.http.client.HttpRequestDescriptor;
import org.restcomm.connect.http.client.HttpResponseDescriptor;
import org.restcomm.connect.interpreter.BaseVoiceInterpreter;
import org.restcomm.connect.interpreter.StartGathering;
import org.restcomm.connect.interpreter.StartInterpreter;
import org.restcomm.connect.interpreter.StopInterpreter;
import org.restcomm.connect.interpreter.rcml.Attribute;
import org.restcomm.connect.interpreter.rcml.End;
import org.restcomm.connect.interpreter.rcml.GetNextVerb;
import org.restcomm.connect.interpreter.rcml.Tag;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupResponse;
import org.restcomm.connect.mscontrol.api.messages.StopMediaGroup;
import org.restcomm.connect.sms.api.SmsServiceResponse;
import org.restcomm.connect.sms.api.SmsSessionResponse;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.CallResponse;
import org.restcomm.connect.telephony.api.CallStateChanged;
import org.restcomm.connect.telephony.api.Cancel;
import org.restcomm.connect.telephony.api.CreateCall;
import org.restcomm.connect.telephony.api.DestroyCall;
import org.restcomm.connect.telephony.api.Reject;
import org.restcomm.connect.tts.api.SpeechSynthesizerResponse;

public final class SubVoiceInterpreter
extends BaseVoiceInterpreter {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final State downloadingRcml;
    private final State ready;
    private final State notFound;
    private final State rejecting;
    private final State finished;
    private DownloaderResponse downloaderResponse;
    private ActorRef source = this.self();
    private Boolean hangupOnEnd = false;
    private ActorRef originalInterpreter;

    public SubVoiceInterpreter(Configuration configuration, Sid account, Sid phone, String version, URI url, String method, URI fallbackUrl, String fallbackMethod, URI statusCallback, String statusCallbackMethod, String emailAddress, ActorRef callManager, ActorRef conferenceManager, ActorRef sms, DaoManager storage) {
        this(configuration, account, phone, version, url, method, fallbackUrl, fallbackMethod, statusCallback, statusCallbackMethod, emailAddress, callManager, conferenceManager, sms, storage, false);
    }

    public SubVoiceInterpreter(Configuration configuration, Sid account, Sid phone, String version, URI url, String method, URI fallbackUrl, String fallbackMethod, URI statusCallback, String statusCallbackMethod, String emailAddress, ActorRef callManager, ActorRef conferenceManager, ActorRef sms, DaoManager storage, Boolean hangupOnEnd) {
        this.downloadingRcml = new State("downloading rcml", (Action)new DownloadingRcml(this.source), null);
        this.ready = new State("ready", (Action)new Ready(this.source), null);
        this.notFound = new State("notFound", (Action)new NotFound(this.source), null);
        this.rejecting = new State("rejecting", (Action)new Rejecting(this.source), null);
        this.finished = new State("finished", (Action)new Finished(this.source), null);
        this.transitions.add(new Transition(this.acquiringAsrInfo, this.finished));
        this.transitions.add(new Transition(this.acquiringSynthesizerInfo, this.finished));
        this.transitions.add(new Transition(this.acquiringCallInfo, this.downloadingRcml));
        this.transitions.add(new Transition(this.acquiringCallInfo, this.finished));
        this.transitions.add(new Transition(this.downloadingRcml, this.ready));
        this.transitions.add(new Transition(this.downloadingRcml, this.notFound));
        this.transitions.add(new Transition(this.downloadingRcml, this.hangingUp));
        this.transitions.add(new Transition(this.downloadingRcml, this.finished));
        this.transitions.add(new Transition(this.ready, this.faxing));
        this.transitions.add(new Transition(this.ready, this.pausing));
        this.transitions.add(new Transition(this.ready, this.checkingCache));
        this.transitions.add(new Transition(this.ready, this.caching));
        this.transitions.add(new Transition(this.ready, this.synthesizing));
        this.transitions.add(new Transition(this.ready, this.rejecting));
        this.transitions.add(new Transition(this.ready, this.redirecting));
        this.transitions.add(new Transition(this.ready, this.processingGatherChildren));
        this.transitions.add(new Transition(this.ready, this.creatingRecording));
        this.transitions.add(new Transition(this.ready, this.creatingSmsSession));
        this.transitions.add(new Transition(this.ready, this.hangingUp));
        this.transitions.add(new Transition(this.ready, this.finished));
        this.transitions.add(new Transition(this.pausing, this.ready));
        this.transitions.add(new Transition(this.pausing, this.finished));
        this.transitions.add(new Transition(this.rejecting, this.finished));
        this.transitions.add(new Transition(this.faxing, this.ready));
        this.transitions.add(new Transition(this.faxing, this.finished));
        this.transitions.add(new Transition(this.caching, this.finished));
        this.transitions.add(new Transition(this.playing, this.ready));
        this.transitions.add(new Transition(this.playing, this.finished));
        this.transitions.add(new Transition(this.synthesizing, this.finished));
        this.transitions.add(new Transition(this.redirecting, this.ready));
        this.transitions.add(new Transition(this.redirecting, this.finished));
        this.transitions.add(new Transition(this.creatingRecording, this.finished));
        this.transitions.add(new Transition(this.finishRecording, this.ready));
        this.transitions.add(new Transition(this.finishRecording, this.finished));
        this.transitions.add(new Transition(this.processingGatherChildren, this.finished));
        this.transitions.add(new Transition(this.gathering, this.finished));
        this.transitions.add(new Transition(this.finishGathering, this.finished));
        this.transitions.add(new Transition(this.creatingSmsSession, this.finished));
        this.transitions.add(new Transition(this.sendingSms, this.ready));
        this.transitions.add(new Transition(this.sendingSms, this.finished));
        this.transitions.add(new Transition(this.hangingUp, this.finished));
        this.fsm = new FiniteStateMachine(this.uninitialized, this.transitions);
        this.accountId = account;
        this.phoneId = phone;
        this.version = version;
        this.url = url;
        this.method = method;
        this.fallbackUrl = fallbackUrl;
        this.fallbackMethod = fallbackMethod;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.emailAddress = emailAddress;
        this.configuration = configuration;
        this.callManager = callManager;
        this.smsService = sms;
        this.smsSessions = new HashMap();
        this.storage = storage;
        Configuration runtime = configuration.subset("runtime-settings");
        this.downloader = this.downloader();
        this.hangupOnEnd = hangupOnEnd;
    }

    private Notification notification(int log, int error, String message) {
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(this.accountId);
        builder.setCallSid(this.callInfo.sid());
        builder.setApiVersion(this.version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        URI info = URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        if (this.request != null) {
            builder.setRequestUrl(this.request.getUri());
            builder.setRequestMethod(this.request.getMethod());
            builder.setRequestVariables(this.request.getParametersAsString());
        }
        if (this.response != null) {
            builder.setResponseHeaders(this.response.getHeadersAsString());
            String type = this.response.getContentType();
            if (type.contains("text/xml") || type.contains("application/xml") || type.contains("text/html")) {
                try {
                    builder.setResponseBody(this.response.getContentAsString());
                }
                catch (IOException exception) {
                    this.logger.error("There was an error while reading the contents of the resource located @ " + this.url.toString(), (Object)exception);
                }
            }
        }
        buffer = new StringBuilder();
        buffer.append("/").append(this.version).append("/Accounts/");
        buffer.append(this.accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    @Override
    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        State state = this.fsm.state();
        ActorRef sender = this.sender();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** SubVoiceInterpreter's Current State: " + state.toString());
            this.logger.info(" ********** SubVoiceInterpreter's Processing Message: " + klass.getName());
        }
        if (StartInterpreter.class.equals(klass)) {
            StartInterpreter request = (StartInterpreter)message;
            this.call = request.resource();
            this.originalInterpreter = sender;
            this.fsm.transition(message, this.acquiringAsrInfo);
        } else if (AsrResponse.class.equals(klass)) {
            if (this.outstandingAsrRequests > 0) {
                this.asrResponse(message);
            } else {
                this.fsm.transition(message, this.acquiringSynthesizerInfo);
            }
        } else if (SpeechSynthesizerResponse.class.equals(klass)) {
            if (this.acquiringSynthesizerInfo.equals((Object)state)) {
                this.fsm.transition(message, this.acquiringCallInfo);
            } else if (this.synthesizing.equals((Object)state)) {
                SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
                if (response.succeeded()) {
                    this.fsm.transition(message, this.caching);
                } else {
                    this.fsm.transition(message, this.hangingUp);
                }
            } else if (this.processingGatherChildren.equals((Object)state)) {
                SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
                if (response.succeeded()) {
                    this.fsm.transition(message, this.processingGatherChildren);
                } else {
                    this.fsm.transition(message, this.hangingUp);
                }
            }
        } else if (CallResponse.class.equals(klass)) {
            if (this.acquiringCallInfo.equals((Object)state)) {
                CallResponse response = (CallResponse)message;
                this.callInfo = (CallInfo)response.get();
                this.fsm.transition(message, this.downloadingRcml);
            }
        } else if (DownloaderResponse.class.equals(klass)) {
            this.downloaderResponse = (DownloaderResponse)message;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("response succeeded " + this.downloaderResponse.succeeded() + ", statusCode " + ((HttpResponseDescriptor)this.downloaderResponse.get()).getStatusCode());
            }
            if (this.downloaderResponse.succeeded() && 200 == ((HttpResponseDescriptor)this.downloaderResponse.get()).getStatusCode()) {
                this.fsm.transition(message, this.ready);
            } else if (this.downloaderResponse.succeeded() && 404 == ((HttpResponseDescriptor)this.downloaderResponse.get()).getStatusCode()) {
                this.originalInterpreter.tell((Object)new Exception("Downloader Response Exception"), this.source);
                this.fsm.transition(message, this.notFound);
            }
        } else if (DiskCacheResponse.class.equals(klass)) {
            DiskCacheResponse response = (DiskCacheResponse)message;
            if (response.succeeded()) {
                if (this.caching.equals((Object)state) || this.checkingCache.equals((Object)state)) {
                    if ("Play".equals(this.verb.name()) || "Say".equals(this.verb.name())) {
                        this.fsm.transition(message, this.playing);
                    } else if ("Fax".equals(this.verb.name())) {
                        this.fsm.transition(message, this.faxing);
                    }
                } else if (this.processingGatherChildren.equals((Object)state)) {
                    this.fsm.transition(message, this.processingGatherChildren);
                }
            } else if (this.checkingCache.equals((Object)state)) {
                this.fsm.transition(message, this.synthesizing);
            } else {
                this.fsm.transition(message, this.hangingUp);
            }
        } else if (Tag.class.equals(klass)) {
            this.verb = (Tag)message;
            if ("Dial".equals(this.verb.name())) {
                this.originalInterpreter.tell((Object)new Exception("Dial verb not supported"), this.source);
            }
            if ("Reject".equals(this.verb.name())) {
                this.fsm.transition(message, this.rejecting);
            } else if ("Pause".equals(this.verb.name())) {
                this.fsm.transition(message, this.pausing);
            } else if ("Fax".equals(this.verb.name())) {
                this.fsm.transition(message, this.caching);
            } else if ("Play".equals(this.verb.name())) {
                this.fsm.transition(message, this.caching);
            } else if ("Say".equals(this.verb.name())) {
                this.fsm.transition(message, this.checkingCache);
            } else if ("Gather".equals(this.verb.name())) {
                this.fsm.transition(message, this.processingGatherChildren);
            } else if ("Pause".equals(this.verb.name())) {
                this.fsm.transition(message, this.pausing);
            } else if ("Hangup".equals(this.verb.name())) {
                this.originalInterpreter.tell(message, this.source);
                this.fsm.transition(message, this.hangingUp);
            } else if ("Redirect".equals(this.verb.name())) {
                this.fsm.transition(message, this.redirecting);
            } else if ("Record".equals(this.verb.name())) {
                this.fsm.transition(message, this.creatingRecording);
            } else if ("Sms".equals(this.verb.name())) {
                this.fsm.transition(message, this.creatingSmsSession);
            } else {
                this.invalidVerb(this.verb);
            }
        } else if (End.class.equals(klass)) {
            if (!this.hangupOnEnd.booleanValue()) {
                this.originalInterpreter.tell(message, this.source);
            } else {
                this.fsm.transition(message, this.hangingUp);
            }
        } else if (StartGathering.class.equals(klass)) {
            this.fsm.transition(message, this.gathering);
        } else if (CallStateChanged.class.equals(klass)) {
            CallStateChanged event = (CallStateChanged)message;
            if (CallStateChanged.State.NO_ANSWER == event.state() || CallStateChanged.State.COMPLETED == event.state() || CallStateChanged.State.FAILED == event.state() || CallStateChanged.State.BUSY == event.state()) {
                this.originalInterpreter.tell((Object)new Cancel(), this.source);
            }
        } else if (MediaGroupResponse.class.equals(klass)) {
            MediaGroupResponse response = (MediaGroupResponse)message;
            if (response.succeeded()) {
                if (this.playingRejectionPrompt.equals((Object)state)) {
                    this.originalInterpreter.tell(message, this.source);
                } else if (this.playing.equals((Object)state)) {
                    this.fsm.transition(message, this.ready);
                } else if (this.creatingRecording.equals((Object)state)) {
                    this.fsm.transition(message, this.finishRecording);
                } else if (this.gathering.equals((Object)state)) {
                    this.fsm.transition(message, this.finishGathering);
                }
            } else {
                this.originalInterpreter.tell(message, this.source);
            }
        } else if (SmsServiceResponse.class.equals(klass)) {
            SmsServiceResponse response = (SmsServiceResponse)message;
            if (response.succeeded()) {
                if (this.creatingSmsSession.equals((Object)state)) {
                    this.fsm.transition(message, this.sendingSms);
                }
            } else {
                this.fsm.transition(message, this.hangingUp);
            }
        } else if (SmsSessionResponse.class.equals(klass)) {
            this.smsResponse(message);
        } else if (FaxResponse.class.equals(klass)) {
            this.fsm.transition(message, this.ready);
        } else if (StopInterpreter.class.equals(klass)) {
            if (CallStateChanged.State.IN_PROGRESS == this.callState) {
                this.fsm.transition(message, this.hangingUp);
            } else {
                this.fsm.transition(message, this.finished);
            }
        } else if (message instanceof ReceiveTimeout && this.pausing.equals((Object)state)) {
            this.fsm.transition(message, this.ready);
        }
    }

    @Override
    List<NameValuePair> parameters() {
        SipServletResponse lastResponse;
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        String callSid = this.callInfo.sid().toString();
        parameters.add((NameValuePair)new BasicNameValuePair("CallSid", callSid));
        String accountSid = this.accountId.toString();
        parameters.add((NameValuePair)new BasicNameValuePair("AccountSid", accountSid));
        String from = this.e164(this.callInfo.from());
        parameters.add((NameValuePair)new BasicNameValuePair("From", from));
        String to = this.e164(this.callInfo.to());
        parameters.add((NameValuePair)new BasicNameValuePair("To", to));
        String state = this.callState.toString();
        parameters.add((NameValuePair)new BasicNameValuePair("CallStatus", state));
        parameters.add((NameValuePair)new BasicNameValuePair("ApiVersion", this.version));
        String direction = this.callInfo.direction();
        parameters.add((NameValuePair)new BasicNameValuePair("Direction", direction));
        String callerName = this.callInfo.fromName();
        parameters.add((NameValuePair)new BasicNameValuePair("CallerName", callerName));
        String forwardedFrom = this.callInfo.forwardedFrom();
        parameters.add((NameValuePair)new BasicNameValuePair("ForwardedFrom", forwardedFrom));
        if (CreateCall.Type.SIP == this.callInfo.type() && (lastResponse = this.callInfo.lastResponse()) != null) {
            int statusCode = lastResponse.getStatus();
            String method = lastResponse.getMethod();
            if (statusCode >= 200 && statusCode < 300 && "INVITE".equalsIgnoreCase(method)) {
                String sipCallId = lastResponse.getCallId();
                parameters.add((NameValuePair)new BasicNameValuePair("SipCallId", sipCallId));
                Iterator headerIt = lastResponse.getHeaderNames();
                while (headerIt.hasNext()) {
                    String headerName = (String)headerIt.next();
                    if (!headerName.startsWith("X-")) continue;
                    parameters.add((NameValuePair)new BasicNameValuePair("SipHeader_" + headerName, lastResponse.getHeader(headerName)));
                }
            }
        }
        return parameters;
    }

    private final class Finished
    extends AbstractAction {
        public Finished(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (CallStateChanged.class.equals(klass)) {
                CallStateChanged event = (CallStateChanged)message;
                SubVoiceInterpreter.this.callState = event.state();
                if (SubVoiceInterpreter.this.callRecord != null) {
                    SubVoiceInterpreter.this.callRecord = SubVoiceInterpreter.this.callRecord.setStatus(SubVoiceInterpreter.this.callState.toString());
                    DateTime end = DateTime.now();
                    SubVoiceInterpreter.this.callRecord = SubVoiceInterpreter.this.callRecord.setEndTime(end);
                    int seconds = (int)(end.getMillis() - SubVoiceInterpreter.this.callRecord.getStartTime().getMillis()) / 1000;
                    SubVoiceInterpreter.this.callRecord = SubVoiceInterpreter.this.callRecord.setDuration(Integer.valueOf(seconds));
                    CallDetailRecordsDao records = SubVoiceInterpreter.this.storage.getCallDetailRecordsDao();
                    records.updateCallDetailRecord(SubVoiceInterpreter.this.callRecord);
                }
                SubVoiceInterpreter.this.callback();
            }
            if (SubVoiceInterpreter.this.call != null) {
                StopMediaGroup stop = new StopMediaGroup();
                SubVoiceInterpreter.this.call.tell((Object)stop, this.source);
            }
            SubVoiceInterpreter.this.callManager.tell((Object)new DestroyCall(SubVoiceInterpreter.this.call), this.source);
            UntypedActorContext context = SubVoiceInterpreter.this.getContext();
            if (SubVoiceInterpreter.this.mailerNotify != null) {
                context.stop(SubVoiceInterpreter.this.mailerNotify);
            }
            context.stop(SubVoiceInterpreter.this.downloader);
            context.stop(SubVoiceInterpreter.this.getAsrService());
            context.stop(SubVoiceInterpreter.this.getFaxService());
            context.stop(SubVoiceInterpreter.this.getCache());
            context.stop(SubVoiceInterpreter.this.getSynthesizer());
            SubVoiceInterpreter.this.postCleanup();
        }
    }

    private final class Rejecting
    extends AbstractAction {
        public Rejecting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                SubVoiceInterpreter.this.verb = (Tag)message;
            }
            String reason = "rejected";
            Attribute attribute = SubVoiceInterpreter.this.verb.attribute("reason");
            if (attribute != null) {
                reason = attribute.value();
                reason = reason != null && !reason.isEmpty() ? ("rejected".equalsIgnoreCase(reason) ? "rejected" : ("busy".equalsIgnoreCase(reason) ? "busy" : "rejected")) : "rejected";
            }
            SubVoiceInterpreter.this.call.tell((Object)new Reject(reason), this.source);
        }
    }

    private final class NotFound
    extends AbstractAction {
        public NotFound(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            DownloaderResponse response = (DownloaderResponse)message;
            if (SubVoiceInterpreter.this.logger.isDebugEnabled()) {
                SubVoiceInterpreter.this.logger.debug("response succeeded " + response.succeeded() + ", statusCode " + ((HttpResponseDescriptor)response.get()).getStatusCode());
            }
            Notification notification = SubVoiceInterpreter.this.notification(1, 21402, "URL Not Found : " + ((HttpResponseDescriptor)response.get()).getURI());
            NotificationsDao notifications = SubVoiceInterpreter.this.storage.getNotificationsDao();
            notifications.addNotification(notification);
            SubVoiceInterpreter.this.call.tell((Object)new org.restcomm.connect.telephony.api.NotFound(), this.source);
        }
    }

    private final class Ready
    extends AbstractAction {
        public Ready(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (SubVoiceInterpreter.this.parser == null) {
                SubVoiceInterpreter.this.response = (HttpResponseDescriptor)SubVoiceInterpreter.this.downloaderResponse.get();
                String type = SubVoiceInterpreter.this.response.getContentType();
                if (type.contains("text/xml") || type.contains("application/xml") || type.contains("text/html")) {
                    SubVoiceInterpreter.this.parser = SubVoiceInterpreter.this.parser(SubVoiceInterpreter.this.response.getContentAsString());
                } else if (type.contains("audio/wav") || type.contains("audio/wave") || type.contains("audio/x-wav")) {
                    SubVoiceInterpreter.this.parser = SubVoiceInterpreter.this.parser("<Play>" + SubVoiceInterpreter.this.request.getUri() + "</Play>");
                } else if (type.contains("text/plain")) {
                    SubVoiceInterpreter.this.parser = SubVoiceInterpreter.this.parser("<Say>" + SubVoiceInterpreter.this.response.getContentAsString() + "</Say>");
                } else {
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
            }
            GetNextVerb next = GetNextVerb.instance();
            SubVoiceInterpreter.this.parser.tell((Object)next, this.source);
        }
    }

    private final class DownloadingRcml
    extends AbstractAction {
        public DownloadingRcml(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (CallResponse.class.equals(klass)) {
                CallResponse response = (CallResponse)message;
                SubVoiceInterpreter.this.callInfo = (CallInfo)response.get();
                SubVoiceInterpreter.this.callState = SubVoiceInterpreter.this.callInfo.state();
                List<NameValuePair> parameters = SubVoiceInterpreter.this.parameters();
                SubVoiceInterpreter.this.request = new HttpRequestDescriptor(SubVoiceInterpreter.this.url, SubVoiceInterpreter.this.method, parameters);
                SubVoiceInterpreter.this.downloader.tell((Object)SubVoiceInterpreter.this.request, this.source);
            }
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

