/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.interpreter;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActorContext;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.pattern.Patterns;
import akka.util.Timeout;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import org.apache.commons.configuration.Configuration;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.message.BasicNameValuePair;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.restcomm.connect.asr.AsrResponse;
import org.restcomm.connect.commons.cache.DiskCacheResponse;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.fsm.TransitionFailedException;
import org.restcomm.connect.commons.fsm.TransitionNotFoundException;
import org.restcomm.connect.commons.fsm.TransitionRollbackException;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.commons.util.UriUtils;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.NotificationsDao;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.email.api.EmailResponse;
import org.restcomm.connect.fax.FaxResponse;
import org.restcomm.connect.http.client.DownloaderResponse;
import org.restcomm.connect.http.client.HttpRequestDescriptor;
import org.restcomm.connect.http.client.HttpResponseDescriptor;
import org.restcomm.connect.interpreter.BaseVoiceInterpreter;
import org.restcomm.connect.interpreter.Fork;
import org.restcomm.connect.interpreter.StartForking;
import org.restcomm.connect.interpreter.StartGathering;
import org.restcomm.connect.interpreter.StartInterpreter;
import org.restcomm.connect.interpreter.StopInterpreter;
import org.restcomm.connect.interpreter.SubVoiceInterpreterBuilder;
import org.restcomm.connect.interpreter.rcml.Attribute;
import org.restcomm.connect.interpreter.rcml.End;
import org.restcomm.connect.interpreter.rcml.GetNextVerb;
import org.restcomm.connect.interpreter.rcml.ParserFailed;
import org.restcomm.connect.interpreter.rcml.Tag;
import org.restcomm.connect.mscontrol.api.messages.JoinComplete;
import org.restcomm.connect.mscontrol.api.messages.Left;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupResponse;
import org.restcomm.connect.mscontrol.api.messages.Mute;
import org.restcomm.connect.mscontrol.api.messages.Play;
import org.restcomm.connect.mscontrol.api.messages.StartRecording;
import org.restcomm.connect.mscontrol.api.messages.StopMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.Unmute;
import org.restcomm.connect.sms.api.SmsServiceResponse;
import org.restcomm.connect.sms.api.SmsSessionResponse;
import org.restcomm.connect.telephony.api.AddParticipant;
import org.restcomm.connect.telephony.api.Answer;
import org.restcomm.connect.telephony.api.BridgeManagerResponse;
import org.restcomm.connect.telephony.api.BridgeStateChanged;
import org.restcomm.connect.telephony.api.CallFail;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.CallManagerResponse;
import org.restcomm.connect.telephony.api.CallResponse;
import org.restcomm.connect.telephony.api.CallStateChanged;
import org.restcomm.connect.telephony.api.Cancel;
import org.restcomm.connect.telephony.api.ConferenceCenterResponse;
import org.restcomm.connect.telephony.api.ConferenceInfo;
import org.restcomm.connect.telephony.api.ConferenceModeratorPresent;
import org.restcomm.connect.telephony.api.ConferenceResponse;
import org.restcomm.connect.telephony.api.ConferenceStateChanged;
import org.restcomm.connect.telephony.api.CreateBridge;
import org.restcomm.connect.telephony.api.CreateCall;
import org.restcomm.connect.telephony.api.CreateConference;
import org.restcomm.connect.telephony.api.DestroyCall;
import org.restcomm.connect.telephony.api.DestroyConference;
import org.restcomm.connect.telephony.api.Dial;
import org.restcomm.connect.telephony.api.GetCallInfo;
import org.restcomm.connect.telephony.api.GetConferenceInfo;
import org.restcomm.connect.telephony.api.GetRelatedCall;
import org.restcomm.connect.telephony.api.Hangup;
import org.restcomm.connect.telephony.api.JoinCalls;
import org.restcomm.connect.telephony.api.Reject;
import org.restcomm.connect.telephony.api.RemoveParticipant;
import org.restcomm.connect.telephony.api.StartBridge;
import org.restcomm.connect.telephony.api.StopBridge;
import org.restcomm.connect.telephony.api.StopConference;
import org.restcomm.connect.tts.api.SpeechSynthesizerResponse;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public final class VoiceInterpreter
extends BaseVoiceInterpreter {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final State startDialing;
    private final State processingDialChildren;
    private final State acquiringOutboundCallInfo;
    private final State forking;
    private final State creatingBridge;
    private final State initializingBridge;
    private final State bridging;
    private final State bridged;
    private final State finishDialing;
    private final State acquiringConferenceInfo;
    private final State joiningConference;
    private final State conferencing;
    private final State finishConferencing;
    private final State downloadingRcml;
    private final State downloadingFallbackRcml;
    private final State initializingCall;
    private final State ready;
    private final State notFound;
    private final State rejecting;
    private final State finished;
    private final ActorRef conferenceManager;
    private boolean isForking;
    private List<ActorRef> dialBranches;
    private List<Tag> dialChildren;
    private Map<ActorRef, Tag> dialChildrenWithAttributes;
    private int maxParticipantLimit = 40;
    private ActorRef conference;
    private Sid conferenceSid;
    private ConferenceInfo conferenceInfo;
    private ConferenceStateChanged.State conferenceState;
    private boolean muteCall;
    private boolean startConferenceOnEnter = true;
    private boolean endConferenceOnExit = false;
    private boolean confModeratorPresent = false;
    private ActorRef confSubVoiceInterpreter;
    private Attribute dialRecordAttribute;
    private boolean dialActionExecuted = false;
    private ActorRef sender;
    private boolean liveCallModification = false;
    private boolean recordingCall = true;
    protected boolean isParserFailed = false;
    protected boolean playWaitUrlPending = false;
    Tag conferenceVerb;
    List<URI> conferenceWaitUris;
    private boolean playMusicForConference = false;
    private String rcml;
    private final ActorRef bridgeManager;
    private ActorRef bridge;
    private boolean beep;
    private boolean enable200OkDelay;

    public VoiceInterpreter(Configuration configuration, Sid account, Sid phone, String version, URI url, String method, URI fallbackUrl, String fallbackMethod, URI statusCallback, String statusCallbackMethod, String emailAddress, ActorRef callManager, ActorRef conferenceManager, ActorRef bridgeManager, ActorRef sms, DaoManager storage, ActorRef monitoring, String rcml) {
        ActorRef source = this.self();
        this.downloadingRcml = new State("downloading rcml", (Action)new DownloadingRcml(source), null);
        this.downloadingFallbackRcml = new State("downloading fallback rcml", (Action)new DownloadingFallbackRcml(source), null);
        this.initializingCall = new State("initializing call", (Action)new InitializingCall(source), null);
        this.ready = new State("ready", (Action)new Ready(source), null);
        this.notFound = new State("notFound", (Action)new NotFound(source), null);
        this.rejecting = new State("rejecting", (Action)new Rejecting(source), null);
        this.startDialing = new State("start dialing", (Action)new StartDialing(source), null);
        this.processingDialChildren = new State("processing dial children", (Action)new ProcessingDialChildren(source), null);
        this.acquiringOutboundCallInfo = new State("acquiring outbound call info", (Action)new AcquiringOutboundCallInfo(source), null);
        this.forking = new State("forking", (Action)new Forking(source), null);
        this.creatingBridge = new State("creating bridge", (Action)new CreatingBridge(source), null);
        this.initializingBridge = new State("initializing bridge", (Action)new InitializingBridge(source), null);
        this.bridging = new State("bridging", (Action)new Bridging(source), null);
        this.bridged = new State("bridged", (Action)new Bridged(source), null);
        this.finishDialing = new State("finish dialing", (Action)new FinishDialing(source), null);
        this.acquiringConferenceInfo = new State("acquiring conference info", (Action)new AcquiringConferenceInfo(source), null);
        this.joiningConference = new State("joining conference", (Action)new JoiningConference(source), null);
        this.conferencing = new State("conferencing", (Action)new Conferencing(source), null);
        this.finishConferencing = new State("finish conferencing", (Action)new FinishConferencing(source), null);
        this.finished = new State("finished", (Action)new Finished(source), null);
        this.transitions.add(new Transition(this.acquiringAsrInfo, this.finished));
        this.transitions.add(new Transition(this.acquiringSynthesizerInfo, this.finished));
        this.transitions.add(new Transition(this.acquiringCallInfo, this.initializingCall));
        this.transitions.add(new Transition(this.acquiringCallInfo, this.downloadingRcml));
        this.transitions.add(new Transition(this.acquiringCallInfo, this.finished));
        this.transitions.add(new Transition(this.acquiringCallInfo, this.ready));
        this.transitions.add(new Transition(this.initializingCall, this.downloadingRcml));
        this.transitions.add(new Transition(this.initializingCall, this.ready));
        this.transitions.add(new Transition(this.initializingCall, this.finishDialing));
        this.transitions.add(new Transition(this.initializingCall, this.hangingUp));
        this.transitions.add(new Transition(this.initializingCall, this.finished));
        this.transitions.add(new Transition(this.downloadingRcml, this.ready));
        this.transitions.add(new Transition(this.downloadingRcml, this.notFound));
        this.transitions.add(new Transition(this.downloadingRcml, this.downloadingFallbackRcml));
        this.transitions.add(new Transition(this.downloadingRcml, this.hangingUp));
        this.transitions.add(new Transition(this.downloadingRcml, this.finished));
        this.transitions.add(new Transition(this.downloadingFallbackRcml, this.ready));
        this.transitions.add(new Transition(this.downloadingFallbackRcml, this.hangingUp));
        this.transitions.add(new Transition(this.downloadingFallbackRcml, this.finished));
        this.transitions.add(new Transition(this.downloadingFallbackRcml, this.notFound));
        this.transitions.add(new Transition(this.ready, this.initializingCall));
        this.transitions.add(new Transition(this.ready, this.faxing));
        this.transitions.add(new Transition(this.ready, this.sendingEmail));
        this.transitions.add(new Transition(this.ready, this.pausing));
        this.transitions.add(new Transition(this.ready, this.checkingCache));
        this.transitions.add(new Transition(this.ready, this.caching));
        this.transitions.add(new Transition(this.ready, this.synthesizing));
        this.transitions.add(new Transition(this.ready, this.rejecting));
        this.transitions.add(new Transition(this.ready, this.redirecting));
        this.transitions.add(new Transition(this.ready, this.processingGatherChildren));
        this.transitions.add(new Transition(this.ready, this.creatingRecording));
        this.transitions.add(new Transition(this.ready, this.creatingSmsSession));
        this.transitions.add(new Transition(this.ready, this.startDialing));
        this.transitions.add(new Transition(this.ready, this.hangingUp));
        this.transitions.add(new Transition(this.ready, this.finished));
        this.transitions.add(new Transition(this.pausing, this.ready));
        this.transitions.add(new Transition(this.pausing, this.finished));
        this.transitions.add(new Transition(this.rejecting, this.finished));
        this.transitions.add(new Transition(this.faxing, this.ready));
        this.transitions.add(new Transition(this.faxing, this.finished));
        this.transitions.add(new Transition(this.sendingEmail, this.ready));
        this.transitions.add(new Transition(this.sendingEmail, this.finished));
        this.transitions.add(new Transition(this.sendingEmail, this.finishDialing));
        this.transitions.add(new Transition(this.checkingCache, this.caching));
        this.transitions.add(new Transition(this.checkingCache, this.conferencing));
        this.transitions.add(new Transition(this.caching, this.finished));
        this.transitions.add(new Transition(this.caching, this.conferencing));
        this.transitions.add(new Transition(this.caching, this.finishConferencing));
        this.transitions.add(new Transition(this.playing, this.ready));
        this.transitions.add(new Transition(this.playing, this.finishConferencing));
        this.transitions.add(new Transition(this.playing, this.finished));
        this.transitions.add(new Transition(this.synthesizing, this.finished));
        this.transitions.add(new Transition(this.redirecting, this.ready));
        this.transitions.add(new Transition(this.redirecting, this.finished));
        this.transitions.add(new Transition(this.creatingRecording, this.finished));
        this.transitions.add(new Transition(this.finishRecording, this.ready));
        this.transitions.add(new Transition(this.finishRecording, this.finished));
        this.transitions.add(new Transition(this.processingGatherChildren, this.finished));
        this.transitions.add(new Transition(this.gathering, this.finished));
        this.transitions.add(new Transition(this.finishGathering, this.ready));
        this.transitions.add(new Transition(this.finishGathering, this.finishGathering));
        this.transitions.add(new Transition(this.finishGathering, this.finished));
        this.transitions.add(new Transition(this.creatingSmsSession, this.finished));
        this.transitions.add(new Transition(this.sendingSms, this.ready));
        this.transitions.add(new Transition(this.sendingSms, this.startDialing));
        this.transitions.add(new Transition(this.sendingSms, this.finished));
        this.transitions.add(new Transition(this.startDialing, this.processingDialChildren));
        this.transitions.add(new Transition(this.startDialing, this.acquiringConferenceInfo));
        this.transitions.add(new Transition(this.startDialing, this.faxing));
        this.transitions.add(new Transition(this.startDialing, this.sendingEmail));
        this.transitions.add(new Transition(this.startDialing, this.pausing));
        this.transitions.add(new Transition(this.startDialing, this.checkingCache));
        this.transitions.add(new Transition(this.startDialing, this.caching));
        this.transitions.add(new Transition(this.startDialing, this.synthesizing));
        this.transitions.add(new Transition(this.startDialing, this.redirecting));
        this.transitions.add(new Transition(this.startDialing, this.processingGatherChildren));
        this.transitions.add(new Transition(this.startDialing, this.creatingRecording));
        this.transitions.add(new Transition(this.startDialing, this.creatingSmsSession));
        this.transitions.add(new Transition(this.startDialing, this.startDialing));
        this.transitions.add(new Transition(this.startDialing, this.hangingUp));
        this.transitions.add(new Transition(this.startDialing, this.finished));
        this.transitions.add(new Transition(this.processingDialChildren, this.processingDialChildren));
        this.transitions.add(new Transition(this.processingDialChildren, this.forking));
        this.transitions.add(new Transition(this.processingDialChildren, this.hangingUp));
        this.transitions.add(new Transition(this.processingDialChildren, this.finished));
        this.transitions.add(new Transition(this.forking, this.acquiringOutboundCallInfo));
        this.transitions.add(new Transition(this.forking, this.finishDialing));
        this.transitions.add(new Transition(this.forking, this.hangingUp));
        this.transitions.add(new Transition(this.forking, this.finished));
        this.transitions.add(new Transition(this.forking, this.ready));
        this.transitions.add(new Transition(this.acquiringOutboundCallInfo, this.hangingUp));
        this.transitions.add(new Transition(this.acquiringOutboundCallInfo, this.finished));
        this.transitions.add(new Transition(this.acquiringOutboundCallInfo, this.creatingBridge));
        this.transitions.add(new Transition(this.creatingBridge, this.initializingBridge));
        this.transitions.add(new Transition(this.creatingBridge, this.finishDialing));
        this.transitions.add(new Transition(this.initializingBridge, this.bridging));
        this.transitions.add(new Transition(this.initializingBridge, this.hangingUp));
        this.transitions.add(new Transition(this.bridging, this.bridged));
        this.transitions.add(new Transition(this.bridging, this.finishDialing));
        this.transitions.add(new Transition(this.bridged, this.finishDialing));
        this.transitions.add(new Transition(this.bridged, this.finished));
        this.transitions.add(new Transition(this.finishDialing, this.ready));
        this.transitions.add(new Transition(this.finishDialing, this.faxing));
        this.transitions.add(new Transition(this.finishDialing, this.sendingEmail));
        this.transitions.add(new Transition(this.finishDialing, this.pausing));
        this.transitions.add(new Transition(this.finishDialing, this.checkingCache));
        this.transitions.add(new Transition(this.finishDialing, this.caching));
        this.transitions.add(new Transition(this.finishDialing, this.synthesizing));
        this.transitions.add(new Transition(this.finishDialing, this.redirecting));
        this.transitions.add(new Transition(this.finishDialing, this.processingGatherChildren));
        this.transitions.add(new Transition(this.finishDialing, this.creatingRecording));
        this.transitions.add(new Transition(this.finishDialing, this.creatingSmsSession));
        this.transitions.add(new Transition(this.finishDialing, this.startDialing));
        this.transitions.add(new Transition(this.finishDialing, this.hangingUp));
        this.transitions.add(new Transition(this.finishDialing, this.finished));
        this.transitions.add(new Transition(this.finishDialing, this.initializingCall));
        this.transitions.add(new Transition(this.acquiringConferenceInfo, this.joiningConference));
        this.transitions.add(new Transition(this.acquiringConferenceInfo, this.hangingUp));
        this.transitions.add(new Transition(this.acquiringConferenceInfo, this.finished));
        this.transitions.add(new Transition(this.joiningConference, this.conferencing));
        this.transitions.add(new Transition(this.joiningConference, this.hangingUp));
        this.transitions.add(new Transition(this.joiningConference, this.finished));
        this.transitions.add(new Transition(this.conferencing, this.finishConferencing));
        this.transitions.add(new Transition(this.conferencing, this.hangingUp));
        this.transitions.add(new Transition(this.conferencing, this.finished));
        this.transitions.add(new Transition(this.conferencing, this.checkingCache));
        this.transitions.add(new Transition(this.conferencing, this.caching));
        this.transitions.add(new Transition(this.conferencing, this.playing));
        this.transitions.add(new Transition(this.conferencing, this.startDialing));
        this.transitions.add(new Transition(this.conferencing, this.creatingSmsSession));
        this.transitions.add(new Transition(this.conferencing, this.sendingEmail));
        this.transitions.add(new Transition(this.finishConferencing, this.ready));
        this.transitions.add(new Transition(this.finishConferencing, this.faxing));
        this.transitions.add(new Transition(this.finishConferencing, this.sendingEmail));
        this.transitions.add(new Transition(this.finishConferencing, this.pausing));
        this.transitions.add(new Transition(this.finishConferencing, this.checkingCache));
        this.transitions.add(new Transition(this.finishConferencing, this.caching));
        this.transitions.add(new Transition(this.finishConferencing, this.synthesizing));
        this.transitions.add(new Transition(this.finishConferencing, this.redirecting));
        this.transitions.add(new Transition(this.finishConferencing, this.processingGatherChildren));
        this.transitions.add(new Transition(this.finishConferencing, this.creatingRecording));
        this.transitions.add(new Transition(this.finishConferencing, this.creatingSmsSession));
        this.transitions.add(new Transition(this.finishConferencing, this.startDialing));
        this.transitions.add(new Transition(this.finishConferencing, this.hangingUp));
        this.transitions.add(new Transition(this.finishConferencing, this.finished));
        this.transitions.add(new Transition(this.hangingUp, this.finished));
        this.transitions.add(new Transition(this.hangingUp, this.finishConferencing));
        this.transitions.add(new Transition(this.hangingUp, this.finishDialing));
        this.transitions.add(new Transition(this.uninitialized, this.finished));
        this.transitions.add(new Transition(this.notFound, this.finished));
        this.fsm = new FiniteStateMachine(this.uninitialized, this.transitions);
        this.accountId = account;
        this.phoneId = phone;
        this.version = version;
        this.url = url;
        this.method = method;
        this.fallbackUrl = fallbackUrl;
        this.fallbackMethod = fallbackMethod;
        this.statusCallback = statusCallback;
        this.statusCallbackMethod = statusCallbackMethod;
        this.emailAddress = emailAddress;
        this.configuration = configuration;
        this.callManager = callManager;
        this.conferenceManager = conferenceManager;
        this.bridgeManager = bridgeManager;
        this.smsService = sms;
        this.smsSessions = new HashMap();
        this.storage = storage;
        Configuration runtime = configuration.subset("runtime-settings");
        this.playMusicForConference = Boolean.parseBoolean(runtime.getString("play-music-for-conference", "false"));
        this.enable200OkDelay = this.configuration.subset("runtime-settings").getBoolean("enable-200-ok-delay", false);
        this.downloader = this.downloader();
        this.monitoring = monitoring;
        this.rcml = rcml;
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    private Notification notification(int log, int error, String message) {
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(this.accountId);
        builder.setCallSid(this.callInfo.sid());
        builder.setApiVersion(this.version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        try {
            base = UriUtils.resolve((URI)new URI(base)).toString();
        }
        catch (URISyntaxException e) {
            this.logger.error("URISyntaxException when trying to resolve Error-Dictionary URI: " + e);
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        URI info = URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        if (this.request != null) {
            builder.setRequestUrl(this.request.getUri());
            builder.setRequestMethod(this.request.getMethod());
            builder.setRequestVariables(this.request.getParametersAsString());
        }
        if (this.response != null) {
            builder.setResponseHeaders(this.response.getHeadersAsString());
            String type = this.response.getContentType();
            if (type.contains("text/xml") || type.contains("application/xml") || type.contains("text/html")) {
                try {
                    builder.setResponseBody(this.response.getContentAsString());
                }
                catch (IOException exception) {
                    this.logger.error("There was an error while reading the contents of the resource located @ " + this.url.toString(), (Object)exception);
                }
            }
        }
        buffer = new StringBuilder();
        buffer.append("/").append(this.version).append("/Accounts/");
        buffer.append(this.accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    @Override
    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        State state = this.fsm.state();
        this.sender = this.sender();
        ActorRef self = this.self();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** VoiceInterpreter's " + this.self().path() + " Current State: " + state.toString() + "\n" + ", Processing Message: " + klass.getName());
        }
        if (StartInterpreter.class.equals(klass)) {
            StartInterpreter request = (StartInterpreter)message;
            this.call = request.resource();
            this.fsm.transition(message, this.acquiringAsrInfo);
        } else if (AsrResponse.class.equals(klass)) {
            this.onAsrResponse(message);
        } else if (SpeechSynthesizerResponse.class.equals(klass)) {
            this.onSpeechSynthesizerResponse(message);
        } else if (CallResponse.class.equals(klass)) {
            this.onCallResponse(message, state);
        } else if (CallStateChanged.class.equals(klass)) {
            this.onCallStateChanged(message, this.sender);
        } else if (CallManagerResponse.class.equals(klass)) {
            this.onCallManagerResponse(message);
        } else if (StartForking.class.equals(klass)) {
            this.fsm.transition(message, this.processingDialChildren);
        } else if (ConferenceCenterResponse.class.equals(klass)) {
            this.onConferenceCenterResponse(message);
        } else if (Fork.class.equals(klass)) {
            this.onForkMessage(message);
        } else if (ConferenceResponse.class.equals(klass)) {
            this.onConferenceResponse(message);
        } else if (ConferenceStateChanged.class.equals(klass)) {
            this.onConferenceStateChanged(message);
        } else if (DownloaderResponse.class.equals(klass)) {
            this.onDownloaderResponse(message, state);
        } else if (DiskCacheResponse.class.equals(klass)) {
            this.onDiskCacheResponse(message);
        } else if (ParserFailed.class.equals(klass)) {
            this.onParserFailed(message);
        } else if (Tag.class.equals(klass)) {
            this.onTagMessage(message);
        } else if (End.class.equals(klass)) {
            this.onEndMessage(message);
        } else if (StartGathering.class.equals(klass)) {
            this.fsm.transition(message, this.gathering);
        } else if (MediaGroupResponse.class.equals(klass)) {
            this.onMediaGroupResponse(message);
        } else if (SmsServiceResponse.class.equals(klass)) {
            this.onSmsServiceResponse(message);
        } else if (SmsSessionResponse.class.equals(klass)) {
            this.smsResponse(message);
        } else if (FaxResponse.class.equals(klass)) {
            this.fsm.transition(message, this.ready);
        } else if (EmailResponse.class.equals(klass)) {
            this.onEmailResponse(message);
        } else if (StopInterpreter.class.equals(klass)) {
            this.onStopInterpreter(message);
        } else if (message instanceof ReceiveTimeout) {
            this.onReceiveTimeout(message);
        } else if (BridgeManagerResponse.class.equals(klass)) {
            this.onBridgeManagerResponse((BridgeManagerResponse)message, self, this.sender);
        } else if (BridgeStateChanged.class.equals(klass)) {
            this.onBridgeStateChanged((BridgeStateChanged)message, self, this.sender);
        } else if (GetRelatedCall.class.equals(klass)) {
            this.onGetRelatedCall((GetRelatedCall)message, self, this.sender);
        } else if (JoinComplete.class.equals(klass)) {
            this.onJoinComplete((JoinComplete)message);
        }
    }

    private void onJoinComplete(JoinComplete message) throws TransitionNotFoundException, TransitionFailedException, TransitionRollbackException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("JoinComplete received, sender: " + this.sender().path() + ", VI state: " + this.fsm.state());
        }
        if (this.is(this.joiningConference)) {
            this.fsm.transition((Object)message, this.conferencing);
        }
    }

    private void onAsrResponse(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        if (this.outstandingAsrRequests > 0) {
            this.asrResponse(message);
        } else {
            this.fsm.transition(message, this.acquiringSynthesizerInfo);
        }
    }

    private void onForkMessage(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        if (this.is(this.processingDialChildren)) {
            this.fsm.transition(message, this.forking);
        }
    }

    private void onConferenceCenterResponse(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        if (this.is(this.startDialing)) {
            ConferenceCenterResponse ccReponse = (ConferenceCenterResponse)message;
            if (ccReponse.succeeded()) {
                this.fsm.transition(message, this.acquiringConferenceInfo);
            } else {
                this.fsm.transition(message, this.hangingUp);
            }
        }
    }

    private void onConferenceResponse(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        ConferenceResponse response = (ConferenceResponse)message;
        Class<?> klass = ((ConferenceResponse)message).get().getClass();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("New ConferenceResponse received with message: " + klass.getName());
        }
        if (Left.class.equals(klass)) {
            Left left = (Left)((ConferenceResponse)message).get();
            ActorRef leftCall = left.get();
            if (leftCall.equals((Object)this.call) && this.conference != null) {
                if (this.conferenceInfo.globalParticipants() != 0) {
                    String path = this.configuration.subset("runtime-settings").getString("prompts-uri");
                    if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                    String exitAudio = this.configuration.subset("runtime-settings").getString("conference-exit-audio");
                    path = path + (exitAudio == null || exitAudio.equals("") ? "alert.wav" : exitAudio);
                    URI uri = null;
                    try {
                        uri = UriUtils.resolve((URI)new URI(path));
                    }
                    catch (Exception exception) {
                        Notification notification = this.notification(0, 12400, exception.getMessage());
                        NotificationsDao notifications = this.storage.getNotificationsDao();
                        notifications.addNotification(notification);
                        this.sendMail(notification);
                        StopInterpreter stop = new StopInterpreter();
                        this.self().tell((Object)stop, this.self());
                        return;
                    }
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("going to play conference-exit-audio beep");
                    }
                    Play play = new Play(uri, 1);
                    this.conference.tell((Object)play, this.self());
                }
                if (this.endConferenceOnExit) {
                    StopConference stop = new StopConference();
                    this.conference.tell((Object)stop, this.self());
                }
                Attribute attribute = null;
                if (this.verb != null) {
                    attribute = this.verb.attribute("action");
                }
                if (attribute == null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Attribute is null, will ask for the next verb from parser");
                    }
                    GetNextVerb next = GetNextVerb.instance();
                    this.parser.tell((Object)next, this.self());
                } else {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Dial Action is set, executing Dial Action");
                    }
                    this.executeDialAction(message, this.sender);
                }
                this.conference.tell((Object)new StopObserving(this.self()), null);
            }
        } else if (ConferenceInfo.class.equals(klass)) {
            this.conferenceInfo = (ConferenceInfo)response.get();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("VoiceInterpreter received ConferenceResponse from Conference: " + this.conferenceInfo.name() + ", path: " + this.sender().path() + ", current confernce size: " + this.conferenceInfo.globalParticipants() + ", VI state: " + this.fsm.state());
            }
            if (this.is(this.acquiringConferenceInfo)) {
                this.fsm.transition(message, this.joiningConference);
            }
        }
    }

    private void onConferenceStateChanged(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        ConferenceStateChanged event = (ConferenceStateChanged)message;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("onConferenceStateChanged: " + event.state());
        }
        switch (event.state()) {
            case RUNNING_MODERATOR_PRESENT: {
                this.conferenceState = event.state();
                this.conferenceStateModeratorPresent(message);
                break;
            }
            case COMPLETED: {
                this.conferenceState = event.state();
                if (this.is(this.finished)) break;
                this.fsm.transition(message, this.finishConferencing);
                break;
            }
        }
    }

    private void onParserFailed(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ParserFailed received. Will stop the call");
        }
        this.isParserFailed = true;
        this.fsm.transition(message, this.hangingUp);
    }

    private void onStopInterpreter(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        this.liveCallModification = ((StopInterpreter)message).isLiveCallModification();
        if (CallStateChanged.State.IN_PROGRESS.equals((Object)this.callState) && !this.liveCallModification) {
            this.fsm.transition(message, this.hangingUp);
        } else {
            this.fsm.transition(message, this.finished);
        }
    }

    private void onReceiveTimeout(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Timeout received");
        }
        if (this.is(this.pausing)) {
            this.fsm.transition(message, this.ready);
        } else if (this.is(this.conferencing)) {
            this.fsm.transition(message, this.finishConferencing);
        } else if (this.is(this.forking)) {
            this.fsm.transition(message, this.finishDialing);
        } else if (this.is(this.bridged)) {
            this.fsm.transition(message, this.finishDialing);
        } else if (this.is(this.bridging)) {
            this.fsm.transition(message, this.finishDialing);
        }
    }

    private void onEmailResponse(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        EmailResponse response = (EmailResponse)message;
        if (!response.succeeded()) {
            this.logger.error("There was an error while sending an email :" + response.error(), (Object)response.cause());
            return;
        }
        this.fsm.transition(message, this.ready);
    }

    private void onSmsServiceResponse(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        SmsServiceResponse response = (SmsServiceResponse)message;
        if (response.succeeded()) {
            if (this.is(this.creatingSmsSession)) {
                this.fsm.transition(message, this.sendingSms);
            }
        } else {
            this.fsm.transition(message, this.hangingUp);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onMediaGroupResponse(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        MediaGroupResponse response = (MediaGroupResponse)message;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("MediaGroupResponse, succeeded: " + response.succeeded() + "  " + response.cause());
        }
        if (!response.succeeded()) {
            this.fsm.transition(message, this.hangingUp);
            return;
        }
        if (this.is(this.playingRejectionPrompt)) {
            this.fsm.transition(message, this.hangingUp);
            return;
        }
        if (this.is(this.playing)) {
            this.fsm.transition(message, this.ready);
            return;
        }
        if (this.is(this.creatingRecording)) {
            this.fsm.transition(message, this.finishRecording);
            return;
        }
        if (this.is(this.gathering) || this.is(this.finishGathering) && !this.dtmfReceived.booleanValue()) {
            MediaGroupResponse dtmfResponse = (MediaGroupResponse)message;
            if (this.sender != this.call) {
                this.collectedDigits.append((String)dtmfResponse.get());
                this.fsm.transition(message, this.finishGathering);
                return;
            }
            this.collectedDigits.append((String)dtmfResponse.get());
            if (this.numberOfDigits != Short.MAX_VALUE) {
                if (this.collectedDigits.length() == this.numberOfDigits) {
                    this.dtmfReceived = true;
                    this.fsm.transition(message, this.finishGathering);
                    return;
                }
                this.dtmfReceived = false;
                return;
            }
            if (this.collectedDigits.toString().endsWith(this.finishOnKey)) {
                this.dtmfReceived = true;
                this.fsm.transition(message, this.finishGathering);
                return;
            }
            this.dtmfReceived = false;
            return;
        }
        if (!this.is(this.bridging)) return;
        JoinCalls bridgeCalls = new JoinCalls(this.call, this.outboundCall);
        this.bridge.tell((Object)bridgeCalls, this.self());
    }

    private void onEndMessage(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        if (this.playWaitUrlPending && this.conferenceWaitUris != null && this.conferenceWaitUris.size() > 0) {
            this.fsm.transition(this.conferenceWaitUris, this.conferencing);
            return;
        }
        if (this.callState.equals((Object)CallStateChanged.State.COMPLETED)) {
            this.fsm.transition(message, this.finished);
        } else if (!this.isParserFailed) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("End tag received will move to hangup the call, VI state: " + this.fsm.state());
            }
            this.fsm.transition(message, this.hangingUp);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("End tag received but parser failed earlier so hangup would have been already sent to the call");
        }
    }

    private void onTagMessage(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        this.verb = (Tag)message;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Tag received, name: " + this.verb.name() + ", text: " + this.verb.text());
        }
        if (this.playWaitUrlPending) {
            if (!"Play".equals(this.verb.name()) && !"Say".equals(this.verb.name())) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Tag for waitUrl is neither Play or Say");
                }
                this.fsm.transition(message, this.hangingUp);
            }
            if ("Say".equals(this.verb.name())) {
                this.fsm.transition(message, this.checkingCache);
            } else if ("Play".equals(this.verb.name())) {
                this.fsm.transition(message, this.caching);
            }
            return;
        }
        if (CallStateChanged.State.RINGING == this.callState) {
            if ("Reject".equals(this.verb.name())) {
                this.fsm.transition(message, this.rejecting);
            } else if ("Pause".equals(this.verb.name())) {
                this.fsm.transition(message, this.pausing);
            } else {
                this.fsm.transition(message, this.initializingCall);
            }
        } else if ("Dial".equals(this.verb.name())) {
            this.dialRecordAttribute = this.verb.attribute("record");
            this.fsm.transition(message, this.startDialing);
        } else if ("Fax".equals(this.verb.name())) {
            this.fsm.transition(message, this.caching);
        } else if ("Play".equals(this.verb.name())) {
            this.fsm.transition(message, this.caching);
        } else if ("Say".equals(this.verb.name())) {
            this.fsm.transition(message, this.checkingCache);
        } else if ("Gather".equals(this.verb.name())) {
            this.gatherVerb = this.verb;
            this.fsm.transition(message, this.processingGatherChildren);
        } else if ("Pause".equals(this.verb.name())) {
            this.fsm.transition(message, this.pausing);
        } else if ("Hangup".equals(this.verb.name())) {
            if (this.is(this.finishDialing)) {
                this.fsm.transition(message, this.finished);
            } else {
                this.fsm.transition(message, this.hangingUp);
            }
        } else if ("Redirect".equals(this.verb.name())) {
            this.fsm.transition(message, this.redirecting);
        } else if ("Record".equals(this.verb.name())) {
            this.fsm.transition(message, this.creatingRecording);
        } else if ("Sms".equals(this.verb.name())) {
            this.fsm.transition(message, this.creatingSmsSession);
        } else if ("Email".equals(this.verb.name())) {
            this.fsm.transition(message, this.sendingEmail);
        } else {
            this.invalidVerb(this.verb);
        }
    }

    private void onDiskCacheResponse(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        DiskCacheResponse response = (DiskCacheResponse)message;
        if (response.succeeded()) {
            if (this.playWaitUrlPending) {
                if (this.conferenceWaitUris == null) {
                    this.conferenceWaitUris = new ArrayList<URI>();
                }
                URI waitUrl = (URI)response.get();
                this.conferenceWaitUris.add(waitUrl);
                GetNextVerb next = GetNextVerb.instance();
                this.parser.tell((Object)next, this.self());
                return;
            }
            if (this.is(this.caching) || this.is(this.checkingCache)) {
                if ("Play".equals(this.verb.name()) || "Say".equals(this.verb.name())) {
                    this.fsm.transition(message, this.playing);
                } else if ("Fax".equals(this.verb.name())) {
                    this.fsm.transition(message, this.faxing);
                } else if ("Email".equals(this.verb.name())) {
                    this.fsm.transition(message, this.sendingEmail);
                }
            } else if (this.is(this.processingGatherChildren)) {
                this.fsm.transition(message, this.processingGatherChildren);
            }
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("DiskCacheResponse is " + response.toString());
            }
            if (this.is(this.checkingCache) || this.is(this.processingGatherChildren)) {
                this.fsm.transition(message, this.synthesizing);
            } else {
                if (response.cause() != null) {
                    Notification notification = this.notification(1, 13233, response.cause().getMessage());
                    NotificationsDao notifications = this.storage.getNotificationsDao();
                    notifications.addNotification(notification);
                    this.sendMail(notification);
                }
                this.fsm.transition(message, this.hangingUp);
            }
        }
    }

    private void onCallManagerResponse(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        CallManagerResponse response = (CallManagerResponse)message;
        if (response.succeeded()) {
            if (this.is(this.startDialing)) {
                this.fsm.transition(message, this.processingDialChildren);
            } else if (this.is(this.processingDialChildren)) {
                this.fsm.transition(message, this.processingDialChildren);
            }
        } else if (this.dialChildren != null && this.dialChildren.size() > 1) {
            this.fsm.transition(message, this.processingDialChildren);
        } else {
            this.fsm.transition(message, this.hangingUp);
        }
    }

    private void onSpeechSynthesizerResponse(Object message) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        if (this.is(this.acquiringSynthesizerInfo)) {
            this.fsm.transition(message, this.acquiringCallInfo);
        } else if (this.is(this.processingGatherChildren) || this.processingGather.booleanValue()) {
            SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
            if (response.succeeded()) {
                this.fsm.transition(message, this.processingGatherChildren);
            } else {
                this.fsm.transition(message, this.hangingUp);
            }
        } else if (this.is(this.synthesizing)) {
            SpeechSynthesizerResponse response = (SpeechSynthesizerResponse)message;
            if (response.succeeded()) {
                this.fsm.transition(message, this.caching);
            } else {
                this.fsm.transition(message, this.hangingUp);
            }
        }
    }

    private void onCallResponse(Object message, State state) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        if (this.forking.equals((Object)state)) {
            CallResponse response = (CallResponse)message;
            if (this.sender == this.call) {
                this.callInfo = (CallInfo)response.get();
            } else {
                this.outboundCall = this.sender;
                this.outboundCallInfo = (CallInfo)response.get();
            }
        } else if (this.acquiringCallInfo.equals((Object)state)) {
            String direction;
            CallResponse response = (CallResponse)message;
            if (this.sender == this.call) {
                this.callInfo = (CallInfo)response.get();
                if (this.callInfo.state() == CallStateChanged.State.CANCELED || this.callInfo.invite() != null && this.callInfo.invite().getSession().getState().equals((Object)SipSession.State.TERMINATED)) {
                    this.fsm.transition(message, this.finished);
                    return;
                }
                this.call.tell((Object)new Observe(this.self()), this.self());
                if (this.monitoring != null) {
                    this.call.tell((Object)new Observe(this.monitoring), this.self());
                }
            } else {
                this.outboundCallInfo = (CallInfo)response.get();
            }
            if ("inbound".equals(direction = this.callInfo.direction())) {
                if (this.rcml != null && !this.rcml.isEmpty()) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("System app is present will proceed to ready state, system app: " + this.rcml);
                    }
                    this.createInitialCallRecord((CallResponse<CallInfo>)((CallResponse)message));
                    this.fsm.transition(message, this.ready);
                } else {
                    this.fsm.transition(message, this.downloadingRcml);
                }
            } else {
                this.fsm.transition(message, this.initializingCall);
            }
        } else if (this.acquiringOutboundCallInfo.equals((Object)state)) {
            CallResponse response = (CallResponse)message;
            this.outboundCallInfo = (CallInfo)response.get();
            this.fsm.transition(message, this.creatingBridge);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onDownloaderResponse(Object message, State state) throws IOException, TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        DownloaderResponse response = (DownloaderResponse)message;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Download Rcml response succeeded " + response.succeeded());
            if (response.get() != null) {
                this.logger.debug("statusCode " + ((HttpResponseDescriptor)response.get()).getStatusCode());
            }
        }
        if (response.succeeded() && 200 == ((HttpResponseDescriptor)response.get()).getStatusCode()) {
            if (this.conferencing.equals((Object)state)) {
                String type;
                if (this.parser != null) {
                    this.getContext().stop(this.parser);
                    this.parser = null;
                }
                if ((type = ((HttpResponseDescriptor)response.get()).getContentType()) != null) {
                    if (type.contains("text/xml") || type.contains("application/xml") || type.contains("text/html")) {
                        this.parser = this.parser(((HttpResponseDescriptor)response.get()).getContentAsString());
                    } else if (type.contains("audio/wav") || type.contains("audio/wave") || type.contains("audio/x-wav")) {
                        this.parser = this.parser("<Play>" + this.request.getUri() + "</Play>");
                    } else if (type.contains("text/plain")) {
                        this.parser = this.parser("<Say>" + ((HttpResponseDescriptor)response.get()).getContentAsString() + "</Say>");
                    }
                } else {
                    this.fsm.transition(message, this.hangingUp);
                }
                GetNextVerb next = GetNextVerb.instance();
                this.parser.tell((Object)next, this.self());
                return;
            }
            if (this.dialBranches != null && this.dialBranches.size() != 0) return;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Downloader response is success, moving to Ready state");
            }
            this.fsm.transition(message, this.ready);
            return;
        } else if (this.downloadingRcml.equals((Object)state) && this.fallbackUrl != null) {
            this.fsm.transition(message, this.downloadingFallbackRcml);
            return;
        } else if (response.succeeded() && 404 == ((HttpResponseDescriptor)response.get()).getStatusCode()) {
            this.fsm.transition(message, this.notFound);
            return;
        } else {
            this.call.tell((Object)new CallFail(response.error()), this.self());
        }
    }

    private void onCallStateChanged(Object message, ActorRef sender) throws TransitionFailedException, TransitionNotFoundException, TransitionRollbackException {
        CallStateChanged event = (CallStateChanged)message;
        if (sender == this.call) {
            this.callState = event.state();
        } else if (event.sipResponse() != null && event.sipResponse() >= 400) {
            this.outboundCallResponse = event.sipResponse();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("VoiceInterpreter received CallStateChanged event: " + event + " from " + (sender == this.call ? "call" : "outboundCall") + ", sender path: " + sender.path() + ", current VI state: " + this.fsm.state());
        }
        Attribute attribute = null;
        if (this.verb != null) {
            attribute = this.verb.attribute("action");
        }
        switch (event.state()) {
            case QUEUED: {
                break;
            }
            case RINGING: {
                if (!this.is(this.forking)) break;
                this.outboundCall = sender;
                break;
            }
            case CANCELED: {
                if (this.is(this.initializingBridge) || this.is(this.acquiringOutboundCallInfo) || this.is(this.bridging) || this.is(this.bridged)) {
                    this.callManager.tell((Object)new DestroyCall(sender), this.self());
                    return;
                }
                if (this.enable200OkDelay && this.dialBranches != null && sender.equals((Object)this.call)) {
                    if (this.callRecord != null) {
                        CallDetailRecordsDao records = this.storage.getCallDetailRecordsDao();
                        this.callRecord = records.getCallDetailRecord(this.callRecord.getSid());
                        this.callRecord = this.callRecord.setStatus(this.callState.toString());
                        records.updateCallDetailRecord(this.callRecord);
                    }
                    this.fsm.transition(message, this.finishDialing);
                    break;
                }
                if (sender == this.call) {
                    this.fsm.transition(message, this.finished);
                    break;
                }
                if (this.dialBranches != null && this.dialBranches.contains(sender)) {
                    this.removeDialBranch(message, sender);
                    this.checkDialBranch(message, sender, attribute);
                    break;
                }
                this.callState = event.state();
                break;
            }
            case BUSY: {
                if (this.is(this.forking)) {
                    if (sender == this.call) {
                        this.fsm.transition(message, this.finishDialing);
                        break;
                    }
                    if (this.dialBranches != null && this.dialBranches.contains(sender)) {
                        this.removeDialBranch(message, sender);
                    }
                    this.checkDialBranch(message, sender, attribute);
                    return;
                }
                this.fsm.transition(message, this.finishDialing);
                return;
            }
            case NOT_FOUND: {
                break;
            }
            case NO_ANSWER: {
                if (this.is(this.bridging) || this.is(this.bridged) && !sender.equals((Object)this.call)) {
                    this.fsm.transition(message, this.finishDialing);
                    break;
                }
                if (this.is(this.forking)) {
                    if (sender.equals((Object)this.call)) break;
                    break;
                }
                if (!this.is(this.finishDialing) || this.dialBranches != null && this.dialBranches.size() != 0 || !sender.equals((Object)this.call)) break;
                this.logger.info("No-Answer event received, and dialBrances is either null or 0 size, sender: " + sender.path() + ", vi state: " + this.fsm.state());
                this.checkDialBranch(message, sender, attribute);
                break;
            }
            case FAILED: {
                if (sender.equals((Object)this.call)) break;
                if (this.dialBranches != null && this.dialBranches.contains(sender)) {
                    this.dialBranches.remove(sender);
                }
                this.checkDialBranch(message, sender, attribute);
                break;
            }
            case COMPLETED: {
                if (this.is(this.bridging)) {
                    this.fsm.transition(message, this.finishDialing);
                    break;
                }
                if (this.is(this.bridged) && (sender.equals((Object)this.outboundCall) || this.outboundCall != null)) {
                    this.fsm.transition(message, this.finishDialing);
                    break;
                }
                if (this.is(this.forking) && (this.dialBranches != null && this.dialBranches.contains(sender) || this.outboundCall == null)) {
                    if (!sender.equals((Object)this.call)) {
                        this.removeDialBranch(message, sender);
                        this.checkDialBranch(message, sender, attribute);
                        return;
                    }
                    this.fsm.transition(message, this.finishDialing);
                    break;
                }
                if (this.is(this.creatingRecording)) {
                    this.call.tell((Object)new StopMediaGroup(), null);
                    this.fsm.transition(message, this.finishRecording);
                    break;
                }
                if ((this.is(this.bridged) || this.is(this.forking)) && this.call == this.sender()) {
                    if (this.dialActionExecuted) break;
                    this.fsm.transition(message, this.finishDialing);
                    break;
                }
                if (this.is(this.finishDialing)) {
                    if (sender.equals((Object)this.call)) {
                        this.fsm.transition(message, this.finished);
                        break;
                    }
                    this.checkDialBranch(message, this.sender(), attribute);
                    break;
                }
                if (this.is(this.conferencing) || this.is(this.finishConferencing)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("VoiceInterpreter received CallStateChanged.Completed VI in: " + this.fsm.state() + " state, will return and wait for ConferenceStateChanged.Completed event");
                    }
                    return;
                }
                if (this.is(this.finishDialing)) break;
                this.fsm.transition(message, this.finished);
                break;
            }
            case WAIT_FOR_ANSWER: 
            case IN_PROGRESS: {
                if (this.is(this.initializingCall) || this.is(this.rejecting)) {
                    if (this.parser != null) {
                        this.fsm.transition(message, this.ready);
                    } else {
                        this.fsm.transition(message, this.downloadingRcml);
                    }
                } else if (this.is(this.forking)) {
                    if (this.outboundCall == null || !sender.equals((Object)this.call)) {
                        this.outboundCall = sender;
                    }
                    this.fsm.transition(message, this.acquiringOutboundCallInfo);
                } else if (this.is(this.conferencing)) {
                    if (!this.liveCallModification) {
                        Hangup hangup = new Hangup();
                        this.call.tell((Object)hangup, sender);
                    } else {
                        GetNextVerb next = GetNextVerb.instance();
                        this.parser.tell((Object)next, this.self());
                    }
                }
                if (this.callRecord == null || this.is(this.initializingCall) || this.is(this.rejecting)) break;
                CallDetailRecordsDao records = this.storage.getCallDetailRecordsDao();
                this.callRecord = records.getCallDetailRecord(this.callRecord.getSid());
                this.callRecord = this.callRecord.setStatus(this.callState.toString());
                records.updateCallDetailRecord(this.callRecord);
            }
        }
    }

    private void removeDialBranch(Object message, ActorRef sender) {
        CallStateChanged.State state = null;
        if (message instanceof CallStateChanged) {
            state = ((CallStateChanged)message).state();
        } else if (message instanceof ReceiveTimeout) {
            state = CallStateChanged.State.NO_ANSWER;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Dial branch new call state: " + state + " call path: " + this.sender().path() + " VI state: " + this.fsm.state());
        }
        if (state != null && !state.equals((Object)CallStateChanged.State.CANCELED)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("At removeDialBranch() will cancel call: " + sender.path() + ", isTerminated: " + sender.isTerminated());
            }
            sender.tell((Object)new Cancel(), this.self());
        }
        if (this.outboundCall != null && this.outboundCall.equals((Object)sender)) {
            this.outboundCall = null;
        }
        if (this.dialBranches != null && this.dialBranches.contains(sender)) {
            this.dialBranches.remove(sender);
        }
    }

    private void checkDialBranch(Object message, ActorRef sender, Attribute attribute) {
        CallStateChanged.State state = null;
        if (message instanceof CallStateChanged) {
            state = ((CallStateChanged)message).state();
        } else if (message instanceof ReceiveTimeout) {
            state = CallStateChanged.State.NO_ANSWER;
        }
        if (this.dialBranches == null || this.dialBranches.size() == 0) {
            this.dialBranches = null;
            if (attribute == null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Attribute is null, will destroy call and ask for the next verb from parser");
                }
                if (sender != null && !sender.equals((Object)this.call)) {
                    this.callManager.tell((Object)new DestroyCall(sender), this.self());
                }
                GetNextVerb next = GetNextVerb.instance();
                this.parser.tell((Object)next, this.self());
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Executing Dial Action and will destroy call");
                }
                this.executeDialAction(message, sender);
                if (sender != null && !sender.equals((Object)this.call)) {
                    this.callManager.tell((Object)new DestroyCall(sender), this.self());
                }
            }
            if (this.bridge != null) {
                this.bridge.tell((Object)new StopBridge(this.liveCallModification), this.self());
                this.recordingCall = false;
                this.bridge = null;
            }
        } else if (state != null && (state.equals((Object)CallStateChanged.State.BUSY) || state.equals((Object)CallStateChanged.State.CANCELED) || state.equals((Object)CallStateChanged.State.FAILED))) {
            this.callManager.tell((Object)new DestroyCall(sender), this.self());
        }
    }

    private void onBridgeManagerResponse(BridgeManagerResponse message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.creatingBridge)) {
            this.bridge = (ActorRef)message.get();
            this.fsm.transition((Object)message, this.initializingBridge);
        }
    }

    private void onBridgeStateChanged(BridgeStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        switch (message.getState()) {
            case READY: {
                if (!this.is(this.initializingBridge)) break;
                this.fsm.transition((Object)message, this.bridging);
                break;
            }
            case BRIDGED: {
                if (!this.is(this.bridging)) break;
                this.fsm.transition((Object)message, this.bridged);
                break;
            }
            case FAILED: {
                if (!this.is(this.initializingBridge)) break;
                this.fsm.transition((Object)message, this.hangingUp);
            }
        }
    }

    private void onGetRelatedCall(GetRelatedCall message, ActorRef self, ActorRef sender) {
        ActorRef callActor = message.call();
        if (this.is(this.forking)) {
            sender.tell(this.dialBranches, self);
            return;
        }
        if (this.outboundCall != null) {
            if (callActor.equals((Object)this.outboundCall)) {
                sender.tell((Object)this.call, self);
            } else if (callActor.equals((Object)this.call)) {
                sender.tell((Object)this.outboundCall, self);
            }
        } else {
            sender.tell((Object)new org.restcomm.connect.telephony.api.NotFound(), sender);
        }
    }

    private void conferenceStateModeratorPresent(Object message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("VoiceInterpreter#conferenceStateModeratorPresent will unmute the call: " + this.call.path().toString() + ", direction: " + this.callInfo.direction());
        }
        this.call.tell((Object)new Unmute(), this.self());
        if (this.confSubVoiceInterpreter != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("VoiceInterpreter stopping confSubVoiceInterpreter");
            }
            StopInterpreter stop = new StopInterpreter();
            this.confSubVoiceInterpreter.tell((Object)stop, this.self());
        }
    }

    @Override
    List<NameValuePair> parameters() {
        ArrayList<NameValuePair> parameters = new ArrayList<NameValuePair>();
        String callSid = this.callInfo.sid().toString();
        parameters.add((NameValuePair)new BasicNameValuePair("CallSid", callSid));
        parameters.add((NameValuePair)new BasicNameValuePair("InstanceId", RestcommConfiguration.getInstance().getMain().getInstanceId()));
        if (this.outboundCallInfo != null) {
            String outboundCallSid = this.outboundCallInfo.sid().toString();
            parameters.add((NameValuePair)new BasicNameValuePair("OutboundCallSid", outboundCallSid));
        }
        String accountSid = this.accountId.toString();
        parameters.add((NameValuePair)new BasicNameValuePair("AccountSid", accountSid));
        String from = this.e164(this.callInfo.from());
        parameters.add((NameValuePair)new BasicNameValuePair("From", from));
        String to = this.e164(this.callInfo.to());
        parameters.add((NameValuePair)new BasicNameValuePair("To", to));
        String state = this.callState.toString();
        parameters.add((NameValuePair)new BasicNameValuePair("CallStatus", state));
        parameters.add((NameValuePair)new BasicNameValuePair("ApiVersion", this.version));
        String direction = this.callInfo.direction();
        parameters.add((NameValuePair)new BasicNameValuePair("Direction", direction));
        String callerName = this.callInfo.fromName() == null || this.callInfo.fromName().isEmpty() ? "null" : this.callInfo.fromName();
        parameters.add((NameValuePair)new BasicNameValuePair("CallerName", callerName));
        String forwardedFrom = this.callInfo.forwardedFrom() == null || this.callInfo.forwardedFrom().isEmpty() ? "null" : this.callInfo.forwardedFrom();
        parameters.add((NameValuePair)new BasicNameValuePair("ForwardedFrom", forwardedFrom));
        parameters.add((NameValuePair)new BasicNameValuePair("CallTimestamp", this.callInfo.dateCreated().toString()));
        SipServletResponse lastResponse = this.callInfo.lastResponse();
        if (CreateCall.Type.SIP == this.callInfo.type() && lastResponse != null) {
            int statusCode = lastResponse.getStatus();
            String method = lastResponse.getMethod();
            if (statusCode >= 400 && "INVITE".equalsIgnoreCase(method) || statusCode >= 200 && statusCode < 300 && "BYE".equalsIgnoreCase(method)) {
                String sipCallId = lastResponse.getCallId();
                parameters.add((NameValuePair)new BasicNameValuePair("DialSipCallId", sipCallId));
                parameters.add((NameValuePair)new BasicNameValuePair("DialSipResponseCode", "" + statusCode));
                this.processCustomAndDiversionHeaders((SipServletMessage)lastResponse, "DialSipHeader_", parameters);
            }
        }
        if (lastResponse == null) {
            SipServletRequest invite = this.callInfo.invite();
            if (invite != null) {
                this.processCustomAndDiversionHeaders((SipServletMessage)invite, "SipHeader_", parameters);
            }
        } else {
            this.processCustomAndDiversionHeaders((SipServletMessage)lastResponse, "SipHeader_", parameters);
        }
        return parameters;
    }

    private void processCustomAndDiversionHeaders(SipServletMessage sipMessage, String prefix, List<NameValuePair> parameters) {
        Iterator headerNames = sipMessage.getHeaderNames();
        block2: while (headerNames.hasNext()) {
            String headerName = (String)headerNames.next();
            if (headerName.startsWith("X-")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("%%%%%%%%%%% Identified customer header: " + headerName);
                }
                parameters.add((NameValuePair)new BasicNameValuePair(prefix + headerName, sipMessage.getHeader(headerName)));
                continue;
            }
            if (!headerName.startsWith("Diversion")) continue;
            String sipDiversionHeader = sipMessage.getHeader(headerName);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("%%%%%%%%%%% Identified diversion header: " + sipDiversionHeader);
            }
            parameters.add((NameValuePair)new BasicNameValuePair(prefix + headerName, sipDiversionHeader));
            try {
                String forwardedFrom = sipDiversionHeader.substring(sipDiversionHeader.indexOf("sip:") + 4, sipDiversionHeader.indexOf("@"));
                for (int i = 0; i < parameters.size(); ++i) {
                    if (!parameters.get(i).getName().equals("ForwardedFrom")) continue;
                    if (!parameters.get(i).getValue().equals("null")) continue block2;
                    parameters.remove(i);
                    parameters.add((NameValuePair)new BasicNameValuePair("ForwardedFrom", forwardedFrom));
                    continue block2;
                }
            }
            catch (Exception e) {
                this.logger.warning("Error parsing SIP Diversion header" + e.getMessage());
            }
        }
    }

    private void createInitialCallRecord(CallResponse<CallInfo> message) {
        CallDetailRecordsDao records = this.storage.getCallDetailRecordsDao();
        CallResponse<CallInfo> response = message;
        this.callInfo = (CallInfo)response.get();
        this.callState = this.callInfo.state();
        if (this.callInfo.direction().equals("inbound")) {
            this.callRecord = records.getCallDetailRecord(this.callInfo.sid());
            if (this.callRecord == null) {
                CallDetailRecord.Builder builder = CallDetailRecord.builder();
                builder.setSid(this.callInfo.sid());
                builder.setInstanceId(RestcommConfiguration.getInstance().getMain().getInstanceId());
                builder.setDateCreated(this.callInfo.dateCreated());
                builder.setAccountSid(this.accountId);
                builder.setTo(this.callInfo.to());
                if (this.callInfo.fromName() != null) {
                    builder.setCallerName(this.callInfo.fromName());
                } else {
                    builder.setCallerName("Unknown");
                }
                if (this.callInfo.from() != null) {
                    builder.setFrom(this.callInfo.from());
                } else {
                    builder.setFrom("Unknown");
                }
                builder.setForwardedFrom(this.callInfo.forwardedFrom());
                builder.setPhoneNumberSid(this.phoneId);
                builder.setStatus(this.callState.toString());
                DateTime now = DateTime.now();
                builder.setStartTime(now);
                builder.setDirection(this.callInfo.direction());
                builder.setApiVersion(this.version);
                builder.setPrice(new BigDecimal("0.00"));
                builder.setMuted(Boolean.valueOf(false));
                builder.setOnHold(Boolean.valueOf(false));
                builder.setPriceUnit(Currency.getInstance("USD"));
                StringBuilder buffer = new StringBuilder();
                buffer.append("/").append(this.version).append("/Accounts/");
                buffer.append(this.accountId.toString()).append("/Calls/");
                buffer.append(this.callInfo.sid().toString());
                URI uri = URI.create(buffer.toString());
                builder.setUri(uri);
                builder.setCallPath(this.call.path().toString());
                this.callRecord = builder.build();
                records.addCallDetailRecord(this.callRecord);
            }
            this.callback();
        }
    }

    private void record(ActorRef target) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Start recording of the call: " + target.path() + ", VI state: " + this.fsm.state());
        }
        Configuration runtimeSettings = this.configuration.subset("runtime-settings");
        this.recordingSid = Sid.generate((Sid.Type)Sid.Type.RECORDING);
        String path = runtimeSettings.getString("recordings-path");
        String httpRecordingUri = runtimeSettings.getString("recordings-uri");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (!httpRecordingUri.endsWith("/")) {
            httpRecordingUri = httpRecordingUri + "/";
        }
        path = path + this.recordingSid.toString() + ".wav";
        httpRecordingUri = httpRecordingUri + this.recordingSid.toString() + ".wav";
        this.recordingUri = URI.create(path);
        try {
            this.publicRecordingUri = UriUtils.resolve((URI)new URI(httpRecordingUri));
        }
        catch (URISyntaxException e) {
            this.logger.error("URISyntaxException when trying to resolve Recording URI: " + e);
        }
        this.recordingCall = true;
        StartRecording message = new StartRecording(this.accountId, this.callInfo.sid(), runtimeSettings, this.storage, this.recordingSid, this.recordingUri);
        target.tell((Object)message, null);
    }

    private void recordConference() {
        this.logger.info("Start recording of the conference");
        this.record(this.conference);
    }

    private void executeDialAction(Object message, ActorRef outboundCall) {
        if (!this.dialActionExecuted && this.verb != null && "Dial".equals(this.verb.name())) {
            String dialCallSid;
            CallResponse callResponse;
            Future future;
            Timeout expires;
            Attribute attribute;
            List<NameValuePair> parameters;
            block39: {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Proceeding to execute Dial Action attribute");
                }
                this.dialActionExecuted = true;
                parameters = this.parameters();
                attribute = this.verb.attribute("action");
                if (this.call != null) {
                    try {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Trying to get inbound call Info");
                        }
                        expires = new Timeout(Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
                        future = Patterns.ask((ActorRef)this.call, (Object)new GetCallInfo(), (Timeout)expires);
                        callResponse = (CallResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
                        this.callInfo = (CallInfo)callResponse.get();
                    }
                    catch (Exception e) {
                        if (!this.logger.isDebugEnabled()) break block39;
                        this.logger.debug("Timeout waiting for inbound call info: \n" + e.getMessage());
                    }
                }
            }
            if (outboundCall != null) {
                try {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Trying to get outboundCall Info");
                    }
                    expires = new Timeout(Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
                    future = Patterns.ask((ActorRef)outboundCall, (Object)new GetCallInfo(), (Timeout)expires);
                    callResponse = (CallResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
                    this.outboundCallInfo = (CallInfo)callResponse.get();
                    long dialRingDuration = new Interval((ReadableInstant)this.outboundCallInfo.dateCreated(), (ReadableInstant)this.outboundCallInfo.dateConUpdated()).toDuration().getStandardSeconds();
                    parameters.add((NameValuePair)new BasicNameValuePair("DialRingDuration", String.valueOf(dialRingDuration)));
                }
                catch (Exception e) {
                    this.logger.error("Timeout waiting for outbound call info: \n" + e);
                }
            }
            if (message instanceof CallManagerResponse && !((CallManagerResponse)message).succeeded()) {
                if (this.outboundCallInfo != null) {
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallSid", this.outboundCallInfo.sid() == null ? "null" : this.outboundCallInfo.sid().toString()));
                } else {
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallSid", "null"));
                }
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", CallStateChanged.State.FAILED.toString()));
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallDuration", "0"));
                parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", null));
                parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", null));
            } else if (message instanceof ReceiveTimeout) {
                if (this.outboundCallInfo != null) {
                    dialCallSid = this.outboundCallInfo.sid().toString();
                    long dialCallDuration = this.outboundCallInfo.state().toString().equalsIgnoreCase("Completed") ? new Interval((ReadableInstant)this.outboundCallInfo.dateConUpdated(), (ReadableInstant)DateTime.now()).toDuration().getStandardSeconds() : 0L;
                    String recordingUrl = this.recordingUri == null ? null : this.recordingUri.toString();
                    String publicRecordingUrl = this.publicRecordingUri == null ? null : this.publicRecordingUri.toString();
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallSid", dialCallSid));
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", this.outboundCallInfo.state().toString()));
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallDuration", String.valueOf(dialCallDuration)));
                    parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", recordingUrl));
                    parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", publicRecordingUrl));
                } else {
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallSid", "null"));
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", CallStateChanged.State.NO_ANSWER.toString()));
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallDuration", "0"));
                    parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", null));
                    parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", null));
                }
            } else if (this.outboundCallInfo != null) {
                dialCallSid = this.outboundCallInfo.sid().toString();
                CallStateChanged.State dialCallStatus = this.outboundCallInfo.state();
                long dialCallDuration = 0L;
                try {
                    dialCallDuration = new Interval((ReadableInstant)this.outboundCallInfo.dateConUpdated(), (ReadableInstant)DateTime.now()).toDuration().getStandardSeconds();
                }
                catch (Exception e) {
                    // empty catch block
                }
                String recordingUrl = this.recordingUri == null ? null : this.recordingUri.toString();
                String publicRecordingUrl = this.publicRecordingUri == null ? null : this.publicRecordingUri.toString();
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallSid", dialCallSid));
                if (this.callInfo.state().equals((Object)CallStateChanged.State.COMPLETED)) {
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", this.callInfo.state().toString()));
                } else {
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", dialCallStatus == null ? null : dialCallStatus.toString()));
                }
                if (this.callState == CallStateChanged.State.BUSY) {
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallDuration", "0"));
                } else {
                    parameters.add((NameValuePair)new BasicNameValuePair("DialCallDuration", String.valueOf(dialCallDuration)));
                }
                parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", recordingUrl));
                parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", publicRecordingUrl));
            } else {
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallSid", "null"));
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallStatus", "null"));
                parameters.add((NameValuePair)new BasicNameValuePair("DialCallDuration", "0"));
                parameters.add((NameValuePair)new BasicNameValuePair("RecordingUrl", null));
                parameters.add((NameValuePair)new BasicNameValuePair("PublicRecordingUrl", "null"));
            }
            NotificationsDao notifications = this.storage.getNotificationsDao();
            if (attribute != null) {
                String action;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Executing Dial Action attribute.");
                }
                if ((action = attribute.value()) != null && !action.isEmpty()) {
                    URI target = null;
                    try {
                        target = URI.create(action);
                    }
                    catch (Exception exception) {
                        Notification notification = this.notification(0, 11100, action + " is an invalid URI.");
                        notifications.addNotification(notification);
                        this.sendMail(notification);
                        StopInterpreter stop = new StopInterpreter();
                        this.self().tell((Object)stop, this.self());
                        return;
                    }
                    URI base = this.request.getUri();
                    URI uri = UriUtils.resolve((URI)base, (URI)target);
                    String method = "POST";
                    attribute = this.verb.attribute("method");
                    if (attribute != null) {
                        method = attribute.value();
                        if (method != null && !method.isEmpty()) {
                            if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                                Notification notification = this.notification(1, 13210, method + " is not a valid HTTP method for <Dial>");
                                notifications.addNotification(notification);
                                method = "POST";
                            }
                        } else {
                            method = "POST";
                        }
                    }
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Dial Action URL: " + uri.toString() + " Method: " + method);
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Dial Action parameters: \n" + parameters);
                    }
                    this.request = new HttpRequestDescriptor(uri, method, parameters);
                    this.downloader.tell((Object)this.request, this.self());
                    return;
                }
            }
        } else if (this.verb == null && this.logger.isInfoEnabled()) {
            this.logger.info("Dial action didn't executed because verb is null");
        }
    }

    protected void playBeepOnEnter(ActorRef source) {
        String path = this.configuration.subset("runtime-settings").getString("prompts-uri");
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        String entryAudio = this.configuration.subset("runtime-settings").getString("conference-entry-audio");
        path = path + (entryAudio == null || entryAudio.equals("") ? "beep.wav" : entryAudio);
        URI uri = null;
        try {
            uri = UriUtils.resolve((URI)new URI(path));
        }
        catch (Exception exception) {
            Notification notification = this.notification(0, 12400, exception.getMessage());
            NotificationsDao notifications = this.storage.getNotificationsDao();
            notifications.addNotification(notification);
            this.sendMail(notification);
            StopInterpreter stop = new StopInterpreter();
            source.tell((Object)stop, source);
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Will ask conference: " + this.conferenceInfo.name() + " ,to play beep: " + uri);
        }
        Play play = new Play(uri, 1);
        this.conference.tell((Object)play, source);
    }

    protected void playWaitUrl(List<URI> waitUrls, ActorRef source) {
        this.conference.tell((Object)new Play(waitUrls, Short.MAX_VALUE, this.confModeratorPresent), source);
    }

    protected void playWaitUrl(URI waitUrl, ActorRef source) {
        this.conference.tell((Object)new Play(waitUrl, Short.MAX_VALUE, this.confModeratorPresent), source);
    }

    public void postStop() {
        if (!this.fsm.state().equals((Object)this.uninitialized)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("VoiceIntepreter: " + this.self().path() + "At the postStop() method. Will clean up Voice Interpreter. Keep calls: " + this.liveCallModification);
            }
            if (this.fsm.state().equals((Object)this.bridged) && this.outboundCall != null && !this.liveCallModification) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("At postStop(), will clean up outbound call");
                }
                this.outboundCall.tell((Object)new Hangup(), null);
                this.callManager.tell((Object)new DestroyCall(this.outboundCall), null);
                this.outboundCall = null;
            }
            if (this.call != null && !this.liveCallModification) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("At postStop(), will clean up call");
                }
                this.callManager.tell((Object)new DestroyCall(this.call), null);
                this.call = null;
            }
            this.getContext().stop(this.self());
            this.postCleanup();
        }
        super.postStop();
    }

    private final class Bridging
    extends AbstractAction {
        public Bridging(ActorRef source) {
            super(source);
        }

        private ActorRef buildSubVoiceInterpreter(Tag child) throws MalformedURLException, URISyntaxException {
            URI url = null;
            if (VoiceInterpreter.this.request != null) {
                URI base = VoiceInterpreter.this.request.getUri();
                url = UriUtils.resolve((URI)base, (URI)new URI(child.attribute("url").value()));
            } else {
                url = UriUtils.resolve((URI)new URI(child.attribute("url").value()));
            }
            String method = child.hasAttribute("method") ? child.attribute("method").value().toUpperCase() : "POST";
            SubVoiceInterpreterBuilder builder = new SubVoiceInterpreterBuilder(VoiceInterpreter.this.getContext().system());
            builder.setConfiguration(VoiceInterpreter.this.configuration);
            builder.setStorage(VoiceInterpreter.this.storage);
            builder.setCallManager(this.source);
            builder.setSmsService(VoiceInterpreter.this.smsService);
            builder.setAccount(VoiceInterpreter.this.accountId);
            builder.setVersion(VoiceInterpreter.this.version);
            builder.setUrl(url);
            builder.setMethod(method);
            return builder.build();
        }

        public void execute(Object message) throws Exception {
            Tag child;
            if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                VoiceInterpreter.this.logger.info("Joining call from:" + VoiceInterpreter.this.callInfo.from() + " to: " + VoiceInterpreter.this.callInfo.to() + " with outboundCall from: " + VoiceInterpreter.this.outboundCallInfo.from() + " to: " + VoiceInterpreter.this.outboundCallInfo.to());
            }
            if ((child = (Tag)VoiceInterpreter.this.dialChildrenWithAttributes.get(VoiceInterpreter.this.outboundCall)) != null && child.attribute("url") != null) {
                ActorRef interpreter = this.buildSubVoiceInterpreter(child);
                StartInterpreter start = new StartInterpreter(VoiceInterpreter.this.outboundCall);
                try {
                    Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
                    Future future = Patterns.ask((ActorRef)interpreter, (Object)start, (Timeout)expires);
                    Object object = Await.result((Awaitable)future, (Duration)Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
                    if (!End.class.equals(object.getClass())) {
                        VoiceInterpreter.this.fsm.transition(message, VoiceInterpreter.this.hangingUp);
                        return;
                    }
                }
                catch (Exception e) {
                    if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                        VoiceInterpreter.this.logger.info("Exception while trying to execute call screening: " + e);
                    }
                    VoiceInterpreter.this.fsm.transition(message, VoiceInterpreter.this.hangingUp);
                    return;
                }
                VoiceInterpreter.this.outboundCall.tell((Object)new StopObserving(interpreter), null);
                VoiceInterpreter.this.getContext().stop(interpreter);
            }
            StopMediaGroup stop = new StopMediaGroup();
            VoiceInterpreter.this.call.tell((Object)stop, this.source);
        }
    }

    private final class InitializingBridge
    extends AbstractAction {
        public InitializingBridge(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Observe observe = new Observe(this.source);
            VoiceInterpreter.this.bridge.tell((Object)observe, this.source);
            StartBridge start = new StartBridge();
            VoiceInterpreter.this.bridge.tell((Object)start, this.source);
        }
    }

    private final class CreatingBridge
    extends AbstractAction {
        public CreatingBridge(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            CreateBridge create = new CreateBridge();
            VoiceInterpreter.this.bridgeManager.tell((Object)create, this.source);
        }
    }

    private final class Finished
    extends AbstractAction {
        public Finished(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                VoiceInterpreter.this.logger.info("At Finished state, state: " + VoiceInterpreter.this.fsm.state() + ", liveCallModification: " + VoiceInterpreter.this.liveCallModification);
            }
            Class<?> klass = message.getClass();
            if (VoiceInterpreter.this.callRecord != null) {
                CallDetailRecordsDao records = VoiceInterpreter.this.storage.getCallDetailRecordsDao();
                VoiceInterpreter.this.callRecord = records.getCallDetailRecord(VoiceInterpreter.this.callRecord.getSid());
                VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setStatus(VoiceInterpreter.this.callState.toString());
                DateTime end = DateTime.now();
                VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setEndTime(end);
                int seconds = (int)(end.getMillis() - VoiceInterpreter.this.callRecord.getStartTime().getMillis()) / 1000;
                VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setDuration(Integer.valueOf(seconds));
                records.updateCallDetailRecord(VoiceInterpreter.this.callRecord);
            }
            if (!VoiceInterpreter.this.dialActionExecuted) {
                VoiceInterpreter.this.executeDialAction(message, VoiceInterpreter.this.outboundCall);
                VoiceInterpreter.this.callback(true);
            }
            if (VoiceInterpreter.this.bridge != null) {
                VoiceInterpreter.this.bridge.tell((Object)new StopBridge(VoiceInterpreter.this.liveCallModification), this.source);
                VoiceInterpreter.this.recordingCall = false;
                VoiceInterpreter.this.bridge = null;
            }
            if (VoiceInterpreter.this.outboundCall != null && !VoiceInterpreter.this.liveCallModification) {
                VoiceInterpreter.this.outboundCall.tell((Object)new StopObserving(this.source), null);
                VoiceInterpreter.this.outboundCall.tell((Object)new Hangup(), null);
                VoiceInterpreter.this.callManager.tell((Object)new DestroyCall(VoiceInterpreter.this.outboundCall), null);
            }
            if (!VoiceInterpreter.this.liveCallModification) {
                if (VoiceInterpreter.this.call != null && !VoiceInterpreter.this.call.isTerminated()) {
                    VoiceInterpreter.this.call.tell((Object)new Hangup(), VoiceInterpreter.this.self());
                }
                if (VoiceInterpreter.this.outboundCall != null && !VoiceInterpreter.this.outboundCall.isTerminated()) {
                    VoiceInterpreter.this.outboundCall.tell((Object)new Hangup(), VoiceInterpreter.this.self());
                }
                VoiceInterpreter.this.callManager.tell((Object)new DestroyCall(VoiceInterpreter.this.call), this.source);
                if (VoiceInterpreter.this.outboundCall != null) {
                    VoiceInterpreter.this.callManager.tell((Object)new DestroyCall(VoiceInterpreter.this.outboundCall), this.source);
                }
                if (VoiceInterpreter.this.sender != VoiceInterpreter.this.call) {
                    VoiceInterpreter.this.callManager.tell((Object)new DestroyCall(VoiceInterpreter.this.sender), this.source);
                }
            } else {
                VoiceInterpreter.this.call.tell((Object)new StopMediaGroup(true), this.source);
            }
            UntypedActorContext context = VoiceInterpreter.this.getContext();
            if (VoiceInterpreter.this.mailerNotify != null) {
                context.stop(VoiceInterpreter.this.mailerNotify);
            }
            if (VoiceInterpreter.this.mailerService != null) {
                context.stop(VoiceInterpreter.this.mailerService);
            }
            context.stop(VoiceInterpreter.this.getAsrService());
            context.stop(VoiceInterpreter.this.getFaxService());
            context.stop(VoiceInterpreter.this.getCache());
            context.stop(VoiceInterpreter.this.getSynthesizer());
            VoiceInterpreter.this.postCleanup();
        }
    }

    private final class FinishConferencing
    extends AbstractDialAction {
        public FinishConferencing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String action;
            ConferenceStateChanged confStateChanged;
            if (message instanceof ReceiveTimeout) {
                if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                    VoiceInterpreter.this.logger.info("At FinishConferencing received timeout, VI path: " + VoiceInterpreter.this.self().path() + ", call path: " + VoiceInterpreter.this.call.path());
                }
                UntypedActorContext context = VoiceInterpreter.this.getContext();
                context.setReceiveTimeout((Duration)Duration.Undefined());
                RemoveParticipant remove = new RemoveParticipant(VoiceInterpreter.this.call);
                VoiceInterpreter.this.conference.tell((Object)remove, this.source);
            }
            if (message instanceof ConferenceStateChanged && ConferenceStateChanged.State.COMPLETED.equals((Object)(confStateChanged = (ConferenceStateChanged)message).state())) {
                DestroyConference destroyConference = new DestroyConference(VoiceInterpreter.this.conferenceInfo.name());
                VoiceInterpreter.this.conferenceManager.tell((Object)destroyConference, this.source);
            }
            VoiceInterpreter.this.conference = null;
            NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
            Attribute attribute = VoiceInterpreter.this.conferenceVerb.attribute("action");
            if (attribute != null && (action = attribute.value()) != null && !action.isEmpty()) {
                URI target = null;
                try {
                    target = URI.create(action);
                }
                catch (Exception exception) {
                    Notification notification = VoiceInterpreter.this.notification(0, 11100, action + " is an invalid URI.");
                    notifications.addNotification(notification);
                    VoiceInterpreter.this.sendMail(notification);
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                URI base = VoiceInterpreter.this.request.getUri();
                URI uri = UriUtils.resolve((URI)base, (URI)target);
                String method = "POST";
                attribute = VoiceInterpreter.this.conferenceVerb.attribute("method");
                if (attribute != null) {
                    method = attribute.value();
                    if (method != null && !method.isEmpty()) {
                        if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                            Notification notification = VoiceInterpreter.this.notification(1, 13210, method + " is not a valid HTTP method for <Dial>");
                            notifications.addNotification(notification);
                            method = "POST";
                        }
                    } else {
                        method = "POST";
                    }
                }
                List<NameValuePair> parameters = VoiceInterpreter.this.parameters();
                VoiceInterpreter.this.request = new HttpRequestDescriptor(uri, method, parameters);
                VoiceInterpreter.this.downloader.tell((Object)VoiceInterpreter.this.request, this.source);
                return;
            }
            GetNextVerb next = GetNextVerb.instance();
            VoiceInterpreter.this.parser.tell((Object)next, this.source);
        }
    }

    private final class Conferencing
    extends AbstractDialAction {
        public Conferencing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Attribute attribute;
            boolean onHoldInCDR = false;
            boolean onMuteInCDR = VoiceInterpreter.this.muteCall;
            if (message instanceof List) {
                List waitUrls = (List)message;
                VoiceInterpreter.this.playWaitUrl(waitUrls, VoiceInterpreter.this.self());
                VoiceInterpreter.this.playWaitUrlPending = false;
                return;
            }
            NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
            Tag child = this.conference(VoiceInterpreter.this.verb);
            VoiceInterpreter.this.conferenceVerb = VoiceInterpreter.this.verb;
            if (VoiceInterpreter.this.muteCall) {
                Mute mute = new Mute();
                VoiceInterpreter.this.call.tell((Object)mute, this.source);
            }
            if ((attribute = child.attribute("startConferenceOnEnter")) != null) {
                String value = attribute.value();
                if (value != null && !value.isEmpty()) {
                    VoiceInterpreter.this.startConferenceOnEnter = Boolean.parseBoolean(value);
                }
            } else {
                VoiceInterpreter.this.startConferenceOnEnter = true;
            }
            VoiceInterpreter.this.confModeratorPresent = VoiceInterpreter.this.startConferenceOnEnter;
            if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                VoiceInterpreter.this.logger.info("At conferencing, VI state: " + VoiceInterpreter.this.fsm.state() + " , playMusicForConference: " + VoiceInterpreter.this.playMusicForConference + " ConferenceState: " + VoiceInterpreter.this.conferenceState.name() + " startConferenceOnEnter: " + VoiceInterpreter.this.startConferenceOnEnter + "  conferenceInfo.globalParticipants(): " + VoiceInterpreter.this.conferenceInfo.globalParticipants());
            }
            if (VoiceInterpreter.this.playMusicForConference) {
                if (VoiceInterpreter.this.conferenceInfo.globalParticipants() == 1) {
                    VoiceInterpreter.this.startConferenceOnEnter = false;
                } else if (VoiceInterpreter.this.conferenceInfo.globalParticipants() > 1) {
                    if (VoiceInterpreter.this.startConferenceOnEnter || VoiceInterpreter.this.conferenceInfo.isModeratorPresent()) {
                        VoiceInterpreter.this.startConferenceOnEnter = true;
                    } else {
                        VoiceInterpreter.this.startConferenceOnEnter = false;
                    }
                }
            }
            if (!VoiceInterpreter.this.startConferenceOnEnter && VoiceInterpreter.this.conferenceState == ConferenceStateChanged.State.RUNNING_MODERATOR_ABSENT) {
                boolean playBackground;
                if (!VoiceInterpreter.this.muteCall) {
                    Mute mute = new Mute();
                    if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                        VoiceInterpreter.this.logger.info("Muting the call as startConferenceOnEnter =" + VoiceInterpreter.this.startConferenceOnEnter + " , callMuted = " + VoiceInterpreter.this.muteCall);
                    }
                    VoiceInterpreter.this.call.tell((Object)mute, this.source);
                    onMuteInCDR = true;
                }
                if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                    VoiceInterpreter.this.logger.info("Play background music? " + (VoiceInterpreter.this.conferenceInfo.globalParticipants() == 1));
                }
                boolean bl = playBackground = VoiceInterpreter.this.conferenceInfo.globalParticipants() == 1;
                if (playBackground) {
                    Notification notification;
                    String value;
                    URI waitUrl = new URI("/restcomm/music/electronica/teru_-_110_Downtempo_Electronic_4.wav");
                    attribute = child.attribute("waitUrl");
                    if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                        try {
                            waitUrl = URI.create(value);
                        }
                        catch (Exception exception) {
                            notification = VoiceInterpreter.this.notification(0, 13233, VoiceInterpreter.this.method + " is not a valid waitUrl value for <Conference>");
                            notifications.addNotification(notification);
                            VoiceInterpreter.this.sendMail(notification);
                            StopInterpreter stop = new StopInterpreter();
                            this.source.tell((Object)stop, this.source);
                        }
                    }
                    URI base = VoiceInterpreter.this.request.getUri();
                    waitUrl = UriUtils.resolve((URI)base, (URI)waitUrl);
                    String method = "POST";
                    attribute = child.attribute("waitMethod");
                    if (attribute != null) {
                        method = attribute.value();
                        if (method != null && !method.isEmpty()) {
                            if (!"GET".equalsIgnoreCase(method) && !"POST".equalsIgnoreCase(method)) {
                                notification = VoiceInterpreter.this.notification(1, 13234, method + " is not a valid waitMethod value for <Conference>");
                                notifications.addNotification(notification);
                                method = "POST";
                            }
                        } else {
                            method = "POST";
                        }
                    }
                    if (!waitUrl.getPath().toLowerCase().endsWith("wav")) {
                        if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                            VoiceInterpreter.this.logger.info("WaitUrl for Conference will use RCML from URI: " + waitUrl.toString());
                        }
                        List<NameValuePair> parameters = VoiceInterpreter.this.parameters();
                        VoiceInterpreter.this.request = new HttpRequestDescriptor(waitUrl, method, parameters);
                        VoiceInterpreter.this.downloader.tell((Object)VoiceInterpreter.this.request, VoiceInterpreter.this.self());
                        VoiceInterpreter.this.playWaitUrlPending = true;
                        return;
                    }
                    if (waitUrl != null && !VoiceInterpreter.this.playWaitUrlPending) {
                        onHoldInCDR = true;
                        VoiceInterpreter.this.playWaitUrl(waitUrl, this.source);
                    }
                }
            } else if (VoiceInterpreter.this.conferenceState == ConferenceStateChanged.State.RUNNING_MODERATOR_ABSENT) {
                VoiceInterpreter.this.conference.tell((Object)new ConferenceModeratorPresent(), this.source);
                if (VoiceInterpreter.this.beep) {
                    VoiceInterpreter.this.playBeepOnEnter(this.source);
                } else if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                    VoiceInterpreter.this.logger.info("Wont play beep bcz: beep=" + VoiceInterpreter.this.beep + " AND conferenceInfo.state()=" + VoiceInterpreter.this.conferenceInfo.state());
                }
                Attribute record = VoiceInterpreter.this.verb.attribute("record");
                if (record != null && "true".equalsIgnoreCase(record.value())) {
                    VoiceInterpreter.this.recordConference();
                }
            }
            if (VoiceInterpreter.this.callRecord != null) {
                VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setOnHold(Boolean.valueOf(onHoldInCDR));
                VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setMuted(Boolean.valueOf(onMuteInCDR));
                CallDetailRecordsDao callRecords = VoiceInterpreter.this.storage.getCallDetailRecordsDao();
                callRecords.updateCallDetailRecord(VoiceInterpreter.this.callRecord);
            }
            int timeLimit = this.timeLimit(VoiceInterpreter.this.verb);
            UntypedActorContext context = VoiceInterpreter.this.getContext();
            context.setReceiveTimeout((Duration)Duration.create((long)timeLimit, (TimeUnit)TimeUnit.SECONDS));
        }
    }

    private final class JoiningConference
    extends AbstractDialAction {
        public JoiningConference(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String value;
            VoiceInterpreter.this.conferenceState = VoiceInterpreter.this.conferenceInfo.state();
            VoiceInterpreter.this.conferenceSid = VoiceInterpreter.this.conferenceInfo.sid();
            Tag child = this.conference(VoiceInterpreter.this.verb);
            Attribute attribute = child.attribute("maxParticipants");
            if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                try {
                    VoiceInterpreter.this.maxParticipantLimit = Integer.parseInt(value);
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            if (VoiceInterpreter.this.conferenceInfo.globalParticipants() < VoiceInterpreter.this.maxParticipantLimit) {
                VoiceInterpreter.this.beep = true;
                attribute = child.attribute("beep");
                if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                    VoiceInterpreter.this.beep = Boolean.parseBoolean(value);
                }
                if (VoiceInterpreter.this.beep && ConferenceStateChanged.State.RUNNING_MODERATOR_PRESENT.equals((Object)VoiceInterpreter.this.conferenceInfo.state())) {
                    VoiceInterpreter.this.playBeepOnEnter(this.source);
                } else if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                    VoiceInterpreter.this.logger.info("Wont play beep bcz: beep=" + VoiceInterpreter.this.beep + " AND conferenceInfo.state()=" + VoiceInterpreter.this.conferenceInfo.state());
                }
                if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                    VoiceInterpreter.this.logger.info("About to join call to Conference: " + VoiceInterpreter.this.conferenceInfo.name() + ", with state: " + VoiceInterpreter.this.conferenceInfo.state() + ", with moderator present: " + VoiceInterpreter.this.conferenceInfo.isModeratorPresent() + ", and current participants: " + VoiceInterpreter.this.conferenceInfo.globalParticipants());
                }
                this.addConferenceStuffInCDR(VoiceInterpreter.this.conferenceSid);
                AddParticipant request = new AddParticipant(VoiceInterpreter.this.call);
                VoiceInterpreter.this.conference.tell((Object)request, this.source);
            } else {
                GetNextVerb next = GetNextVerb.instance();
                VoiceInterpreter.this.parser.tell((Object)next, this.source);
            }
            attribute = child.attribute("muted");
            if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                VoiceInterpreter.this.muteCall = Boolean.parseBoolean(value);
            }
            if ((attribute = child.attribute("startConferenceOnEnter")) != null && (value = attribute.value()) != null && !value.isEmpty()) {
                VoiceInterpreter.this.startConferenceOnEnter = Boolean.parseBoolean(value);
            }
            if ((attribute = child.attribute("endConferenceOnExit")) != null && (value = attribute.value()) != null && !value.isEmpty()) {
                VoiceInterpreter.this.endConferenceOnExit = Boolean.parseBoolean(value);
            }
        }

        private void addConferenceStuffInCDR(Sid conferenceSid) {
            if (VoiceInterpreter.this.callRecord != null) {
                if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                    VoiceInterpreter.this.logger.info("Updating CDR for call: " + VoiceInterpreter.this.callInfo.sid() + ", call status: " + VoiceInterpreter.this.callInfo.state() + ", to include Conference details, conference: " + conferenceSid);
                }
                VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setConferenceSid(conferenceSid);
                VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setMuted(Boolean.valueOf(VoiceInterpreter.this.muteCall));
                VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setStartConferenceOnEnter(Boolean.valueOf(VoiceInterpreter.this.startConferenceOnEnter));
                VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setEndConferenceOnExit(Boolean.valueOf(VoiceInterpreter.this.endConferenceOnExit));
                CallDetailRecordsDao records = VoiceInterpreter.this.storage.getCallDetailRecordsDao();
                records.updateCallDetailRecord(VoiceInterpreter.this.callRecord);
            }
        }
    }

    private final class AcquiringConferenceInfo
    extends AbstractDialAction {
        public AcquiringConferenceInfo(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            ConferenceCenterResponse response = (ConferenceCenterResponse)message;
            VoiceInterpreter.this.conference = (ActorRef)response.get();
            VoiceInterpreter.this.conference.tell((Object)new Observe(this.source), this.source);
            VoiceInterpreter.this.conference.tell((Object)new GetConferenceInfo(), this.source);
        }
    }

    private final class FinishDialing
    extends AbstractDialAction {
        public FinishDialing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            State state = VoiceInterpreter.this.fsm.state();
            if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                VoiceInterpreter.this.logger.info("FinishDialing, current state: " + state);
            }
            if (message instanceof ReceiveTimeout) {
                if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                    VoiceInterpreter.this.logger.info("Received timeout, will cancel branches, current VoiceIntepreter state: " + state);
                }
                if (VoiceInterpreter.this.enable200OkDelay) {
                    VoiceInterpreter.this.outboundCallResponse = 408;
                }
                UntypedActorContext context = VoiceInterpreter.this.getContext();
                context.setReceiveTimeout((Duration)Duration.Undefined());
                if (VoiceInterpreter.this.dialBranches != null) {
                    for (ActorRef branch : VoiceInterpreter.this.dialBranches) {
                        branch.tell((Object)new Cancel(), this.source);
                        if (!VoiceInterpreter.this.logger.isInfoEnabled()) continue;
                        VoiceInterpreter.this.logger.info("Canceled branch: " + branch.path() + ", isTerminated: " + branch.isTerminated());
                    }
                } else if (VoiceInterpreter.this.outboundCall != null) {
                    VoiceInterpreter.this.outboundCall.tell((Object)new Cancel(), this.source);
                    VoiceInterpreter.this.call.tell((Object)new Hangup(VoiceInterpreter.this.outboundCallResponse), VoiceInterpreter.this.self());
                }
                VoiceInterpreter.this.dialChildren = null;
                VoiceInterpreter.this.callback();
                return;
            }
            if (message instanceof CallStateChanged) {
                if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                    VoiceInterpreter.this.logger.info("CallStateChanged state: " + ((CallStateChanged)message).state().toString() + " ,sender: " + VoiceInterpreter.this.sender().path());
                }
                if (VoiceInterpreter.this.forking.equals((Object)state) || VoiceInterpreter.this.finishDialing.equals((Object)state) || VoiceInterpreter.this.is(VoiceInterpreter.this.bridged) || VoiceInterpreter.this.is(VoiceInterpreter.this.bridging)) {
                    if (VoiceInterpreter.this.sender.equals((Object)VoiceInterpreter.this.call)) {
                        if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                            VoiceInterpreter.this.logger.info("Sender == call: " + VoiceInterpreter.this.sender.equals((Object)VoiceInterpreter.this.call));
                        }
                        UntypedActorContext context = VoiceInterpreter.this.getContext();
                        context.setReceiveTimeout((Duration)Duration.Undefined());
                        if (VoiceInterpreter.this.dialBranches != null) {
                            for (ActorRef branch : VoiceInterpreter.this.dialBranches) {
                                branch.tell((Object)new Cancel(), this.source);
                            }
                        } else if (VoiceInterpreter.this.outboundCall != null) {
                            VoiceInterpreter.this.outboundCall.tell((Object)new Cancel(), this.source);
                        }
                        VoiceInterpreter.this.dialChildren = null;
                        VoiceInterpreter.this.callback();
                        return;
                    }
                    if (VoiceInterpreter.this.dialBranches != null && VoiceInterpreter.this.dialBranches.contains(VoiceInterpreter.this.sender)) {
                        if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                            VoiceInterpreter.this.logger.info("At FinishDialing. Sender in the dialBranches, will remove and check next verb");
                        }
                        VoiceInterpreter.this.removeDialBranch(message, VoiceInterpreter.this.sender);
                        return;
                    }
                    Attribute attribute = null;
                    if (VoiceInterpreter.this.verb != null) {
                        attribute = VoiceInterpreter.this.verb.attribute("action");
                    }
                    if (attribute == null) {
                        if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                            VoiceInterpreter.this.logger.info("At FinishDialing. Sender NOT in the dialBranches, attribute is null, will check for the next verb");
                        }
                        GetNextVerb next = GetNextVerb.instance();
                        if (VoiceInterpreter.this.parser != null) {
                            VoiceInterpreter.this.parser.tell((Object)next, this.source);
                        }
                    } else {
                        if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                            VoiceInterpreter.this.logger.info("At FinishDialing. Sender NOT in the dialBranches, attribute is NOT null, will execute Dial Action");
                        }
                        VoiceInterpreter.this.executeDialAction(message, VoiceInterpreter.this.outboundCall);
                    }
                    VoiceInterpreter.this.dialChildren = null;
                    if (!VoiceInterpreter.this.sender().equals((Object)VoiceInterpreter.this.outboundCall)) {
                        VoiceInterpreter.this.callManager.tell((Object)new DestroyCall(VoiceInterpreter.this.sender), VoiceInterpreter.this.self());
                    }
                    return;
                }
            }
        }
    }

    private final class Bridged
    extends AbstractDialAction {
        public Bridged(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            int timeLimit = this.timeLimit(VoiceInterpreter.this.verb);
            UntypedActorContext context = VoiceInterpreter.this.getContext();
            context.setReceiveTimeout((Duration)Duration.create((long)timeLimit, (TimeUnit)TimeUnit.SECONDS));
            if (VoiceInterpreter.this.dialRecordAttribute != null && "true".equalsIgnoreCase(VoiceInterpreter.this.dialRecordAttribute.value())) {
                if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                    VoiceInterpreter.this.logger.info("Start recording of the bridge");
                }
                VoiceInterpreter.this.record(VoiceInterpreter.this.bridge);
            }
            if (VoiceInterpreter.this.enable200OkDelay && VoiceInterpreter.this.verb != null && "Dial".equals(VoiceInterpreter.this.verb.name())) {
                VoiceInterpreter.this.call.tell(message, VoiceInterpreter.this.self());
            }
        }
    }

    private final class AcquiringOutboundCallInfo
    extends AbstractDialAction {
        public AcquiringOutboundCallInfo(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (VoiceInterpreter.this.isForking) {
                VoiceInterpreter.this.dialBranches.remove(VoiceInterpreter.this.outboundCall);
                for (ActorRef branch : VoiceInterpreter.this.dialBranches) {
                    branch.tell((Object)new Cancel(), null);
                }
                VoiceInterpreter.this.dialBranches = null;
            }
            VoiceInterpreter.this.outboundCall.tell((Object)new GetCallInfo(), this.source);
        }
    }

    private final class Forking
    extends AbstractDialAction {
        public Forking(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (CallManagerResponse.class.equals(klass)) {
                CallManagerResponse response = (CallManagerResponse)message;
                VoiceInterpreter.this.outboundCall = (ActorRef)response.get();
                VoiceInterpreter.this.outboundCall.tell((Object)new Observe(this.source), this.source);
                if (VoiceInterpreter.this.monitoring != null) {
                    VoiceInterpreter.this.outboundCall.tell((Object)new Observe(VoiceInterpreter.this.monitoring), VoiceInterpreter.this.self());
                }
                VoiceInterpreter.this.outboundCall.tell((Object)new Dial(), this.source);
            } else if (Fork.class.equals(klass)) {
                Observe observe = new Observe(this.source);
                Dial dial = new Dial();
                for (ActorRef branch : VoiceInterpreter.this.dialBranches) {
                    branch.tell((Object)observe, this.source);
                    if (VoiceInterpreter.this.monitoring != null) {
                        branch.tell((Object)new Observe(VoiceInterpreter.this.monitoring), VoiceInterpreter.this.self());
                    }
                    branch.tell((Object)dial, this.source);
                }
            }
            String path = VoiceInterpreter.this.configuration.subset("runtime-settings").getString("prompts-uri");
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            path = path + "ringing.wav";
            URI uri = null;
            try {
                uri = UriUtils.resolve((URI)new URI(path));
            }
            catch (Exception exception) {
                Notification notification = VoiceInterpreter.this.notification(0, 12400, exception.getMessage());
                NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
                notifications.addNotification(notification);
                VoiceInterpreter.this.sendMail(notification);
                StopInterpreter stop = new StopInterpreter();
                this.source.tell((Object)stop, this.source);
                return;
            }
            Play play = new Play(uri, Short.MAX_VALUE);
            VoiceInterpreter.this.call.tell((Object)play, this.source);
            UntypedActorContext context = VoiceInterpreter.this.getContext();
            context.setReceiveTimeout((Duration)Duration.create((long)this.timeout(VoiceInterpreter.this.verb), (TimeUnit)TimeUnit.SECONDS));
        }
    }

    private final class ProcessingDialChildren
    extends AbstractDialAction {
        public ProcessingDialChildren(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (CallManagerResponse.class.equals(klass) && ((CallManagerResponse)message).succeeded()) {
                Tag child = (Tag)VoiceInterpreter.this.dialChildren.get(0);
                CallManagerResponse response = (CallManagerResponse)message;
                if (response.get() instanceof List) {
                    List calls = (List)response.get();
                    for (ActorRef branch : calls) {
                        VoiceInterpreter.this.dialBranches.add(branch);
                        if (!child.hasAttributes()) continue;
                        VoiceInterpreter.this.dialChildrenWithAttributes.put(branch, child);
                    }
                } else {
                    ActorRef branch = (ActorRef)response.get();
                    VoiceInterpreter.this.dialBranches.add(branch);
                    if (child.hasAttributes()) {
                        VoiceInterpreter.this.dialChildrenWithAttributes.put(branch, child);
                    }
                }
                VoiceInterpreter.this.dialChildren.remove(child);
            } else if (CallManagerResponse.class.equals(klass) && !((CallManagerResponse)message).succeeded()) {
                VoiceInterpreter.this.dialChildren.remove(0);
            }
            if (!VoiceInterpreter.this.dialChildren.isEmpty()) {
                CreateCall create = null;
                Tag child = (Tag)VoiceInterpreter.this.dialChildren.get(0);
                if ("Client".equals(child.name())) {
                    create = VoiceInterpreter.this.call != null && VoiceInterpreter.this.callInfo != null ? new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), null, null, VoiceInterpreter.this.callInfo.isFromApi(), this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.CLIENT, VoiceInterpreter.this.accountId, VoiceInterpreter.this.callInfo.sid()) : new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), null, null, false, this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.CLIENT, VoiceInterpreter.this.accountId, null);
                } else if ("Number".equals(child.name())) {
                    create = VoiceInterpreter.this.call != null && VoiceInterpreter.this.callInfo != null ? new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), null, null, VoiceInterpreter.this.callInfo.isFromApi(), this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.PSTN, VoiceInterpreter.this.accountId, VoiceInterpreter.this.callInfo.sid()) : new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), null, null, false, this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.PSTN, VoiceInterpreter.this.accountId, null);
                } else if ("Uri".equals(child.name())) {
                    create = VoiceInterpreter.this.call != null && VoiceInterpreter.this.callInfo != null ? new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), null, null, VoiceInterpreter.this.callInfo.isFromApi(), this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.SIP, VoiceInterpreter.this.accountId, VoiceInterpreter.this.callInfo.sid()) : new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), null, null, false, this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.SIP, VoiceInterpreter.this.accountId, null);
                } else if ("Sip".equals(child.name())) {
                    String username = null;
                    String password = null;
                    if (child.attribute("username") != null) {
                        username = child.attribute("username").value();
                    }
                    if (child.attribute("password") != null) {
                        password = child.attribute("password").value();
                    }
                    if ((username == null || username.isEmpty()) && VoiceInterpreter.this.storage.getClientsDao().getClient(VoiceInterpreter.this.callInfo.from()) != null) {
                        username = VoiceInterpreter.this.callInfo.from();
                        password = VoiceInterpreter.this.storage.getClientsDao().getClient(VoiceInterpreter.this.callInfo.from()).getPassword();
                    }
                    create = VoiceInterpreter.this.call != null && VoiceInterpreter.this.callInfo != null ? new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), username, password, false, this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.SIP, VoiceInterpreter.this.accountId, VoiceInterpreter.this.callInfo.sid()) : new CreateCall(VoiceInterpreter.this.e164(this.callerId(VoiceInterpreter.this.verb)), VoiceInterpreter.this.e164(child.text()), username, password, false, this.timeout(VoiceInterpreter.this.verb), CreateCall.Type.SIP, VoiceInterpreter.this.accountId, null);
                }
                VoiceInterpreter.this.callManager.tell(create, this.source);
            } else {
                Fork fork = Fork.instance();
                this.source.tell((Object)fork, this.source);
                VoiceInterpreter.this.dialChildren = null;
            }
        }
    }

    private final class StartDialing
    extends AbstractDialAction {
        public StartDialing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String text;
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                VoiceInterpreter.this.verb = (Tag)message;
            }
            if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                VoiceInterpreter.this.logger.info("At StartDialing state, preparing Dial for RCML: " + VoiceInterpreter.this.verb.toString().trim().replace("\\n", ""));
            }
            if ((text = VoiceInterpreter.this.verb.text()) != null && !text.isEmpty()) {
                Tag.Builder builder = Tag.builder();
                if (text.contains("@")) {
                    builder.setName("Sip");
                } else if (text.startsWith("client")) {
                    builder.setName("Client");
                } else {
                    builder.setName("Number");
                }
                builder.setText(text);
                Tag numberTag = builder.build();
                Tag.Builder tagBuilder = Tag.builder();
                tagBuilder.addChild(numberTag);
                tagBuilder.setIterable(VoiceInterpreter.this.verb.isIterable());
                tagBuilder.setName(VoiceInterpreter.this.verb.name());
                tagBuilder.setParent(VoiceInterpreter.this.verb.parent());
                for (Attribute attribute : VoiceInterpreter.this.verb.attributes()) {
                    if (attribute == null) continue;
                    tagBuilder.addAttribute(attribute);
                }
                VoiceInterpreter.this.verb = null;
                VoiceInterpreter.this.verb = tagBuilder.build();
            }
            if (VoiceInterpreter.this.verb.hasChildren()) {
                Tag child = this.conference(VoiceInterpreter.this.verb);
                if (child != null) {
                    String name = child.text();
                    StringBuilder buffer = new StringBuilder();
                    buffer.append(VoiceInterpreter.this.accountId.toString()).append(":").append(name);
                    Sid sid = null;
                    if (VoiceInterpreter.this.callInfo != null && VoiceInterpreter.this.callInfo.sid() != null) {
                        sid = VoiceInterpreter.this.callInfo.sid();
                    }
                    if (sid == null && VoiceInterpreter.this.callRecord != null) {
                        sid = VoiceInterpreter.this.callRecord.getSid();
                    }
                    CreateConference create = new CreateConference(buffer.toString(), sid);
                    VoiceInterpreter.this.conferenceManager.tell((Object)create, this.source);
                } else {
                    VoiceInterpreter.this.dialBranches = new ArrayList();
                    VoiceInterpreter.this.dialChildren = new ArrayList<Tag>(VoiceInterpreter.this.verb.children());
                    VoiceInterpreter.this.dialChildrenWithAttributes = new HashMap();
                    VoiceInterpreter.this.isForking = true;
                    StartForking start = StartForking.instance();
                    this.source.tell((Object)start, this.source);
                    if (VoiceInterpreter.this.logger.isInfoEnabled()) {
                        VoiceInterpreter.this.logger.info("Dial verb " + VoiceInterpreter.this.verb.toString().replace("\\n", "") + " with more that one element, will start forking. Dial Children size: " + VoiceInterpreter.this.dialChildren.size());
                    }
                }
            } else {
                GetNextVerb next = GetNextVerb.instance();
                VoiceInterpreter.this.parser.tell((Object)next, this.source);
            }
        }
    }

    private abstract class AbstractDialAction
    extends AbstractAction {
        public AbstractDialAction(ActorRef source) {
            super(source);
        }

        protected String callerId(Tag container) {
            String callerId = null;
            boolean useInitialFromAsCallerId = VoiceInterpreter.this.configuration.subset("runtime-settings").getBoolean("from-address-to-proxied-calls");
            Attribute attribute = VoiceInterpreter.this.verb.attribute("callerId");
            if (attribute != null && (callerId = attribute.value()) != null && !callerId.isEmpty() && (callerId = VoiceInterpreter.this.e164(callerId)) == null) {
                callerId = VoiceInterpreter.this.verb.attribute("callerId").value();
                NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
                Notification notification = VoiceInterpreter.this.notification(0, 13214, callerId + " is an invalid callerId.");
                notifications.addNotification(notification);
                VoiceInterpreter.this.sendMail(notification);
                StopInterpreter stop = new StopInterpreter();
                this.source.tell((Object)stop, this.source);
                return null;
            }
            if (callerId == null && useInitialFromAsCallerId) {
                callerId = VoiceInterpreter.this.callInfo.from();
            }
            return callerId;
        }

        protected int timeout(Tag container) {
            String value;
            int timeout = 30;
            Attribute attribute = container.attribute("timeout");
            if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                try {
                    timeout = Integer.parseInt(value);
                }
                catch (NumberFormatException exception) {
                    NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
                    Notification notification = VoiceInterpreter.this.notification(1, 13212, value + " is not a valid timeout value for <Dial>");
                    notifications.addNotification(notification);
                }
            }
            return timeout;
        }

        protected int timeLimit(Tag container) {
            String value;
            int timeLimit = 14400;
            Attribute attribute = container.attribute("timeLimit");
            if (attribute != null && (value = attribute.value()) != null && !value.isEmpty()) {
                try {
                    timeLimit = Integer.parseInt(value);
                }
                catch (NumberFormatException exception) {
                    NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
                    Notification notification = VoiceInterpreter.this.notification(1, 13216, value + " is not a valid timeLimit value for <Dial>");
                    notifications.addNotification(notification);
                }
            }
            return timeLimit;
        }
    }

    private final class Rejecting
    extends AbstractAction {
        public Rejecting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Tag.class.equals(klass)) {
                VoiceInterpreter.this.verb = (Tag)message;
            }
            String reason = "rejected";
            Attribute attribute = VoiceInterpreter.this.verb.attribute("reason");
            if (attribute != null) {
                reason = attribute.value();
                reason = reason != null && !reason.isEmpty() ? ("rejected".equalsIgnoreCase(reason) ? "rejected" : ("busy".equalsIgnoreCase(reason) ? "busy" : "rejected")) : "rejected";
            }
            VoiceInterpreter.this.call.tell((Object)new Reject(reason), this.source);
        }
    }

    private final class NotFound
    extends AbstractAction {
        public NotFound(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            DownloaderResponse response = (DownloaderResponse)message;
            if (VoiceInterpreter.this.logger.isDebugEnabled()) {
                VoiceInterpreter.this.logger.debug("response succeeded " + response.succeeded() + ", statusCode " + ((HttpResponseDescriptor)response.get()).getStatusCode());
            }
            Notification notification = VoiceInterpreter.this.notification(1, 21402, "URL Not Found : " + ((HttpResponseDescriptor)response.get()).getURI());
            NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
            notifications.addNotification(notification);
            VoiceInterpreter.this.call.tell((Object)new org.restcomm.connect.telephony.api.NotFound(), this.source);
        }
    }

    private final class Ready
    extends AbstractAction {
        public Ready(ActorRef source) {
            super(source);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void execute(Object message) throws IOException {
            block15: {
                State state;
                UntypedActorContext context;
                block12: {
                    block13: {
                        String type;
                        block14: {
                            context = VoiceInterpreter.this.getContext();
                            state = VoiceInterpreter.this.fsm.state();
                            if (VoiceInterpreter.this.initializingCall.equals((Object)state)) {
                                CallStateChanged event = (CallStateChanged)message;
                                VoiceInterpreter.this.callState = event.state();
                                VoiceInterpreter.this.callback();
                                if (VoiceInterpreter.this.callRecord != null) {
                                    CallDetailRecordsDao records = VoiceInterpreter.this.storage.getCallDetailRecordsDao();
                                    VoiceInterpreter.this.callRecord = records.getCallDetailRecord(VoiceInterpreter.this.callRecord.getSid());
                                    VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setStatus(VoiceInterpreter.this.callState.toString());
                                    VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setStartTime(DateTime.now());
                                    records.updateCallDetailRecord(VoiceInterpreter.this.callRecord);
                                }
                                this.source.tell((Object)VoiceInterpreter.this.verb, this.source);
                                return;
                            }
                            if (!VoiceInterpreter.this.downloadingRcml.equals((Object)state) && !VoiceInterpreter.this.downloadingFallbackRcml.equals((Object)state) && !VoiceInterpreter.this.redirecting.equals((Object)state) && !VoiceInterpreter.this.finishGathering.equals((Object)state) && !VoiceInterpreter.this.finishRecording.equals((Object)state) && !VoiceInterpreter.this.sendingSms.equals((Object)state) && !VoiceInterpreter.this.finishDialing.equals((Object)state) && !VoiceInterpreter.this.finishConferencing.equals((Object)state) && !VoiceInterpreter.this.is(VoiceInterpreter.this.forking)) break block12;
                            VoiceInterpreter.this.response = (HttpResponseDescriptor)((DownloaderResponse)message).get();
                            if (VoiceInterpreter.this.parser != null) {
                                context.stop(VoiceInterpreter.this.parser);
                                VoiceInterpreter.this.parser = null;
                            }
                            if ((type = VoiceInterpreter.this.response.getContentType()) == null) break block13;
                            if (!type.contains("text/xml") && !type.contains("application/xml") && !type.contains("text/html")) break block14;
                            VoiceInterpreter.this.parser = VoiceInterpreter.this.parser(VoiceInterpreter.this.response.getContentAsString());
                            break block15;
                        }
                        if (type.contains("audio/wav") || type.contains("audio/wave") || type.contains("audio/x-wav")) {
                            VoiceInterpreter.this.parser = VoiceInterpreter.this.parser("<Play>" + VoiceInterpreter.this.request.getUri() + "</Play>");
                            break block15;
                        } else if (type.contains("text/plain")) {
                            VoiceInterpreter.this.parser = VoiceInterpreter.this.parser("<Say>" + VoiceInterpreter.this.response.getContentAsString() + "</Say>");
                        }
                        break block15;
                    }
                    if (VoiceInterpreter.this.call != null) {
                        VoiceInterpreter.this.call.tell((Object)new Hangup(VoiceInterpreter.this.outboundCallResponse), null);
                    }
                    StopInterpreter stop = new StopInterpreter();
                    this.source.tell((Object)stop, this.source);
                    return;
                }
                if (message instanceof CallResponse && VoiceInterpreter.this.rcml != null && !VoiceInterpreter.this.rcml.isEmpty()) {
                    if (VoiceInterpreter.this.parser != null) {
                        context.stop(VoiceInterpreter.this.parser);
                        VoiceInterpreter.this.parser = null;
                    }
                    VoiceInterpreter.this.parser = VoiceInterpreter.this.parser(VoiceInterpreter.this.rcml);
                } else if (VoiceInterpreter.this.pausing.equals((Object)state)) {
                    context.setReceiveTimeout((Duration)Duration.Undefined());
                }
            }
            GetNextVerb next = GetNextVerb.instance();
            if (VoiceInterpreter.this.parser != null) {
                VoiceInterpreter.this.parser.tell((Object)next, this.source);
                return;
            }
            if (!VoiceInterpreter.this.logger.isInfoEnabled()) return;
            VoiceInterpreter.this.logger.info("Parser is null");
        }
    }

    private final class DownloadingFallbackRcml
    extends AbstractAction {
        public DownloadingFallbackRcml(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (DownloaderResponse.class.equals(klass)) {
                DownloaderResponse result = (DownloaderResponse)message;
                Throwable cause = result.cause();
                Notification notification = null;
                if (cause instanceof ClientProtocolException) {
                    notification = VoiceInterpreter.this.notification(0, 11206, cause.getMessage());
                } else if (cause instanceof IOException) {
                    notification = VoiceInterpreter.this.notification(0, 11205, cause.getMessage());
                } else if (cause instanceof URISyntaxException) {
                    notification = VoiceInterpreter.this.notification(0, 11100, cause.getMessage());
                }
                if (notification != null) {
                    NotificationsDao notifications = VoiceInterpreter.this.storage.getNotificationsDao();
                    notifications.addNotification(notification);
                    VoiceInterpreter.this.sendMail(notification);
                }
            }
            List<NameValuePair> parameters = VoiceInterpreter.this.parameters();
            VoiceInterpreter.this.request = new HttpRequestDescriptor(VoiceInterpreter.this.fallbackUrl, VoiceInterpreter.this.fallbackMethod, parameters);
            VoiceInterpreter.this.downloader.tell((Object)VoiceInterpreter.this.request, this.source);
        }
    }

    private final class DownloadingRcml
    extends AbstractAction {
        public DownloadingRcml(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (CallResponse.class.equals(klass)) {
                VoiceInterpreter.this.createInitialCallRecord((CallResponse<CallInfo>)((CallResponse)message));
            }
            List<NameValuePair> parameters = VoiceInterpreter.this.parameters();
            VoiceInterpreter.this.request = new HttpRequestDescriptor(VoiceInterpreter.this.url, VoiceInterpreter.this.method, parameters);
            VoiceInterpreter.this.downloader.tell((Object)VoiceInterpreter.this.request, this.source);
        }
    }

    private final class InitializingCall
    extends AbstractAction {
        public InitializingCall(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (CallResponse.class.equals(klass)) {
                CallResponse response = (CallResponse)message;
                VoiceInterpreter.this.callInfo = (CallInfo)response.get();
                VoiceInterpreter.this.callState = VoiceInterpreter.this.callInfo.state();
                if (VoiceInterpreter.this.callState.name().equalsIgnoreCase(CallStateChanged.State.IN_PROGRESS.name())) {
                    CallStateChanged event = new CallStateChanged(CallStateChanged.State.IN_PROGRESS);
                    this.source.tell((Object)event, this.source);
                    return;
                }
                if (VoiceInterpreter.this.callRecord != null) {
                    VoiceInterpreter.this.callRecord = VoiceInterpreter.this.callRecord.setStatus(VoiceInterpreter.this.callState.toString());
                    CallDetailRecordsDao records = VoiceInterpreter.this.storage.getCallDetailRecordsDao();
                    records.updateCallDetailRecord(VoiceInterpreter.this.callRecord);
                }
                VoiceInterpreter.this.callback();
                VoiceInterpreter.this.call.tell((Object)new Dial(), this.source);
            } else if (Tag.class.equals(klass)) {
                VoiceInterpreter.this.verb = (Tag)message;
                boolean confirmCall = true;
                if (VoiceInterpreter.this.enable200OkDelay && "Dial".equals(VoiceInterpreter.this.verb.name())) {
                    confirmCall = false;
                }
                VoiceInterpreter.this.call.tell((Object)new Answer(VoiceInterpreter.this.callRecord.getSid(), confirmCall), this.source);
            }
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }

        protected Tag conference(Tag container) {
            List<Tag> children = container.children();
            for (Tag child : children) {
                if (!"Conference".equals(child.name())) continue;
                return child;
            }
            return null;
        }
    }
}

