/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.interpreter.rcml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.interpreter.rcml.Attribute;
import org.restcomm.connect.interpreter.rcml.TagIterator;
import org.restcomm.connect.interpreter.rcml.TagPrinter;

@Immutable
public class Tag {
    private final Map<String, Attribute> attributes;
    private final List<Tag> children;
    private final String name;
    private final Tag parent;
    private final String text;
    private final boolean iterable;

    private Tag(String name, Tag parent, String text, Map<String, Attribute> attributes, List<Tag> children, boolean iterable) {
        this.attributes = attributes;
        this.children = children;
        this.name = name;
        this.parent = parent;
        this.text = text;
        this.iterable = iterable;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Attribute attribute(String name) {
        return this.attributes.get(name);
    }

    public List<Attribute> attributes() {
        return new ArrayList<Attribute>(this.attributes.values());
    }

    public List<Tag> children() {
        return this.children;
    }

    public boolean isIterable() {
        return this.iterable;
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public Iterator<Tag> iterator() {
        return new TagIterator(this);
    }

    public String name() {
        return this.name;
    }

    public Tag parent() {
        return this.parent;
    }

    public String text() {
        return this.text;
    }

    public final String toString() {
        return TagPrinter.print(this);
    }

    public static final class Builder {
        private final Map<String, Attribute> attributes = new HashMap<String, Attribute>();
        private final List<Tag> children = new ArrayList<Tag>();
        private String name = null;
        private Tag parent = null;
        private String text = null;
        private boolean iterable = false;

        private Builder() {
        }

        public void addAttribute(Attribute attribute) {
            this.attributes.put(attribute.name(), attribute);
        }

        public void addChild(Tag child) {
            this.children.add(child);
        }

        public Tag build() {
            return new Tag(this.name, this.parent, this.text, this.attributes, this.children, this.iterable);
        }

        public void setIterable(boolean iterable) {
            this.iterable = iterable;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setParent(Tag parent) {
            this.parent = parent;
        }

        public void setText(String text) {
            this.text = text;
        }
    }
}

