/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.mrb;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.dao.ConferenceDetailRecordsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.ConferenceDetailRecord;
import org.restcomm.connect.mgcp.CreateMediaSession;
import org.restcomm.connect.mgcp.MediaGatewayResponse;
import org.restcomm.connect.mgcp.MediaSession;
import org.restcomm.connect.mrb.MgcpMediaGroup;
import org.restcomm.connect.mrb.api.ConferenceMediaResourceControllerStateChanged;
import org.restcomm.connect.mrb.api.StartConferenceMediaResourceController;
import org.restcomm.connect.mrb.api.StopConferenceMediaResourceController;
import org.restcomm.connect.mrb.api.StopConferenceMediaResourceControllerResponse;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupResponse;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupStateChanged;
import org.restcomm.connect.mscontrol.api.messages.Play;
import org.restcomm.connect.mscontrol.api.messages.Record;
import org.restcomm.connect.mscontrol.api.messages.StartMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.StartRecording;
import org.restcomm.connect.mscontrol.api.messages.Stop;
import org.restcomm.connect.mscontrol.api.messages.StopMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.StopRecording;

public class ConferenceMediaResourceControllerGeneric
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State acquiringConferenceInfo;
    private final State creatingMediaGroup;
    private final State preActive;
    private final State active;
    private final State stopping;
    private final State inactive;
    private final State failed;
    private final ActorRef localMediaGateway;
    private ActorRef mediaGroup;
    private String masterIVREndpointIdName;
    private MediaSession localMediaSession;
    private ActorRef localConfernceEndpoint;
    private ActorRef connectionWithLocalMS;
    private ActorRef connectionWithMasterMS;
    private final DaoManager storage;
    private final Configuration configuration;
    private ConferenceDetailRecord cdr;
    private Sid conferenceSid;
    private Boolean playing;
    private Boolean fail;
    private Boolean recording;
    private DateTime recordStarted;
    private final List<ActorRef> observers;
    private final ActorRef mrb;

    public ConferenceMediaResourceControllerGeneric(String localMsId, ActorRef localMediaGateway, Configuration configuration, DaoManager storage, ActorRef mrb) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.creatingMediaGroup = new State("creating media group", (Action)new CreatingMediaGroup(source), null);
        this.acquiringConferenceInfo = new State("getting Conference Info From DB", (Action)new AcquiringConferenceInfo(source), null);
        this.preActive = new State("pre active", (Action)new PreActive(source));
        this.active = new State("active", (Action)new Active(source));
        this.stopping = new State("stopping", (Action)new Stopping(source));
        this.inactive = new State("inactive", (Action)new Inactive(source));
        this.failed = new State("failed", (Action)new Failed(source));
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.acquiringConferenceInfo));
        transitions.add(new Transition(this.acquiringConferenceInfo, this.creatingMediaGroup));
        transitions.add(new Transition(this.creatingMediaGroup, this.preActive));
        transitions.add(new Transition(this.preActive, this.active));
        transitions.add(new Transition(this.active, this.stopping));
        transitions.add(new Transition(this.stopping, this.inactive));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.storage = storage;
        this.configuration = configuration;
        this.logger.info("localMsId: " + localMsId);
        this.localMediaGateway = localMediaGateway;
        this.masterIVREndpointIdName = null;
        this.playing = Boolean.FALSE;
        this.recording = Boolean.FALSE;
        this.fail = Boolean.FALSE;
        this.mrb = mrb;
        this.observers = new ArrayList<ActorRef>(1);
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(Object message) {
        if (!this.observers.isEmpty()) {
            ActorRef self = this.self();
            List<ActorRef> list = this.observers;
            synchronized (list) {
                for (ActorRef observer : this.observers) {
                    observer.tell(message, self);
                }
            }
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef sender = this.sender();
        ActorRef self = this.self();
        State state = this.fsm.state();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** ConferenceMediaResourceController " + this.self().path() + " Processing Message: " + klass.getName());
            this.logger.info(" ********** ConferenceMediaResourceController " + this.self().path() + " Current State: \"" + state.toString());
        }
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (StartConferenceMediaResourceController.class.equals(klass)) {
            this.onStartConferenceMediaResourceController((StartConferenceMediaResourceController)message, self, sender);
        } else if (MediaGatewayResponse.class.equals(klass)) {
            this.onMediaGatewayResponse((MediaGatewayResponse)message, self, sender);
        } else if (MediaGroupStateChanged.class.equals(klass)) {
            this.onMediaGroupStateChanged((MediaGroupStateChanged)message, self, sender);
        } else if (StopMediaGroup.class.equals(klass)) {
            this.onStopMediaGroup((StopMediaGroup)message, self, sender);
        } else if (Play.class.equals(klass)) {
            this.onPlay((Play)message, self, sender);
        } else if (MediaGroupResponse.class.equals(klass)) {
            this.onMediaGroupResponse((MediaGroupResponse<String>)((MediaGroupResponse)message), self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecording((StartRecording)message, self, sender);
        } else if (StopRecording.class.equals(klass)) {
            this.onStopRecording((StopRecording)message, self, sender);
        } else if (StopConferenceMediaResourceController.class.equals(klass)) {
            this.onStopConferenceMediaResourceController((StopConferenceMediaResourceController)message, self, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private void onStartConferenceMediaResourceController(StartConferenceMediaResourceController message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("onStartConferenceMediaResourceController: conferenceSid: " + message.conferenceSid() + " cnfEndpoint: " + message.cnfEndpoint());
            }
            this.localConfernceEndpoint = message.cnfEndpoint();
            this.conferenceSid = message.conferenceSid();
            this.fsm.transition((Object)message, this.acquiringConferenceInfo);
        }
    }

    private void onMediaGatewayResponse(MediaGatewayResponse<?> message, ActorRef self, ActorRef sender) throws Exception {
        this.logger.info("inside onMediaGatewayResponse: state = " + this.fsm.state());
        if (this.is(this.acquiringConferenceInfo)) {
            this.localMediaSession = (MediaSession)message.get();
            this.fsm.transition(message, this.creatingMediaGroup);
        }
    }

    private void onStopConferenceMediaResourceController(StopConferenceMediaResourceController message, ActorRef self, ActorRef sender) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("onStopConferenceMediaResourceController");
        }
        sender.tell((Object)new StopConferenceMediaResourceControllerResponse(true), sender);
        this.fsm.transition((Object)message, this.stopping);
    }

    private void onMediaGroupStateChanged(MediaGroupStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ onMediaGroupStateChanged - received STATE is: " + message.state() + " current fsm STATE is: " + this.fsm.state() + " ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^");
        }
        switch (message.state()) {
            case ACTIVE: {
                if (!this.is(this.creatingMediaGroup)) break;
                this.fsm.transition((Object)message, this.preActive);
                break;
            }
            case INACTIVE: {
                if (this.is(this.creatingMediaGroup)) {
                    this.fail = Boolean.TRUE;
                    this.fsm.transition((Object)message, this.failed);
                    break;
                }
                if (!this.is(this.stopping)) break;
                this.mediaGroup.tell((Object)new StopObserving(self), self);
                this.context().stop(this.mediaGroup);
                this.mediaGroup = null;
                if (this.mediaGroup != null || this.localConfernceEndpoint != null) break;
                this.fsm.transition((Object)message, this.fail != false ? this.failed : this.inactive);
                break;
            }
        }
    }

    private void onPlay(Play message, ActorRef self, ActorRef sender) {
        if (!this.playing.booleanValue()) {
            this.playing = Boolean.TRUE;
            this.mediaGroup.tell((Object)message, self);
        }
    }

    private void onStartRecording(StartRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active) && !this.recording.booleanValue()) {
            String finishOnKey = "1234567890*#";
            int maxLength = 3600;
            int timeout = 5;
            this.recording = Boolean.TRUE;
            this.recordStarted = DateTime.now();
            Record record = new Record(message.getRecordingUri(), timeout, maxLength, finishOnKey);
            this.mediaGroup.tell((Object)record, null);
        }
    }

    private void onStopRecording(StopRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active) && this.recording.booleanValue()) {
            this.recording = Boolean.FALSE;
            this.mediaGroup.tell((Object)new Stop(), null);
        }
    }

    private void onMediaGroupResponse(MediaGroupResponse<String> message, ActorRef self, ActorRef sender) throws Exception {
        if (this.playing.booleanValue()) {
            this.playing = Boolean.FALSE;
        }
    }

    private void onStopMediaGroup(StopMediaGroup message, ActorRef self, ActorRef sender) {
        this.mediaGroup.tell((Object)new Stop(), self);
        this.playing = Boolean.FALSE;
    }

    public void postStop() {
        this.cleanup();
        this.observers.clear();
        this.getContext().stop(this.self());
    }

    protected void cleanup() {
        if (this.connectionWithLocalMS != null) {
            this.context().stop(this.connectionWithLocalMS);
            this.connectionWithLocalMS = null;
        }
        if (this.connectionWithMasterMS != null) {
            this.context().stop(this.connectionWithMasterMS);
            this.connectionWithMasterMS = null;
        }
    }

    private void updateConferenceStatus(String status) {
        if (this.cdr != null) {
            ConferenceDetailRecordsDao dao = this.storage.getConferenceDetailRecordsDao();
            this.cdr = dao.getConferenceDetailRecord(this.conferenceSid);
            this.cdr = this.cdr.setStatus(status);
            dao.updateConferenceDetailRecordStatus(this.cdr);
        }
    }

    private final class Failed
    extends FinalState {
        public Failed(ActorRef source) {
            super(source, ConferenceMediaResourceControllerStateChanged.MediaServerControllerState.FAILED);
        }
    }

    private final class Inactive
    extends FinalState {
        public Inactive(ActorRef source) {
            super(source, ConferenceMediaResourceControllerStateChanged.MediaServerControllerState.INACTIVE);
        }
    }

    private abstract class FinalState
    extends AbstractAction {
        private final ConferenceMediaResourceControllerStateChanged.MediaServerControllerState state;

        public FinalState(ActorRef source, ConferenceMediaResourceControllerStateChanged.MediaServerControllerState state) {
            super(source);
            this.state = state;
        }

        public void execute(Object message) throws Exception {
            ConferenceMediaResourceControllerGeneric.this.broadcast(new ConferenceMediaResourceControllerStateChanged(this.state));
        }
    }

    private class Stopping
    extends AbstractAction {
        public Stopping(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (ConferenceMediaResourceControllerGeneric.this.logger.isInfoEnabled()) {
                ConferenceMediaResourceControllerGeneric.this.logger.info("CMRC is STOPPING NOW...");
            }
            ConferenceMediaResourceControllerGeneric.this.updateConferenceStatus("COMPLETED");
            ConferenceMediaResourceControllerGeneric.this.mediaGroup.tell((Object)new StopMediaGroup(), this.source);
        }
    }

    private final class Active
    extends AbstractAction {
        public Active(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (ConferenceMediaResourceControllerGeneric.this.logger.isInfoEnabled()) {
                ConferenceMediaResourceControllerGeneric.this.logger.info("CMRC is ACTIVE NOW...");
            }
        }
    }

    private final class PreActive
    extends AbstractAction {
        public PreActive(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (ConferenceMediaResourceControllerGeneric.this.logger.isInfoEnabled()) {
                ConferenceMediaResourceControllerGeneric.this.logger.info("CMRC is in pre ACTIVE NOW...");
            }
            ConferenceMediaResourceControllerGeneric.this.updateConferenceStatus("RUNNING_MODERATOR_ABSENT");
            ConferenceMediaResourceControllerGeneric.this.broadcast(new ConferenceMediaResourceControllerStateChanged(ConferenceMediaResourceControllerStateChanged.MediaServerControllerState.ACTIVE, ConferenceMediaResourceControllerGeneric.this.cdr.getStatus()));
            ConferenceMediaResourceControllerGeneric.this.fsm.transition(message, ConferenceMediaResourceControllerGeneric.this.active);
        }
    }

    private final class CreatingMediaGroup
    extends AbstractAction {
        public CreatingMediaGroup(ActorRef source) {
            super(source);
        }

        private ActorRef createMediaGroup(Object message) {
            return ConferenceMediaResourceControllerGeneric.this.getContext().actorOf(new Props(new UntypedActorFactory(){
                private static final long serialVersionUID = 1L;

                public UntypedActor create() throws Exception {
                    return new MgcpMediaGroup(ConferenceMediaResourceControllerGeneric.this.localMediaGateway, ConferenceMediaResourceControllerGeneric.this.localMediaSession, ConferenceMediaResourceControllerGeneric.this.localConfernceEndpoint, ConferenceMediaResourceControllerGeneric.this.masterIVREndpointIdName);
                }
            }));
        }

        public void execute(Object message) throws Exception {
            ConferenceMediaResourceControllerGeneric.this.mediaGroup = this.createMediaGroup(message);
            ConferenceMediaResourceControllerGeneric.this.mediaGroup.tell((Object)new Observe(this.source), this.source);
            ConferenceMediaResourceControllerGeneric.this.mediaGroup.tell((Object)new StartMediaGroup(), this.source);
        }
    }

    private final class AcquiringConferenceInfo
    extends AbstractAction {
        public AcquiringConferenceInfo(ActorRef source) {
            super(source);
        }

        public void execute(Object msg) throws Exception {
            ConferenceMediaResourceControllerGeneric.this.logger.info("current state is: " + ConferenceMediaResourceControllerGeneric.this.fsm.state());
            ConferenceDetailRecordsDao conferenceDetailRecordsDao = ConferenceMediaResourceControllerGeneric.this.storage.getConferenceDetailRecordsDao();
            ConferenceMediaResourceControllerGeneric.this.cdr = conferenceDetailRecordsDao.getConferenceDetailRecord(ConferenceMediaResourceControllerGeneric.this.conferenceSid);
            if (ConferenceMediaResourceControllerGeneric.this.cdr == null) {
                ConferenceMediaResourceControllerGeneric.this.logger.error("there is no information available in DB to proceed with this CMRC");
                ConferenceMediaResourceControllerGeneric.this.fsm.transition(msg, ConferenceMediaResourceControllerGeneric.this.failed);
            } else {
                if (ConferenceMediaResourceControllerGeneric.this.logger.isInfoEnabled()) {
                    ConferenceMediaResourceControllerGeneric.this.logger.info("first participant Joined on master MS and sent message to CMRC");
                }
                ConferenceMediaResourceControllerGeneric.this.localMediaGateway.tell((Object)new CreateMediaSession(), this.source);
            }
        }
    }

    protected abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

