/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.mrb;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.mobicents.protocols.mgcp.jain.pkg.AUMgcpEvent;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.mgcp.CreateIvrEndpoint;
import org.restcomm.connect.mgcp.CreateLink;
import org.restcomm.connect.mgcp.DestroyEndpoint;
import org.restcomm.connect.mgcp.DestroyLink;
import org.restcomm.connect.mgcp.EndpointState;
import org.restcomm.connect.mgcp.EndpointStateChanged;
import org.restcomm.connect.mgcp.InitializeLink;
import org.restcomm.connect.mgcp.IvrEndpointResponse;
import org.restcomm.connect.mgcp.LinkStateChanged;
import org.restcomm.connect.mgcp.MediaGatewayResponse;
import org.restcomm.connect.mgcp.MediaSession;
import org.restcomm.connect.mgcp.OpenLink;
import org.restcomm.connect.mgcp.Play;
import org.restcomm.connect.mgcp.PlayCollect;
import org.restcomm.connect.mgcp.PlayRecord;
import org.restcomm.connect.mgcp.StopEndpoint;
import org.restcomm.connect.mgcp.UpdateLink;
import org.restcomm.connect.mscontrol.api.MediaGroup;
import org.restcomm.connect.mscontrol.api.messages.Collect;
import org.restcomm.connect.mscontrol.api.messages.Join;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupResponse;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupStateChanged;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupStatus;
import org.restcomm.connect.mscontrol.api.messages.Record;
import org.restcomm.connect.mscontrol.api.messages.StartMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.Stop;
import org.restcomm.connect.mscontrol.api.messages.StopMediaGroup;

public class MgcpMediaGroup
extends MediaGroup {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final State uninitialized;
    private final State active;
    private final State inactive;
    private final State acquiringIvr;
    private final State acquiringLink;
    private final State initializingLink;
    private final State openingLink;
    private final State updatingLink;
    private final State deactivating;
    private final State acquiringInternalLink;
    private final State initializingInternalLink;
    private final State openingInternalLink;
    private final State updatingInternalLink;
    private final FiniteStateMachine fsm;
    private final ActorRef gateway;
    private final ActorRef endpoint;
    private final MediaSession session;
    private ActorRef link;
    private final String ivrEndpointName;
    private ActorRef ivr;
    private boolean ivrInUse;
    private MgcpEvent lastEvent;
    private final List<ActorRef> observers;
    private ActorRef originator;
    private ActorRef internalLinkEndpoint;
    private ActorRef internalLink;
    private ConnectionMode internalLinkMode;
    private ConnectionIdentifier ivrConnectionIdentifier;

    public MgcpMediaGroup(ActorRef gateway, MediaSession session, ActorRef endpoint, String ivrEndpointName) {
        this(gateway, session, endpoint, ivrEndpointName, null);
    }

    public MgcpMediaGroup(ActorRef gateway, MediaSession session, ActorRef endpoint, String ivrEndpointName, ConnectionIdentifier ivrConnectionIdentifier) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.active = new State("active", (Action)new Active(source), null);
        this.inactive = new State("inactive", (Action)new Inactive(source), null);
        this.acquiringIvr = new State("acquiring ivr", (Action)new AcquiringIvr(source), null);
        this.acquiringLink = new State("acquiring link", (Action)new AcquiringLink(source), null);
        this.initializingLink = new State("initializing link", (Action)new InitializingLink(source), null);
        this.openingLink = new State("opening link", (Action)new OpeningLink(source), null);
        this.updatingLink = new State("updating link", (Action)new UpdatingLink(source), null);
        this.deactivating = new State("deactivating", (Action)new Deactivating(source), null);
        this.acquiringInternalLink = new State("acquiring internal link", (Action)new AcquiringInternalLink(source), null);
        this.initializingInternalLink = new State("initializing internal link", (Action)new InitializingInternalLink(source), null);
        this.openingInternalLink = new State("opening internal link", (Action)new OpeningInternalLink(source), null);
        this.updatingInternalLink = new State("updating internal link", (Action)new UpdatingInternalLink(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.acquiringIvr));
        transitions.add(new Transition(this.acquiringIvr, this.inactive));
        transitions.add(new Transition(this.acquiringIvr, this.acquiringLink));
        transitions.add(new Transition(this.acquiringLink, this.inactive));
        transitions.add(new Transition(this.acquiringLink, this.initializingLink));
        transitions.add(new Transition(this.initializingLink, this.inactive));
        transitions.add(new Transition(this.initializingLink, this.openingLink));
        transitions.add(new Transition(this.openingLink, this.inactive));
        transitions.add(new Transition(this.openingLink, this.deactivating));
        transitions.add(new Transition(this.openingLink, this.updatingLink));
        transitions.add(new Transition(this.updatingLink, this.active));
        transitions.add(new Transition(this.updatingLink, this.inactive));
        transitions.add(new Transition(this.updatingLink, this.deactivating));
        transitions.add(new Transition(this.active, this.deactivating));
        transitions.add(new Transition(this.deactivating, this.inactive));
        transitions.add(new Transition(this.active, this.acquiringIvr));
        transitions.add(new Transition(this.active, this.acquiringInternalLink));
        transitions.add(new Transition(this.acquiringInternalLink, this.initializingInternalLink));
        transitions.add(new Transition(this.initializingInternalLink, this.openingInternalLink));
        transitions.add(new Transition(this.openingInternalLink, this.updatingInternalLink));
        transitions.add(new Transition(this.updatingInternalLink, this.active));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.gateway = gateway;
        this.session = session;
        this.endpoint = endpoint;
        this.ivrInUse = false;
        this.ivrEndpointName = ivrEndpointName;
        this.ivrConnectionIdentifier = ivrConnectionIdentifier;
        this.observers = new ArrayList<ActorRef>();
    }

    private void collect(Object message) {
        ActorRef self = this.self();
        Collect request = (Collect)message;
        PlayCollect.Builder builder = PlayCollect.builder();
        for (URI prompt : request.prompts()) {
            builder.addPrompt(prompt);
        }
        builder.setClearDigitBuffer(true);
        builder.setDigitPattern(request.pattern());
        builder.setFirstDigitTimer((long)request.timeout());
        builder.setInterDigitTimer((long)request.timeout());
        builder.setEndInputKey(request.endInputKey());
        builder.setMaxNumberOfDigits(request.numberOfDigits());
        this.lastEvent = AUMgcpEvent.aupc;
        this.stop(this.lastEvent);
        this.originator = this.sender();
        this.ivr.tell((Object)builder.build(), self);
        this.ivrInUse = true;
    }

    private void play(Object message) {
        ActorRef self = this.self();
        org.restcomm.connect.mscontrol.api.messages.Play request = (org.restcomm.connect.mscontrol.api.messages.Play)message;
        List uris = request.uris();
        int iterations = request.iterations();
        Play play = new Play(uris, iterations);
        this.lastEvent = AUMgcpEvent.aupa;
        this.stop(this.lastEvent);
        this.originator = this.sender();
        this.ivr.tell((Object)play, self);
        this.ivrInUse = true;
    }

    private void notification(Object message) {
        IvrEndpointResponse response = (IvrEndpointResponse)message;
        ActorRef self = this.self();
        MediaGroupResponse event = null;
        event = response.succeeded() ? new MediaGroupResponse(response.get()) : new MediaGroupResponse(response.cause(), response.error());
        this.originator.tell((Object)event, self);
        this.ivrInUse = false;
    }

    private void observe(Object message) {
        ActorRef self = this.self();
        Observe request = (Observe)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.add(observer);
            observer.tell((Object)new Observing(self), self);
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        State state = this.fsm.state();
        ActorRef sender = this.sender();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("********** Media Group " + this.self().path() + " Current State: \"" + state.toString());
            this.logger.info("********** Media Group " + this.self().path() + " Processing Message: \"" + klass.getName() + " sender : " + sender.getClass());
        }
        if (Observe.class.equals(klass)) {
            this.observe(message);
        } else if (StopObserving.class.equals(klass)) {
            this.stopObserving(message);
        } else if (MediaGroupStatus.class.equals(klass)) {
            if (this.active.equals((Object)state)) {
                this.sender().tell((Object)new MediaGroupStateChanged(MediaGroupStateChanged.State.ACTIVE, this.ivr, this.ivrConnectionIdentifier), this.self());
            } else {
                this.sender().tell((Object)new MediaGroupStateChanged(MediaGroupStateChanged.State.INACTIVE, this.ivr, this.ivrConnectionIdentifier), this.self());
            }
        } else if (StartMediaGroup.class.equals(klass)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("MediaGroup: " + this.self().path() + " got StartMediaGroup from: " + this.sender().path() + " endpoint: " + this.endpoint.path() + " isTerminated: " + this.endpoint.isTerminated());
            }
            this.fsm.transition(message, this.acquiringIvr);
        } else if (Join.class.equals(klass)) {
            this.fsm.transition(message, this.acquiringInternalLink);
        } else if (MediaGatewayResponse.class.equals(klass)) {
            if (this.acquiringIvr.equals((Object)state)) {
                this.fsm.transition(message, this.acquiringLink);
            } else if (this.acquiringLink.equals((Object)state)) {
                this.fsm.transition(message, this.initializingLink);
            } else if (this.acquiringInternalLink.equals((Object)state)) {
                this.fsm.transition(message, this.initializingInternalLink);
            }
        } else if (LinkStateChanged.class.equals(klass)) {
            LinkStateChanged response = (LinkStateChanged)message;
            if (LinkStateChanged.State.CLOSED == response.state()) {
                if (this.initializingLink.equals((Object)state)) {
                    this.fsm.transition(message, this.openingLink);
                } else if (this.openingLink.equals((Object)state) || this.deactivating.equals((Object)state) || this.updatingLink.equals((Object)state)) {
                    this.fsm.transition(message, this.inactive);
                }
                if (this.initializingInternalLink.equals((Object)state)) {
                    this.fsm.transition(message, this.openingInternalLink);
                }
            } else if (LinkStateChanged.State.OPEN == response.state()) {
                this.ivrConnectionIdentifier = response.connectionIdentifier();
                if (this.openingLink.equals((Object)state)) {
                    this.fsm.transition(message, this.updatingLink);
                } else if (this.updatingLink.equals((Object)state)) {
                    this.fsm.transition(message, this.active);
                }
                if (this.openingInternalLink.equals((Object)state)) {
                    this.fsm.transition(message, this.updatingInternalLink);
                }
                if (this.updatingInternalLink.equals((Object)state)) {
                    this.fsm.transition(message, this.active);
                }
            }
        } else if (StopMediaGroup.class.equals(klass)) {
            if (this.acquiringLink.equals((Object)state) || this.initializingLink.equals((Object)state)) {
                this.fsm.transition(message, this.inactive);
            } else if (this.active.equals((Object)state) || this.openingLink.equals((Object)state) || this.updatingLink.equals((Object)state)) {
                this.fsm.transition(message, this.deactivating);
            }
        } else if (EndpointStateChanged.class.equals(klass)) {
            this.onEndpointStateChanged((EndpointStateChanged)message, this.self(), sender);
        } else if (this.active.equals((Object)state)) {
            if (org.restcomm.connect.mscontrol.api.messages.Play.class.equals(klass)) {
                this.play(message);
            } else if (Collect.class.equals(klass)) {
                this.collect(message);
            } else if (Record.class.equals(klass)) {
                this.record(message);
            } else if (Stop.class.equals(klass)) {
                this.stop(this.lastEvent);
                this.sender().tell((Object)new MediaGroupResponse((Object)"stopped"), this.self());
            } else if (IvrEndpointResponse.class.equals(klass)) {
                this.notification(message);
            }
        } else if (this.ivrInUse && Stop.class.equals(klass)) {
            this.stop(this.lastEvent);
        }
    }

    private boolean is(State state) {
        return state != null && state.equals((Object)this.fsm.state());
    }

    private void onEndpointStateChanged(EndpointStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.deactivating) && sender.equals((Object)this.ivr) && EndpointState.DESTROYED.equals((Object)message.getState())) {
            this.ivr.tell((Object)new StopObserving(self), self);
            this.fsm.transition((Object)message, this.inactive);
        }
    }

    private void record(Object message) {
        ActorRef self = this.self();
        Record request = (Record)message;
        PlayRecord.Builder builder = PlayRecord.builder();
        for (URI prompt : request.prompts()) {
            builder.addPrompt(prompt);
        }
        builder.setClearDigitBuffer(true);
        builder.setPreSpeechTimer((long)request.timeout());
        builder.setPostSpeechTimer((long)request.timeout());
        builder.setRecordingLength((long)request.length());
        builder.setEndInputKey(request.endInputKey());
        builder.setRecordingId(request.destination());
        this.lastEvent = AUMgcpEvent.aupr;
        this.stop(this.lastEvent);
        this.originator = this.sender();
        this.ivr.tell((Object)builder.build(), self);
        this.ivrInUse = true;
    }

    private void stop(MgcpEvent signal) {
        ActorRef self = this.self();
        this.ivr.tell((Object)new StopEndpoint(signal), self);
        this.ivrInUse = false;
        this.originator = null;
    }

    private void stopObserving(Object message) {
        StopObserving request = (StopObserving)message;
        ActorRef observer = request.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    public void postStop() {
        if (this.internalLinkEndpoint != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("MediaGroup: " + this.self().path() + " at postStop, about to stop intenalLinkEndpoint: " + this.internalLinkEndpoint.path() + " sender: " + this.sender().path());
            }
            this.gateway.tell((Object)new DestroyEndpoint(this.internalLinkEndpoint), null);
            this.getContext().stop(this.internalLinkEndpoint);
            this.internalLinkEndpoint = null;
        }
        if (this.ivr != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("MediaGroup :" + this.self().path() + " at postStop, about to stop ivr endpoint :" + this.ivr.path());
            }
            this.gateway.tell((Object)new DestroyEndpoint(this.ivr), null);
            this.getContext().stop(this.ivr);
            this.ivr = null;
        }
        if (this.link != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("MediaGroup :" + this.self().path() + " at postStop, about to stop link :" + this.link.path());
            }
            this.getContext().stop(this.link);
            this.link = null;
        }
        if (this.internalLink != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("MediaGroup :" + this.self().path() + " at postStop, about to stop internal link :" + this.internalLink.path());
            }
            this.getContext().stop(this.link);
            this.link = null;
        }
        this.getContext().stop(this.self());
        super.postStop();
    }

    private final class Deactivating
    extends AbstractAction {
        public Deactivating(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MgcpMediaGroup.this.ivr.tell((Object)new DestroyEndpoint(), this.source);
        }
    }

    private final class Inactive
    extends AbstractAction {
        public Inactive(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (MgcpMediaGroup.this.link != null) {
                MgcpMediaGroup.this.gateway.tell((Object)new DestroyLink(MgcpMediaGroup.this.link), this.source);
                MgcpMediaGroup.this.link = null;
            }
            if (MgcpMediaGroup.this.internalLink != null) {
                MgcpMediaGroup.this.gateway.tell((Object)new DestroyLink(MgcpMediaGroup.this.internalLink), this.source);
                MgcpMediaGroup.this.internalLink = null;
            }
            MediaGroupStateChanged event = new MediaGroupStateChanged(MediaGroupStateChanged.State.INACTIVE, MgcpMediaGroup.this.ivr, MgcpMediaGroup.this.ivrConnectionIdentifier);
            for (ActorRef observer : MgcpMediaGroup.this.observers) {
                observer.tell((Object)event, this.source);
            }
        }
    }

    private final class Active
    extends AbstractAction {
        public Active(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MediaGroupStateChanged event = new MediaGroupStateChanged(MediaGroupStateChanged.State.ACTIVE, MgcpMediaGroup.this.ivr, MgcpMediaGroup.this.ivrConnectionIdentifier);
            for (ActorRef observer : MgcpMediaGroup.this.observers) {
                observer.tell((Object)event, this.source);
            }
        }
    }

    private final class UpdatingInternalLink
    extends AbstractAction {
        public UpdatingInternalLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UpdateLink update = new UpdateLink(ConnectionMode.SendRecv, UpdateLink.Type.PRIMARY);
            MgcpMediaGroup.this.internalLink.tell((Object)update, this.source);
        }
    }

    private final class OpeningInternalLink
    extends AbstractAction {
        public OpeningInternalLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MgcpMediaGroup.this.internalLink.tell((Object)new OpenLink(MgcpMediaGroup.this.internalLinkMode), this.source);
        }
    }

    private final class InitializingInternalLink
    extends AbstractAction {
        public InitializingInternalLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MediaGatewayResponse response = (MediaGatewayResponse)message;
            MgcpMediaGroup.this.internalLink = (ActorRef)response.get();
            MgcpMediaGroup.this.internalLink.tell((Object)new Observe(this.source), this.source);
            MgcpMediaGroup.this.internalLink.tell((Object)new InitializeLink(MgcpMediaGroup.this.internalLinkEndpoint, MgcpMediaGroup.this.ivr), this.source);
        }
    }

    private final class AcquiringInternalLink
    extends AbstractAction {
        public AcquiringInternalLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Join.class.equals(klass)) {
                Join request = (Join)message;
                MgcpMediaGroup.this.internalLinkEndpoint = request.endpoint();
                MgcpMediaGroup.this.internalLinkMode = request.mode();
            }
            MgcpMediaGroup.this.gateway.tell((Object)new CreateLink(MgcpMediaGroup.this.session, MgcpMediaGroup.this.ivrConnectionIdentifier), this.source);
        }
    }

    private final class UpdatingLink
    extends AbstractAction {
        public UpdatingLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            UpdateLink update = new UpdateLink(ConnectionMode.SendRecv, UpdateLink.Type.PRIMARY);
            MgcpMediaGroup.this.link.tell((Object)update, this.source);
        }
    }

    private final class OpeningLink
    extends AbstractAction {
        public OpeningLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (MgcpMediaGroup.this.logger.isInfoEnabled()) {
                MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " state: " + MgcpMediaGroup.this.fsm.state().toString() + " session: " + MgcpMediaGroup.this.session.id() + " link: " + MgcpMediaGroup.this.link.path() + " will ask to open Link");
            }
            MgcpMediaGroup.this.link.tell((Object)new OpenLink(ConnectionMode.SendRecv), this.source);
        }
    }

    private final class InitializingLink
    extends AbstractAction {
        public InitializingLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MediaGatewayResponse response = (MediaGatewayResponse)message;
            MgcpMediaGroup.this.link = (ActorRef)response.get();
            if (MgcpMediaGroup.this.endpoint == null && MgcpMediaGroup.this.logger.isInfoEnabled()) {
                MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " state: " + MgcpMediaGroup.this.fsm.state().toString() + " session: " + MgcpMediaGroup.this.session.id() + " link: " + MgcpMediaGroup.this.link.path() + " endpoint is null will have exception");
            }
            MgcpMediaGroup.this.link.tell((Object)new Observe(this.source), this.source);
            MgcpMediaGroup.this.link.tell((Object)new InitializeLink(MgcpMediaGroup.this.endpoint, MgcpMediaGroup.this.ivr), this.source);
            if (MgcpMediaGroup.this.logger.isInfoEnabled()) {
                MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " state: " + MgcpMediaGroup.this.fsm.state().toString() + " session: " + MgcpMediaGroup.this.session.id() + " link: " + MgcpMediaGroup.this.link.path() + " endpoint: " + MgcpMediaGroup.this.endpoint.path() + " initializeLink sent, endpoint isTerminated: " + MgcpMediaGroup.this.endpoint.isTerminated());
            }
        }
    }

    private final class AcquiringLink
    extends AbstractAction {
        public AcquiringLink(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MediaGatewayResponse response = (MediaGatewayResponse)message;
            MgcpMediaGroup.this.ivr = (ActorRef)response.get();
            MgcpMediaGroup.this.ivr.tell((Object)new Observe(this.source), this.source);
            if (MgcpMediaGroup.this.link != null && !MgcpMediaGroup.this.link.isTerminated()) {
                if (MgcpMediaGroup.this.logger.isInfoEnabled()) {
                    MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " got request to create link endpoint, will stop the existing one first: " + MgcpMediaGroup.this.link.path());
                }
                MgcpMediaGroup.this.gateway.tell((Object)new DestroyLink(MgcpMediaGroup.this.link), null);
                MgcpMediaGroup.this.getContext().stop(MgcpMediaGroup.this.link);
            }
            if (MgcpMediaGroup.this.logger.isInfoEnabled()) {
                MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " state: " + MgcpMediaGroup.this.fsm.state().toString() + " session: " + MgcpMediaGroup.this.session.id() + " ivr endpoint: " + MgcpMediaGroup.this.ivr.path() + " will ask to get Link");
            }
            MgcpMediaGroup.this.gateway.tell((Object)new CreateLink(MgcpMediaGroup.this.session, MgcpMediaGroup.this.ivrConnectionIdentifier), this.source);
        }
    }

    private final class AcquiringIvr
    extends AbstractAction {
        public AcquiringIvr(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (MgcpMediaGroup.this.ivr != null && !MgcpMediaGroup.this.ivr.isTerminated()) {
                if (MgcpMediaGroup.this.logger.isInfoEnabled()) {
                    MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " got request to create ivr endpoint, will stop the existing one first: " + MgcpMediaGroup.this.ivr.path());
                }
                MgcpMediaGroup.this.gateway.tell((Object)new DestroyEndpoint(MgcpMediaGroup.this.ivr), null);
                MgcpMediaGroup.this.getContext().stop(MgcpMediaGroup.this.ivr);
                MgcpMediaGroup.this.ivr = null;
            }
            if (MgcpMediaGroup.this.logger.isInfoEnabled()) {
                MgcpMediaGroup.this.logger.info("MediaGroup :" + MgcpMediaGroup.this.self().path() + " state: " + MgcpMediaGroup.this.fsm.state().toString() + " session: " + MgcpMediaGroup.this.session.id() + " will ask to get IvrEndpoint");
            }
            MgcpMediaGroup.this.gateway.tell((Object)new CreateIvrEndpoint(MgcpMediaGroup.this.session, MgcpMediaGroup.this.ivrEndpointName), this.source);
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

