/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.mrb;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import jain.protocol.ip.mgcp.CreateProviderException;
import jain.protocol.ip.mgcp.JainMgcpProvider;
import jain.protocol.ip.mgcp.JainMgcpStack;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.protocols.mgcp.stack.JainMgcpStackImpl;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.loader.ObjectFactory;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.ConferenceDetailRecordsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.MediaServersDao;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.dao.entities.ConferenceDetailRecord;
import org.restcomm.connect.dao.entities.ConferenceDetailRecordFilter;
import org.restcomm.connect.dao.entities.MediaServerEntity;
import org.restcomm.connect.mgcp.MediaResourceBrokerResponse;
import org.restcomm.connect.mgcp.PowerOnMediaGateway;
import org.restcomm.connect.mrb.ConferenceMediaResourceControllerGeneric;
import org.restcomm.connect.mrb.api.GetConferenceMediaResourceController;
import org.restcomm.connect.mrb.api.GetMediaGateway;
import org.restcomm.connect.mrb.api.MediaGatewayForConference;
import org.restcomm.connect.mrb.api.StartMediaResourceBroker;

public class MediaResourceBrokerGeneric
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private Configuration configuration;
    private DaoManager storage;
    private ClassLoader loader;
    private ActorRef localMediaGateway;
    private String localMsId;
    private Map<String, ActorRef> mediaGatewayMap;
    private JainMgcpStack mgcpStack;
    private JainMgcpProvider mgcpProvider;
    private MediaServerEntity localMediaServerEntity;

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef sender = this.sender();
        ActorRef self = this.self();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** MediaResourceBroker " + this.self().path() + " Processing Message: " + klass.getName());
        }
        if (StartMediaResourceBroker.class.equals(klass)) {
            this.onStartMediaResourceBroker((StartMediaResourceBroker)message, self, sender);
        } else if (GetMediaGateway.class.equals(klass)) {
            this.onGetMediaGateway((GetMediaGateway)message, self, sender);
        } else if (GetConferenceMediaResourceController.class.equals(klass)) {
            sender.tell((Object)new MediaResourceBrokerResponse((Object)this.getConferenceMediaResourceController()), self);
        }
    }

    private void onStartMediaResourceBroker(StartMediaResourceBroker message, ActorRef self, ActorRef sender) throws UnknownHostException {
        this.configuration = message.configuration();
        this.storage = message.storage();
        this.loader = message.loader();
        this.localMediaServerEntity = this.uploadLocalMediaServersInDataBase();
        this.bindMGCPStack(this.localMediaServerEntity.getLocalIpAddress(), this.localMediaServerEntity.getLocalPort());
        this.localMediaGateway = this.turnOnMediaGateway(this.localMediaServerEntity);
        this.mediaGatewayMap = new HashMap<String, ActorRef>();
        this.mediaGatewayMap.put(this.localMediaServerEntity.getMsId() + "", this.localMediaGateway);
    }

    private void bindMGCPStack(String ip, int port) throws UnknownHostException {
        this.mgcpStack = new JainMgcpStackImpl(InetAddress.getByName(ip), port);
        try {
            this.mgcpProvider = this.mgcpStack.createProvider();
        }
        catch (CreateProviderException exception) {
            this.logger.error((Throwable)exception, "Could not create a JAIN MGCP provider.");
        }
    }

    private ActorRef turnOnMediaGateway(MediaServerEntity mediaServerEntity) throws UnknownHostException {
        if (this.logger.isDebugEnabled()) {
            String mgcpServer = this.configuration.getString("mgcp-server[@class]");
            this.logger.debug("Will switch on media gateway: " + mgcpServer);
        }
        ActorRef gateway = this.getContext().system().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                String classpath = MediaResourceBrokerGeneric.this.configuration.getString("mgcp-server[@class]");
                return (UntypedActor)new ObjectFactory(MediaResourceBrokerGeneric.this.loader).getObjectInstance(classpath);
            }
        }));
        PowerOnMediaGateway.Builder builder = PowerOnMediaGateway.builder();
        builder.setName(this.configuration.getString("mgcp-server[@name]"));
        if (this.logger.isInfoEnabled()) {
            this.logger.info("turnOnMediaGateway local ip: " + this.localMediaServerEntity.getLocalIpAddress() + " local port: " + this.localMediaServerEntity.getLocalPort() + " remote ip: " + mediaServerEntity.getRemoteIpAddress() + " remote port: " + mediaServerEntity.getRemotePort());
        }
        builder.setLocalIP(InetAddress.getByName(this.localMediaServerEntity.getLocalIpAddress()));
        builder.setLocalPort(this.localMediaServerEntity.getLocalPort());
        builder.setRemoteIP(InetAddress.getByName(mediaServerEntity.getRemoteIpAddress()));
        builder.setRemotePort(mediaServerEntity.getRemotePort());
        if (mediaServerEntity.getExternalAddress() != null) {
            builder.setExternalIP(InetAddress.getByName(mediaServerEntity.getExternalAddress()));
            builder.setUseNat(true);
        } else {
            builder.setUseNat(false);
        }
        builder.setTimeout(Long.parseLong(mediaServerEntity.getResponseTimeout()));
        builder.setStack(this.mgcpStack);
        builder.setProvider(this.mgcpProvider);
        PowerOnMediaGateway powerOn = builder.build();
        gateway.tell((Object)powerOn, null);
        return gateway;
    }

    private ActorRef getConferenceMediaResourceController() {
        return this.getContext().system().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new ConferenceMediaResourceControllerGeneric(MediaResourceBrokerGeneric.this.localMsId, MediaResourceBrokerGeneric.this.localMediaGateway, MediaResourceBrokerGeneric.this.configuration, MediaResourceBrokerGeneric.this.storage, MediaResourceBrokerGeneric.this.self());
            }
        }));
    }

    private void onGetMediaGateway(GetMediaGateway message, ActorRef self, ActorRef sender) throws Exception {
        String conferenceName = message.conferenceName();
        Sid callSid = message.callSid();
        if (conferenceName == null) {
            this.updateMSIdinCallDetailRecord(this.localMsId, callSid);
            sender.tell((Object)new MediaResourceBrokerResponse((Object)this.localMediaGateway), self);
        } else {
            Sid conferenceSid = this.addConferenceDetailRecord(conferenceName, callSid);
            sender.tell((Object)new MediaResourceBrokerResponse((Object)new MediaGatewayForConference(conferenceSid, this.localMediaGateway, null, false)), self);
        }
    }

    private void updateMSIdinCallDetailRecord(String msId, Sid callSid) {
        if (callSid == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Call Id is not specisfied, it can be an outbound call.");
            }
        } else {
            CallDetailRecordsDao dao = this.storage.getCallDetailRecordsDao();
            CallDetailRecord cdr = dao.getCallDetailRecord(callSid);
            if (cdr != null) {
                cdr = cdr.setMsId(msId);
                dao.updateCallDetailRecord(cdr);
            } else {
                this.logger.warning("provided call id did not found");
            }
        }
    }

    private Sid addConferenceDetailRecord(String conferenceName, Sid callSid) throws Exception {
        Sid sid = null;
        if (conferenceName == null) {
            this.logger.error("provided conference name is null, this can lead to problems in future of this call");
        } else {
            CallDetailRecordsDao callDao = this.storage.getCallDetailRecordsDao();
            CallDetailRecord callRecord = callDao.getCallDetailRecord(callSid);
            if (callRecord != null) {
                String friendlyName;
                String[] cnfNameAndAccount;
                String accountSid;
                ConferenceDetailRecordFilter filter;
                ConferenceDetailRecordsDao dao = this.storage.getConferenceDetailRecordsDao();
                List records = dao.getConferenceDetailRecords(filter = new ConferenceDetailRecordFilter(accountSid = (cnfNameAndAccount = conferenceName.split(":"))[0], "RUNNING%", null, null, friendlyName = cnfNameAndAccount[1], Integer.valueOf(1), Integer.valueOf(0)));
                if (records != null && records.size() > 0) {
                    ConferenceDetailRecord cdr = (ConferenceDetailRecord)records.get(0);
                    sid = cdr.getSid();
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("A conference with same name is running. According to database record. given SID is: " + sid);
                    }
                } else {
                    ConferenceDetailRecord.Builder conferenceBuilder = ConferenceDetailRecord.builder();
                    sid = Sid.generate((Sid.Type)Sid.Type.CONFERENCE);
                    conferenceBuilder.setSid(sid);
                    conferenceBuilder.setDateCreated(DateTime.now());
                    conferenceBuilder.setAccountSid(new Sid(accountSid));
                    conferenceBuilder.setStatus("RUNNING_INITIALIZING");
                    conferenceBuilder.setApiVersion(callRecord.getApiVersion());
                    StringBuilder UriBuffer = new StringBuilder();
                    UriBuffer.append("/").append(callRecord.getApiVersion()).append("/Accounts/").append(accountSid).append("/Conferences/");
                    UriBuffer.append(sid);
                    URI uri = URI.create(UriBuffer.toString());
                    conferenceBuilder.setUri(uri);
                    conferenceBuilder.setFriendlyName(friendlyName);
                    conferenceBuilder.setMasterMsId(this.localMsId);
                    ConferenceDetailRecord cdr = conferenceBuilder.build();
                    dao.addConferenceDetailRecord(cdr);
                    cdr = (ConferenceDetailRecord)dao.getConferenceDetailRecords(filter).get(0);
                    sid = cdr.getSid();
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("addConferenceDetailRecord: SID: " + sid + " NAME: " + conferenceName);
                    }
                }
            } else {
                this.logger.error("call record is null");
            }
        }
        return sid;
    }

    private MediaServerEntity uploadLocalMediaServersInDataBase() {
        String localIpAdressForMediaGateway = this.configuration.getString("mgcp-server.local-address");
        int localPortAdressForMediaGateway = Integer.parseInt(this.configuration.getString("mgcp-server.local-port"));
        String remoteIpAddress = this.configuration.getString("mgcp-server.remote-address");
        int remotePort = Integer.parseInt(this.configuration.getString("mgcp-server.remote-port"));
        String responseTimeout = this.configuration.getString("mgcp-server.response-timeout");
        String externalAddress = this.configuration.getString("mgcp-server.external-address");
        MediaServerEntity.Builder builder = MediaServerEntity.builder();
        builder.setLocalIpAddress(localIpAdressForMediaGateway);
        builder.setLocalPort(localPortAdressForMediaGateway);
        builder.setRemoteIpAddress(remoteIpAddress);
        builder.setRemotePort(remotePort);
        builder.setResponseTimeout(responseTimeout);
        builder.setExternalAddress(externalAddress);
        MediaServersDao dao = this.storage.getMediaServersDao();
        MediaServerEntity mediaServerEntity = builder.build();
        List existingMediaServersForSameIP = dao.getMediaServerEntityByIP(remoteIpAddress);
        if (existingMediaServersForSameIP == null || existingMediaServersForSameIP.size() == 0) {
            dao.addMediaServer(mediaServerEntity);
            List newMediaServerEntity = dao.getMediaServerEntityByIP(remoteIpAddress);
            this.localMsId = ((MediaServerEntity)newMediaServerEntity.get(0)).getMsId() + "";
        } else {
            this.localMsId = ((MediaServerEntity)existingMediaServersForSameIP.get(0)).getMsId() + "";
            mediaServerEntity = mediaServerEntity.setMsId(Integer.parseInt(this.localMsId));
            dao.updateMediaServer(mediaServerEntity);
            if (existingMediaServersForSameIP.size() > 1) {
                this.logger.error("in DB: there are multiple media servers registered for same IP address");
            }
        }
        return mediaServerEntity;
    }

    public void postStop() {
        this.cleanup();
        this.getContext().stop(this.self());
    }

    protected void cleanup() {
    }
}

