/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.mrb.mock;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.restcomm.connect.mgcp.MediaResourceBrokerResponse;
import org.restcomm.connect.mrb.MediaResourceBrokerGeneric;
import org.restcomm.connect.mrb.api.GetConferenceMediaResourceController;
import org.restcomm.connect.mrb.api.GetMediaGateway;
import org.restcomm.connect.mrb.api.StartMediaResourceBroker;

public class MockMediaResourceBroker
extends MediaResourceBrokerGeneric {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));

    public MockMediaResourceBroker() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** MockMediaResourceBroker Constructed.");
        }
    }

    @Override
    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef sender = this.sender();
        ActorRef self = this.self();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** MockMediaResourceBroker " + this.self().path() + " Processing Message: " + klass.getName());
        }
        if (StartMediaResourceBroker.class.equals(klass)) {
            this.onStartMediaResourceBroker((StartMediaResourceBroker)message, self, sender);
        } else if (GetMediaGateway.class.equals(klass)) {
            this.onGetMediaGateway((GetMediaGateway)message, self, sender);
        } else if (GetConferenceMediaResourceController.class.equals(klass)) {
            sender.tell((Object)new MediaResourceBrokerResponse((Object)this.getConferenceMediaResourceController()), self);
        } else if (String.class.equals(klass)) {
            this.testExceptionOnRecieve((String)message, self, sender);
        }
    }

    private void testExceptionOnRecieve(String message, ActorRef self, ActorRef sender) {
        String s = null;
        s.equalsIgnoreCase("blabla");
    }

    @Override
    protected void onStartMediaResourceBroker(StartMediaResourceBroker message, ActorRef self, ActorRef sender) throws UnknownHostException {
        this.configuration = message.configuration();
        this.storage = message.storage();
        this.loader = message.loader();
        this.localMediaServerEntity = this.uploadLocalMediaServersInDataBase();
        this.localMediaGateway = this.turnOnMediaGateway(this.localMediaServerEntity);
        this.mediaGatewayMap = new HashMap();
        this.mediaGatewayMap.put(this.localMediaServerEntity.getMsId() + "", this.localMediaGateway);
    }

    @Override
    public void postStop() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("MRB Mock post stop called");
        }
        super.postStop();
    }
}

