/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.mscontrol.mms;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerConferenceControllerStateChanged;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.mgcp.CreateConferenceEndpoint;
import org.restcomm.connect.mgcp.DestroyEndpoint;
import org.restcomm.connect.mgcp.EndpointState;
import org.restcomm.connect.mgcp.EndpointStateChanged;
import org.restcomm.connect.mgcp.MediaGatewayResponse;
import org.restcomm.connect.mgcp.MediaResourceBrokerResponse;
import org.restcomm.connect.mgcp.MediaSession;
import org.restcomm.connect.mrb.api.ConferenceMediaResourceControllerStateChanged;
import org.restcomm.connect.mrb.api.GetConferenceMediaResourceController;
import org.restcomm.connect.mrb.api.GetMediaGateway;
import org.restcomm.connect.mrb.api.MediaGatewayForConference;
import org.restcomm.connect.mrb.api.StartConferenceMediaResourceController;
import org.restcomm.connect.mrb.api.StopConferenceMediaResourceController;
import org.restcomm.connect.mrb.api.StopConferenceMediaResourceControllerResponse;
import org.restcomm.connect.mscontrol.api.MediaServerController;
import org.restcomm.connect.mscontrol.api.messages.CloseMediaSession;
import org.restcomm.connect.mscontrol.api.messages.CreateMediaSession;
import org.restcomm.connect.mscontrol.api.messages.JoinCall;
import org.restcomm.connect.mscontrol.api.messages.JoinComplete;
import org.restcomm.connect.mscontrol.api.messages.JoinConference;
import org.restcomm.connect.mscontrol.api.messages.MediaServerControllerStateChanged;
import org.restcomm.connect.mscontrol.api.messages.Play;
import org.restcomm.connect.mscontrol.api.messages.StartRecording;
import org.restcomm.connect.mscontrol.api.messages.Stop;
import org.restcomm.connect.mscontrol.api.messages.StopMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.StopRecording;

@Immutable
public final class MmsConferenceController
extends MediaServerController {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State acquiringMediaGateway;
    private final State acquiringCnfMediaResourceController;
    private final State active;
    private final State inactive;
    private final State failed;
    private final State acquiringMediaSession;
    private final State acquiringEndpoint;
    private final State stopping;
    private final State stoppingCMRC;
    private ActorRef mediaGateway;
    private MediaSession mediaSession;
    private ActorRef cnfEndpoint;
    private ActorRef conferenceMediaResourceController;
    private boolean firstJoinSent = false;
    private final List<ActorRef> observers;
    private final ActorRef mrb;
    private String conferenceName;
    private Sid conferenceSid;
    private String conferenceEndpointIdName;
    private ConnectionMode connectionMode;

    public MmsConferenceController(ActorRef mrb) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.acquiringMediaGateway = new State("acquiring media gateway from mrb", (Action)new AcquiringMediaGateway(source), null);
        this.acquiringCnfMediaResourceController = new State("acquiring Cnf Media Resource Controller", (Action)new AcquiringCnfMediaResourceController(source), null);
        this.active = new State("active", (Action)new Active(source), null);
        this.inactive = new State("inactive", (Action)new Inactive(source), null);
        this.failed = new State("failed", (Action)new Failed(source), null);
        this.acquiringMediaSession = new State("acquiring media session", (Action)new AcquiringMediaSession(source), null);
        this.acquiringEndpoint = new State("acquiring endpoint", (Action)new AcquiringEndpoint(source), null);
        this.stoppingCMRC = new State("stopping HA Conference Media Resource Controller", (Action)new StoppingCMRC(source), null);
        this.stopping = new State("stopping", (Action)new Stopping(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.acquiringMediaGateway));
        transitions.add(new Transition(this.acquiringMediaGateway, this.acquiringMediaSession));
        transitions.add(new Transition(this.acquiringMediaSession, this.acquiringEndpoint));
        transitions.add(new Transition(this.acquiringMediaSession, this.inactive));
        transitions.add(new Transition(this.acquiringEndpoint, this.acquiringCnfMediaResourceController));
        transitions.add(new Transition(this.acquiringEndpoint, this.inactive));
        transitions.add(new Transition(this.acquiringCnfMediaResourceController, this.active));
        transitions.add(new Transition(this.acquiringCnfMediaResourceController, this.stoppingCMRC));
        transitions.add(new Transition(this.acquiringCnfMediaResourceController, this.failed));
        transitions.add(new Transition(this.active, this.stoppingCMRC));
        transitions.add(new Transition(this.stoppingCMRC, this.stopping));
        transitions.add(new Transition(this.stoppingCMRC, this.inactive));
        transitions.add(new Transition(this.stopping, this.inactive));
        transitions.add(new Transition(this.stopping, this.failed));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.mrb = mrb;
        this.observers = new ArrayList<ActorRef>(2);
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(Object message) {
        if (!this.observers.isEmpty()) {
            ActorRef self = this.self();
            List<ActorRef> list = this.observers;
            synchronized (list) {
                for (ActorRef observer : this.observers) {
                    observer.tell(message, self);
                }
            }
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef sender = this.sender();
        ActorRef self = this.self();
        State state = this.fsm.state();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** Conference Controller Current State: " + state.toString());
            this.logger.info(" ********** Conference Controller Processing Message: " + klass.getName());
        }
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (CreateMediaSession.class.equals(klass)) {
            this.onCreateMediaSession((CreateMediaSession)message, self, sender);
        } else if (CloseMediaSession.class.equals(klass)) {
            this.onCloseMediaSession((CloseMediaSession)message, self, sender);
        } else if (MediaGatewayResponse.class.equals(klass)) {
            this.onMediaGatewayResponse((MediaGatewayResponse)message, self, sender);
        } else if (Stop.class.equals(klass)) {
            this.onStop((Stop)message, self, sender);
        } else if (JoinCall.class.equals(klass)) {
            this.onJoinCall((JoinCall)message, self, sender);
        } else if (Play.class.equals(klass) || StartRecording.class.equals(klass) || StopRecording.class.equals(klass) || StopMediaGroup.class.equals(klass)) {
            this.conferenceMediaResourceController.tell(message, sender);
        } else if (EndpointStateChanged.class.equals(klass)) {
            this.onEndpointStateChanged((EndpointStateChanged)message, self, sender);
        } else if (MediaResourceBrokerResponse.class.equals(klass)) {
            this.onMediaResourceBrokerResponse((MediaResourceBrokerResponse)message, self, sender);
        } else if (StopConferenceMediaResourceControllerResponse.class.equals(klass)) {
            this.fsm.transition(message, this.stopping);
        } else if (JoinComplete.class.equals(klass)) {
            this.onJoinComplete((JoinComplete)message, self, sender);
        } else if (ConferenceMediaResourceControllerStateChanged.class.equals(klass)) {
            this.onConferenceMediaResourceControllerStateChanged((ConferenceMediaResourceControllerStateChanged)message, self, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private void onJoinComplete(JoinComplete message, ActorRef self, ActorRef sender) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("got JoinComplete in conference controller");
        }
        if (!this.firstJoinSent) {
            this.firstJoinSent = true;
            this.conferenceMediaResourceController.tell((Object)message, self);
        }
    }

    private void onMediaResourceBrokerResponse(MediaResourceBrokerResponse<?> message, ActorRef self, ActorRef sender) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("got MRB response in conference controller");
        }
        if (this.is(this.acquiringMediaGateway)) {
            MediaGatewayForConference mgc = (MediaGatewayForConference)message.get();
            this.mediaGateway = mgc.mediaGateway();
            this.conferenceSid = mgc.conferenceSid();
            String string = this.conferenceEndpointIdName = mgc.isThisMaster() ? mgc.masterConfernceEndpointIdName() : null;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("onMediaResourceBrokerResponse: " + mgc.toString());
            }
            this.fsm.transition(message, this.acquiringMediaSession);
        } else if (this.is(this.acquiringCnfMediaResourceController)) {
            this.conferenceMediaResourceController = (ActorRef)message.get();
            this.conferenceMediaResourceController.tell((Object)new Observe(self), self);
            this.conferenceMediaResourceController.tell((Object)new StartConferenceMediaResourceController(this.cnfEndpoint, this.conferenceSid), self);
        }
    }

    private void onConferenceMediaResourceControllerStateChanged(ConferenceMediaResourceControllerStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("onConferenceMediaResourceControllerStateChanged: " + message.state());
        }
        switch (message.state()) {
            case ACTIVE: {
                if (!this.is(this.acquiringCnfMediaResourceController)) break;
                this.fsm.transition((Object)message, this.active);
                break;
            }
            case FAILED: {
                this.fsm.transition((Object)message, this.failed);
                break;
            }
            case INACTIVE: {
                break;
            }
        }
    }

    private void onCreateMediaSession(CreateMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.fsm.transition((Object)message, this.acquiringMediaGateway);
        }
    }

    private void onCloseMediaSession(CloseMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active)) {
            this.fsm.transition((Object)message, this.inactive);
        } else {
            this.fsm.transition((Object)message, this.stoppingCMRC);
        }
    }

    private void onStop(Stop message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.acquiringMediaSession) || this.is(this.acquiringEndpoint)) {
            this.fsm.transition((Object)message, this.inactive);
        } else if (this.is(this.acquiringCnfMediaResourceController) || this.is(this.active)) {
            this.fsm.transition((Object)message, this.stoppingCMRC);
        }
    }

    private void onMediaGatewayResponse(MediaGatewayResponse<?> message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.acquiringMediaSession)) {
            this.mediaSession = (MediaSession)message.get();
            this.fsm.transition(message, this.acquiringEndpoint);
        } else if (this.is(this.acquiringEndpoint)) {
            this.cnfEndpoint = (ActorRef)message.get();
            this.cnfEndpoint.tell((Object)new Observe(self), self);
            this.fsm.transition(message, this.acquiringCnfMediaResourceController);
        }
    }

    private void onJoinCall(JoinCall message, ActorRef self, ActorRef sender) {
        this.connectionMode = message.getConnectionMode();
        JoinConference join = new JoinConference((Object)this.cnfEndpoint, this.connectionMode);
        message.getCall().tell((Object)join, sender);
    }

    private void onEndpointStateChanged(EndpointStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.stopping) && sender.equals((Object)this.cnfEndpoint) && EndpointState.DESTROYED.equals((Object)message.getState())) {
            this.cnfEndpoint.tell((Object)new StopObserving(self), self);
            this.context().stop(this.cnfEndpoint);
            this.cnfEndpoint = null;
            if (this.cnfEndpoint == null) {
                this.fsm.transition((Object)message, this.inactive);
            }
        }
    }

    private final class Failed
    extends FinalState {
        public Failed(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.FAILED);
        }
    }

    private final class Inactive
    extends FinalState {
        public Inactive(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.INACTIVE);
        }
    }

    private abstract class FinalState
    extends AbstractAction {
        private final MediaServerControllerStateChanged.MediaServerControllerState state;

        public FinalState(ActorRef source, MediaServerControllerStateChanged.MediaServerControllerState state) {
            super(source);
            this.state = state;
        }

        public void execute(Object message) throws Exception {
            if (MmsConferenceController.this.cnfEndpoint != null) {
                MmsConferenceController.this.mediaGateway.tell((Object)new DestroyEndpoint(MmsConferenceController.this.cnfEndpoint), this.source);
                MmsConferenceController.this.cnfEndpoint = null;
            }
            MmsConferenceController.this.broadcast(new MediaServerConferenceControllerStateChanged(this.state, MmsConferenceController.this.conferenceSid));
            MmsConferenceController.this.observers.clear();
            MmsConferenceController.this.getContext().stop(this.source);
        }
    }

    private final class Stopping
    extends AbstractAction {
        public Stopping(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            StopConferenceMediaResourceControllerResponse response = (StopConferenceMediaResourceControllerResponse)message;
            if (response.distroyEndpoint()) {
                MmsConferenceController.this.cnfEndpoint.tell((Object)new DestroyEndpoint(), this.source);
            } else {
                if (MmsConferenceController.this.logger.isInfoEnabled()) {
                    MmsConferenceController.this.logger.info("CMRC have ask you not to destroy endpoint bcz master have left firt and other slaves are still connected to this conference endpoint");
                }
                MmsConferenceController.this.cnfEndpoint.tell((Object)new StopObserving(MmsConferenceController.this.self()), MmsConferenceController.this.self());
                MmsConferenceController.this.context().stop(MmsConferenceController.this.cnfEndpoint);
                MmsConferenceController.this.cnfEndpoint = null;
                if (MmsConferenceController.this.cnfEndpoint == null) {
                    MmsConferenceController.this.fsm.transition(message, MmsConferenceController.this.inactive);
                }
            }
        }
    }

    private final class StoppingCMRC
    extends AbstractAction {
        public StoppingCMRC(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (MmsConferenceController.this.logger.isInfoEnabled()) {
                MmsConferenceController.this.logger.info("StoppingCMRC");
            }
            MmsConferenceController.this.conferenceMediaResourceController.tell((Object)new StopConferenceMediaResourceController(), this.source);
        }
    }

    private final class Active
    extends AbstractAction {
        public Active(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            ConferenceMediaResourceControllerStateChanged msg = (ConferenceMediaResourceControllerStateChanged)message;
            MmsConferenceController.this.broadcast(new MediaServerConferenceControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.ACTIVE, MmsConferenceController.this.conferenceSid, msg.conferenceState()));
        }
    }

    private final class AcquiringEndpoint
    extends AbstractAction {
        public AcquiringEndpoint(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MmsConferenceController.this.mediaGateway.tell((Object)new CreateConferenceEndpoint(MmsConferenceController.this.mediaSession, MmsConferenceController.this.conferenceEndpointIdName), this.source);
        }
    }

    private final class AcquiringMediaSession
    extends AbstractAction {
        public AcquiringMediaSession(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MmsConferenceController.this.mediaGateway.tell((Object)new org.restcomm.connect.mgcp.CreateMediaSession(), this.source);
        }
    }

    private final class AcquiringCnfMediaResourceController
    extends AbstractAction {
        public AcquiringCnfMediaResourceController(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (MmsConferenceController.this.logger.isInfoEnabled()) {
                MmsConferenceController.this.logger.info("MMSConferenceController: GettingCnfMediaResourceController: conferenceName = " + MmsConferenceController.this.conferenceName + " conferenceSid: " + MmsConferenceController.this.conferenceSid + " cnfenpointID: " + MmsConferenceController.this.cnfEndpoint);
            }
            MmsConferenceController.this.mrb.tell((Object)new GetConferenceMediaResourceController(MmsConferenceController.this.conferenceName), MmsConferenceController.this.self());
        }
    }

    private final class AcquiringMediaGateway
    extends AbstractAction {
        public AcquiringMediaGateway(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            CreateMediaSession createMediaSession = (CreateMediaSession)message;
            String conferenceName = createMediaSession.conferenceName();
            MmsConferenceController.this.mrb.tell((Object)new GetMediaGateway(createMediaSession.callSid(), conferenceName, null), MmsConferenceController.this.self());
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

