/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.mscontrol.mms;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActorFactory;
import org.restcomm.connect.mscontrol.api.MediaServerControllerFactory;
import org.restcomm.connect.mscontrol.mms.MmsBridgeController;
import org.restcomm.connect.mscontrol.mms.MmsCallController;
import org.restcomm.connect.mscontrol.mms.MmsConferenceController;

public class MmsControllerFactory
implements MediaServerControllerFactory {
    private final ActorSystem system;
    private final CallControllerFactory callControllerFactory;
    private final ConferenceControllerFactory conferenceControllerFactory;
    private final BridgeControllerFactory bridgeControllerFactory;
    private final ActorRef mrb;

    public MmsControllerFactory(ActorSystem system, ActorRef mrb) {
        this.system = system;
        this.callControllerFactory = new CallControllerFactory();
        this.conferenceControllerFactory = new ConferenceControllerFactory();
        this.bridgeControllerFactory = new BridgeControllerFactory();
        this.mrb = mrb;
    }

    public ActorRef provideCallController() {
        return this.system.actorOf(new Props((UntypedActorFactory)this.callControllerFactory));
    }

    public ActorRef provideConferenceController() {
        return this.system.actorOf(new Props((UntypedActorFactory)this.conferenceControllerFactory));
    }

    public ActorRef provideBridgeController() {
        return this.system.actorOf(new Props((UntypedActorFactory)this.bridgeControllerFactory));
    }

    private final class BridgeControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = 8999152285760508857L;

        private BridgeControllerFactory() {
        }

        public Actor create() throws Exception {
            return new MmsBridgeController(MmsControllerFactory.this.mrb);
        }
    }

    private final class ConferenceControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = -919317656354678281L;

        private ConferenceControllerFactory() {
        }

        public Actor create() throws Exception {
            return new MmsConferenceController(MmsControllerFactory.this.mrb);
        }
    }

    private final class CallControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = -4649683839304615853L;

        private CallControllerFactory() {
        }

        public Actor create() throws Exception {
            return new MmsCallController(MmsControllerFactory.this.mrb);
        }
    }
}

