/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.mscontrol.mms;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.commons.util.WavUtils;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.RecordingsDao;
import org.restcomm.connect.dao.entities.Recording;
import org.restcomm.connect.mgcp.CloseConnection;
import org.restcomm.connect.mgcp.CloseLink;
import org.restcomm.connect.mgcp.ConnectionStateChanged;
import org.restcomm.connect.mgcp.CreateBridgeEndpoint;
import org.restcomm.connect.mgcp.CreateConnection;
import org.restcomm.connect.mgcp.CreateLink;
import org.restcomm.connect.mgcp.DestroyEndpoint;
import org.restcomm.connect.mgcp.DestroyLink;
import org.restcomm.connect.mgcp.EndpointState;
import org.restcomm.connect.mgcp.EndpointStateChanged;
import org.restcomm.connect.mgcp.GetMediaGatewayInfo;
import org.restcomm.connect.mgcp.InitializeConnection;
import org.restcomm.connect.mgcp.InitializeLink;
import org.restcomm.connect.mgcp.LinkStateChanged;
import org.restcomm.connect.mgcp.MediaGatewayInfo;
import org.restcomm.connect.mgcp.MediaGatewayResponse;
import org.restcomm.connect.mgcp.MediaResourceBrokerResponse;
import org.restcomm.connect.mgcp.MediaSession;
import org.restcomm.connect.mgcp.OpenConnection;
import org.restcomm.connect.mgcp.OpenLink;
import org.restcomm.connect.mgcp.UpdateConnection;
import org.restcomm.connect.mgcp.UpdateLink;
import org.restcomm.connect.mrb.api.GetMediaGateway;
import org.restcomm.connect.mscontrol.api.MediaServerController;
import org.restcomm.connect.mscontrol.api.messages.CloseMediaSession;
import org.restcomm.connect.mscontrol.api.messages.Collect;
import org.restcomm.connect.mscontrol.api.messages.CreateMediaSession;
import org.restcomm.connect.mscontrol.api.messages.JoinBridge;
import org.restcomm.connect.mscontrol.api.messages.JoinComplete;
import org.restcomm.connect.mscontrol.api.messages.JoinConference;
import org.restcomm.connect.mscontrol.api.messages.Leave;
import org.restcomm.connect.mscontrol.api.messages.Left;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupStateChanged;
import org.restcomm.connect.mscontrol.api.messages.MediaServerControllerStateChanged;
import org.restcomm.connect.mscontrol.api.messages.MediaSessionInfo;
import org.restcomm.connect.mscontrol.api.messages.Mute;
import org.restcomm.connect.mscontrol.api.messages.Play;
import org.restcomm.connect.mscontrol.api.messages.Record;
import org.restcomm.connect.mscontrol.api.messages.StartMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.StartRecording;
import org.restcomm.connect.mscontrol.api.messages.Stop;
import org.restcomm.connect.mscontrol.api.messages.StopMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.StopRecording;
import org.restcomm.connect.mscontrol.api.messages.Unmute;
import org.restcomm.connect.mscontrol.api.messages.UpdateMediaSession;
import org.restcomm.connect.mscontrol.mms.MgcpMediaGroup;

public class MmsCallController
extends MediaServerController {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State acquiringMediaGateway;
    private final State acquiringMediaGatewayInfo;
    private final State acquiringMediaSession;
    private final State acquiringBridge;
    private final State creatingMediaGroup;
    private final State acquiringRemoteConnection;
    private final State initializingRemoteConnection;
    private final State openingRemoteConnection;
    private final State updatingRemoteConnection;
    private final State pending;
    private final State active;
    private final State muting;
    private final State unmuting;
    private final State acquiringInternalLink;
    private final State initializingInternalLink;
    private final State openingInternalLink;
    private final State updatingInternalLink;
    private final State closingInternalLink;
    private final State closingRemoteConnection;
    private final State stopping;
    private final State failed;
    private final State inactive;
    private ActorRef call;
    private Sid callId;
    private String localSdp;
    private String remoteSdp;
    private String connectionMode;
    private boolean callOutbound;
    private boolean webrtc;
    private ActorRef mediaGroup;
    private ActorRef bridge;
    private ActorRef outboundCallBridgeEndpoint;
    private ActorRef mediaGateway;
    private final ActorRef mrb;
    private MediaGatewayInfo gatewayInfo;
    private MediaSession session;
    private ActorRef bridgeEndpoint;
    private ActorRef remoteConn;
    private ActorRef internalLink;
    private ActorRef internalLinkEndpoint;
    private ConnectionMode internalLinkMode;
    private Sid accountId;
    private Sid recordingSid;
    private URI recordingUri;
    private Boolean recording = false;
    private DateTime recordStarted;
    private DaoManager daoManager;
    private Boolean collecting = false;
    private Configuration runtimeSettings;
    private final List<ActorRef> observers;
    private ConnectionIdentifier connectionIdentifier;

    public MmsCallController(ActorRef mrb) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.acquiringMediaGateway = new State("acquiring media gateway from mrb", (Action)new AcquiringMediaGateway(source), null);
        this.acquiringMediaGatewayInfo = new State("acquiring media gateway info", (Action)new AcquiringMediaGatewayInfo(source), null);
        this.acquiringMediaSession = new State("acquiring media session", (Action)new AcquiringMediaSession(source), null);
        this.acquiringBridge = new State("acquiring media bridge", (Action)new AcquiringBridge(source), null);
        this.creatingMediaGroup = new State("creating media group", (Action)new CreatingMediaGroup(source), null);
        this.acquiringRemoteConnection = new State("acquiring connection", (Action)new AcquiringRemoteConnection(source), null);
        this.initializingRemoteConnection = new State("initializing connection", (Action)new InitializingRemoteConnection(source), null);
        this.openingRemoteConnection = new State("opening connection", (Action)new OpeningRemoteConnection(source), null);
        this.updatingRemoteConnection = new State("updating connection", (Action)new UpdatingRemoteConnection(source), null);
        this.pending = new State("pending", (Action)new Pending(source), null);
        this.active = new State("active", (Action)new Active(source), null);
        this.muting = new State("muting", (Action)new Muting(source), null);
        this.unmuting = new State("unmuting", (Action)new Unmuting(source), null);
        this.acquiringInternalLink = new State("acquiring link", (Action)new AcquiringInternalLink(source), null);
        this.initializingInternalLink = new State("initializing link", (Action)new InitializingInternalLink(source), null);
        this.openingInternalLink = new State("opening link", (Action)new OpeningInternalLink(source), null);
        this.updatingInternalLink = new State("updating link", (Action)new UpdatingInternalLink(source), null);
        this.closingInternalLink = new State("closing link", (Action)new EnterClosingInternalLink(source), (Action)new ExitClosingInternalLink(source));
        this.closingRemoteConnection = new State("closing connection", (Action)new ClosingRemoteConnection(source), null);
        this.stopping = new State("stopping", (Action)new Stopping(source));
        this.inactive = new State("inactive", (Action)new Inactive(source));
        this.failed = new State("failed", (Action)new Failed(source));
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.acquiringMediaGateway));
        transitions.add(new Transition(this.acquiringMediaGateway, this.acquiringMediaGatewayInfo));
        transitions.add(new Transition(this.uninitialized, this.closingRemoteConnection));
        transitions.add(new Transition(this.acquiringMediaGatewayInfo, this.acquiringMediaSession));
        transitions.add(new Transition(this.acquiringMediaSession, this.acquiringBridge));
        transitions.add(new Transition(this.acquiringMediaSession, this.stopping));
        transitions.add(new Transition(this.acquiringBridge, this.creatingMediaGroup));
        transitions.add(new Transition(this.acquiringBridge, this.stopping));
        transitions.add(new Transition(this.creatingMediaGroup, this.acquiringRemoteConnection));
        transitions.add(new Transition(this.creatingMediaGroup, this.stopping));
        transitions.add(new Transition(this.creatingMediaGroup, this.failed));
        transitions.add(new Transition(this.acquiringRemoteConnection, this.initializingRemoteConnection));
        transitions.add(new Transition(this.initializingRemoteConnection, this.openingRemoteConnection));
        transitions.add(new Transition(this.openingRemoteConnection, this.active));
        transitions.add(new Transition(this.openingRemoteConnection, this.failed));
        transitions.add(new Transition(this.openingRemoteConnection, this.pending));
        transitions.add(new Transition(this.active, this.muting));
        transitions.add(new Transition(this.active, this.unmuting));
        transitions.add(new Transition(this.active, this.updatingRemoteConnection));
        transitions.add(new Transition(this.active, this.stopping));
        transitions.add(new Transition(this.active, this.acquiringInternalLink));
        transitions.add(new Transition(this.active, this.closingInternalLink));
        transitions.add(new Transition(this.active, this.creatingMediaGroup));
        transitions.add(new Transition(this.pending, this.active));
        transitions.add(new Transition(this.pending, this.failed));
        transitions.add(new Transition(this.pending, this.updatingRemoteConnection));
        transitions.add(new Transition(this.pending, this.stopping));
        transitions.add(new Transition(this.muting, this.active));
        transitions.add(new Transition(this.muting, this.closingRemoteConnection));
        transitions.add(new Transition(this.unmuting, this.active));
        transitions.add(new Transition(this.unmuting, this.closingRemoteConnection));
        transitions.add(new Transition(this.updatingRemoteConnection, this.active));
        transitions.add(new Transition(this.updatingRemoteConnection, this.stopping));
        transitions.add(new Transition(this.updatingRemoteConnection, this.failed));
        transitions.add(new Transition(this.closingRemoteConnection, this.inactive));
        transitions.add(new Transition(this.closingRemoteConnection, this.closingInternalLink));
        transitions.add(new Transition(this.acquiringInternalLink, this.closingRemoteConnection));
        transitions.add(new Transition(this.acquiringInternalLink, this.initializingInternalLink));
        transitions.add(new Transition(this.initializingInternalLink, this.closingRemoteConnection));
        transitions.add(new Transition(this.initializingInternalLink, this.openingInternalLink));
        transitions.add(new Transition(this.openingInternalLink, this.stopping));
        transitions.add(new Transition(this.openingInternalLink, this.updatingInternalLink));
        transitions.add(new Transition(this.updatingInternalLink, this.stopping));
        transitions.add(new Transition(this.updatingInternalLink, this.closingInternalLink));
        transitions.add(new Transition(this.updatingInternalLink, this.active));
        transitions.add(new Transition(this.closingInternalLink, this.closingRemoteConnection));
        transitions.add(new Transition(this.closingInternalLink, this.active));
        transitions.add(new Transition(this.closingInternalLink, this.inactive));
        transitions.add(new Transition(this.stopping, this.inactive));
        transitions.add(new Transition(this.stopping, this.failed));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.mrb = mrb;
        this.localSdp = "";
        this.remoteSdp = "";
        this.callOutbound = false;
        this.connectionMode = "inactive";
        this.webrtc = false;
        this.observers = new ArrayList<ActorRef>(1);
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    private void broadcast(Object message) {
        if (!this.observers.isEmpty()) {
            ActorRef self = this.self();
            for (ActorRef observer : this.observers) {
                observer.tell(message, self);
            }
        }
    }

    private ActorRef createMediaGroup(Object message) {
        if (this.mediaGroup != null && !this.mediaGroup.isTerminated()) {
            return this.mediaGroup;
        }
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new MgcpMediaGroup(MmsCallController.this.mediaGateway, MmsCallController.this.session, MmsCallController.this.bridgeEndpoint);
            }
        }));
    }

    private void startRecordingCall() throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Start recording call");
        }
        String finishOnKey = "1234567890*#";
        int maxLength = 3600;
        int timeout = 5;
        this.recordStarted = DateTime.now();
        this.recording = true;
        Record record = new Record(this.recordingUri, timeout, maxLength, finishOnKey);
        this.mediaGroup.tell((Object)record, null);
    }

    private void stopCollect(Stop message) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Stop DTMF collect");
        }
        if (this.mediaGroup != null) {
            this.mediaGroup.tell((Object)message, null);
        }
        this.collecting = false;
    }

    private void stopRecordingCall(Stop message) throws Exception {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Stop recording call");
        }
        if (this.mediaGroup != null) {
            this.mediaGroup.tell((Object)message, null);
            this.recording = false;
            if (message.createRecord() && this.recordingUri != null) {
                Double duration;
                try {
                    duration = WavUtils.getAudioDuration((URI)this.recordingUri);
                }
                catch (IOException | UnsupportedAudioFileException e) {
                    this.logger.error("Could not measure recording duration: " + e.getMessage(), (Object)e);
                    duration = 0.0;
                }
                if (duration.equals(0.0)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Call wraping up recording. File doesn't exist since duration is 0");
                    }
                    DateTime end = DateTime.now();
                    duration = new Double((end.getMillis() - this.recordStarted.getMillis()) / 1000L);
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info("Call wraping up recording. File already exists, length: " + new File(this.recordingUri).length());
                }
                Recording.Builder builder = Recording.builder();
                builder.setSid(this.recordingSid);
                builder.setAccountSid(this.accountId);
                builder.setCallSid(this.callId);
                builder.setDuration(duration.doubleValue());
                builder.setApiVersion(this.runtimeSettings.getString("api-version"));
                StringBuilder buffer = new StringBuilder();
                buffer.append("/").append(this.runtimeSettings.getString("api-version")).append("/Accounts/").append(this.accountId.toString());
                buffer.append("/Recordings/").append(this.recordingSid.toString());
                builder.setUri(URI.create(buffer.toString()));
                Recording recording = builder.build();
                RecordingsDao recordsDao = this.daoManager.getRecordingsDao();
                recordsDao.addRecording(recording);
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Tried to stop recording but group was null.");
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        State state = this.fsm.state();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("********** MmsCallController Current State: \"" + state.toString());
            this.logger.info("********** MmsCallController Processing Message: \"" + klass.getName() + " sender : " + sender.getClass());
        }
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (CreateMediaSession.class.equals(klass)) {
            this.onCreateMediaSession((CreateMediaSession)message, self, sender);
        } else if (CloseMediaSession.class.equals(klass)) {
            this.onCloseMediaSession((CloseMediaSession)message, self, sender);
        } else if (UpdateMediaSession.class.equals(klass)) {
            this.onUpdateMediaSession((UpdateMediaSession)message, self, sender);
        } else if (MediaGatewayResponse.class.equals(klass)) {
            this.onMediaGatewayResponse((MediaGatewayResponse)message, self, sender);
        } else if (ConnectionStateChanged.class.equals(klass)) {
            this.onConnectionStateChanged((ConnectionStateChanged)message, self, sender);
        } else if (LinkStateChanged.class.equals(klass)) {
            this.onLinkStateChanged((LinkStateChanged)message, self, sender);
        } else if (Leave.class.equals(klass)) {
            this.onLeave((Leave)message, self, sender);
        } else if (Mute.class.equals(klass)) {
            this.onMute((Mute)message, self, sender);
        } else if (Unmute.class.equals(klass)) {
            this.onUnmute((Unmute)message, self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecordingCall((StartRecording)message, self, sender);
        } else if (StopRecording.class.equals(klass)) {
            this.onStopRecordingCall((StopRecording)message, self, sender);
        } else if (Stop.class.equals(klass)) {
            this.onStop((Stop)message, self, sender);
        } else if (StopMediaGroup.class.equals(klass)) {
            this.onStopMediaGroup((StopMediaGroup)message, self, sender);
        } else if (JoinConference.class.equals(klass)) {
            this.onJoinConference((JoinConference)message, self, sender);
        } else if (JoinBridge.class.equals(klass)) {
            this.onJoinBridge((JoinBridge)message, self, sender);
        } else if (Leave.class.equals(klass)) {
            this.onLeave((Leave)message, self, sender);
        } else if (MediaGroupStateChanged.class.equals(klass)) {
            this.onMediaGroupStateChanged((MediaGroupStateChanged)message, self, sender);
        } else if (Record.class.equals(klass)) {
            this.onRecord((Record)message, self, sender);
        } else if (Play.class.equals(klass)) {
            this.onPlay((Play)message, self, sender);
        } else if (Collect.class.equals(klass)) {
            this.onCollect((Collect)message, self, sender);
        } else if (EndpointStateChanged.class.equals(klass)) {
            this.onEndpointStateChanged((EndpointStateChanged)message, self, sender);
        } else if (MediaResourceBrokerResponse.class.equals(klass)) {
            this.onMediaResourceBrokerResponse((MediaResourceBrokerResponse)message, self, sender);
        }
    }

    private void onMediaResourceBrokerResponse(MediaResourceBrokerResponse<?> message, ActorRef self, ActorRef sender) throws Exception {
        this.mediaGateway = (ActorRef)message.get();
        this.fsm.transition(message, this.acquiringMediaGatewayInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private void onCreateMediaSession(CreateMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        this.call = sender;
        this.connectionMode = message.getConnectionMode();
        this.callOutbound = message.isOutbound();
        this.remoteSdp = message.getSessionDescription();
        this.webrtc = message.isWebrtc();
        this.callId = message.callSid();
        this.fsm.transition((Object)message, this.acquiringMediaGateway);
    }

    private void onCloseMediaSession(CloseMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.pending) || this.is(this.updatingRemoteConnection) || this.is(this.active) || this.is(this.acquiringInternalLink) || this.is(this.updatingInternalLink) || this.is(this.creatingMediaGroup) || this.is(this.acquiringBridge) || this.is(this.acquiringMediaSession)) {
            this.fsm.transition((Object)message, this.stopping);
        }
    }

    private void onUpdateMediaSession(UpdateMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        this.remoteSdp = message.getSessionDescription();
        this.fsm.transition((Object)message, this.updatingRemoteConnection);
    }

    private void onMediaGatewayResponse(MediaGatewayResponse<?> message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.acquiringMediaGatewayInfo)) {
            this.fsm.transition(message, this.acquiringMediaSession);
        } else if (this.is(this.acquiringMediaSession)) {
            this.fsm.transition(message, this.acquiringBridge);
        } else if (this.is(this.acquiringBridge)) {
            this.bridgeEndpoint = (ActorRef)message.get();
            this.bridgeEndpoint.tell((Object)new Observe(self), self);
            this.fsm.transition(message, this.creatingMediaGroup);
        } else if (this.is(this.acquiringRemoteConnection)) {
            this.fsm.transition(message, this.initializingRemoteConnection);
        } else if (this.is(this.acquiringInternalLink)) {
            this.fsm.transition(message, this.initializingInternalLink);
        }
    }

    private void onConnectionStateChanged(ConnectionStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        switch (message.state()) {
            case CLOSED: {
                if (this.is(this.initializingRemoteConnection)) {
                    this.fsm.transition((Object)message, this.openingRemoteConnection);
                    break;
                }
                if (this.is(this.openingRemoteConnection)) {
                    this.fsm.transition((Object)message, this.failed);
                    break;
                }
                if (this.is(this.muting) || this.is(this.unmuting)) {
                    this.fsm.transition((Object)message, this.closingRemoteConnection);
                    break;
                }
                if (this.is(this.closingRemoteConnection)) {
                    this.remoteConn = null;
                    if (this.internalLink != null) {
                        this.fsm.transition((Object)message, this.closingInternalLink);
                        break;
                    }
                    this.fsm.transition((Object)message, this.inactive);
                    break;
                }
                if (!this.is(this.updatingRemoteConnection)) break;
                this.fsm.transition((Object)message, this.failed);
                break;
            }
            case HALF_OPEN: {
                this.fsm.transition((Object)message, this.pending);
                break;
            }
            case OPEN: {
                this.fsm.transition((Object)message, this.active);
                break;
            }
        }
    }

    private void onLinkStateChanged(LinkStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        switch (message.state()) {
            case CLOSED: {
                if (this.is(this.initializingInternalLink)) {
                    this.fsm.transition((Object)message, this.openingInternalLink);
                    break;
                }
                if (this.is(this.openingInternalLink)) {
                    this.fsm.transition((Object)message, this.stopping);
                    break;
                }
                if (!this.is(this.closingInternalLink)) break;
                if (this.remoteConn != null) {
                    this.fsm.transition((Object)message, this.active);
                    break;
                }
                this.fsm.transition((Object)message, this.inactive);
                break;
            }
            case OPEN: {
                if (this.is(this.openingInternalLink)) {
                    this.fsm.transition((Object)message, this.updatingInternalLink);
                    break;
                }
                if (!this.is(this.updatingInternalLink)) break;
                this.fsm.transition((Object)message, this.active);
                break;
            }
        }
    }

    private void onMute(Mute message, ActorRef self, ActorRef sender) throws Exception {
        this.fsm.transition((Object)message, this.muting);
    }

    private void onUnmute(Unmute message, ActorRef self, ActorRef sender) throws Exception {
        this.fsm.transition((Object)message, this.unmuting);
    }

    private void onStartRecordingCall(StartRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.runtimeSettings == null) {
            this.runtimeSettings = message.getRuntimeSetting();
        }
        if (this.daoManager == null) {
            this.daoManager = message.getDaoManager();
        }
        if (this.accountId == null) {
            this.accountId = message.getAccountId();
        }
        this.callId = message.getCallId();
        this.recordingSid = message.getRecordingSid();
        this.recordingUri = message.getRecordingUri();
        this.recording = true;
        this.startRecordingCall();
    }

    private void onStopRecordingCall(StopRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.recording.booleanValue()) {
            if (this.runtimeSettings == null) {
                this.runtimeSettings = message.getRuntimeSetting();
            }
            if (this.daoManager == null) {
                this.daoManager = message.getDaoManager();
            }
            if (this.accountId == null) {
                this.accountId = message.getAccountId();
            }
            this.onStop(new Stop(false), self, sender);
        }
    }

    private void onStop(Stop message, ActorRef self, ActorRef sender) throws Exception {
        if (this.recording.booleanValue()) {
            this.stopRecordingCall(message);
        } else if (this.collecting.booleanValue()) {
            this.stopCollect(message);
        }
    }

    private void onStopMediaGroup(StopMediaGroup message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active) && this.mediaGroup != null) {
            this.mediaGroup.tell((Object)new Stop(), sender);
        }
    }

    private void onLeave(Leave message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.active) && this.internalLinkEndpoint != null || this.is(this.updatingInternalLink)) {
            this.fsm.transition((Object)message, this.closingInternalLink);
        }
    }

    private void onJoinBridge(JoinBridge message, ActorRef self, ActorRef sender) throws Exception {
        this.bridge = sender;
        this.internalLinkEndpoint = (ActorRef)message.getEndpoint();
        this.internalLinkMode = message.getConnectionMode();
        this.fsm.transition((Object)message, this.acquiringInternalLink);
    }

    private void onJoinConference(JoinConference message, ActorRef self, ActorRef sender) throws Exception {
        this.bridge = sender;
        this.internalLinkEndpoint = (ActorRef)message.getEndpoint();
        this.internalLinkMode = message.getConnectionMode();
        this.fsm.transition((Object)message, this.acquiringInternalLink);
    }

    private void onMediaGroupStateChanged(MediaGroupStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        switch (message.state()) {
            case ACTIVE: {
                if (!this.is(this.creatingMediaGroup)) break;
                this.fsm.transition((Object)message, this.acquiringRemoteConnection);
                break;
            }
            case INACTIVE: {
                if (this.is(this.creatingMediaGroup)) {
                    this.fsm.transition((Object)message, this.failed);
                    break;
                }
                if (!this.is(this.stopping)) break;
                this.mediaGroup.tell((Object)new StopObserving(self), self);
                this.context().stop(this.mediaGroup);
                this.mediaGroup = null;
                if (this.mediaGroup != null || this.bridgeEndpoint != null) break;
                this.fsm.transition((Object)message, this.inactive);
                break;
            }
        }
    }

    private void onRecord(Record message, ActorRef self, ActorRef sender) {
        if (this.is(this.active)) {
            this.recording = Boolean.TRUE;
            this.mediaGroup.tell((Object)message, sender);
        }
    }

    private void onPlay(Play message, ActorRef self, ActorRef sender) {
        if (this.is(this.active) || this.is(this.muting)) {
            this.mediaGroup.tell((Object)message, sender);
        }
    }

    private void onCollect(Collect message, ActorRef self, ActorRef sender) {
        if (this.is(this.active)) {
            this.mediaGroup.tell((Object)message, sender);
            this.collecting = true;
        }
    }

    private void onEndpointStateChanged(EndpointStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.stopping) && sender.equals((Object)this.bridgeEndpoint) && EndpointState.DESTROYED.equals((Object)message.getState())) {
            this.bridgeEndpoint.tell((Object)new StopObserving(self), self);
            this.context().stop(this.bridgeEndpoint);
            this.bridgeEndpoint = null;
            if (this.mediaGroup == null && this.bridgeEndpoint == null) {
                this.fsm.transition((Object)message, this.inactive);
            }
        }
    }

    protected void cleanup() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("De-activating Call Controller");
        }
        if (this.mediaGroup != null) {
            this.mediaGroup.tell((Object)new StopObserving(this.self()), this.self());
            this.mediaGroup.tell((Object)new StopMediaGroup(), null);
            this.context().stop(this.mediaGroup);
            this.mediaGroup = null;
        }
        if (this.remoteConn != null) {
            this.context().stop(this.remoteConn);
            this.remoteConn = null;
        }
        if (this.internalLink != null) {
            this.context().stop(this.internalLink);
            this.internalLink = null;
        }
        if (this.bridgeEndpoint != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Call Controller: " + this.self().path() + " about to stop bridge endpoint: " + this.bridgeEndpoint.path());
            }
            this.mediaGateway.tell((Object)new DestroyEndpoint(this.bridgeEndpoint), this.self());
            this.context().stop(this.bridgeEndpoint);
            this.bridgeEndpoint = null;
        }
        this.bridge = null;
        this.outboundCallBridgeEndpoint = null;
    }

    public void postStop() {
        this.cleanup();
        this.observers.clear();
        this.getContext().stop(this.self());
    }

    private final class Failed
    extends FinalState {
        public Failed(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.FAILED);
        }
    }

    private final class Inactive
    extends FinalState {
        public Inactive(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.INACTIVE);
        }
    }

    private abstract class FinalState
    extends MediaServerController.AbstractAction {
        private final MediaServerControllerStateChanged.MediaServerControllerState state;

        public FinalState(ActorRef source, MediaServerControllerStateChanged.MediaServerControllerState state) {
            super((MediaServerController)MmsCallController.this, source);
            this.state = state;
        }

        public void execute(Object message) throws Exception {
            MmsCallController.this.broadcast(new MediaServerControllerStateChanged(this.state));
        }
    }

    private class Stopping
    extends MediaServerController.AbstractAction {
        public Stopping(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            if (MmsCallController.this.mediaGroup != null) {
                MmsCallController.this.mediaGroup.tell((Object)new StopMediaGroup(), this.source);
            }
            if (MmsCallController.this.bridgeEndpoint != null) {
                MmsCallController.this.bridgeEndpoint.tell((Object)new DestroyEndpoint(), this.source);
            }
        }
    }

    private class ClosingRemoteConnection
    extends MediaServerController.AbstractAction {
        public ClosingRemoteConnection(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            if (MmsCallController.this.remoteConn != null) {
                MmsCallController.this.remoteConn.tell((Object)new CloseConnection(), this.source);
            }
        }
    }

    private final class ExitClosingInternalLink
    extends MediaServerController.AbstractAction {
        public ExitClosingInternalLink(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MmsCallController.this.mediaGateway.tell((Object)new DestroyLink(MmsCallController.this.internalLink), this.source);
            MmsCallController.this.internalLink = null;
            MmsCallController.this.internalLinkEndpoint = null;
            MmsCallController.this.internalLinkMode = null;
        }
    }

    private final class EnterClosingInternalLink
    extends MediaServerController.AbstractAction {
        public EnterClosingInternalLink(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MmsCallController.this.internalLink.tell((Object)new CloseLink(), this.source);
        }
    }

    private final class Unmuting
    extends MediaServerController.AbstractAction {
        public Unmuting(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            UpdateConnection update = new UpdateConnection(ConnectionMode.SendRecv);
            MmsCallController.this.remoteConn.tell((Object)update, this.source);
        }
    }

    private final class Muting
    extends MediaServerController.AbstractAction {
        public Muting(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            UpdateConnection update = new UpdateConnection(ConnectionMode.SendOnly);
            MmsCallController.this.remoteConn.tell((Object)update, this.source);
        }
    }

    private final class CreatingMediaGroup
    extends MediaServerController.AbstractAction {
        public CreatingMediaGroup(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            if (MmsCallController.this.mediaGroup == null) {
                MmsCallController.this.mediaGroup = MmsCallController.this.createMediaGroup(message);
                MmsCallController.this.mediaGroup.tell((Object)new Observe(this.source), this.source);
                MmsCallController.this.mediaGroup.tell((Object)new StartMediaGroup(), this.source);
            }
        }
    }

    private final class UpdatingInternalLink
    extends MediaServerController.AbstractAction {
        public UpdatingInternalLink(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            UpdateLink update = new UpdateLink(ConnectionMode.SendRecv, UpdateLink.Type.PRIMARY);
            MmsCallController.this.internalLink.tell((Object)update, this.source);
        }
    }

    private final class OpeningInternalLink
    extends MediaServerController.AbstractAction {
        public OpeningInternalLink(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MmsCallController.this.internalLink.tell((Object)new OpenLink(MmsCallController.this.internalLinkMode), this.source);
        }
    }

    private final class InitializingInternalLink
    extends MediaServerController.AbstractAction {
        public InitializingInternalLink(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MediaGatewayResponse response = (MediaGatewayResponse)message;
            if (MmsCallController.this.self().path().toString().equalsIgnoreCase("akka://RestComm/user/$j") && MmsCallController.this.logger.isInfoEnabled()) {
                MmsCallController.this.logger.info("Initializing Internal Link for the Outbound call");
            }
            if (MmsCallController.this.bridgeEndpoint != null) {
                if (MmsCallController.this.logger.isInfoEnabled()) {
                    MmsCallController.this.logger.info("##################### $$ Bridge for Call " + MmsCallController.this.self().path() + " is terminated: " + MmsCallController.this.bridgeEndpoint.isTerminated());
                }
                if (MmsCallController.this.bridgeEndpoint.isTerminated() && MmsCallController.this.logger.isInfoEnabled()) {
                    MmsCallController.this.logger.info("##################### $$ Call :" + MmsCallController.this.self().path() + " bridge is terminated.");
                }
            }
            MmsCallController.this.internalLink = (ActorRef)response.get();
            MmsCallController.this.internalLink.tell((Object)new Observe(this.source), this.source);
            MmsCallController.this.internalLink.tell((Object)new InitializeLink(MmsCallController.this.bridgeEndpoint, MmsCallController.this.internalLinkEndpoint), this.source);
        }
    }

    private final class AcquiringInternalLink
    extends MediaServerController.AbstractAction {
        public AcquiringInternalLink(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MmsCallController.this.mediaGateway.tell((Object)new CreateLink(MmsCallController.this.session), this.source);
        }
    }

    private final class Pending
    extends MediaServerController.AbstractAction {
        public Pending(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            ConnectionStateChanged connState = (ConnectionStateChanged)message;
            MmsCallController.this.localSdp = connState.descriptor().toString();
            MediaSessionInfo mediaSessionInfo = new MediaSessionInfo(MmsCallController.this.gatewayInfo.useNat(), MmsCallController.this.gatewayInfo.externalIP(), MmsCallController.this.localSdp, MmsCallController.this.remoteSdp);
            MmsCallController.this.broadcast(new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.PENDING, mediaSessionInfo));
        }
    }

    private final class Active
    extends MediaServerController.AbstractAction {
        public Active(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            if (MmsCallController.this.is(MmsCallController.this.updatingInternalLink)) {
                MmsCallController.this.call.tell((Object)new JoinComplete(MmsCallController.this.bridgeEndpoint, MmsCallController.this.session.id(), MmsCallController.this.connectionIdentifier), this.source);
            } else if (MmsCallController.this.is(MmsCallController.this.closingInternalLink)) {
                MmsCallController.this.call.tell((Object)new Left(), this.source);
            } else if (MmsCallController.this.is(MmsCallController.this.openingRemoteConnection) || MmsCallController.this.is(MmsCallController.this.updatingRemoteConnection)) {
                ConnectionStateChanged connState = (ConnectionStateChanged)message;
                MmsCallController.this.connectionIdentifier = connState.connectionIdentifier();
                MmsCallController.this.logger.info("connectionIdentifier: " + MmsCallController.this.connectionIdentifier);
                MmsCallController.this.localSdp = connState.descriptor().toString();
                MediaSessionInfo mediaSessionInfo = new MediaSessionInfo(MmsCallController.this.gatewayInfo.useNat(), MmsCallController.this.gatewayInfo.externalIP(), MmsCallController.this.localSdp, MmsCallController.this.remoteSdp);
                MmsCallController.this.broadcast(new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.ACTIVE, mediaSessionInfo));
            }
        }
    }

    private final class UpdatingRemoteConnection
    extends MediaServerController.AbstractAction {
        public UpdatingRemoteConnection(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            ConnectionDescriptor descriptor = new ConnectionDescriptor(MmsCallController.this.remoteSdp);
            UpdateConnection update = new UpdateConnection(descriptor);
            MmsCallController.this.remoteConn.tell((Object)update, this.source);
        }
    }

    private final class OpeningRemoteConnection
    extends MediaServerController.AbstractAction {
        public OpeningRemoteConnection(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            OpenConnection open = null;
            if (MmsCallController.this.callOutbound) {
                open = new OpenConnection(ConnectionMode.SendRecv, MmsCallController.this.webrtc);
            } else {
                ConnectionDescriptor descriptor = new ConnectionDescriptor(MmsCallController.this.remoteSdp);
                open = new OpenConnection(descriptor, ConnectionMode.SendRecv, MmsCallController.this.webrtc);
            }
            MmsCallController.this.remoteConn.tell((Object)open, this.source);
        }
    }

    private final class InitializingRemoteConnection
    extends MediaServerController.AbstractAction {
        public InitializingRemoteConnection(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MediaGatewayResponse response = (MediaGatewayResponse)message;
            MmsCallController.this.remoteConn = (ActorRef)response.get();
            MmsCallController.this.remoteConn.tell((Object)new Observe(this.source), this.source);
            MmsCallController.this.remoteConn.tell((Object)new InitializeConnection(MmsCallController.this.bridgeEndpoint), this.source);
        }
    }

    private final class AcquiringRemoteConnection
    extends MediaServerController.AbstractAction {
        public AcquiringRemoteConnection(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MmsCallController.this.mediaGateway.tell((Object)new CreateConnection(MmsCallController.this.session), this.source);
        }
    }

    public final class AcquiringBridge
    extends MediaServerController.AbstractAction {
        public AcquiringBridge(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MediaGatewayResponse response = (MediaGatewayResponse)message;
            MmsCallController.this.session = (MediaSession)response.get();
            MmsCallController.this.mediaGateway.tell((Object)new CreateBridgeEndpoint(MmsCallController.this.session), this.source);
        }
    }

    private final class AcquiringMediaSession
    extends MediaServerController.AbstractAction {
        public AcquiringMediaSession(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MediaGatewayResponse response = (MediaGatewayResponse)message;
            MmsCallController.this.gatewayInfo = (MediaGatewayInfo)response.get();
            MmsCallController.this.mediaGateway.tell((Object)new org.restcomm.connect.mgcp.CreateMediaSession(), this.source);
        }
    }

    private final class AcquiringMediaGatewayInfo
    extends MediaServerController.AbstractAction {
        public AcquiringMediaGatewayInfo(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MmsCallController.this.mediaGateway.tell((Object)new GetMediaGatewayInfo(), MmsCallController.this.self());
        }
    }

    private final class AcquiringMediaGateway
    extends MediaServerController.AbstractAction {
        public AcquiringMediaGateway(ActorRef source) {
            super((MediaServerController)MmsCallController.this, source);
        }

        public void execute(Object message) throws Exception {
            MmsCallController.this.mrb.tell((Object)new GetMediaGateway(MmsCallController.this.callId), MmsCallController.this.self());
        }
    }
}

