/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.mscontrol.mms;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.commons.util.WavUtils;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.RecordingsDao;
import org.restcomm.connect.dao.entities.Recording;
import org.restcomm.connect.mgcp.CreateConferenceEndpoint;
import org.restcomm.connect.mgcp.DestroyEndpoint;
import org.restcomm.connect.mgcp.EndpointState;
import org.restcomm.connect.mgcp.EndpointStateChanged;
import org.restcomm.connect.mgcp.MediaGatewayResponse;
import org.restcomm.connect.mgcp.MediaResourceBrokerResponse;
import org.restcomm.connect.mgcp.MediaSession;
import org.restcomm.connect.mrb.api.GetMediaGateway;
import org.restcomm.connect.mscontrol.api.MediaServerController;
import org.restcomm.connect.mscontrol.api.messages.CreateMediaSession;
import org.restcomm.connect.mscontrol.api.messages.JoinBridge;
import org.restcomm.connect.mscontrol.api.messages.JoinCall;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupStateChanged;
import org.restcomm.connect.mscontrol.api.messages.MediaServerControllerStateChanged;
import org.restcomm.connect.mscontrol.api.messages.Record;
import org.restcomm.connect.mscontrol.api.messages.StartMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.StartRecording;
import org.restcomm.connect.mscontrol.api.messages.Stop;
import org.restcomm.connect.mscontrol.api.messages.StopMediaGroup;
import org.restcomm.connect.mscontrol.mms.MgcpMediaGroup;

public class MmsBridgeController
extends MediaServerController {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State getMediaGatewayFromMRB;
    private final State active;
    private final State acquiringMediaSession;
    private final State acquiringEndpoint;
    private final State creatingMediaGroup;
    private final State stopping;
    private final State inactive;
    private final State failed;
    private Boolean fail;
    private ActorRef mediaGateway;
    private MediaSession mediaSession;
    private ActorRef endpoint;
    private final ActorRef mrb;
    private ActorRef bridge;
    private ActorRef mediaGroup;
    private Boolean recording;
    private DateTime recordStarted;
    private StartRecording recordingRequest;
    private final List<ActorRef> observers;
    private Sid callSid;

    public MmsBridgeController(ActorRef mrb) {
        ActorRef self = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.getMediaGatewayFromMRB = new State("get media gateway from mrb", (Action)new GetMediaGatewayFromMRB(self), null);
        this.active = new State("active", (Action)new Active(self), null);
        this.acquiringMediaSession = new State("acquiring media session", (Action)new AcquiringMediaSession(self), null);
        this.acquiringEndpoint = new State("acquiring endpoint", (Action)new AcquiringEndpoint(self), null);
        this.creatingMediaGroup = new State("creating media group", (Action)new CreatingMediaGroup(self), null);
        this.stopping = new State("stopping", (Action)new Stopping(self));
        this.inactive = new State("inactive", (Action)new Inactive(self));
        this.failed = new State("failed", (Action)new Failed(self));
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.getMediaGatewayFromMRB));
        transitions.add(new Transition(this.getMediaGatewayFromMRB, this.acquiringMediaSession));
        transitions.add(new Transition(this.acquiringMediaSession, this.acquiringEndpoint));
        transitions.add(new Transition(this.acquiringMediaSession, this.inactive));
        transitions.add(new Transition(this.acquiringEndpoint, this.creatingMediaGroup));
        transitions.add(new Transition(this.acquiringEndpoint, this.inactive));
        transitions.add(new Transition(this.creatingMediaGroup, this.active));
        transitions.add(new Transition(this.creatingMediaGroup, this.stopping));
        transitions.add(new Transition(this.creatingMediaGroup, this.failed));
        transitions.add(new Transition(this.active, this.stopping));
        transitions.add(new Transition(this.stopping, this.inactive));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.fail = Boolean.FALSE;
        this.mrb = mrb;
        this.recording = Boolean.FALSE;
        this.observers = new ArrayList<ActorRef>(1);
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast(Object message) {
        if (!this.observers.isEmpty()) {
            ActorRef self = this.self();
            List<ActorRef> list = this.observers;
            synchronized (list) {
                for (ActorRef observer : this.observers) {
                    observer.tell(message, self);
                }
            }
        }
    }

    private void saveRecording() {
        Double duration;
        Sid accountId = this.recordingRequest.getAccountId();
        Sid callId = this.recordingRequest.getCallId();
        DaoManager daoManager = this.recordingRequest.getDaoManager();
        Sid recordingSid = this.recordingRequest.getRecordingSid();
        URI recordingUri = this.recordingRequest.getRecordingUri();
        Configuration runtimeSettings = this.recordingRequest.getRuntimeSetting();
        try {
            duration = WavUtils.getAudioDuration((URI)recordingUri);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            this.logger.error("Could not measure recording duration: " + e.getMessage(), (Object)e);
            duration = 0.0;
        }
        if (duration.equals(0.0)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Call wraping up recording. File doesn't exist since duration is 0");
            }
            DateTime end = DateTime.now();
            duration = new Double((end.getMillis() - this.recordStarted.getMillis()) / 1000L);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Call wraping up recording. File already exists, length: " + new File(recordingUri).length());
        }
        Recording.Builder builder = Recording.builder();
        builder.setSid(recordingSid);
        builder.setAccountSid(accountId);
        builder.setCallSid(callId);
        builder.setDuration(duration.doubleValue());
        builder.setApiVersion(runtimeSettings.getString("api-version"));
        StringBuilder buffer = new StringBuilder();
        buffer.append("/").append(runtimeSettings.getString("api-version")).append("/Accounts/").append(accountId.toString());
        buffer.append("/Recordings/").append(recordingSid.toString());
        builder.setUri(URI.create(buffer.toString()));
        Recording recording = builder.build();
        RecordingsDao recordsDao = daoManager.getRecordingsDao();
        recordsDao.addRecording(recording);
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        State state = this.fsm.state();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("********** Bridge Controller " + this.self().path() + " State: \"" + state.toString());
            this.logger.info("********** Bridge Controller " + this.self().path() + " Processing: \"" + klass.getName() + " Sender: " + sender.path());
        }
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (CreateMediaSession.class.equals(klass)) {
            this.onCreateMediaSession((CreateMediaSession)message, self, sender);
        } else if (JoinCall.class.equals(klass)) {
            this.onJoinCall((JoinCall)message, self, sender);
        } else if (Stop.class.equals(klass)) {
            this.onStop((Stop)message, self, sender);
        } else if (MediaGatewayResponse.class.equals(klass)) {
            this.onMediaGatewayResponse((MediaGatewayResponse)message, self, sender);
        } else if (MediaGroupStateChanged.class.equals(klass)) {
            this.onMediaGroupStateChanged((MediaGroupStateChanged)message, self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecording((StartRecording)message, self, sender);
        } else if (EndpointStateChanged.class.equals(klass)) {
            this.onEndpointStateChanged((EndpointStateChanged)message, self, sender);
        } else if (MediaResourceBrokerResponse.class.equals(klass)) {
            this.onMediaResourceBrokerResponse((MediaResourceBrokerResponse)message, self, sender);
        }
    }

    private void onMediaResourceBrokerResponse(MediaResourceBrokerResponse<?> message, ActorRef self, ActorRef sender) throws Exception {
        this.mediaGateway = (ActorRef)message.get();
        this.fsm.transition(message, this.acquiringMediaSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private void onCreateMediaSession(CreateMediaSession message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.bridge = sender;
            this.fsm.transition((Object)message, this.getMediaGatewayFromMRB);
        }
    }

    private void onJoinCall(JoinCall message, ActorRef self, ActorRef sender) {
        JoinBridge join = new JoinBridge((Object)this.endpoint, message.getConnectionMode());
        message.getCall().tell((Object)join, sender);
    }

    private void onStop(Stop message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.acquiringMediaSession) || this.is(this.acquiringEndpoint)) {
            this.fsm.transition((Object)message, this.inactive);
        } else if (this.is(this.creatingMediaGroup) || this.is(this.active)) {
            this.fsm.transition((Object)message, this.stopping);
        }
    }

    private void onMediaGatewayResponse(MediaGatewayResponse<?> message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.acquiringMediaSession)) {
            this.mediaSession = (MediaSession)message.get();
            this.fsm.transition(message, this.acquiringEndpoint);
        } else if (this.is(this.acquiringEndpoint)) {
            this.endpoint = (ActorRef)message.get();
            this.endpoint.tell((Object)new Observe(self), self);
            this.fsm.transition(message, this.creatingMediaGroup);
        }
    }

    private void onMediaGroupStateChanged(MediaGroupStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        switch (message.state()) {
            case ACTIVE: {
                if (!this.is(this.creatingMediaGroup)) break;
                this.fsm.transition((Object)message, this.active);
                break;
            }
            case INACTIVE: {
                if (this.is(this.creatingMediaGroup)) {
                    this.fail = Boolean.TRUE;
                    this.fsm.transition((Object)message, this.failed);
                    break;
                }
                if (!this.is(this.stopping)) break;
                this.mediaGroup.tell((Object)new StopObserving(self), self);
                this.context().stop(this.mediaGroup);
                this.mediaGroup = null;
                if (this.recordStarted != null) {
                    this.saveRecording();
                    this.recordStarted = null;
                    this.recordingRequest = null;
                }
                if (this.mediaGroup != null || this.endpoint != null) break;
                this.fsm.transition((Object)message, this.fail != false ? this.failed : this.inactive);
                break;
            }
        }
    }

    private void onEndpointStateChanged(EndpointStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.stopping) && sender.equals((Object)this.endpoint) && (EndpointState.DESTROYED.equals((Object)message.getState()) || EndpointState.FAILED.equals((Object)message.getState()))) {
            if (EndpointState.FAILED.equals((Object)message.getState())) {
                this.logger.error("Could not destroy endpoint on media server. corresponding actor path is: " + this.endpoint.path());
            }
            this.endpoint.tell((Object)new StopObserving(self), self);
            this.context().stop(this.endpoint);
            this.endpoint = null;
            if (this.mediaGroup == null && this.endpoint == null) {
                this.fsm.transition((Object)message, this.inactive);
            }
        }
    }

    private void onStartRecording(StartRecording message, ActorRef self, ActorRef sender) {
        if (this.is(this.active) && !this.recording.booleanValue()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Start recording bridged call");
            }
            String finishOnKey = "1234567890*#";
            int maxLength = 3600;
            int timeout = 5;
            this.recording = Boolean.TRUE;
            this.recordStarted = DateTime.now();
            this.recordingRequest = message;
            Record record = new Record(message.getRecordingUri(), timeout, maxLength, finishOnKey);
            this.mediaGroup.tell((Object)record, self);
        }
    }

    public void postStop() {
        this.mediaSession = null;
        this.observers.clear();
        super.postStop();
    }

    private final class Failed
    extends FinalState {
        public Failed(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.FAILED);
        }
    }

    private final class Inactive
    extends FinalState {
        public Inactive(ActorRef source) {
            super(source, MediaServerControllerStateChanged.MediaServerControllerState.INACTIVE);
        }
    }

    private abstract class FinalState
    extends AbstractAction {
        private final MediaServerControllerStateChanged.MediaServerControllerState state;

        public FinalState(ActorRef source, MediaServerControllerStateChanged.MediaServerControllerState state) {
            super(source);
            this.state = state;
        }

        public void execute(Object message) throws Exception {
            if (MmsBridgeController.this.endpoint != null) {
                MmsBridgeController.this.mediaGateway.tell((Object)new DestroyEndpoint(MmsBridgeController.this.endpoint), this.source);
                MmsBridgeController.this.endpoint = null;
            }
            MmsBridgeController.this.broadcast(new MediaServerControllerStateChanged(this.state));
            MmsBridgeController.this.observers.clear();
            MmsBridgeController.this.getContext().stop(this.source);
        }
    }

    @Deprecated
    private final class DestroyingMediaGroup
    extends AbstractAction {
        public DestroyingMediaGroup(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (MmsBridgeController.this.recording.booleanValue()) {
                MmsBridgeController.this.mediaGroup.tell((Object)new Stop(), this.source);
                MmsBridgeController.this.recording = Boolean.FALSE;
            }
            MmsBridgeController.this.mediaGroup.tell((Object)new StopMediaGroup(), this.source);
        }
    }

    private final class Stopping
    extends AbstractAction {
        public Stopping(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (MmsBridgeController.this.recording.booleanValue()) {
                MmsBridgeController.this.mediaGroup.tell((Object)new Stop(), this.source);
                MmsBridgeController.this.recording = Boolean.FALSE;
            }
            MmsBridgeController.this.mediaGroup.tell((Object)new StopMediaGroup(), this.source);
            MmsBridgeController.this.endpoint.tell((Object)new DestroyEndpoint(), this.source);
        }
    }

    private final class Active
    extends AbstractAction {
        public Active(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MmsBridgeController.this.broadcast(new MediaServerControllerStateChanged(MediaServerControllerStateChanged.MediaServerControllerState.ACTIVE));
        }
    }

    private final class CreatingMediaGroup
    extends AbstractAction {
        public CreatingMediaGroup(ActorRef source) {
            super(source);
        }

        private ActorRef createMediaGroup(Object message) {
            Props props = new Props(new UntypedActorFactory(){
                private static final long serialVersionUID = 1L;

                public UntypedActor create() throws Exception {
                    return new MgcpMediaGroup(MmsBridgeController.this.mediaGateway, MmsBridgeController.this.mediaSession, MmsBridgeController.this.endpoint);
                }
            });
            return MmsBridgeController.this.getContext().actorOf(props);
        }

        public void execute(Object message) throws Exception {
            MmsBridgeController.this.mediaGroup = this.createMediaGroup(message);
            MmsBridgeController.this.mediaGroup.tell((Object)new Observe(this.source), this.source);
            MmsBridgeController.this.mediaGroup.tell((Object)new StartMediaGroup(), this.source);
        }
    }

    private final class AcquiringEndpoint
    extends AbstractAction {
        public AcquiringEndpoint(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            CreateConferenceEndpoint createEndpoint = new CreateConferenceEndpoint(MmsBridgeController.this.mediaSession);
            MmsBridgeController.this.mediaGateway.tell((Object)createEndpoint, this.source);
        }
    }

    private final class AcquiringMediaSession
    extends AbstractAction {
        public AcquiringMediaSession(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MmsBridgeController.this.mediaGateway.tell((Object)new org.restcomm.connect.mgcp.CreateMediaSession(), this.source);
        }
    }

    private final class GetMediaGatewayFromMRB
    extends AbstractAction {
        public GetMediaGatewayFromMRB(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MmsBridgeController.this.mrb.tell((Object)new GetMediaGateway(MmsBridgeController.this.callSid), MmsBridgeController.this.self());
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

