/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.mscontrol.mms;

import akka.actor.Actor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.UntypedActorFactory;
import org.apache.log4j.Logger;
import org.restcomm.connect.mscontrol.api.MediaServerControllerFactory;
import org.restcomm.connect.mscontrol.mms.MmsBridgeController;
import org.restcomm.connect.mscontrol.mms.MmsCallController;
import org.restcomm.connect.mscontrol.mms.MmsConferenceController;

public class MmsControllerFactory
implements MediaServerControllerFactory {
    private static Logger logger = Logger.getLogger(MmsControllerFactory.class);
    private final CallControllerFactory callControllerFactory = new CallControllerFactory();
    private final ConferenceControllerFactory conferenceControllerFactory = new ConferenceControllerFactory();
    private final BridgeControllerFactory bridgeControllerFactory = new BridgeControllerFactory();
    private final ActorRef mrb;

    public MmsControllerFactory(ActorRef mrb) {
        this.mrb = mrb;
    }

    public Props provideCallControllerProps() {
        return new Props((UntypedActorFactory)this.callControllerFactory);
    }

    public Props provideConferenceControllerProps() {
        return new Props((UntypedActorFactory)this.conferenceControllerFactory);
    }

    public Props provideBridgeControllerProps() {
        return new Props((UntypedActorFactory)this.bridgeControllerFactory);
    }

    private final class BridgeControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = 8999152285760508857L;

        private BridgeControllerFactory() {
        }

        public Actor create() throws Exception {
            return new MmsBridgeController(MmsControllerFactory.this.mrb);
        }
    }

    private final class ConferenceControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = -919317656354678281L;

        private ConferenceControllerFactory() {
        }

        public Actor create() throws Exception {
            return new MmsConferenceController(MmsControllerFactory.this.mrb);
        }
    }

    private final class CallControllerFactory
    implements UntypedActorFactory {
        private static final long serialVersionUID = -4649683839304615853L;

        private CallControllerFactory() {
        }

        public Actor create() throws Exception {
            return new MmsCallController(MmsControllerFactory.this.mrb);
        }
    }
}

