/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.sms;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.sms.SmsService;
import org.restcomm.connect.sms.smpp.SmppMessageHandler;
import org.restcomm.connect.sms.smpp.SmppService;

public final class SmsServiceProxy
extends SipServlet
implements SipServletListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(SmsServiceProxy.class);
    private ActorSystem system;
    private ActorRef service;
    private ActorRef smppService;
    private ActorRef smppMessageHandler;
    private ServletContext context;

    protected void doRequest(SipServletRequest request) throws ServletException, IOException {
        this.service.tell((Object)request, null);
    }

    protected void doResponse(SipServletResponse response) throws ServletException, IOException {
        this.service.tell((Object)response, null);
    }

    private ActorRef service(final Configuration configuration, final SipFactory factory, final DaoManager storage) {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SmsService(SmsServiceProxy.this.system, configuration, factory, storage, SmsServiceProxy.this.context);
            }
        }));
    }

    private ActorRef smppService(final Configuration configuration, final SipFactory factory, final DaoManager storage, final ServletContext context, final ActorRef smppMessageHandler) {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SmppService(SmsServiceProxy.this.system, configuration, factory, storage, context, smppMessageHandler);
            }
        }));
    }

    private ActorRef smppMessageHandler() {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SmppMessageHandler(SmsServiceProxy.this.context);
            }
        }));
    }

    public void servletInitialized(SipServletContextEvent event) {
        if (event.getSipServlet().getClass().equals(SmsServiceProxy.class)) {
            this.context = event.getServletContext();
            SipFactory factory = (SipFactory)this.context.getAttribute("javax.servlet.sip.SipFactory");
            Configuration configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
            DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
            this.system = (ActorSystem)this.context.getAttribute(ActorSystem.class.getName());
            this.service = this.service(configuration, factory, storage);
            this.context.setAttribute(SmsService.class.getName(), (Object)this.service);
            if (configuration.subset("smpp").getString("[@activateSmppConnection]", "false").equalsIgnoreCase("true")) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)"Will initialize SMPP");
                }
                this.smppMessageHandler = this.smppMessageHandler();
                this.smppService = this.smppService(configuration, factory, storage, this.context, this.smppMessageHandler);
                this.context.setAttribute(SmppService.class.getName(), (Object)this.smppService);
                this.context.setAttribute(SmppMessageHandler.class.getName(), (Object)this.smppMessageHandler);
            }
        }
    }
}

