/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.sms;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Currency;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.util.UriUtils;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.ApplicationsDao;
import org.restcomm.connect.dao.ClientsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.IncomingPhoneNumbersDao;
import org.restcomm.connect.dao.NotificationsDao;
import org.restcomm.connect.dao.SmsMessagesDao;
import org.restcomm.connect.dao.entities.Application;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.dao.entities.IncomingPhoneNumber;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.dao.entities.SmsMessage;
import org.restcomm.connect.extension.api.ExtensionRequest;
import org.restcomm.connect.extension.api.ExtensionResponse;
import org.restcomm.connect.extension.api.ExtensionType;
import org.restcomm.connect.extension.api.MessageExtensionResponse;
import org.restcomm.connect.extension.api.NodeExtensionResponse;
import org.restcomm.connect.extension.api.RestcommExtensionException;
import org.restcomm.connect.extension.api.RestcommExtensionGeneric;
import org.restcomm.connect.extension.api.SessionExtensionResponse;
import org.restcomm.connect.extension.api.SystemExtensionResponse;
import org.restcomm.connect.extension.api.TransactionExtensionResponse;
import org.restcomm.connect.extension.controller.ExtensionController;
import org.restcomm.connect.interpreter.SmsInterpreterBuilder;
import org.restcomm.connect.interpreter.StartInterpreter;
import org.restcomm.connect.monitoringservice.MonitoringService;
import org.restcomm.connect.sms.SmsSession;
import org.restcomm.connect.sms.api.CreateSmsSession;
import org.restcomm.connect.sms.api.DestroySmsSession;
import org.restcomm.connect.sms.api.SmsServiceResponse;
import org.restcomm.connect.sms.api.SmsSessionAttribute;
import org.restcomm.connect.sms.api.SmsSessionRequest;
import org.restcomm.connect.telephony.api.TextMessage;
import org.restcomm.connect.telephony.api.util.B2BUAHelper;
import org.restcomm.connect.telephony.api.util.CallControlHelper;
import org.restcomm.smpp.parameter.TlvSet;

public final class SmsService
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final ActorSystem system = this.context().system();
    private final Configuration configuration;
    private boolean authenticateUsers = true;
    private final ServletConfig servletConfig;
    private final SipFactory sipFactory;
    private final DaoManager storage;
    private final ServletContext servletContext;
    static final int ERROR_NOTIFICATION = 0;
    static final int WARNING_NOTIFICATION = 1;
    private final ActorRef monitoringService;
    private boolean useTo = true;
    private boolean patchForNatB2BUASessions;
    List<RestcommExtensionGeneric> extensions;

    public SmsService(Configuration configuration, SipFactory factory, DaoManager storage, ServletContext servletContext) {
        this.configuration = configuration;
        Configuration runtime = configuration.subset("runtime-settings");
        this.authenticateUsers = runtime.getBoolean("authenticate");
        this.servletConfig = (ServletConfig)configuration.getProperty(ServletConfig.class.getName());
        this.sipFactory = factory;
        this.storage = storage;
        this.servletContext = servletContext;
        this.monitoringService = (ActorRef)servletContext.getAttribute(MonitoringService.class.getName());
        this.patchForNatB2BUASessions = runtime.getBoolean("patch-for-nat-b2bua-sessions", true);
        this.extensions = ExtensionController.getInstance().getExtensions(ExtensionType.SmsService);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SmsService extensions: " + (this.extensions != null ? Integer.valueOf(this.extensions.size()) : "0"));
        }
    }

    private void message(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletRequest request = (SipServletRequest)message;
        if (request.getContentLength() == 0 || !request.getContentType().contains("text/plain")) {
            SipServletResponse reject = request.createResponse(406);
            reject.addHeader("Reason", "Content Type is not text plain");
            reject.send();
            return;
        }
        SipURI fromURI = (SipURI)request.getFrom().getURI();
        String fromUser = fromURI.getUser();
        ClientsDao clients = this.storage.getClientsDao();
        Client client = clients.getClient(fromUser);
        AccountsDao accounts = this.storage.getAccountsDao();
        ApplicationsDao applications = this.storage.getApplicationsDao();
        if (client != null && this.authenticateUsers && !CallControlHelper.checkAuthentication((SipServletRequest)request, (DaoManager)this.storage)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Client " + client.getLogin() + " failed to authenticate");
            }
            return;
        }
        String toUser = CallControlHelper.getUserSipId((SipServletRequest)request, (boolean)this.useTo);
        if (this.redirectToHostedSmsApp(self, request, accounts, applications, toUser)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Message to :" + toUser + " matched to one of the hosted applications");
            }
            SipServletResponse messageAccepted = request.createResponse(202);
            messageAccepted.send();
            this.monitoringService.tell((Object)new TextMessage(((SipURI)request.getFrom().getURI()).getUser(), ((SipURI)request.getTo().getURI()).getUser(), TextMessage.SmsState.INBOUND_TO_APP), self);
            return;
        }
        if (client != null) {
            Client toClient = clients.getClient(toUser);
            if (toClient != null) {
                if (B2BUAHelper.redirectToB2BUA((SipServletRequest)request, (Client)client, (Client)toClient, (DaoManager)this.storage, (SipFactory)this.sipFactory, (boolean)this.patchForNatB2BUASessions)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("P2P, Message from: " + client.getLogin() + " redirected to registered client: " + toClient.getLogin());
                    }
                    this.monitoringService.tell((Object)new TextMessage(((SipURI)request.getFrom().getURI()).getUser(), ((SipURI)request.getTo().getURI()).getUser(), TextMessage.SmsState.INBOUND_TO_CLIENT), self);
                    return;
                }
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Restcomm will route this SMS to an external aggregator: " + client.getLogin() + " to: " + toUser);
                }
                SipServletResponse trying = request.createResponse(100);
                trying.send();
                ActorRef session = this.session(this.configuration);
                Sid sid = Sid.generate((Sid.Type)Sid.Type.SMS_MESSAGE);
                SmsMessage.Builder builder = SmsMessage.builder();
                builder.setSid(sid);
                builder.setAccountSid(client.getAccountSid());
                builder.setApiVersion(client.getApiVersion());
                builder.setRecipient(toUser);
                builder.setSender(client.getLogin());
                builder.setBody(new String(request.getRawContent()));
                builder.setDirection(SmsMessage.Direction.OUTBOUND_CALL);
                builder.setStatus(SmsMessage.Status.RECEIVED);
                builder.setPrice(new BigDecimal("0.00"));
                builder.setPriceUnit(Currency.getInstance("USD"));
                StringBuilder buffer = new StringBuilder();
                buffer.append("/").append(client.getApiVersion()).append("/Accounts/");
                buffer.append(client.getAccountSid().toString()).append("/SMS/Messages/");
                buffer.append(sid.toString());
                URI uri = URI.create(buffer.toString());
                builder.setUri(uri);
                SmsMessage record = builder.build();
                SmsMessagesDao messages = this.storage.getSmsMessagesDao();
                messages.addSmsMessage(record);
                session.tell((Object)new SmsSessionAttribute("record", (Object)record), this.self());
                TlvSet tlvSet = new TlvSet();
                SmsSessionRequest sms = new SmsSessionRequest(client.getLogin(), toUser, new String(request.getRawContent()), SmsSessionRequest.Encoding.GSM, request, null, tlvSet);
                this.monitoringService.tell((Object)new TextMessage(((SipURI)request.getFrom().getURI()).getUser(), ((SipURI)request.getTo().getURI()).getUser(), TextMessage.SmsState.INBOUND_TO_PROXY_OUT), self);
                session.tell((Object)sms, this.self());
            }
        } else {
            SipServletResponse response = request.createResponse(404);
            response.send();
            String errMsg = "Restcomm cannot process this SMS because the destination number is not hosted locally. To: " + toUser;
            this.sendNotification(errMsg, 11005, "error", true);
            this.monitoringService.tell((Object)new TextMessage(((SipURI)request.getFrom().getURI()).getUser(), ((SipURI)request.getTo().getURI()).getUser(), TextMessage.SmsState.NOT_FOUND), self);
        }
    }

    private boolean redirectToHostedSmsApp(ActorRef self, SipServletRequest request, AccountsDao accounts, ApplicationsDao applications, String id) throws IOException {
        boolean isFoundHostedApp = false;
        SipURI uri = (SipURI)request.getRequestURI();
        String to = uri.getUser();
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        String phone = to;
        try {
            phone = phoneNumberUtil.format(phoneNumberUtil.parse(to, "US"), PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        catch (Exception e) {
            // empty catch block
        }
        IncomingPhoneNumbersDao numbers = this.storage.getIncomingPhoneNumbersDao();
        IncomingPhoneNumber number = numbers.getIncomingPhoneNumber(phone);
        if (number == null) {
            number = numbers.getIncomingPhoneNumber(to);
        }
        try {
            if (number != null) {
                URI appUri = number.getSmsUrl();
                ActorRef interpreter = null;
                if (appUri != null || number.getSmsApplicationSid() != null) {
                    SmsInterpreterBuilder builder = new SmsInterpreterBuilder(this.system);
                    builder.setSmsService(self);
                    builder.setConfiguration(this.configuration);
                    builder.setStorage(this.storage);
                    builder.setAccount(number.getAccountSid());
                    builder.setVersion(number.getApiVersion());
                    Sid sid = number.getSmsApplicationSid();
                    if (sid != null) {
                        Application application = applications.getApplication(sid);
                        builder.setUrl(UriUtils.resolve((URI)application.getRcmlUrl()));
                    } else {
                        builder.setUrl(UriUtils.resolve((URI)appUri));
                    }
                    String smsMethod = number.getSmsMethod();
                    if (smsMethod == null || smsMethod.isEmpty()) {
                        builder.setMethod("POST");
                    } else {
                        builder.setMethod(smsMethod);
                    }
                    URI appFallbackUrl = number.getSmsFallbackUrl();
                    if (appFallbackUrl != null) {
                        builder.setFallbackUrl(UriUtils.resolve((URI)number.getSmsFallbackUrl()));
                        builder.setFallbackMethod(number.getSmsFallbackMethod());
                    }
                    interpreter = builder.build();
                }
                ActorRef session = this.session(this.configuration);
                session.tell((Object)request, self);
                StartInterpreter start = new StartInterpreter(session);
                interpreter.tell((Object)start, self);
                isFoundHostedApp = true;
            }
        }
        catch (Exception e) {
            String errMsg = "There is no valid Restcomm SMS Request URL configured for this number : " + phone;
            this.sendNotification(errMsg, 12003, "warning", true);
        }
        return isFoundHostedApp;
    }

    private ExtensionResponse executePreOutboundAction(Object er) {
        ExtensionResponse response = new ExtensionResponse();
        if (this.extensions != null && this.extensions.size() > 0) {
            for (RestcommExtensionGeneric extension : this.extensions) {
                this.logger.info("isEnabled=" + extension.isEnabled());
                if (!extension.isEnabled() || (response = extension.preOutboundAction(er)).isAllowed()) continue;
                break;
            }
        }
        return response;
    }

    private boolean executePostOutboundAction(Object message) {
        return true;
    }

    private Object handleExtensionResponse(ExtensionResponse response) {
        Configuration object = this.configuration;
        if (response instanceof SystemExtensionResponse) {
            // empty if block
        }
        if (response instanceof NodeExtensionResponse) {
            // empty if block
        }
        if (response instanceof SessionExtensionResponse) {
            Configuration config;
            SessionExtensionResponse ser = (SessionExtensionResponse)response;
            object = config = ser.getConfiguration();
        }
        if (response instanceof TransactionExtensionResponse) {
            // empty if block
        }
        if (response instanceof MessageExtensionResponse) {
            // empty if block
        }
        return object;
    }

    public void onReceive(Object message) throws Exception {
        SipServletResponse response;
        SipServletRequest request;
        String method;
        UntypedActorContext context = this.getContext();
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (CreateSmsSession.class.equals(klass)) {
            ExtensionRequest er = new ExtensionRequest();
            er.setObject(message);
            er.setConfiguration(this.configuration);
            ExtensionResponse extensionResponse = this.executePreOutboundAction(er);
            if (extensionResponse.isAllowed()) {
                Object obj = this.handleExtensionResponse(extensionResponse);
                ActorRef session = this.session((Configuration)obj);
                SmsServiceResponse response2 = new SmsServiceResponse((Object)session);
                sender.tell((Object)response2, self);
            } else {
                SmsServiceResponse response3 = new SmsServiceResponse((Throwable)new RestcommExtensionException("Now allowed to create SmsSession"));
                sender.tell((Object)response3, this.self());
            }
            this.executePostOutboundAction(message);
        } else if (DestroySmsSession.class.equals(klass)) {
            DestroySmsSession request2 = (DestroySmsSession)message;
            ActorRef session = request2.session();
            context.stop(session);
        } else if (message instanceof SipServletRequest) {
            SipServletRequest request3 = (SipServletRequest)message;
            String method2 = request3.getMethod();
            if ("MESSAGE".equalsIgnoreCase(method2)) {
                this.message(message);
            }
        } else if (message instanceof SipServletResponse && "MESSAGE".equalsIgnoreCase(method = (request = (response = (SipServletResponse)message).getRequest()).getMethod())) {
            this.response(message);
        }
    }

    private void response(Object message) throws Exception {
        ActorRef self = this.self();
        SipServletResponse response = (SipServletResponse)message;
        if (B2BUAHelper.isB2BUASession((SipServletMessage)response)) {
            B2BUAHelper.forwardResponse((SipServletResponse)response, (boolean)this.patchForNatB2BUASessions);
            return;
        }
        SipApplicationSession application = response.getApplicationSession();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Is SipApplicationSession valid: " + application.isValid());
        }
        if (application != null) {
            ActorRef session = (ActorRef)application.getAttribute(SmsSession.class.getName());
            session.tell((Object)response, self);
            SipServletRequest origRequest = (SipServletRequest)application.getAttribute(SipServletRequest.class.getName());
            if (origRequest != null && origRequest.getSession().isValid()) {
                SipServletResponse responseToOriginator = origRequest.createResponse(response.getStatus(), response.getReasonPhrase());
                responseToOriginator.send();
            }
        }
    }

    private SipURI outboundInterface() {
        SipURI result = null;
        List uris = (List)this.servletContext.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String transport = uri.getTransportParam();
            if (!"udp".equalsIgnoreCase(transport)) continue;
            result = uri;
        }
        return result;
    }

    private ActorRef session(final Configuration p_configuration) {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new SmsSession(p_configuration, SmsService.this.sipFactory, SmsService.this.outboundInterface(), SmsService.this.storage, SmsService.this.monitoringService, SmsService.this.servletContext);
            }
        });
        return this.system.actorOf(props);
    }

    private void sendNotification(String errMessage, int errCode, String errType, boolean createNotification) {
        NotificationsDao notifications = this.storage.getNotificationsDao();
        if (errType == "warning") {
            this.logger.warning(errMessage);
            if (createNotification) {
                Notification notification = this.notification(1, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "error") {
            this.logger.error(errMessage);
            if (createNotification) {
                Notification notification = this.notification(0, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "info" && this.logger.isInfoEnabled()) {
            this.logger.info(errMessage);
        }
    }

    private Notification notification(int log, int error, String message) {
        String version = this.configuration.subset("runtime-settings").getString("api-version");
        Sid accountId = new Sid("ACae6e420f425248d6a26948c17a9e2acf");
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(accountId);
        builder.setApiVersion(version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        URI info = URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        try {
            builder.setRequestUrl(new URI(""));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        builder.setRequestMethod("");
        builder.setRequestVariables("");
        buffer = new StringBuilder();
        buffer.append("/").append(version).append("/Accounts/");
        buffer.append(accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        URI uri = URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }
}

