/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony.api;

import org.restcomm.connect.commons.annotations.concurrency.Immutable;

@Immutable
public final class CallStateChanged {
    private final State state;
    private final Integer sipResponse;

    public CallStateChanged(State state) {
        this.state = state;
        this.sipResponse = null;
    }

    public CallStateChanged(State state, Integer sipResponse) {
        this.state = state;
        this.sipResponse = sipResponse;
    }

    public State state() {
        return this.state;
    }

    public Integer sipResponse() {
        return this.sipResponse;
    }

    public String toString() {
        return "CallStateChanged [state=" + (Object)((Object)this.state) + ", sipResponse=" + this.sipResponse + "]";
    }

    public static enum State {
        QUEUED("queued"),
        RINGING("ringing"),
        CANCELED("canceled"),
        BUSY("busy"),
        NOT_FOUND("not-found"),
        FAILED("failed"),
        NO_ANSWER("no-answer"),
        WAIT_FOR_ANSWER("wait-for-answer"),
        IN_PROGRESS("in-progress"),
        COMPLETED("completed");

        private final String text;

        private State(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

