/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony.api;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.telephony.CreateCallType;
import org.restcomm.connect.extension.api.IExtensionCreateCallRequest;

@Immutable
public final class CreateCall
implements IExtensionCreateCallRequest {
    private final String from;
    private final String to;
    private String username;
    private String password;
    private final boolean isFromApi;
    private final int timeout;
    private final CreateCallType callType;
    private final Sid accountId;
    private boolean createCDR = true;
    private final Sid parentCallSid;
    private final URI statusCallbackUrl;
    private final String statusCallbackMethod;
    private final List<String> statusCallbackEvent;
    private String outboundProxy;
    private Map<String, ArrayList<String>> outboundProxyHeaders;
    private boolean allowed = true;

    public CreateCall(String from, String to, String username, String password, boolean isFromApi, int timeout, CreateCallType type, Sid accountId, Sid parentCallSid, URI statusCallbackUrl, String statusCallbackMethod, List<String> statusCallbackEvent) {
        this(from, to, username, password, isFromApi, timeout, type, accountId, parentCallSid, statusCallbackUrl, statusCallbackMethod, statusCallbackEvent, "", null);
    }

    public CreateCall(String from, String to, String username, String password, boolean isFromApi, int timeout, CreateCallType type, Sid accountId, Sid parentCallSid, URI statusCallbackUrl, String statusCallbackMethod, List<String> statusCallbackEvent, String outboundProxy, Map<String, ArrayList<String>> outboundProxyHeaders) {
        this.from = from;
        this.to = to;
        this.username = username;
        this.password = password;
        this.isFromApi = isFromApi;
        this.timeout = timeout;
        this.callType = type;
        this.accountId = accountId;
        this.parentCallSid = parentCallSid;
        this.statusCallbackUrl = statusCallbackUrl;
        this.statusCallbackMethod = statusCallbackMethod;
        this.statusCallbackEvent = statusCallbackEvent;
        this.outboundProxy = outboundProxy;
        this.outboundProxyHeaders = outboundProxyHeaders;
    }

    public String from() {
        return this.from;
    }

    public String to() {
        return this.to;
    }

    public int timeout() {
        return this.timeout;
    }

    public CreateCallType type() {
        return this.callType;
    }

    public Sid accountId() {
        return this.accountId;
    }

    public String username() {
        return this.username;
    }

    public String setUsername() {
        return this.username;
    }

    public String password() {
        return this.password;
    }

    public String setPassword() {
        return this.password;
    }

    public boolean isCreateCDR() {
        return this.createCDR;
    }

    public void setCreateCDR(boolean createCDR) {
        this.createCDR = createCDR;
    }

    public Sid parentCallSid() {
        return this.parentCallSid;
    }

    public URI statusCallback() {
        return this.statusCallbackUrl;
    }

    public String statusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public List<String> statusCallbackEvent() {
        return this.statusCallbackEvent;
    }

    public String getOutboundProxy() {
        return this.outboundProxy;
    }

    public void setOutboundProxy(String outboundProxy) {
        this.outboundProxy = outboundProxy;
    }

    public String getOutboundProxyUsername() {
        return this.username;
    }

    public void setOutboundProxyUsername(String outboundProxyUsername) {
        this.username = outboundProxyUsername;
    }

    public String getOutboundProxyPassword() {
        return this.password;
    }

    public void setOutboundProxyPassword(String outboundProxyPassword) {
        this.password = outboundProxyPassword;
    }

    public Map<String, ArrayList<String>> getOutboundProxyHeaders() {
        return this.outboundProxyHeaders;
    }

    public void setOutboundProxyHeaders(Map<String, ArrayList<String>> outboundProxyHeaders) {
        this.outboundProxyHeaders = outboundProxyHeaders;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public Sid getAccountId() {
        return this.accountId;
    }

    public boolean isFromApi() {
        return this.isFromApi;
    }

    public boolean isParentCallSidExists() {
        return this.parentCallSid != null;
    }

    public CreateCallType getType() {
        return this.callType;
    }

    public String getRequestURI() {
        return this.to;
    }

    public String getAccountSid() {
        return this.accountId.toString();
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    public String toString() {
        return "From: " + this.from + ", To: " + this.to + ", Type: " + this.callType.name() + ", AccountId: " + this.accountId + ", isFromApi: " + this.isFromApi + ", parentCallSidExists: " + this.isParentCallSidExists();
    }
}

