/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.sdp.SdpException;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.javax.servlet.sip.SipSessionExt;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.fsm.TransitionFailedException;
import org.restcomm.connect.commons.fsm.TransitionNotFoundException;
import org.restcomm.connect.commons.fsm.TransitionRollbackException;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.commons.util.SdpUtils;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.mscontrol.api.messages.CloseMediaSession;
import org.restcomm.connect.mscontrol.api.messages.Collect;
import org.restcomm.connect.mscontrol.api.messages.CreateMediaSession;
import org.restcomm.connect.mscontrol.api.messages.JoinBridge;
import org.restcomm.connect.mscontrol.api.messages.JoinComplete;
import org.restcomm.connect.mscontrol.api.messages.JoinConference;
import org.restcomm.connect.mscontrol.api.messages.Leave;
import org.restcomm.connect.mscontrol.api.messages.Left;
import org.restcomm.connect.mscontrol.api.messages.MediaGroupResponse;
import org.restcomm.connect.mscontrol.api.messages.MediaServerControllerStateChanged;
import org.restcomm.connect.mscontrol.api.messages.MediaSessionInfo;
import org.restcomm.connect.mscontrol.api.messages.Mute;
import org.restcomm.connect.mscontrol.api.messages.Play;
import org.restcomm.connect.mscontrol.api.messages.Record;
import org.restcomm.connect.mscontrol.api.messages.StartRecording;
import org.restcomm.connect.mscontrol.api.messages.Stop;
import org.restcomm.connect.mscontrol.api.messages.StopMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.StopRecording;
import org.restcomm.connect.mscontrol.api.messages.Unmute;
import org.restcomm.connect.mscontrol.api.messages.UpdateMediaSession;
import org.restcomm.connect.telephony.api.Answer;
import org.restcomm.connect.telephony.api.CallFail;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.CallResponse;
import org.restcomm.connect.telephony.api.CallStateChanged;
import org.restcomm.connect.telephony.api.Cancel;
import org.restcomm.connect.telephony.api.ChangeCallDirection;
import org.restcomm.connect.telephony.api.CreateCall;
import org.restcomm.connect.telephony.api.Dial;
import org.restcomm.connect.telephony.api.GetCallInfo;
import org.restcomm.connect.telephony.api.GetCallObservers;
import org.restcomm.connect.telephony.api.Hangup;
import org.restcomm.connect.telephony.api.InitializeOutbound;
import org.restcomm.connect.telephony.api.Reject;
import org.restcomm.connect.telephony.api.RemoveParticipant;
import scala.concurrent.duration.Duration;

@Immutable
public final class Call
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private static final String INBOUND = "inbound";
    private static final String OUTBOUND_API = "outbound-api";
    private static final String OUTBOUND_DIAL = "outbound-dial";
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State initializing;
    private final State queued;
    private final State failingBusy;
    private final State ringing;
    private final State busy;
    private final State notFound;
    private final State canceling;
    private final State canceled;
    private final State failingNoAnswer;
    private final State noAnswer;
    private final State dialing;
    private final State updatingMediaSession;
    private final State inProgress;
    private final State joining;
    private final State leaving;
    private final State stopping;
    private final State completed;
    private final State failed;
    private boolean fail;
    private final SipFactory factory;
    private String apiVersion;
    private Sid accountId;
    private String name;
    private SipURI from;
    private SipURI to;
    private Map<String, String> headers;
    private String username;
    private String password;
    private CreateCall.Type type;
    private long timeout;
    private SipServletRequest invite;
    private SipServletResponse lastResponse;
    private final Sid id;
    private final String instanceId;
    private CallStateChanged.State external;
    private String direction;
    private String forwardedFrom;
    private DateTime created;
    private DateTime callUpdatedTime;
    private final List<ActorRef> observers;
    private boolean receivedBye;
    private boolean muted;
    private boolean webrtc;
    private ActorRef conference;
    private boolean conferencing;
    private ActorRef bridge;
    private final ActorRef msController;
    private MediaSessionInfo mediaSessionInfo;
    private CallDetailRecord outgoingCallRecord;
    private CallDetailRecordsDao recordsDao;
    private DaoManager daoManager;
    private boolean liveCallModification;
    private boolean recording;
    private Sid parentCallSid;
    private Configuration runtimeSettings;
    private Configuration configuration;
    private boolean disableSdpPatchingOnUpdatingMediaSession;
    private Sid inboundCallSid;

    public Call(SipFactory factory, ActorRef mediaSessionController, Configuration configuration) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.initializing = new State("initializing", (Action)new Initializing(source), null);
        this.queued = new State("queued", (Action)new Queued(source), null);
        this.ringing = new State("ringing", (Action)new Ringing(source), null);
        this.failingBusy = new State("failing busy", (Action)new FailingBusy(source), null);
        this.busy = new State("busy", (Action)new Busy(source), null);
        this.notFound = new State("not found", (Action)new NotFound(source), null);
        this.canceling = new State("canceling", (Action)new Canceling(source));
        this.canceled = new State("canceled", (Action)new Canceled(source), null);
        this.failingNoAnswer = new State("failing no answer", (Action)new FailingNoAnswer(source), null);
        this.noAnswer = new State("no answer", (Action)new NoAnswer(source), null);
        this.dialing = new State("dialing", (Action)new Dialing(source), null);
        this.updatingMediaSession = new State("updating media session", (Action)new UpdatingMediaSession(source), null);
        this.inProgress = new State("in progress", (Action)new InProgress(source), null);
        this.joining = new State("joining", (Action)new Joining(source), null);
        this.leaving = new State("leaving", (Action)new Leaving(source), null);
        this.stopping = new State("stopping", (Action)new Stopping(source), null);
        this.completed = new State("completed", (Action)new Completed(source), null);
        this.failed = new State("failed", (Action)new Failed(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.ringing));
        transitions.add(new Transition(this.uninitialized, this.queued));
        transitions.add(new Transition(this.uninitialized, this.canceled));
        transitions.add(new Transition(this.uninitialized, this.completed));
        transitions.add(new Transition(this.queued, this.canceled));
        transitions.add(new Transition(this.queued, this.initializing));
        transitions.add(new Transition(this.ringing, this.busy));
        transitions.add(new Transition(this.ringing, this.notFound));
        transitions.add(new Transition(this.ringing, this.canceling));
        transitions.add(new Transition(this.ringing, this.canceled));
        transitions.add(new Transition(this.ringing, this.failingNoAnswer));
        transitions.add(new Transition(this.ringing, this.failingBusy));
        transitions.add(new Transition(this.ringing, this.noAnswer));
        transitions.add(new Transition(this.ringing, this.initializing));
        transitions.add(new Transition(this.ringing, this.updatingMediaSession));
        transitions.add(new Transition(this.ringing, this.completed));
        transitions.add(new Transition(this.ringing, this.stopping));
        transitions.add(new Transition(this.ringing, this.failed));
        transitions.add(new Transition(this.initializing, this.canceling));
        transitions.add(new Transition(this.initializing, this.dialing));
        transitions.add(new Transition(this.initializing, this.failed));
        transitions.add(new Transition(this.initializing, this.inProgress));
        transitions.add(new Transition(this.initializing, this.stopping));
        transitions.add(new Transition(this.dialing, this.canceling));
        transitions.add(new Transition(this.dialing, this.stopping));
        transitions.add(new Transition(this.dialing, this.failingBusy));
        transitions.add(new Transition(this.dialing, this.ringing));
        transitions.add(new Transition(this.dialing, this.failed));
        transitions.add(new Transition(this.dialing, this.failingNoAnswer));
        transitions.add(new Transition(this.dialing, this.noAnswer));
        transitions.add(new Transition(this.dialing, this.updatingMediaSession));
        transitions.add(new Transition(this.inProgress, this.stopping));
        transitions.add(new Transition(this.inProgress, this.joining));
        transitions.add(new Transition(this.inProgress, this.leaving));
        transitions.add(new Transition(this.inProgress, this.failed));
        transitions.add(new Transition(this.joining, this.inProgress));
        transitions.add(new Transition(this.joining, this.stopping));
        transitions.add(new Transition(this.joining, this.failed));
        transitions.add(new Transition(this.leaving, this.inProgress));
        transitions.add(new Transition(this.leaving, this.stopping));
        transitions.add(new Transition(this.leaving, this.failed));
        transitions.add(new Transition(this.canceling, this.canceled));
        transitions.add(new Transition(this.canceling, this.completed));
        transitions.add(new Transition(this.failingBusy, this.busy));
        transitions.add(new Transition(this.failingNoAnswer, this.noAnswer));
        transitions.add(new Transition(this.failingNoAnswer, this.canceling));
        transitions.add(new Transition(this.updatingMediaSession, this.inProgress));
        transitions.add(new Transition(this.updatingMediaSession, this.failed));
        transitions.add(new Transition(this.stopping, this.completed));
        transitions.add(new Transition(this.stopping, this.failed));
        transitions.add(new Transition(this.failed, this.completed));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.factory = factory;
        this.conferencing = false;
        this.msController = mediaSessionController;
        this.fail = false;
        this.id = Sid.generate((Sid.Type)Sid.Type.CALL);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
        this.created = DateTime.now();
        this.observers = Collections.synchronizedList(new ArrayList());
        this.receivedBye = false;
        this.liveCallModification = false;
        this.recording = false;
        this.configuration = configuration;
        this.disableSdpPatchingOnUpdatingMediaSession = this.configuration.subset("runtime-settings").getBoolean("disable-sdp-patching-on-updating-mediasession", false);
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    private boolean isInbound() {
        return INBOUND.equals(this.direction);
    }

    private boolean isOutbound() {
        return !this.isInbound();
    }

    private CallResponse<CallInfo> info() {
        String from = this.from.getUser();
        String to = this.to.getUser();
        CallInfo info = new CallInfo(this.id, this.external, this.type, this.direction, this.created, this.forwardedFrom, this.name, from, to, this.invite, this.lastResponse, this.webrtc, this.muted, this.callUpdatedTime);
        return new CallResponse((Object)info);
    }

    private void forwarding(Object message) {
    }

    private SipURI getInitialIpAddressPort(SipServletMessage message) throws ServletParseException, UnknownHostException {
        SipURI uri = null;
        try {
            String realIP = message.getInitialRemoteAddr();
            Integer realPort = message.getInitialRemotePort();
            if (realPort == null || realPort == -1) {
                realPort = 5060;
            }
            if (realPort == 0) {
                realPort = message.getRemotePort();
            }
            ListIterator recordRouteHeaders = message.getHeaders("Record-Route");
            Address contactAddr = this.factory.createAddress(message.getHeader("Contact"));
            InetAddress contactInetAddress = InetAddress.getByName(((SipURI)contactAddr.getURI()).getHost());
            InetAddress inetAddress = InetAddress.getByName(realIP);
            int remotePort = message.getRemotePort();
            int contactPort = ((SipURI)contactAddr.getURI()).getPort();
            String remoteAddress = message.getRemoteAddr();
            String initialIpBeforeLB = message.getHeader("X-Sip-Balancer-InitialRemoteAddr");
            String initialPortBeforeLB = message.getHeader("X-Sip-Balancer-InitialRemotePort");
            String contactAddress = ((SipURI)contactAddr.getURI()).getHost();
            if (initialIpBeforeLB != null) {
                if (initialPortBeforeLB == null) {
                    initialPortBeforeLB = "5060";
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("We are behind load balancer, storing Initial Remote Address " + initialIpBeforeLB + ":" + initialPortBeforeLB + " to the session for later use");
                }
                realIP = initialIpBeforeLB + ":" + initialPortBeforeLB;
                uri = this.factory.createSipURI(null, realIP);
            } else if (contactInetAddress.isSiteLocalAddress() && !recordRouteHeaders.hasNext() && !contactInetAddress.toString().equalsIgnoreCase(inetAddress.toString())) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Contact header address " + contactAddr.toString() + " is a private network ip address, storing Initial Remote Address " + realIP + ":" + realPort + " to the session for later use");
                }
                realIP = realIP + ":" + realPort;
                uri = this.factory.createSipURI(null, realIP);
            }
        }
        catch (Exception e) {
            this.logger.warning("Exception while trying to get the Initial IP Address and Port: " + e);
        }
        return uri;
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        State state = this.fsm.state();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("********** Call's " + this.self().path() + " Current State: \"" + state.toString() + " direction: " + this.direction);
            this.logger.info("********** Call " + this.self().path() + " Processing Message: \"" + klass.getName() + " sender : " + sender.path().toString());
        }
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (GetCallObservers.class.equals(klass)) {
            this.onGetCallObservers((GetCallObservers)message, self, sender);
        } else if (GetCallInfo.class.equals(klass)) {
            this.onGetCallInfo((GetCallInfo)message, sender);
        } else if (InitializeOutbound.class.equals(klass)) {
            this.onInitializeOutbound((InitializeOutbound)message, self, sender);
        } else if (ChangeCallDirection.class.equals(klass)) {
            this.onChangeCallDirection((ChangeCallDirection)message, self, sender);
        } else if (Answer.class.equals(klass)) {
            this.onAnswer((Answer)message, self, sender);
        } else if (Dial.class.equals(klass)) {
            this.onDial((Dial)message, self, sender);
        } else if (Reject.class.equals(klass)) {
            this.onReject((Reject)message, self, sender);
        } else if (CallFail.class.equals(klass)) {
            this.fsm.transition(message, this.failed);
        } else if (JoinComplete.class.equals(klass)) {
            this.onJoinComplete((JoinComplete)message, self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecordingCall((StartRecording)message, self, sender);
        } else if (StopRecording.class.equals(klass)) {
            this.onStopRecordingCall((StopRecording)message, self, sender);
        } else if (Cancel.class.equals(klass)) {
            this.onCancel((Cancel)message, self, sender);
        } else if (message instanceof ReceiveTimeout) {
            this.onReceiveTimeout((ReceiveTimeout)message, self, sender);
        } else if (message instanceof SipServletRequest) {
            this.onSipServletRequest((SipServletRequest)message, self, sender);
        } else if (message instanceof SipServletResponse) {
            this.onSipServletResponse((SipServletResponse)message, self, sender);
        } else if (Hangup.class.equals(klass)) {
            this.onHangup((Hangup)message, self, sender);
        } else if (org.restcomm.connect.telephony.api.NotFound.class.equals(klass)) {
            this.onNotFound((org.restcomm.connect.telephony.api.NotFound)message, self, sender);
        } else if (MediaServerControllerStateChanged.class.equals(klass)) {
            this.onMediaServerControllerStateChanged((MediaServerControllerStateChanged)message, self, sender);
        } else if (JoinConference.class.equals(klass)) {
            this.onJoinConference((JoinConference)message, self, sender);
        } else if (JoinBridge.class.equals(klass)) {
            this.onJoinBridge((JoinBridge)message, self, sender);
        } else if (Leave.class.equals(klass)) {
            this.onLeave((Leave)message, self, sender);
        } else if (Left.class.equals(klass)) {
            this.onLeft((Left)message, self, sender);
        } else if (Record.class.equals(klass)) {
            this.onRecord((Record)message, self, sender);
        } else if (Play.class.equals(klass)) {
            this.onPlay((Play)message, self, sender);
        } else if (Collect.class.equals(klass)) {
            this.onCollect((Collect)message, self, sender);
        } else if (StopMediaGroup.class.equals(klass)) {
            this.onStopMediaGroup((StopMediaGroup)message, self, sender);
        } else if (Mute.class.equals(klass)) {
            this.onMute((Mute)message, self, sender);
        } else if (Unmute.class.equals(klass)) {
            this.onUnmute((Unmute)message, self, sender);
        }
    }

    private void addCustomHeaders(SipServletMessage message) {
        if (this.apiVersion != null) {
            message.addHeader("X-RestComm-ApiVersion", this.apiVersion);
        }
        if (this.accountId != null) {
            message.addHeader("X-RestComm-AccountSid", this.accountId.toString());
        }
        message.addHeader("X-RestComm-CallSid", this.instanceId + "-" + this.id.toString());
    }

    private void sendCallInfoToObservers() {
        for (ActorRef observer : this.observers) {
            observer.tell(this.info(), this.self());
        }
    }

    private void processInfo(SipServletRequest request) throws IOException {
        SipServletResponse okay = request.createResponse(200);
        this.addCustomHeaders((SipServletMessage)okay);
        okay.send();
        String digits = null;
        if (request.getContentType().equalsIgnoreCase("application/dtmf-relay")) {
            String content = new String(request.getRawContent());
            digits = content.split("\n")[0].replaceFirst("Signal=", "").trim();
        } else {
            digits = new String(request.getRawContent());
        }
        if (digits != null) {
            MediaGroupResponse infoResponse = new MediaGroupResponse((Object)digits);
            for (ActorRef observer : this.observers) {
                observer.tell((Object)infoResponse, this.self());
            }
            this.msController.tell((Object)new Stop(), this.self());
        }
    }

    private void onRecord(Record message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress)) {
            this.recording = true;
            this.msController.tell((Object)message, sender);
        }
    }

    private void onPlay(Play message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress)) {
            this.msController.tell((Object)message, sender);
        }
    }

    private void onCollect(Collect message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress)) {
            this.msController.tell((Object)message, sender);
        }
    }

    private void onStopMediaGroup(StopMediaGroup message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress)) {
            this.msController.tell((Object)message, sender);
        }
    }

    private void onMute(Mute message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress)) {
            this.msController.tell((Object)message, sender);
            this.muted = true;
        }
    }

    private void onUnmute(Unmute message, ActorRef self, ActorRef sender) {
        if (this.is(this.inProgress) && this.muted) {
            this.msController.tell((Object)message, sender);
            this.muted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) throws Exception {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving stopObservingMessage, ActorRef self, ActorRef sender) throws Exception {
        ActorRef observer = stopObservingMessage.observer();
        if (observer != null) {
            observer.tell((Object)stopObservingMessage, self);
            this.observers.remove(observer);
        } else {
            for (ActorRef observerNext : this.observers) {
                observerNext.tell((Object)stopObservingMessage, self);
                if (!this.logger.isInfoEnabled()) continue;
                this.logger.info("Sent stop observing for call, from: " + this.from + " to: " + this.to + " direction: " + this.direction + " to observer: " + observerNext.path() + " observer is terminated: " + observerNext.isTerminated());
            }
            this.observers.clear();
        }
    }

    private void onGetCallObservers(GetCallObservers message, ActorRef self, ActorRef sender) throws Exception {
        sender.tell((Object)new CallResponse(this.observers), self);
    }

    private void onGetCallInfo(GetCallInfo message, ActorRef sender) throws Exception {
        sender.tell(this.info(), this.self());
    }

    private void onInitializeOutbound(InitializeOutbound message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.fsm.transition((Object)message, this.queued);
        }
    }

    private void onChangeCallDirection(ChangeCallDirection message, ActorRef self, ActorRef sender) {
        this.direction = INBOUND;
        this.liveCallModification = true;
        this.conferencing = false;
        this.conference = null;
        this.bridge = null;
    }

    private void onAnswer(Answer message, ActorRef self, ActorRef sender) throws Exception {
        this.inboundCallSid = message.callSid();
        if (this.is(this.ringing) && !this.invite.getSession().getState().equals((Object)SipSession.State.TERMINATED)) {
            this.fsm.transition((Object)message, this.initializing);
        } else {
            this.fsm.transition((Object)message, this.canceled);
        }
    }

    private void onDial(Dial message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.queued)) {
            this.fsm.transition((Object)message, this.initializing);
        }
    }

    private void onReject(Reject message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.ringing)) {
            this.fsm.transition((Object)message, this.busy);
        }
    }

    private void onCancel(Cancel message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.initializing) || this.is(this.dialing) || this.is(this.ringing) || this.is(this.failingNoAnswer)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Got CANCEL for Call with the following details, from: " + this.from + " to: " + this.to + " direction: " + this.direction + " state: " + this.fsm.state() + ", will Cancel the call");
            }
            this.fsm.transition((Object)message, this.canceling);
        } else if (this.is(this.inProgress)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Got CANCEL for Call with the following details, from: " + this.from + " to: " + this.to + " direction: " + this.direction + " state: " + this.fsm.state() + ", will Hangup the call");
            }
            this.onHangup(new Hangup(), this.self(), this.sender());
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Got CANCEL for Call with the following details, from: " + this.from + " to: " + this.to + " direction: " + this.direction + " state: " + this.fsm.state());
        }
    }

    private void onReceiveTimeout(ReceiveTimeout message, ActorRef self, ActorRef sender) throws Exception {
        this.getContext().setReceiveTimeout((Duration)Duration.Undefined());
        if (this.is(this.ringing) || this.is(this.dialing)) {
            this.fsm.transition((Object)message, this.failingNoAnswer);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Timeout received for Call : " + this.self().path() + " isTerminated(): " + this.self().isTerminated() + ". Sender: " + sender.path().toString() + " State: " + this.fsm.state() + " Direction: " + this.direction + " From: " + this.from + " To: " + this.to);
        }
    }

    private void onSipServletRequest(SipServletRequest message, ActorRef self, ActorRef sender) throws Exception {
        String method = message.getMethod();
        if ("INVITE".equalsIgnoreCase(method)) {
            if (this.is(this.uninitialized)) {
                this.fsm.transition((Object)message, this.ringing);
            }
        } else if ("CANCEL".equalsIgnoreCase(method)) {
            if (this.is(this.initializing)) {
                this.fsm.transition((Object)message, this.canceling);
            } else if (this.is(this.ringing) && this.isInbound()) {
                this.fsm.transition((Object)message, this.canceling);
            }
        } else if ("BYE".equalsIgnoreCase(method)) {
            this.receivedBye = true;
            SipServletRequest bye = message;
            SipServletResponse okay = bye.createResponse(200);
            okay.send();
            if (this.recording) {
                if (!this.direction.contains("outbound")) {
                    this.recording = false;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Call Direction: " + this.direction);
                        this.logger.info("Initial Call - Will stop recording now");
                    }
                    this.msController.tell((Object)new Stop(false), self);
                } else if (this.conference != null) {
                    this.conference.tell((Object)new StopRecording(this.accountId, this.runtimeSettings, this.daoManager), null);
                }
            }
            if (this.conferencing) {
                this.conference.tell((Object)new RemoveParticipant(self), self);
            } else if (!this.is(this.completed)) {
                this.fsm.transition((Object)message, this.stopping);
            }
        } else if ("INFO".equalsIgnoreCase(method)) {
            this.processInfo(message);
        } else if ("ACK".equalsIgnoreCase(method) && this.isInbound() && this.is(this.initializing)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ACK received moving state to inProgress");
            }
            this.fsm.transition((Object)message, this.inProgress);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSipServletResponse(SipServletResponse message, ActorRef self, ActorRef sender) throws Exception {
        this.lastResponse = message;
        int code = message.getStatus();
        switch (code) {
            case 181: {
                this.forwarding(message);
                return;
            }
            case 180: 
            case 183: {
                if (this.is(this.ringing)) return;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Got 180 Ringing for Call: " + this.self().path() + " To: " + this.to + " sender: " + sender.path() + " observers size: " + this.observers.size());
                }
                this.fsm.transition((Object)message, this.ringing);
                return;
            }
            case 486: 
            case 600: 
            case 603: {
                this.sendCallInfoToObservers();
                this.fsm.transition((Object)message, this.failingBusy);
                return;
            }
            case 401: 
            case 407: {
                if ((this.username != null || this.username.isEmpty()) && this.password != null && this.password.isEmpty()) {
                    this.sendCallInfoToObservers();
                    this.fsm.transition((Object)message, this.failed);
                    return;
                }
                AuthInfo authInfo = this.factory.createAuthInfo();
                String authHeader = message.getHeader("Proxy-Authenticate");
                if (authHeader == null) {
                    authHeader = message.getHeader("WWW-Authenticate");
                }
                String tempRealm = authHeader.substring(authHeader.indexOf("realm=\"") + "realm=\"".length());
                String realm = tempRealm.substring(0, tempRealm.indexOf("\""));
                authInfo.addAuthInfo(message.getStatus(), realm, this.username, this.password);
                SipServletRequest challengeRequest = message.getSession().createRequest(message.getRequest().getMethod());
                challengeRequest.addAuthHeader(message, authInfo);
                challengeRequest.setContent(this.invite.getContent(), this.invite.getContentType());
                this.invite = challengeRequest;
                this.invite.setContent(message.getRequest().getContent(), "application/sdp");
                challengeRequest.send();
                return;
            }
            case 200: {
                if (!this.is(this.dialing)) {
                    if (!this.is(this.ringing)) return;
                    if (INBOUND.equals(this.direction)) return;
                }
                this.fsm.transition((Object)message, this.updatingMediaSession);
                return;
            }
        }
        if (code < 400) return;
        if (code == 487) return;
        if (code == 487 && this.isOutbound()) {
            String initialPortBeforeLB;
            String initialIpBeforeLB;
            block23: {
                initialIpBeforeLB = null;
                initialPortBeforeLB = null;
                try {
                    initialIpBeforeLB = message.getHeader("X-Sip-Balancer-InitialRemoteAddr");
                    initialPortBeforeLB = message.getHeader("X-Sip-Balancer-InitialRemotePort");
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block23;
                    this.logger.debug("Exception during check of LB custom headers for IP address and port");
                }
            }
            SipServletRequest ack = message.createAck();
            this.addCustomHeaders((SipServletMessage)ack);
            SipSession session = message.getSession();
            if (initialIpBeforeLB != null) {
                if (initialPortBeforeLB == null) {
                    initialPortBeforeLB = "5060";
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("We are behind load balancer, will use: " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for ACK message, ");
                }
                String realIP = initialIpBeforeLB + ":" + initialPortBeforeLB;
                SipURI uri = this.factory.createSipURI(null, realIP);
                ack.setRequestURI((URI)uri);
            } else if (!ack.getHeaders("Route").hasNext()) {
                SipServletRequest originalInvite = message.getRequest();
                SipURI realInetUri = (SipURI)originalInvite.getRequestURI();
                if ((SipURI)session.getAttribute("realInetUri") == null) {
                    session.setAttribute("realInetUri", (Object)realInetUri);
                }
                InetAddress ackRURI = InetAddress.getByName(((SipURI)ack.getRequestURI()).getHost());
                int ackRURIPort = ((SipURI)ack.getRequestURI()).getPort();
                if (realInetUri != null && (ackRURI.isSiteLocalAddress() || ackRURI.isAnyLocalAddress() || ackRURI.isLoopbackAddress()) && ackRURIPort != realInetUri.getPort()) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Using the real ip address and port of the sip client " + realInetUri.toString() + " as a request uri of the ACK");
                    }
                    ack.setRequestURI((URI)realInetUri);
                }
            }
            ack.send();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Just sent out ACK : " + ack.toString());
            }
        }
        this.fail = true;
        this.fsm.transition((Object)message, this.stopping);
    }

    private void onHangup(Hangup message, ActorRef self, ActorRef sender) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Got Hangup for Call, from: " + this.from + " to: " + this.to + " state: " + this.fsm.state());
        }
        if (this.is(this.updatingMediaSession) || this.is(this.ringing) || this.is(this.queued) || this.is(this.dialing) || this.is(this.inProgress)) {
            if (!this.receivedBye) {
                this.sendBye(message);
            }
            if (this.recording) {
                this.recording = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Call - Will stop recording now");
                }
                this.msController.tell((Object)new Stop(true), self);
            }
            this.fsm.transition((Object)message, this.stopping);
        }
    }

    private void sendBye(Hangup hangup) throws IOException, TransitionNotFoundException, TransitionFailedException, TransitionRollbackException {
        block26: {
            SipSession session = this.invite.getSession();
            String sessionState = session.getState().name();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("About to send BYE, session state: " + sessionState);
            }
            if (sessionState == SipSession.State.INITIAL.name() || sessionState == SipSession.State.EARLY.name() && this.isInbound()) {
                SipServletResponse resp = this.invite.createResponse(500);
                if (hangup.getMessage() != null && !hangup.getMessage().equals("")) {
                    resp.addHeader("Reason", hangup.getMessage());
                }
                this.addCustomHeaders((SipServletMessage)resp);
                resp.send();
                this.fsm.transition((Object)hangup, this.completed);
                return;
            }
            if (sessionState == SipSession.State.EARLY.name()) {
                SipServletRequest cancel = this.invite.createCancel();
                if (hangup.getMessage() != null && !hangup.getMessage().equals("")) {
                    cancel.addHeader("Reason", hangup.getMessage());
                }
                this.addCustomHeaders((SipServletMessage)cancel);
                cancel.send();
                this.fsm.transition((Object)hangup, this.completed);
                return;
            }
            SipServletRequest bye = session.createRequest("BYE");
            this.addCustomHeaders((SipServletMessage)bye);
            if (hangup.getMessage() != null && !hangup.getMessage().equals("")) {
                bye.addHeader("Reason", hangup.getMessage());
            }
            SipURI realInetUri = (SipURI)session.getAttribute("realInetUri");
            InetAddress byeRURI = InetAddress.getByName(((SipURI)bye.getRequestURI()).getHost());
            ListIterator recordRouteList = this.invite.getHeaders("Record-Route");
            if (this.invite.getHeader("X-Sip-Balancer-InitialRemoteAddr") != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("We are behind LoadBalancer and will remove the first two RecordRoutes since they are the LB node");
                }
                recordRouteList.next();
                recordRouteList.remove();
                recordRouteList.next();
                recordRouteList.remove();
            }
            if (recordRouteList.hasNext()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Record Route is set, wont change the Request URI");
                }
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Checking RURI, realInetUri: " + realInetUri + " byeRURI: " + byeRURI);
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("byeRURI.isSiteLocalAddress(): " + byeRURI.isSiteLocalAddress());
                    this.logger.debug("byeRURI.isAnyLocalAddress(): " + byeRURI.isAnyLocalAddress());
                    this.logger.debug("byeRURI.isLoopbackAddress(): " + byeRURI.isLoopbackAddress());
                }
                if (realInetUri != null && (byeRURI.isSiteLocalAddress() || byeRURI.isAnyLocalAddress() || byeRURI.isLoopbackAddress())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("real ip address of the sip client " + realInetUri.toString() + " is not null, checking if the request URI needs to be patched");
                    }
                    boolean patchRURI = true;
                    try {
                        ListIterator routes = bye.getAddressHeaders("Route");
                        while (routes.hasNext() && patchRURI) {
                            SipURI route = (SipURI)((Address)routes.next()).getURI();
                            String routeHost = route.getHost();
                            int routePort = route.getPort();
                            if (routePort < 0) {
                                routePort = 5060;
                            }
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("Checking if route " + routeHost + ":" + routePort + " is matching ip and port of realNetURI " + realInetUri.getHost() + ":" + realInetUri.getPort() + " for the BYE request");
                            }
                            if (!routeHost.equalsIgnoreCase(realInetUri.getHost()) || routePort != realInetUri.getPort()) continue;
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("route " + route + " is matching ip and port of realNetURI " + realInetUri.getHost() + ":" + realInetUri.getPort() + " for the BYE request, so not patching the Request-URI");
                            }
                            patchRURI = false;
                        }
                    }
                    catch (ServletParseException e) {
                        this.logger.error("Impossible to parse the route set from the BYE " + bye, (Object)e);
                    }
                    if (patchRURI) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Using the real ip address of the sip client " + realInetUri.toString() + " as a request uri of the BYE request");
                        }
                        bye.setRequestURI((URI)realInetUri);
                    }
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Will sent out BYE to: " + bye.getRequestURI());
            }
            try {
                bye.send();
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block26;
                this.logger.debug("Exception during Send Bye: " + e.toString());
            }
        }
    }

    private void onNotFound(org.restcomm.connect.telephony.api.NotFound message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.ringing)) {
            this.fsm.transition((Object)message, this.notFound);
        }
    }

    private void onMediaServerControllerStateChanged(MediaServerControllerStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        switch (message.getState()) {
            case PENDING: {
                if (!this.is(this.initializing)) break;
                this.fsm.transition((Object)message, this.dialing);
                break;
            }
            case ACTIVE: {
                if (!this.is(this.initializing) && !this.is(this.updatingMediaSession)) break;
                SipSession.State sessionState = this.invite.getSession().getState();
                boolean waitForAck = false;
                if (!SipSession.State.CONFIRMED.equals((Object)sessionState) && !SipSession.State.TERMINATED.equals((Object)sessionState)) {
                    this.mediaSessionInfo = message.getMediaSession();
                    SipServletResponse okay = this.invite.createResponse(200);
                    byte[] sdp = this.mediaSessionInfo.getLocalSdp().getBytes();
                    String answer = null;
                    if (this.mediaSessionInfo.usesNat()) {
                        String externalIp = this.mediaSessionInfo.getExternalAddress().getHostAddress();
                        answer = SdpUtils.patch((String)"application/sdp", (byte[])sdp, (String)externalIp);
                    } else {
                        answer = this.mediaSessionInfo.getLocalSdp().toString();
                    }
                    answer = SdpUtils.endWithNewLine((String)answer);
                    okay.setContent((Object)answer, "application/sdp");
                    this.addCustomHeaders((SipServletMessage)okay);
                    okay.send();
                    waitForAck = true;
                } else if (SipSession.State.CONFIRMED.equals((Object)sessionState) && this.is(this.inProgress)) {
                    SipServletRequest reInvite = this.invite.getSession().createRequest("INVITE");
                    this.addCustomHeaders((SipServletMessage)reInvite);
                    this.mediaSessionInfo = message.getMediaSession();
                    byte[] sdp = this.mediaSessionInfo.getLocalSdp().getBytes();
                    String answer = null;
                    if (this.mediaSessionInfo.usesNat()) {
                        String externalIp = this.mediaSessionInfo.getExternalAddress().getHostAddress();
                        answer = SdpUtils.patch((String)"application/sdp", (byte[])sdp, (String)externalIp);
                    } else {
                        answer = this.mediaSessionInfo.getLocalSdp().toString();
                    }
                    answer = SdpUtils.endWithNewLine((String)answer);
                    reInvite.setContent((Object)answer, "application/sdp");
                    reInvite.send();
                }
                this.invite.getApplicationSession().setExpires(0);
                if (!waitForAck) {
                    this.fsm.transition((Object)message, this.inProgress);
                    break;
                }
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info("current state: " + this.fsm.state() + " , will wait for ACK to move to inProgress");
                break;
            }
            case INACTIVE: {
                if (this.is(this.stopping)) {
                    if (this.fail) {
                        this.fsm.transition((Object)message, this.failed);
                        break;
                    }
                    this.fsm.transition((Object)message, this.completed);
                    break;
                }
                if (this.is(this.canceling)) {
                    this.fsm.transition((Object)message, this.canceled);
                    break;
                }
                if (this.is(this.failingBusy)) {
                    this.fsm.transition((Object)message, this.busy);
                    break;
                }
                if (!this.is(this.failingNoAnswer)) break;
                this.fsm.transition((Object)message, this.noAnswer);
                break;
            }
            case FAILED: {
                if (!this.is(this.initializing) && !this.is(this.updatingMediaSession) && !this.is(this.joining) && !this.is(this.leaving)) break;
                this.fsm.transition((Object)message, this.failed);
                break;
            }
        }
    }

    private void onJoinBridge(JoinBridge message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.inProgress)) {
            this.bridge = sender;
            this.fsm.transition((Object)message, this.joining);
        }
    }

    private void onJoinConference(JoinConference message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.inProgress)) {
            this.conferencing = true;
            this.conference = sender;
            this.fsm.transition((Object)message, this.joining);
        }
    }

    private void onJoinComplete(JoinComplete message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.joining)) {
            if (this.conferencing) {
                this.conference.tell((Object)message, self);
            } else {
                this.bridge.tell((Object)message, self);
            }
            this.fsm.transition((Object)message, this.inProgress);
        }
    }

    private void onLeave(Leave message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.inProgress)) {
            this.fsm.transition((Object)message, this.leaving);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received Leave for Call: " + self.path() + ", but state is :" + this.fsm.state().toString());
        }
    }

    private void onLeft(Left message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.leaving)) {
            if (this.conferencing) {
                this.conferencing = false;
                this.conference.tell((Object)new Left(this.self()), self);
                this.conference = null;
            }
            this.fsm.transition((Object)message, this.inProgress);
        }
    }

    private void onStartRecordingCall(StartRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.inProgress)) {
            if (this.runtimeSettings == null) {
                this.runtimeSettings = message.getRuntimeSetting();
            }
            if (this.daoManager == null) {
                this.daoManager = message.getDaoManager();
            }
            if (this.accountId == null) {
                this.accountId = message.getAccountId();
            }
            message.setCallId(this.id);
            this.msController.tell((Object)message, sender);
            this.recording = true;
        }
    }

    private void onStopRecordingCall(StopRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.inProgress) && this.recording) {
            this.msController.tell((Object)message, sender);
            this.recording = false;
        }
    }

    public void postStop() {
        block3: {
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Call actor at postStop, path: " + this.self().path() + ", direction: " + this.direction + ", state: " + this.fsm.state() + ", isTerminated: " + this.self().isTerminated() + ", sender: " + this.sender());
                }
                this.onStopObserving(new StopObserving(), this.self(), null);
                this.getContext().stop(this.msController);
            }
            catch (Exception exception) {
                if (!this.logger.isInfoEnabled()) break block3;
                this.logger.info("Exception during Call postStop while trying to remove observers: " + exception);
            }
        }
        super.postStop();
    }

    private final class Completed
    extends AbstractAction {
        public Completed(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (Call.this.logger.isInfoEnabled()) {
                Call.this.logger.info("Completing Call sid: " + Call.this.id + " from: " + Call.this.from + " to: " + Call.this.to + " direction: " + Call.this.direction + " current external state: " + Call.this.external);
            }
            if (!Call.this.external.equals((Object)CallStateChanged.State.CANCELED)) {
                Call.this.external = CallStateChanged.State.COMPLETED;
            }
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.logger.isInfoEnabled()) {
                Call.this.logger.info("Call sid: " + Call.this.id + " from: " + Call.this.from + " to: " + Call.this.to + " direction: " + Call.this.direction + " new external state: " + Call.this.external);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.toString());
                DateTime now = DateTime.now();
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setEndTime(now);
                int seconds = (int)((now.getMillis() - Call.this.outgoingCallRecord.getStartTime().getMillis()) / 1000L);
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setDuration(Integer.valueOf(seconds));
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
                if (Call.this.logger.isDebugEnabled()) {
                    Call.this.logger.debug("Start: " + Call.this.outgoingCallRecord.getStartTime());
                    Call.this.logger.debug("End: " + Call.this.outgoingCallRecord.getEndTime());
                    Call.this.logger.debug("Duration: " + seconds);
                    Call.this.logger.debug("Just updated CDR for completed call");
                }
            }
        }
    }

    private final class Stopping
    extends AbstractAction {
        public Stopping(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Call.this.msController.tell((Object)new CloseMediaSession(), this.source);
        }
    }

    private final class Leaving
    extends AbstractAction {
        public Leaving(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (!Call.this.receivedBye) {
                Call.this.sendBye(new Hangup("Conference time limit reached"));
            }
            Call.this.msController.tell(message, this.source);
        }
    }

    private final class Joining
    extends AbstractAction {
        public Joining(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Call.this.msController.tell(message, this.source);
        }
    }

    private final class InProgress
    extends AbstractAction {
        public InProgress(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (Call.this.external != null && !Call.this.external.equals((Object)CallStateChanged.State.IN_PROGRESS)) {
                Call.this.external = CallStateChanged.State.IN_PROGRESS;
                CallStateChanged event = new CallStateChanged(Call.this.external);
                for (ActorRef observer : Call.this.observers) {
                    observer.tell((Object)event, this.source);
                }
                if (Call.this.outgoingCallRecord != null && Call.this.isOutbound() && !Call.this.outgoingCallRecord.getStatus().equalsIgnoreCase("in_progress")) {
                    Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                    Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setAnsweredBy(Call.this.to.getUser());
                    Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
                }
            }
        }
    }

    private final class UpdatingMediaSession
    extends AbstractAction {
        public UpdatingMediaSession(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            SipServletResponse response;
            if (Call.this.is(Call.this.dialing) || Call.this.is(Call.this.ringing)) {
                UntypedActorContext context = Call.this.getContext();
                context.setReceiveTimeout((Duration)Duration.Undefined());
            }
            if ((response = (SipServletResponse)message).getStatus() == 200 && Call.this.isOutbound()) {
                String initialPortBeforeLB;
                String initialIpBeforeLB;
                block26: {
                    initialIpBeforeLB = null;
                    initialPortBeforeLB = null;
                    try {
                        initialIpBeforeLB = response.getHeader("X-Sip-Balancer-InitialRemoteAddr");
                        initialPortBeforeLB = response.getHeader("X-Sip-Balancer-InitialRemotePort");
                    }
                    catch (Exception e) {
                        if (!Call.this.logger.isDebugEnabled()) break block26;
                        Call.this.logger.debug("Exception during check of LB custom headers for IP address and port");
                    }
                }
                SipServletRequest ack = response.createAck();
                Call.this.addCustomHeaders((SipServletMessage)ack);
                SipSession session = response.getSession();
                if (initialIpBeforeLB != null) {
                    if (initialPortBeforeLB == null) {
                        initialPortBeforeLB = "5060";
                    }
                    if (Call.this.logger.isDebugEnabled()) {
                        Call.this.logger.debug("We are behind load balancer, checking if the request URI needs to be patched");
                    }
                    String realIP = initialIpBeforeLB + ":" + initialPortBeforeLB;
                    SipURI uri = Call.this.factory.createSipURI(null, realIP);
                    boolean patchRURI = true;
                    try {
                        ListIterator routes = ack.getAddressHeaders("Route");
                        while (routes.hasNext() && patchRURI) {
                            SipURI route = (SipURI)((Address)routes.next()).getURI();
                            String routeHost = route.getHost();
                            int routePort = route.getPort();
                            if (routePort < 0) {
                                routePort = 5060;
                            }
                            if (Call.this.logger.isDebugEnabled()) {
                                Call.this.logger.debug("Checking if route " + routeHost + ":" + routePort + " is matching ip and port before LB " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the ACK request");
                            }
                            if (!routeHost.equalsIgnoreCase(initialIpBeforeLB) || routePort != Integer.parseInt(initialPortBeforeLB)) continue;
                            if (Call.this.logger.isDebugEnabled()) {
                                Call.this.logger.debug("route " + route + " is matching ip and port before LB " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the ACK request, so not patching the Request-URI");
                            }
                            patchRURI = false;
                        }
                    }
                    catch (ServletParseException e) {
                        Call.this.logger.error("Impossible to parse the route set from the ACK " + ack, (Object)e);
                    }
                    if (patchRURI) {
                        if (Call.this.logger.isDebugEnabled()) {
                            Call.this.logger.debug("We are behind load balancer, will use: " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for ACK message, ");
                        }
                        ack.setRequestURI((URI)uri);
                    }
                } else if (!ack.getHeaders("Route").hasNext()) {
                    SipServletRequest originalInvite = response.getRequest();
                    SipURI realInetUri = (SipURI)originalInvite.getRequestURI();
                    if ((SipURI)session.getAttribute("realInetUri") == null) {
                        session.setAttribute("realInetUri", (Object)realInetUri);
                    }
                    InetAddress ackRURI = InetAddress.getByName(((SipURI)ack.getRequestURI()).getHost());
                    int ackRURIPort = ((SipURI)ack.getRequestURI()).getPort();
                    if (realInetUri != null && (ackRURI.isSiteLocalAddress() || ackRURI.isAnyLocalAddress() || ackRURI.isLoopbackAddress()) && ackRURIPort != realInetUri.getPort()) {
                        if (Call.this.logger.isInfoEnabled()) {
                            Call.this.logger.info("Using the real ip address and port of the sip client " + realInetUri.toString() + " as a request uri of the ACK");
                        }
                        ack.setRequestURI((URI)realInetUri);
                    }
                }
                ack.send();
                if (Call.this.logger.isInfoEnabled()) {
                    Call.this.logger.info("Just sent out ACK : " + ack.toString());
                }
            }
            Call.this.callUpdatedTime = DateTime.now();
            if (Call.this.recordsDao != null && Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                int seconds = (int)((DateTime.now().getMillis() - Call.this.outgoingCallRecord.getStartTime().getMillis()) / 1000L);
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setRingDuration(Integer.valueOf(seconds));
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStartTime(DateTime.now());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
            String answer = null;
            if (!Call.this.disableSdpPatchingOnUpdatingMediaSession) {
                if (Call.this.logger.isInfoEnabled()) {
                    Call.this.logger.info("Will patch SDP answer from 200 OK received with the external IP Address from Response on updating media session");
                }
                String externalIp = response.getInitialRemoteAddr();
                byte[] sdp = response.getRawContent();
                answer = SdpUtils.patch((String)response.getContentType(), (byte[])sdp, (String)externalIp);
            } else {
                if (Call.this.logger.isInfoEnabled()) {
                    Call.this.logger.info("SDP Patching on updating media session is disabled");
                }
                answer = SdpUtils.getSdp((String)response.getContentType(), (byte[])response.getRawContent());
            }
            UpdateMediaSession update = new UpdateMediaSession(answer);
            Call.this.msController.tell((Object)update, this.source);
        }
    }

    private final class Initializing
    extends AbstractAction {
        public Initializing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Observe observe = new Observe(this.source);
            Call.this.msController.tell((Object)observe, this.source);
            CreateMediaSession command = null;
            if (Call.this.isOutbound()) {
                command = new CreateMediaSession("sendrecv", "", true, Call.this.webrtc, Call.this.id);
            } else if (!Call.this.liveCallModification) {
                command = this.generateRequest((SipServletMessage)Call.this.invite);
            } else if (Call.this.lastResponse != null && Call.this.lastResponse.getStatus() == 200) {
                command = this.generateRequest((SipServletMessage)Call.this.lastResponse);
            }
            Call.this.msController.tell((Object)command, this.source);
        }

        private CreateMediaSession generateRequest(SipServletMessage sipMessage) throws IOException, SdpException, ServletParseException {
            String externalIp = null;
            SipURI externalSipUri = (SipURI)sipMessage.getSession().getAttribute("realInetUri");
            if (externalSipUri != null) {
                if (Call.this.logger.isInfoEnabled()) {
                    Call.this.logger.info("ExternalSipUri stored in the sip session : " + externalSipUri.toString() + " will use host: " + externalSipUri.getHost().toString());
                }
                externalIp = externalSipUri.getHost().toString();
            } else {
                externalIp = sipMessage.getInitialRemoteAddr();
                if (Call.this.logger.isInfoEnabled()) {
                    Call.this.logger.info("ExternalSipUri stored in the session was null, will use the message InitialRemoteAddr: " + externalIp);
                }
            }
            byte[] sdp = sipMessage.getRawContent();
            String offer = SdpUtils.patch((String)sipMessage.getContentType(), (byte[])sdp, (String)externalIp);
            return new CreateMediaSession("sendrecv", offer, false, Call.this.webrtc, Call.this.inboundCallSid);
        }
    }

    private final class Failed
    extends AbstractAction {
        public Failed(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (Call.this.isInbound()) {
                String reason;
                SipServletResponse resp = Call.this.invite.createResponse(503, "Problem to setup services");
                Call.this.addCustomHeaders((SipServletMessage)resp);
                if (message instanceof CallFail && (reason = ((CallFail)message).getReason()) != null) {
                    resp.addHeader("Reason", reason);
                }
                resp.send();
            } else if (message instanceof CallFail) {
                Call.this.sendBye(new Hangup(((CallFail)message).getReason()));
            }
            Call.this.external = CallStateChanged.State.FAILED;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
        }
    }

    private final class NoAnswer
    extends AbstractAction {
        public NoAnswer(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Call.this.external = CallStateChanged.State.NO_ANSWER;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
        }
    }

    private final class NotFound
    extends AbstractAction {
        public NotFound(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (org.restcomm.connect.telephony.api.NotFound.class.equals(klass) && Call.this.isInbound()) {
                SipServletResponse notFound = Call.this.invite.createResponse(404);
                Call.this.addCustomHeaders((SipServletMessage)notFound);
                notFound.send();
            }
            Call.this.external = CallStateChanged.State.NOT_FOUND;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
        }
    }

    private final class Busy
    extends AbstractAction {
        public Busy(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Class<?> klass = message.getClass();
            if (Reject.class.equals(klass) && Call.this.is(Call.this.ringing) && Call.this.isInbound()) {
                Reject reject = (Reject)message;
                SipServletResponse rejectResponse = reject.getReason().equalsIgnoreCase("busy") ? Call.this.invite.createResponse(486) : Call.this.invite.createResponse(603);
                Call.this.addCustomHeaders((SipServletMessage)rejectResponse);
                rejectResponse.send();
            }
            Call.this.external = CallStateChanged.State.BUSY;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setDuration(Integer.valueOf(0));
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
                int seconds = (int)((DateTime.now().getMillis() - Call.this.outgoingCallRecord.getStartTime().getMillis()) / 1000L);
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setRingDuration(Integer.valueOf(seconds));
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
        }
    }

    private final class FailingNoAnswer
    extends Failing {
        public FailingNoAnswer(ActorRef source) {
            super(source);
        }

        @Override
        public void execute(Object message) throws Exception {
            if (Call.this.logger.isInfoEnabled()) {
                Call.this.logger.info("Call moves to failing state because no answer");
            }
            Call.this.fsm.transition(message, Call.this.noAnswer);
        }
    }

    private final class FailingBusy
    extends Failing {
        public FailingBusy(ActorRef source) {
            super(source);
        }
    }

    private abstract class Failing
    extends AbstractAction {
        public Failing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            if (message instanceof ReceiveTimeout) {
                UntypedActorContext context = Call.this.getContext();
                context.setReceiveTimeout((Duration)Duration.Undefined());
            }
            Call.this.callUpdatedTime = DateTime.now();
            Call.this.msController.tell((Object)new CloseMediaSession(), this.source);
        }
    }

    private final class Canceled
    extends AbstractAction {
        public Canceled(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Call.this.external = CallStateChanged.State.CANCELED;
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                if (Call.this.logger.isInfoEnabled()) {
                    Call.this.logger.info("Going to update CDR to CANCEL, call sid: " + Call.this.id + " from: " + Call.this.from + " to: " + Call.this.to + " direction: " + Call.this.direction);
                }
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
            Call.this.fsm.transition(message, Call.this.completed);
        }
    }

    private final class Canceling
    extends AbstractAction {
        public Canceling(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            try {
                if (Call.this.isOutbound() && (Call.this.invite.getSession().getState() != SipSession.State.INITIAL || Call.this.invite.getSession().getState() != SipSession.State.TERMINATED)) {
                    UntypedActorContext context = Call.this.getContext();
                    context.setReceiveTimeout((Duration)Duration.Undefined());
                    SipServletRequest cancel = Call.this.invite.createCancel();
                    Call.this.addCustomHeaders((SipServletMessage)cancel);
                    cancel.send();
                    if (Call.this.logger.isInfoEnabled()) {
                        Call.this.logger.info("Sent CANCEL for Call: " + Call.this.self().path() + ", state: " + Call.this.fsm.state() + ", direction: " + Call.this.direction);
                    }
                }
            }
            catch (Exception e) {
                StringBuffer strBuffer = new StringBuffer();
                strBuffer.append("Exception while trying to create Cancel for Call with the following details, from: " + Call.this.from + " to: " + Call.this.to + " direction: " + Call.this.direction + " call state: " + Call.this.fsm.state());
                if (Call.this.invite != null) {
                    strBuffer.append(" , invite RURI: " + Call.this.invite.getRequestURI());
                } else {
                    strBuffer.append(" , invite is NULL! ");
                }
                strBuffer.append(" Exception: " + e.getMessage());
                Call.this.logger.warning(strBuffer.toString());
            }
            Call.this.msController.tell((Object)new CloseMediaSession(), this.source);
        }
    }

    private final class Ringing
    extends AbstractAction {
        public Ringing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            SipURI initialInetUri;
            if (message instanceof SipServletRequest) {
                Call.this.invite = (SipServletRequest)message;
                Call.this.from = (SipURI)Call.this.invite.getFrom().getURI();
                Call.this.to = (SipURI)Call.this.invite.getTo().getURI();
                Call.this.timeout = -1L;
                Call.this.direction = Call.INBOUND;
                try {
                    SipServletResponse ringing = Call.this.invite.createResponse(180);
                    Call.this.addCustomHeaders((SipServletMessage)ringing);
                    ringing.send();
                }
                catch (IllegalStateException exception) {
                    if (Call.this.logger.isDebugEnabled()) {
                        Call.this.logger.debug("Exception while creating 180 response to inbound invite request");
                    }
                    Call.this.fsm.transition(message, Call.this.canceled);
                }
                initialInetUri = Call.this.getInitialIpAddressPort((SipServletMessage)Call.this.invite);
                if (initialInetUri != null) {
                    Call.this.invite.getSession().setAttribute("realInetUri", (Object)initialInetUri);
                }
            } else if (message instanceof SipServletResponse && (initialInetUri = Call.this.getInitialIpAddressPort((SipServletMessage)((SipServletResponse)message))) != null) {
                ((SipServletResponse)message).getSession().setAttribute("realInetUri", (Object)initialInetUri);
            }
            Call.this.external = CallStateChanged.State.RINGING;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.outgoingCallRecord != null && Call.this.isOutbound()) {
                Call.this.outgoingCallRecord = Call.this.outgoingCallRecord.setStatus(Call.this.external.name());
                Call.this.recordsDao.updateCallDetailRecord(Call.this.outgoingCallRecord);
            }
        }
    }

    private final class Dialing
    extends AbstractAction {
        public Dialing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            String transport;
            MediaServerControllerStateChanged response = (MediaServerControllerStateChanged)message;
            ActorRef self = Call.this.self();
            Call.this.mediaSessionInfo = response.getMediaSession();
            StringBuilder buffer = new StringBuilder();
            buffer.append(Call.this.to.getHost());
            if (Call.this.to.getPort() > -1) {
                buffer.append(":").append(Call.this.to.getPort());
            }
            if ((transport = Call.this.to.getTransportParam()) != null) {
                buffer.append(";transport=").append(Call.this.to.getTransportParam());
            }
            SipURI uri = Call.this.factory.createSipURI(null, buffer.toString());
            SipApplicationSession application = Call.this.factory.createApplicationSession();
            application.setAttribute(Call.class.getName(), (Object)self);
            if (Call.this.name != null && !Call.this.name.isEmpty()) {
                Address fromAddress = Call.this.factory.createAddress((URI)Call.this.from, Call.this.name);
                Address toAddress = Call.this.factory.createAddress((URI)Call.this.to);
                Call.this.invite = Call.this.factory.createRequest(application, "INVITE", fromAddress, toAddress);
            } else {
                Call.this.invite = Call.this.factory.createRequest(application, "INVITE", (URI)Call.this.from, (URI)Call.this.to);
            }
            Call.this.invite.pushRoute(uri);
            if (Call.this.headers != null) {
                Set entrySet = Call.this.headers.entrySet();
                for (Map.Entry entry : entrySet) {
                    Call.this.invite.addHeader("X-" + (String)entry.getKey(), (String)entry.getValue());
                }
            }
            Call.this.addCustomHeaders((SipServletMessage)Call.this.invite);
            SipSession session = Call.this.invite.getSession();
            session.setHandler("CallManager");
            if (Call.this.logger.isInfoEnabled()) {
                Call.this.logger.info("bypassLoadBalancer is set to: " + RestcommConfiguration.getInstance().getMain().getBypassLbForClients());
            }
            if (RestcommConfiguration.getInstance().getMain().getBypassLbForClients() && (Call.this.type.equals((Object)CreateCall.Type.CLIENT) || Call.this.type.equals((Object)CreateCall.Type.SIP))) {
                ((SipSessionExt)session).setBypassLoadBalancer(true);
                ((SipSessionExt)session).setBypassProxy(true);
            }
            String offer = null;
            if (Call.this.mediaSessionInfo.usesNat()) {
                String externalIp = Call.this.mediaSessionInfo.getExternalAddress().getHostAddress();
                byte[] sdp = Call.this.mediaSessionInfo.getLocalSdp().getBytes();
                offer = SdpUtils.patch((String)"application/sdp", (byte[])sdp, (String)externalIp);
            } else {
                offer = Call.this.mediaSessionInfo.getLocalSdp();
            }
            offer = SdpUtils.endWithNewLine((String)offer);
            Call.this.invite.setContent((Object)offer, "application/sdp");
            Call.this.invite.send();
            UntypedActorContext context = Call.this.getContext();
            context.setReceiveTimeout((Duration)Duration.create((long)Call.this.timeout, (TimeUnit)TimeUnit.SECONDS));
        }
    }

    private final class Queued
    extends AbstractAction {
        public Queued(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            InitializeOutbound request = (InitializeOutbound)message;
            Call.this.name = request.name();
            Call.this.from = request.from();
            Call.this.to = request.to();
            Call.this.apiVersion = request.apiVersion();
            Call.this.accountId = request.accountId();
            Call.this.username = request.username();
            Call.this.password = request.password();
            Call.this.type = request.type();
            Call.this.parentCallSid = request.getParentCallSid();
            Call.this.recordsDao = request.getDaoManager().getCallDetailRecordsDao();
            String toHeaderString = Call.this.to.toString();
            if (toHeaderString.indexOf(63) != -1) {
                Call.this.headers = new HashMap();
                Call.this.to = (SipURI)Call.this.factory.createURI(toHeaderString.substring(0, toHeaderString.lastIndexOf(63)));
                String headersString = toHeaderString.substring(toHeaderString.lastIndexOf(63) + 1);
                StringTokenizer tokenizer = new StringTokenizer(headersString, "&");
                while (tokenizer.hasMoreTokens()) {
                    String headerNameValue = tokenizer.nextToken();
                    String headerName = headerNameValue.substring(0, headerNameValue.lastIndexOf(61));
                    String headerValue = headerNameValue.substring(headerNameValue.lastIndexOf(61) + 1);
                    Call.this.headers.put(headerName, headerValue);
                }
            }
            Call.this.timeout = request.timeout();
            Call.this.direction = request.isFromApi() ? Call.OUTBOUND_API : Call.OUTBOUND_DIAL;
            Call.this.webrtc = request.isWebrtc();
            Call.this.external = CallStateChanged.State.QUEUED;
            CallStateChanged event = new CallStateChanged(Call.this.external);
            for (ActorRef observer : Call.this.observers) {
                observer.tell((Object)event, this.source);
            }
            if (Call.this.recordsDao != null) {
                CallDetailRecord cdr = Call.this.recordsDao.getCallDetailRecord(Call.this.id);
                if (cdr == null) {
                    CallDetailRecord.Builder builder = CallDetailRecord.builder();
                    builder.setSid(Call.this.id);
                    builder.setInstanceId(RestcommConfiguration.getInstance().getMain().getInstanceId());
                    builder.setDateCreated(Call.this.created);
                    builder.setAccountSid(Call.this.accountId);
                    builder.setTo(Call.this.to.getUser());
                    builder.setCallerName(Call.this.name);
                    builder.setStartTime(new DateTime());
                    String fromString = Call.this.from.getUser() != null ? Call.this.from.getUser() : "CALLS REST API";
                    builder.setFrom(fromString);
                    builder.setStatus(Call.this.external.name());
                    builder.setDirection(Call.OUTBOUND_API);
                    builder.setApiVersion(Call.this.apiVersion);
                    builder.setPrice(new BigDecimal("0.00"));
                    builder.setPriceUnit(Currency.getInstance("USD"));
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("/").append(Call.this.apiVersion).append("/Accounts/");
                    buffer.append(Call.this.accountId.toString()).append("/Calls/");
                    buffer.append(Call.this.id.toString());
                    java.net.URI uri = java.net.URI.create(buffer.toString());
                    builder.setUri(uri);
                    builder.setCallPath(Call.this.self().path().toString());
                    builder.setParentCallSid(Call.this.parentCallSid);
                    Call.this.outgoingCallRecord = builder.build();
                    Call.this.recordsDao.addCallDetailRecord(Call.this.outgoingCallRecord);
                } else {
                    cdr.setStatus(Call.this.external.name());
                }
            }
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

