/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.ReceiveTimeout$;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.sdp.SdpParseException;
import javax.servlet.ServletContext;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.commons.util.SdpUtils;
import org.restcomm.connect.commons.util.UriUtils;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.ApplicationsDao;
import org.restcomm.connect.dao.ClientsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.IncomingPhoneNumbersDao;
import org.restcomm.connect.dao.NotificationsDao;
import org.restcomm.connect.dao.RegistrationsDao;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.Application;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.dao.entities.IncomingPhoneNumber;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.dao.entities.Registration;
import org.restcomm.connect.extension.api.CallRequest;
import org.restcomm.connect.extension.api.ExtensionResponse;
import org.restcomm.connect.extension.api.ExtensionType;
import org.restcomm.connect.extension.api.RestcommExtensionGeneric;
import org.restcomm.connect.extension.controller.ExtensionController;
import org.restcomm.connect.interpreter.StartInterpreter;
import org.restcomm.connect.interpreter.StopInterpreter;
import org.restcomm.connect.interpreter.VoiceInterpreterBuilder;
import org.restcomm.connect.monitoringservice.MonitoringService;
import org.restcomm.connect.mscontrol.api.MediaServerControllerFactory;
import org.restcomm.connect.telephony.Call;
import org.restcomm.connect.telephony.api.CallManagerResponse;
import org.restcomm.connect.telephony.api.CallResponse;
import org.restcomm.connect.telephony.api.CallStateChanged;
import org.restcomm.connect.telephony.api.CreateCall;
import org.restcomm.connect.telephony.api.DestroyCall;
import org.restcomm.connect.telephony.api.ExecuteCallScript;
import org.restcomm.connect.telephony.api.GetActiveProxy;
import org.restcomm.connect.telephony.api.GetCall;
import org.restcomm.connect.telephony.api.GetCallObservers;
import org.restcomm.connect.telephony.api.GetProxies;
import org.restcomm.connect.telephony.api.GetRelatedCall;
import org.restcomm.connect.telephony.api.Hangup;
import org.restcomm.connect.telephony.api.InitializeOutbound;
import org.restcomm.connect.telephony.api.SwitchProxy;
import org.restcomm.connect.telephony.api.UpdateCallScript;
import org.restcomm.connect.telephony.api.util.B2BUAHelper;
import org.restcomm.connect.telephony.api.util.CallControlHelper;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public final class CallManager
extends UntypedActor {
    static final int ERROR_NOTIFICATION = 0;
    static final int WARNING_NOTIFICATION = 1;
    static final Pattern PATTERN = Pattern.compile("[\\*#0-9]{1,12}");
    static final String EMAIL_SENDER = "restcomm@restcomm.org";
    static final String EMAIL_SUBJECT = "RestComm Error Notification - Attention Required";
    private final ActorSystem system;
    private final Configuration configuration;
    private final ServletContext context;
    private final MediaServerControllerFactory msControllerFactory;
    private final ActorRef conferences;
    private final ActorRef bridges;
    private final ActorRef sms;
    private final SipFactory sipFactory;
    private final DaoManager storage;
    private final ActorRef monitoring;
    private boolean useTo;
    private boolean authenticateUsers;
    private AtomicInteger numberOfFailedCalls;
    private AtomicBoolean useFallbackProxy;
    private boolean allowFallback;
    private boolean allowFallbackToPrimary;
    private int maxNumberOfFailedCalls;
    private String primaryProxyUri;
    private String primaryProxyUsername;
    private String primaryProxyPassword;
    private String fallBackProxyUri;
    private String fallBackProxyUsername;
    private String fallBackProxyPassword;
    private String activeProxy;
    private String activeProxyUsername;
    private String activeProxyPassword;
    private String mediaExternalIp;
    private String myHostIp;
    private String proxyIp;
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private CreateCall createCallRequest;
    private SwitchProxy switchProxyRequest;
    private boolean patchForNatB2BUASessions;
    List<RestcommExtensionGeneric> extensions;

    private void sendNotification(String errMessage, int errCode, String errType, boolean createNotification) {
        NotificationsDao notifications = this.storage.getNotificationsDao();
        if (errType == "warning") {
            this.logger.warning(errMessage);
            if (createNotification) {
                Notification notification = this.notification(0, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "error") {
            this.logger.error(errMessage);
            if (createNotification) {
                Notification notification = this.notification(0, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "info" && this.logger.isInfoEnabled()) {
            this.logger.info(errMessage);
        }
    }

    public CallManager(Configuration configuration, ServletContext context, ActorSystem system, MediaServerControllerFactory msControllerFactory, ActorRef conferences, ActorRef bridges, ActorRef sms, SipFactory factory, DaoManager storage) {
        this.system = system;
        this.configuration = configuration;
        this.context = context;
        this.msControllerFactory = msControllerFactory;
        this.conferences = conferences;
        this.bridges = bridges;
        this.sms = sms;
        this.sipFactory = factory;
        this.storage = storage;
        Configuration runtime = configuration.subset("runtime-settings");
        Configuration outboundProxyConfig = runtime.subset("outbound-proxy");
        SipURI outboundIntf = this.outboundInterface("udp");
        if (outboundIntf != null) {
            this.myHostIp = outboundIntf.getHost().toString();
        } else {
            String errMsg = "SipURI outboundIntf is null";
            this.sendNotification(errMsg, 14001, "error", false);
            if (context == null) {
                errMsg = "SipServlet context is null";
            }
            this.sendNotification(errMsg, 14002, "error", false);
        }
        Configuration mediaConf = configuration.subset("media-server-manager");
        this.mediaExternalIp = mediaConf.getString("mgcp-server.external-address");
        this.proxyIp = runtime.subset("telestax-proxy").getString("uri").replaceAll("http://", "").replaceAll(":2080", "");
        if (this.mediaExternalIp == null || this.mediaExternalIp.isEmpty()) {
            this.mediaExternalIp = this.myHostIp;
        }
        if (this.proxyIp == null || this.proxyIp.isEmpty()) {
            this.proxyIp = this.myHostIp;
        }
        this.useTo = runtime.getBoolean("use-to");
        this.authenticateUsers = runtime.getBoolean("authenticate");
        this.primaryProxyUri = outboundProxyConfig.getString("outbound-proxy-uri");
        this.primaryProxyUsername = outboundProxyConfig.getString("outbound-proxy-user");
        this.primaryProxyPassword = outboundProxyConfig.getString("outbound-proxy-password");
        this.fallBackProxyUri = outboundProxyConfig.getString("fallback-outbound-proxy-uri");
        this.fallBackProxyUsername = outboundProxyConfig.getString("fallback-outbound-proxy-user");
        this.fallBackProxyPassword = outboundProxyConfig.getString("fallback-outbound-proxy-password");
        this.activeProxy = this.primaryProxyUri;
        this.activeProxyUsername = this.primaryProxyUsername;
        this.activeProxyPassword = this.primaryProxyPassword;
        this.numberOfFailedCalls = new AtomicInteger();
        this.numberOfFailedCalls.set(0);
        this.useFallbackProxy = new AtomicBoolean();
        this.useFallbackProxy.set(false);
        this.allowFallback = outboundProxyConfig.getBoolean("allow-fallback", false);
        this.maxNumberOfFailedCalls = outboundProxyConfig.getInt("max-failed-calls", 20);
        this.allowFallbackToPrimary = outboundProxyConfig.getBoolean("allow-fallback-to-primary", false);
        this.patchForNatB2BUASessions = runtime.getBoolean("patch-for-nat-b2bua-sessions", true);
        this.monitoring = (ActorRef)context.getAttribute(MonitoringService.class.getName());
        this.extensions = ExtensionController.getInstance().getExtensions(ExtensionType.CallManager);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("CallManager extensions: " + (this.extensions != null ? Integer.valueOf(this.extensions.size()) : "0"));
        }
    }

    private ActorRef call() {
        return this.system.actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Call(CallManager.this.sipFactory, CallManager.this.msControllerFactory.provideCallController(), CallManager.this.configuration);
            }
        }));
    }

    private void check(Object message) throws IOException {
        SipServletRequest request = (SipServletRequest)message;
        String content = new String(request.getRawContent());
        if (request.getContentLength() == 0 || !"application/sdp".equals(request.getContentType()) && !content.contains("application/sdp")) {
            SipServletResponse response = request.createResponse(400);
            response.send();
        }
    }

    private void destroy(Object message) throws Exception {
        UntypedActorContext context = this.getContext();
        DestroyCall request = (DestroyCall)message;
        ActorRef call = request.call();
        if (call != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("About to destroy call: " + request.call().path() + ", call isTerminated(): " + this.sender().isTerminated() + ", sender: " + this.sender());
            }
            context.stop(call);
        }
    }

    private void invite(Object message) throws IOException, NumberParseException, ServletParseException {
        String errMsg;
        ActorRef self = this.self();
        SipServletRequest request = (SipServletRequest)message;
        if (!request.isInitial()) {
            SipServletResponse okay = request.createResponse(200);
            okay.send();
            return;
        }
        AccountsDao accounts = this.storage.getAccountsDao();
        ApplicationsDao applications = this.storage.getApplicationsDao();
        SipURI fromUri = (SipURI)request.getFrom().getURI();
        String fromUser = fromUri.getUser();
        ClientsDao clients = this.storage.getClientsDao();
        Client client = clients.getClient(fromUser);
        if (client != null) {
            if (!this.authenticateUsers || CallControlHelper.checkAuthentication((SipServletRequest)request, (DaoManager)this.storage)) {
                if (this.redirectToClientVoiceApp(self, request, accounts, applications, client)) {
                    return;
                }
            } else {
                return;
            }
        }
        String toUser = CallControlHelper.getUserSipId((SipServletRequest)request, (boolean)this.useTo);
        String ruri = ((SipURI)request.getRequestURI()).getHost();
        String toHost = ((SipURI)request.getTo().getURI()).getHost();
        String toHostIpAddress = InetAddress.getByName(toHost).getHostAddress();
        String toPort = String.valueOf(((SipURI)request.getTo().getURI()).getPort()).equalsIgnoreCase("-1") ? "5060" : String.valueOf(((SipURI)request.getTo().getURI()).getHost());
        String transport = ((SipURI)request.getTo().getURI()).getTransportParam() == null ? "udp" : ((SipURI)request.getTo().getURI()).getTransportParam();
        SipURI outboundIntf = this.outboundInterface(transport);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ToHost: " + toHost);
            this.logger.info("ruri: " + ruri);
            this.logger.info("myHostIp: " + this.myHostIp);
            this.logger.info("mediaExternalIp: " + this.mediaExternalIp);
            this.logger.info("proxyIp: " + this.proxyIp);
        }
        if (client != null) {
            Client toClient = clients.getClient(toUser);
            if (toClient != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Client is not null: " + client.getLogin() + " will try to proxy to client: " + toClient);
                }
                if (B2BUAHelper.redirectToB2BUA((SipServletRequest)request, (Client)client, (Client)toClient, (DaoManager)this.storage, (SipFactory)this.sipFactory, (boolean)this.patchForNatB2BUASessions)) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Call to CLIENT.  myHostIp: " + this.myHostIp + " mediaExternalIp: " + this.mediaExternalIp + " toHost: " + toHost + " fromClient: " + client.getUri() + " toClient: " + toClient.getUri());
                    }
                    return;
                }
                errMsg = "Cannot Connect to Client: " + toClient.getFriendlyName() + " : Make sure the Client exist or is registered with Restcomm";
                this.sendNotification(errMsg, 11001, "warning", true);
            } else {
                if (this.redirectToHostedVoiceApp(self, request, accounts, applications, toUser)) {
                    return;
                }
                errMsg = "A Restcomm Client is trying to call a Number/DID that is not registered with Restcomm";
                this.sendNotification(errMsg, 11002, "info", true);
                if (this.isWebRTC(request)) {
                    this.proxyThroughMediaServer(request, client, toUser);
                    return;
                }
                String proxyURI = this.activeProxy;
                String proxyUsername = this.activeProxyUsername;
                String proxyPassword = this.activeProxyPassword;
                SipURI from = null;
                SipURI to = null;
                boolean callToSipUri = false;
                if (proxyURI != null && !proxyURI.isEmpty()) {
                    CallRequest callRequest = new CallRequest(fromUser, toUser, CallRequest.Type.PSTN, client.getAccountSid(), false, false);
                    if (this.executePreOutboundAction(callRequest)) {
                        this.proxyOut(request, client, toUser, toHost, toHostIpAddress, toPort, outboundIntf, proxyURI, proxyUsername, proxyPassword, from, to, callToSipUri);
                        return;
                    }
                    SipServletResponse response = request.createResponse(403);
                    response.send();
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Call request rejected: " + callRequest.toString());
                    }
                } else {
                    String msg = "Restcomm tried to proxy this call to an outbound party but it seems the outbound proxy is not configured.";
                    this.sendNotification(errMsg, 11004, "warning", true);
                }
            }
        } else if (this.redirectToHostedVoiceApp(self, request, accounts, applications, toUser)) {
            return;
        }
        SipServletResponse response = request.createResponse(404);
        response.send();
        errMsg = "Restcomm cannot process this call because the destination number " + toUser + "cannot be found or there is application attached to that";
        this.sendNotification(errMsg, 11005, "error", true);
    }

    private boolean proxyOut(SipServletRequest request, Client client, String toUser, String toHost, String toHostIpAddress, String toPort, SipURI outboundIntf, String proxyURI, String proxyUsername, String proxyPassword, SipURI from, SipURI to, boolean callToSipUri) throws UnknownHostException {
        Configuration runtime = this.configuration.subset("runtime-settings");
        boolean useLocalAddressAtFromHeader = runtime.getBoolean("use-local-address", false);
        boolean outboudproxyUserAtFromHeader = runtime.subset("outbound-proxy").getBoolean("outboudproxy-user-at-from-header", true);
        String fromHost = ((SipURI)request.getFrom().getURI()).getHost();
        String fromHostIpAddress = InetAddress.getByName(fromHost).getHostAddress();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("fromHost: " + fromHost + "fromHostIP: " + fromHostIpAddress + "myHostIp: " + this.myHostIp + " mediaExternalIp: " + this.mediaExternalIp + " toHost: " + toHost + " toHostIP: " + toHostIpAddress + " proxyUri: " + proxyURI);
        }
        if (this.myHostIp.equalsIgnoreCase(toHost) || this.mediaExternalIp.equalsIgnoreCase(toHost) || this.myHostIp.equalsIgnoreCase(toHostIpAddress) || this.mediaExternalIp.equalsIgnoreCase(toHostIpAddress) || fromHost.equalsIgnoreCase(toHost) || fromHost.equalsIgnoreCase(toHostIpAddress) || fromHostIpAddress.equalsIgnoreCase(toHost) || fromHostIpAddress.equalsIgnoreCase(toHostIpAddress)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Call to NUMBER.  myHostIp: " + this.myHostIp + " mediaExternalIp: " + this.mediaExternalIp + " toHost: " + toHost + " proxyUri: " + proxyURI);
            }
            try {
                from = useLocalAddressAtFromHeader ? (outboudproxyUserAtFromHeader ? this.sipFactory.createSipURI(proxyUsername, this.mediaExternalIp + ":" + outboundIntf.getPort()) : this.sipFactory.createSipURI(((SipURI)request.getFrom().getURI()).getUser(), this.mediaExternalIp + ":" + outboundIntf.getPort())) : (outboudproxyUserAtFromHeader ? this.sipFactory.createSipURI(proxyUsername, proxyURI) : this.sipFactory.createSipURI(((SipURI)request.getFrom().getURI()).getUser(), proxyURI));
                to = this.sipFactory.createSipURI(((SipURI)request.getTo().getURI()).getUser(), proxyURI);
            }
            catch (Exception exception) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Exception: " + exception);
                }
            }
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Call to SIP URI. myHostIp: " + this.myHostIp + " mediaExternalIp: " + this.mediaExternalIp + " toHost: " + toHost + " proxyUri: " + proxyURI);
            }
            from = this.sipFactory.createSipURI(((SipURI)request.getFrom().getURI()).getUser(), outboundIntf.getHost() + ":" + outboundIntf.getPort());
            to = this.sipFactory.createSipURI(toUser, toHost + ":" + toPort);
            callToSipUri = true;
        }
        return B2BUAHelper.redirectToB2BUA((SipServletRequest)request, (Client)client, (SipURI)from, (SipURI)to, (String)proxyUsername, (String)proxyPassword, (DaoManager)this.storage, (SipFactory)this.sipFactory, (boolean)callToSipUri, (boolean)this.patchForNatB2BUASessions);
    }

    private boolean isWebRTC(SipServletRequest request) {
        String transport = request.getTransport();
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && !userAgent.isEmpty() && userAgent.equalsIgnoreCase("wss-sipunit")) {
            return true;
        }
        if (!request.getInitialTransport().equalsIgnoreCase(transport) && ("ws".equalsIgnoreCase(transport = request.getInitialTransport()) || "wss".equalsIgnoreCase(transport))) {
            return true;
        }
        try {
            if (SdpUtils.isWebRTCSDP((String)request.getContentType(), (byte[])request.getRawContent())) {
                return true;
            }
        }
        catch (SdpParseException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    private void proxyThroughMediaServer(SipServletRequest request, Client client, String destNumber) {
        String rcml = "<Response><Dial>" + destNumber + "</Dial></Response>";
        VoiceInterpreterBuilder builder = new VoiceInterpreterBuilder(this.system);
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(this.self());
        builder.setConferenceManager(this.conferences);
        builder.setBridgeManager(this.bridges);
        builder.setSmsService(this.sms);
        builder.setAccount(client.getAccountSid());
        builder.setVersion(client.getApiVersion());
        Account account = this.storage.getAccountsDao().getAccount(client.getAccountSid());
        builder.setEmailAddress(account.getEmailAddress());
        builder.setRcml(rcml);
        builder.setMonitoring(this.monitoring);
        ActorRef interpreter = builder.build();
        ActorRef call = this.call();
        SipApplicationSession application = request.getApplicationSession();
        application.setAttribute(Call.class.getName(), (Object)call);
        call.tell((Object)request, this.self());
        interpreter.tell((Object)new StartInterpreter(call), this.self());
    }

    private void info(SipServletRequest request) throws IOException {
        ActorRef self = this.self();
        SipApplicationSession application = request.getApplicationSession();
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession((SipServletMessage)request);
        if (linkedB2BUASession != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("B2BUA: Got INFO request: \n %s", request));
            }
            request.getSession().setAttribute("lastRequest", (Object)request);
            SipServletRequest clonedInfo = linkedB2BUASession.createRequest("INFO");
            linkedB2BUASession.setAttribute("lastRequest", (Object)clonedInfo);
            SipURI toInetUri = (SipURI)request.getSession().getAttribute("toInetURI");
            SipURI fromInetUri = (SipURI)request.getSession().getAttribute("fromInetURI");
            InetAddress infoRURI = null;
            try {
                infoRURI = InetAddress.getByName(((SipURI)clonedInfo.getRequestURI()).getHost());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            if (this.patchForNatB2BUASessions) {
                if (toInetUri != null && infoRURI == null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneBye request");
                    }
                    clonedInfo.setRequestURI((URI)toInetUri);
                } else if (toInetUri != null && (infoRURI.isSiteLocalAddress() || infoRURI.isAnyLocalAddress() || infoRURI.isLoopbackAddress())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneInfo request");
                    }
                    clonedInfo.setRequestURI((URI)toInetUri);
                } else if (fromInetUri != null && (infoRURI.isSiteLocalAddress() || infoRURI.isAnyLocalAddress() || infoRURI.isLoopbackAddress())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Using the real ip address of the sip client " + fromInetUri.toString() + " as a request uri of the CloneInfo request");
                    }
                    clonedInfo.setRequestURI((URI)fromInetUri);
                }
            }
            clonedInfo.send();
        } else {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            call.tell((Object)request, self);
        }
    }

    private boolean redirectToHostedVoiceApp(ActorRef self, SipServletRequest request, AccountsDao accounts, ApplicationsDao applications, String phone) {
        boolean isFoundHostedApp = false;
        PhoneNumberUtil phoneNumberUtil = PhoneNumberUtil.getInstance();
        String formatedPhone = null;
        try {
            formatedPhone = phoneNumberUtil.format(phoneNumberUtil.parse(phone, "US"), PhoneNumberUtil.PhoneNumberFormat.E164);
        }
        catch (Exception e) {
            // empty catch block
        }
        IncomingPhoneNumber number = null;
        try {
            IncomingPhoneNumbersDao numbers = this.storage.getIncomingPhoneNumbersDao();
            number = numbers.getIncomingPhoneNumber(formatedPhone);
            if (number == null) {
                number = numbers.getIncomingPhoneNumber(phone);
            }
            if (number == null) {
                if (phone.startsWith("+")) {
                    phone = phone.replaceFirst("\\+", "");
                    number = numbers.getIncomingPhoneNumber(phone);
                } else {
                    phone = "+".concat(phone);
                    number = numbers.getIncomingPhoneNumber(phone);
                }
            }
            if (number == null) {
                number = numbers.getIncomingPhoneNumber("*");
            }
            if (number != null) {
                VoiceInterpreterBuilder builder = new VoiceInterpreterBuilder(this.system);
                builder.setConfiguration(this.configuration);
                builder.setStorage(this.storage);
                builder.setCallManager(self);
                builder.setConferenceManager(this.conferences);
                builder.setBridgeManager(this.bridges);
                builder.setSmsService(this.sms);
                builder.setAccount(number.getAccountSid());
                builder.setVersion(number.getApiVersion());
                Account account = accounts.getAccount(number.getAccountSid());
                builder.setEmailAddress(account.getEmailAddress());
                Sid sid = number.getVoiceApplicationSid();
                if (sid != null) {
                    Application application = applications.getApplication(sid);
                    builder.setUrl(UriUtils.resolve((java.net.URI)application.getRcmlUrl()));
                } else {
                    builder.setUrl(UriUtils.resolve((java.net.URI)number.getVoiceUrl()));
                }
                String voiceMethod = number.getVoiceMethod();
                if (voiceMethod == null || voiceMethod.isEmpty()) {
                    builder.setMethod("POST");
                } else {
                    builder.setMethod(voiceMethod);
                }
                java.net.URI uri = number.getVoiceFallbackUrl();
                if (uri != null) {
                    builder.setFallbackUrl(UriUtils.resolve((java.net.URI)uri));
                } else {
                    builder.setFallbackUrl(null);
                }
                builder.setFallbackMethod(number.getVoiceFallbackMethod());
                builder.setStatusCallback(number.getStatusCallback());
                builder.setStatusCallbackMethod(number.getStatusCallbackMethod());
                builder.setMonitoring(this.monitoring);
                ActorRef interpreter = builder.build();
                ActorRef call = this.call();
                SipApplicationSession application = request.getApplicationSession();
                application.setAttribute(Call.class.getName(), (Object)call);
                call.tell((Object)request, self);
                interpreter.tell((Object)new StartInterpreter(call), self);
                isFoundHostedApp = true;
            }
        }
        catch (Exception notANumber) {
            String errMsg = number != null ? "The number " + number.getPhoneNumber() + " does not have a Restcomm hosted application attached" : "The number does not have a Restcomm hosted application attached";
            this.sendNotification(errMsg, 11007, "error", false);
            this.logger.error(errMsg, (Object)notANumber);
            isFoundHostedApp = false;
        }
        return isFoundHostedApp;
    }

    private boolean redirectToClientVoiceApp(ActorRef self, SipServletRequest request, AccountsDao accounts, ApplicationsDao applications, Client client) {
        boolean isClientManaged;
        Sid applicationSid = client.getVoiceApplicationSid();
        java.net.URI clientAppVoiceUrl = null;
        if (applicationSid != null) {
            Application application = applications.getApplication(applicationSid);
            clientAppVoiceUrl = UriUtils.resolve((java.net.URI)application.getRcmlUrl());
        }
        if (clientAppVoiceUrl == null) {
            clientAppVoiceUrl = client.getVoiceUrl();
        }
        boolean bl = isClientManaged = applicationSid != null && !applicationSid.toString().isEmpty() && !applicationSid.toString().equals("") || clientAppVoiceUrl != null && !clientAppVoiceUrl.toString().isEmpty() && !clientAppVoiceUrl.toString().equals("");
        if (isClientManaged) {
            VoiceInterpreterBuilder builder = new VoiceInterpreterBuilder(this.system);
            builder.setConfiguration(this.configuration);
            builder.setStorage(this.storage);
            builder.setCallManager(self);
            builder.setConferenceManager(this.conferences);
            builder.setBridgeManager(this.bridges);
            builder.setSmsService(this.sms);
            builder.setAccount(client.getAccountSid());
            builder.setVersion(client.getApiVersion());
            Account account = accounts.getAccount(client.getAccountSid());
            builder.setEmailAddress(account.getEmailAddress());
            Sid sid = client.getVoiceApplicationSid();
            builder.setUrl(clientAppVoiceUrl);
            builder.setMethod(client.getVoiceMethod());
            java.net.URI uri = client.getVoiceFallbackUrl();
            if (uri != null) {
                builder.setFallbackUrl(UriUtils.resolve((java.net.URI)uri));
            } else {
                builder.setFallbackUrl(null);
            }
            builder.setFallbackMethod(client.getVoiceFallbackMethod());
            builder.setMonitoring(this.monitoring);
            ActorRef interpreter = builder.build();
            ActorRef call = this.call();
            SipApplicationSession application = request.getApplicationSession();
            application.setAttribute(Call.class.getName(), (Object)call);
            call.tell((Object)request, self);
            interpreter.tell((Object)new StartInterpreter(call), self);
        }
        return isClientManaged;
    }

    private void pong(Object message) throws IOException {
        SipServletRequest request = (SipServletRequest)message;
        SipServletResponse response = request.createResponse(200);
        response.send();
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("######### CallManager new message received, message instanceof : " + klass + " from sender : " + sender.getClass());
        }
        if (message instanceof SipServletRequest) {
            SipServletRequest request = (SipServletRequest)message;
            String method = request.getMethod();
            if ("INVITE".equals(method)) {
                this.check(request);
                this.invite(request);
            } else if ("OPTIONS".equals(method)) {
                this.pong(request);
            } else if ("ACK".equals(method)) {
                this.ack(request);
            } else if ("CANCEL".equals(method)) {
                this.cancel(request);
            } else if ("BYE".equals(method)) {
                this.bye(request);
            } else if ("INFO".equals(method)) {
                this.info(request);
            }
        } else if (CreateCall.class.equals(klass)) {
            this.createCallRequest = (CreateCall)message;
            this.outbound(message, sender);
        } else if (ExecuteCallScript.class.equals(klass)) {
            this.execute(message);
        } else if (UpdateCallScript.class.equals(klass)) {
            try {
                this.update(message);
            }
            catch (Exception exception) {
                sender.tell((Object)new CallManagerResponse((Throwable)exception), self);
            }
        } else if (DestroyCall.class.equals(klass)) {
            this.destroy(message);
        } else if (message instanceof SipServletResponse) {
            this.response(message);
        } else if (message instanceof SipApplicationSessionEvent) {
            this.timeout(message);
        } else if (GetCall.class.equals(klass)) {
            sender.tell((Object)this.lookup(message), self);
        } else if (GetActiveProxy.class.equals(klass)) {
            sender.tell(this.getActiveProxy(), self);
        } else if (SwitchProxy.class.equals(klass)) {
            this.switchProxyRequest = (SwitchProxy)message;
            sender.tell(this.switchProxy(), self);
        } else if (GetProxies.class.equals(klass)) {
            sender.tell(this.getProxies(message), self);
        }
    }

    private void ack(SipServletRequest request) throws IOException {
        SipServletResponse response = B2BUAHelper.getLinkedResponse((SipServletMessage)request);
        if (response != null) {
            SipServletRequest ack = response.createAck();
            if (this.patchForNatB2BUASessions) {
                SipURI toInetUri;
                InetAddress ackRURI = null;
                try {
                    ackRURI = InetAddress.getByName(((SipURI)ack.getRequestURI()).getHost());
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                boolean isBehindLB = false;
                String initialIpBeforeLB = response.getHeader("X-Sip-Balancer-InitialRemoteAddr");
                String initialPortBeforeLB = response.getHeader("X-Sip-Balancer-InitialRemotePort");
                if (initialIpBeforeLB != null) {
                    if (initialPortBeforeLB == null) {
                        initialPortBeforeLB = "5060";
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("We are behind load balancer, checking if the request URI needs to be patched");
                    }
                    isBehindLB = true;
                }
                if ((toInetUri = (SipURI)request.getSession().getAttribute("toInetURI")) != null && ackRURI == null) {
                    if (isBehindLB) {
                        boolean patchRURI = this.isLBPatchRURI(ack, initialIpBeforeLB, initialPortBeforeLB);
                        if (patchRURI) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("We are behind load balancer, but Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the ACK request");
                            }
                            ack.setRequestURI((URI)toInetUri);
                        } else {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("removing the toInetUri to avoid the other subsequent requests using it " + toInetUri.toString());
                            }
                            request.getSession().removeAttribute("toInetURI");
                        }
                    } else {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the ACK request");
                        }
                        ack.setRequestURI((URI)toInetUri);
                    }
                } else if (toInetUri != null && (ackRURI.isSiteLocalAddress() || ackRURI.isAnyLocalAddress() || ackRURI.isLoopbackAddress())) {
                    if (isBehindLB) {
                        boolean patchRURI = this.isLBPatchRURI(ack, initialIpBeforeLB, initialPortBeforeLB);
                        if (patchRURI) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("We are behind load balancer, but Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the ACK request");
                            }
                            ack.setRequestURI((URI)toInetUri);
                        } else {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("removing the toInetUri to avoid the other subsequent requests using it " + toInetUri.toString());
                            }
                            request.getSession().removeAttribute("toInetURI");
                        }
                    } else {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the ACK request");
                        }
                        ack.setRequestURI((URI)toInetUri);
                    }
                } else if (toInetUri == null && (ackRURI.isSiteLocalAddress() || ackRURI.isAnyLocalAddress() || ackRURI.isLoopbackAddress())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Public IP toInetUri from SipSession is null, will check LB headers from last Response");
                    }
                    if (isBehindLB) {
                        String realIP = initialIpBeforeLB + ":" + initialPortBeforeLB;
                        SipURI uri = this.sipFactory.createSipURI(null, realIP);
                        boolean patchRURI = this.isLBPatchRURI(ack, initialIpBeforeLB, initialPortBeforeLB);
                        if (patchRURI) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("We are behind load balancer, will use Initial Remote Address " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the ACK request");
                            }
                            ack.setRequestURI((URI)uri);
                        }
                    } else if (this.logger.isInfoEnabled()) {
                        this.logger.info("LB Headers are also null");
                    }
                }
            }
            ack.send();
            SipApplicationSession sipApplicationSession = request.getApplicationSession();
            sipApplicationSession.setExpires(60);
        } else {
            ActorRef call;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Linked Response couldn't be found for ACK request");
            }
            if ((call = (ActorRef)request.getApplicationSession().getAttribute(Call.class.getName())) != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will send ACK to call actor: " + call.path());
                }
                call.tell((Object)request, this.self());
            }
        }
    }

    private boolean isLBPatchRURI(SipServletRequest request, String initialIpBeforeLB, String initialPortBeforeLB) {
        try {
            ListIterator routes = request.getAddressHeaders("Route");
            while (routes.hasNext()) {
                SipURI route = (SipURI)((Address)routes.next()).getURI();
                String routeHost = route.getHost();
                int routePort = route.getPort();
                if (routePort < 0) {
                    routePort = 5060;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Checking if route " + routeHost + ":" + routePort + " is matching ip and port before LB " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the " + request.getMethod() + " request");
                }
                if (!routeHost.equalsIgnoreCase(initialIpBeforeLB) || routePort != Integer.parseInt(initialPortBeforeLB)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("route " + route + " is matching ip and port before LB " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the " + request.getMethod() + " request, so not patching the Request-URI");
                }
                return false;
            }
        }
        catch (ServletParseException e) {
            this.logger.error("Impossible to parse the route set from the request " + request, (Object)e);
        }
        return true;
    }

    private void execute(Object message) {
        ExecuteCallScript request = (ExecuteCallScript)message;
        ActorRef self = this.self();
        VoiceInterpreterBuilder builder = new VoiceInterpreterBuilder(this.system);
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(self);
        builder.setConferenceManager(this.conferences);
        builder.setBridgeManager(this.bridges);
        builder.setSmsService(this.sms);
        builder.setAccount(request.account());
        builder.setVersion(request.version());
        builder.setUrl(request.url());
        builder.setMethod(request.method());
        builder.setFallbackUrl(request.fallbackUrl());
        builder.setFallbackMethod(request.fallbackMethod());
        builder.setStatusCallback(request.callback());
        builder.setStatusCallbackMethod(request.callbackMethod());
        builder.setMonitoring(this.monitoring);
        ActorRef interpreter = builder.build();
        interpreter.tell((Object)new StartInterpreter(request.call()), self);
    }

    private void update(Object message) throws Exception {
        UpdateCallScript request = (UpdateCallScript)message;
        ActorRef self = this.self();
        ActorRef call = request.call();
        Boolean moveConnectedCallLeg = request.moveConnecteCallLeg();
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        Future future = Patterns.ask((ActorRef)call, (Object)new GetCallObservers(), (Timeout)expires);
        CallResponse response = (CallResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        List callObservers = (List)response.get();
        ActorRef existingInterpreter = (ActorRef)callObservers.iterator().next();
        future = Patterns.ask((ActorRef)existingInterpreter, (Object)new GetRelatedCall(call), (Timeout)expires);
        Object answer = Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        ActorRef relatedCall = null;
        if (answer instanceof ActorRef) {
            relatedCall = (ActorRef)answer;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("About to start Live Call Modification");
            this.logger.info("Initial Call path: " + call.path());
            if (relatedCall != null) {
                this.logger.info("Related Call path: " + relatedCall.path());
            }
            this.logger.info("Will tell Call actors to stop observing existing Interpreters");
        }
        call.tell((Object)new StopObserving(), this.self());
        if (relatedCall != null) {
            relatedCall.tell((Object)new StopObserving(), this.self());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Existing observers removed from Calls actors");
            this.logger.info("Existing Interpreter path: " + existingInterpreter.path() + " will be stopped");
        }
        existingInterpreter.tell((Object)new StopInterpreter(true), null);
        VoiceInterpreterBuilder builder = new VoiceInterpreterBuilder(this.system);
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(self);
        builder.setConferenceManager(this.conferences);
        builder.setBridgeManager(this.bridges);
        builder.setSmsService(this.sms);
        builder.setAccount(request.account());
        builder.setVersion(request.version());
        builder.setUrl(request.url());
        builder.setMethod(request.method());
        builder.setFallbackUrl(request.fallbackUrl());
        builder.setFallbackMethod(request.fallbackMethod());
        builder.setStatusCallback(request.callback());
        builder.setStatusCallbackMethod(request.callbackMethod());
        builder.setMonitoring(this.monitoring);
        ActorRef interpreter = builder.build();
        this.system.scheduler().scheduleOnce(Duration.create((long)500L, (TimeUnit)TimeUnit.MILLISECONDS), interpreter, (Object)new StartInterpreter(request.call()), (ExecutionContext)this.system.dispatcher());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("New Intepreter for first call leg: " + interpreter.path() + " started");
        }
        if (relatedCall != null) {
            if (moveConnectedCallLeg.booleanValue()) {
                ActorRef relatedInterpreter = builder.build();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("About to redirect related Call :" + relatedCall.path() + " with 200ms delay to related interpreter: " + relatedInterpreter.path());
                }
                this.system.scheduler().scheduleOnce(Duration.create((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS), relatedInterpreter, (Object)new StartInterpreter(relatedCall), (ExecutionContext)this.system.dispatcher());
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("New Intepreter for Second call leg: " + relatedInterpreter.path() + " started");
                }
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("moveConnectedCallLeg is: " + moveConnectedCallLeg + " so will hangup relatedCall: " + relatedCall.path());
                }
                relatedCall.tell((Object)new Hangup(), null);
            }
        }
    }

    private void outbound(Object message, ActorRef sender) throws ServletParseException {
        CreateCall request = (CreateCall)message;
        CallRequest callRequest = new CallRequest(request.from(), request.to(), CallRequest.Type.valueOf((String)request.type().name()), request.accountId(), request.isFromApi(), request.parentCallSid() != null);
        switch (request.type()) {
            case CLIENT: {
                if (this.executePreOutboundAction(callRequest)) {
                    this.outboundToClient(request, sender);
                } else {
                    String errMsg = "Not Allowed to make this outbound call";
                    this.logger.error("Not Allowed to make this outbound call");
                    sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException("Not Allowed to make this outbound call"), this.createCallRequest), this.self());
                }
                this.executePostOutboundAction(callRequest);
                break;
            }
            case PSTN: {
                if (this.executePreOutboundAction(callRequest)) {
                    this.outboundToPstn(request, sender);
                } else {
                    String errMsg = "Not Allowed to make this outbound call";
                    this.logger.error("Not Allowed to make this outbound call");
                    sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException("Not Allowed to make this outbound call"), this.createCallRequest), this.self());
                }
                this.executePostOutboundAction(callRequest);
                break;
            }
            case SIP: {
                if (this.executePreOutboundAction(callRequest)) {
                    this.outboundToSip(request, sender);
                } else {
                    String errMsg = "Not Allowed to make this outbound call";
                    this.logger.error("Not Allowed to make this outbound call");
                    sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException("Not Allowed to make this outbound call"), this.createCallRequest), this.self());
                }
                this.executePostOutboundAction(callRequest);
            }
        }
    }

    private boolean executePreOutboundAction(Object message) {
        if (this.extensions != null && this.extensions.size() > 0) {
            for (RestcommExtensionGeneric extension : this.extensions) {
                ExtensionResponse response = extension.preOutboundAction(message);
                if (response.isAllowed()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean executePostOutboundAction(CallRequest callRequest) {
        return false;
    }

    private void outboundToClient(CreateCall request, ActorRef sender) throws ServletParseException {
        SipURI outboundIntf = null;
        SipURI from = null;
        SipURI to = null;
        boolean webRTC = false;
        boolean isLBPresent = false;
        RegistrationsDao registrationsDao = this.storage.getRegistrationsDao();
        String client = request.to().replaceFirst("client:", "");
        CopyOnWriteArrayList<Registration> registrationToDial = new CopyOnWriteArrayList<Registration>();
        List registrations = registrationsDao.getRegistrations(client);
        if (registrations != null && registrations.size() > 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Preparing call for client: " + client + ". There are " + registrations.size() + " registrations at the database for this client");
            }
            for (Registration registration : registrations) {
                if (registration.isWebRTC()) {
                    if (registration.isLBPresent()) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("WebRTC registration behind LB. Will add WebRTC registration: " + registration.getLocation() + " to the list to be dialed for client: " + client);
                        }
                        registrationToDial.add(registration);
                        continue;
                    }
                    if (registration.getInstanceId() != null && !registration.getInstanceId().equals(RestcommConfiguration.getInstance().getMain().getInstanceId())) {
                        this.logger.warning("Cannot create call for user agent: " + registration.getLocation() + " since this is a webrtc client registered in another Restcomm instance.");
                        continue;
                    }
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Will add WebRTC registration: " + registration.getLocation() + " to the list to be dialed for client: " + client);
                    }
                    registrationToDial.add(registration);
                    continue;
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will add registration: " + registration.getLocation() + " to the list to be dialed for client: " + client);
                }
                registrationToDial.add(registration);
            }
        } else {
            String errMsg = "The SIP Client " + request.to() + " is not registered or does not exist";
            this.logger.error(errMsg);
            this.sendNotification(errMsg, 11008, "error", true);
            sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), this.createCallRequest), this.self());
            return;
        }
        if (registrationToDial.size() > 0) {
            if (this.logger.isInfoEnabled() && registrationToDial.size() > 1) {
                this.logger.info("Preparing call for client: " + client + ", after WebRTC check, Restcomm have to dial :" + registrationToDial.size() + " registrations");
            }
            CopyOnWriteArrayList<ActorRef> calls = new CopyOnWriteArrayList<ActorRef>();
            for (Registration registration : registrationToDial) {
                String transport;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will proceed to create call for client: " + registration.getLocation() + " registration instanceId: " + registration.getInstanceId() + " own InstanceId: " + RestcommConfiguration.getInstance().getMain().getInstanceId());
                }
                if (registration.getLocation().contains("transport")) {
                    transport = registration.getLocation().split(";")[1].replace("transport=", "");
                    outboundIntf = this.outboundInterface(transport);
                } else {
                    transport = "udp";
                    outboundIntf = this.outboundInterface(transport);
                }
                if (outboundIntf == null) {
                    String errMsg = "The outbound interface for transport: " + transport + " is NULL, something is wrong with container, cannot proceed to call client " + request.to();
                    this.logger.error(errMsg);
                    this.sendNotification(errMsg, 11008, "error", true);
                    sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), this.createCallRequest), this.self());
                    return;
                }
                if (request.from() != null && request.from().contains("@")) {
                    from = (SipURI)this.sipFactory.createURI(request.from());
                } else if (request.from() != null) {
                    if (outboundIntf != null) {
                        from = this.sipFactory.createSipURI(request.from(), this.mediaExternalIp + ":" + outboundIntf.getPort());
                    } else {
                        this.logger.error("Outbound interface is null, cannot create From header to be used to Dial client: " + client);
                    }
                } else {
                    from = outboundIntf;
                }
                String location = registration.getLocation();
                to = (SipURI)this.sipFactory.createURI(location);
                webRTC = registration.isWebRTC();
                if (from == null || to == null) {
                    String errMsg = "From and/or To are null, we cannot proceed to the outbound call to: " + request.to();
                    this.logger.error(errMsg);
                    sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), this.createCallRequest), this.self());
                    continue;
                }
                calls.add(this.createOutbound(request, from, to, webRTC));
            }
            if (calls.size() > 0) {
                sender.tell((Object)new CallManagerResponse(calls), this.self());
            }
        } else {
            String errMsg = "The SIP Client " + request.to() + " is not registered or does not exist";
            this.logger.error(errMsg);
            this.sendNotification(errMsg, 11008, "error", true);
            sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), this.createCallRequest), this.self());
        }
    }

    private void outboundToPstn(CreateCall request, ActorRef sender) throws ServletParseException {
        String proxyUsername;
        String uri = this.activeProxy;
        SipURI outboundIntf = null;
        SipURI from = null;
        SipURI to = null;
        Configuration runtime = this.configuration.subset("runtime-settings");
        boolean useLocalAddressAtFromHeader = runtime.getBoolean("use-local-address", false);
        String string = proxyUsername = request.username() != null ? request.username() : this.activeProxyUsername;
        if (uri != null) {
            try {
                to = this.sipFactory.createSipURI(request.to(), uri);
                String transport = to.getTransportParam() != null ? to.getTransportParam() : "udp";
                outboundIntf = this.outboundInterface(transport);
                boolean outboudproxyUserAtFromHeader = runtime.subset("outbound-proxy").getBoolean("outboudproxy-user-at-from-header");
                from = request.from() != null && request.from().contains("@") ? (SipURI)this.sipFactory.createURI(request.from()) : (useLocalAddressAtFromHeader ? this.sipFactory.createSipURI(request.from(), this.mediaExternalIp + ":" + outboundIntf.getPort()) : (outboudproxyUserAtFromHeader ? this.sipFactory.createSipURI(proxyUsername, uri) : this.sipFactory.createSipURI(request.from(), uri)));
                if (from.getUser() == null || from.getUser() == "") {
                    from = uri != null ? this.sipFactory.createSipURI(request.from(), uri) : (SipURI)this.sipFactory.createURI(request.from());
                }
            }
            catch (Exception exception) {
                sender.tell((Object)new CallManagerResponse((Throwable)exception, this.createCallRequest), this.self());
            }
            if (from == null || to == null) {
                String errMsg = "From and/or To are null, we cannot proceed to the outbound call to: " + request.to();
                this.logger.error(errMsg);
                sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), this.createCallRequest), this.self());
            } else {
                sender.tell((Object)new CallManagerResponse((Object)this.createOutbound(request, from, to, false)), this.self());
            }
        } else {
            String errMsg = "Cannot create call to: " + request.to() + ". The Active Outbound Proxy is null. Please check configuration";
            this.logger.error(errMsg);
            this.sendNotification(errMsg, 11008, "error", true);
            sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), this.createCallRequest), this.self());
        }
    }

    private void outboundToSip(CreateCall request, ActorRef sender) throws ServletParseException {
        SipURI outboundIntf = null;
        SipURI from = null;
        SipURI to = null;
        to = (SipURI)this.sipFactory.createURI(request.to());
        String transport = to.getTransportParam() != null ? to.getTransportParam() : "udp";
        outboundIntf = this.outboundInterface(transport);
        from = request.from() == null ? this.outboundInterface(transport) : (request.from() != null && request.from().contains("@") ? (SipURI)this.sipFactory.createURI(request.from()) : this.sipFactory.createSipURI(request.from(), outboundIntf.getHost() + ":" + outboundIntf.getPort()));
        if (from == null || to == null) {
            String errMsg = "From and/or To are null, we cannot proceed to the outbound call to: " + request.to();
            this.logger.error(errMsg);
            sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), this.createCallRequest), this.self());
        } else {
            sender.tell((Object)new CallManagerResponse((Object)this.createOutbound(request, from, to, false)), this.self());
        }
    }

    private ActorRef createOutbound(CreateCall request, SipURI from, SipURI to, boolean webRTC) {
        Configuration runtime = this.configuration.subset("runtime-settings");
        String proxyUsername = request.username() != null ? request.username() : this.activeProxyUsername;
        String proxyPassword = request.password() != null ? request.password() : this.activeProxyPassword;
        ActorRef call = this.call();
        ActorRef self = this.self();
        boolean userAtDisplayedName = runtime.subset("outbound-proxy").getBoolean("user-at-displayed-name");
        InitializeOutbound init = request.from() != null && !request.from().contains("@") && userAtDisplayedName ? new InitializeOutbound(request.from(), from, to, proxyUsername, proxyPassword, (long)request.timeout(), request.isFromApi(), runtime.getString("api-version"), request.accountId(), request.type(), this.storage, webRTC) : new InitializeOutbound(null, from, to, proxyUsername, proxyPassword, (long)request.timeout(), request.isFromApi(), runtime.getString("api-version"), request.accountId(), request.type(), this.storage, webRTC);
        if (request.parentCallSid() != null) {
            init.setParentCallSid(request.parentCallSid());
        }
        call.tell((Object)init, self);
        return call;
    }

    public void cancel(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletRequest request = (SipServletRequest)message;
        SipApplicationSession application = request.getApplicationSession();
        SipServletRequest originalRequest = B2BUAHelper.getLinkedRequest((SipServletMessage)request);
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession((SipServletMessage)request);
        if (originalRequest != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("B2BUA: Got CANCEL request: \n %s", request));
            }
            request.getSession().setAttribute("lastRequest", (Object)request);
            String sessionState = linkedB2BUASession.getState().name();
            SipServletResponse lastFinalResponse = (SipServletResponse)originalRequest.getSession().getAttribute("lastFinalResponse");
            if ((sessionState == SipSession.State.INITIAL.name() || sessionState == SipSession.State.EARLY.name()) && (lastFinalResponse == null || lastFinalResponse.getStatus() != 401 && lastFinalResponse.getStatus() != 407)) {
                SipServletRequest clonedCancel = originalRequest.createCancel();
                linkedB2BUASession.setAttribute("lastRequest", (Object)clonedCancel);
                clonedCancel.send();
            } else {
                SipServletRequest clonedBye = linkedB2BUASession.createRequest("BYE");
                linkedB2BUASession.setAttribute("lastRequest", (Object)clonedBye);
                clonedBye.send();
            }
        } else {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            call.tell((Object)request, self);
        }
    }

    public void bye(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletRequest request = (SipServletRequest)message;
        SipApplicationSession application = request.getApplicationSession();
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession((SipServletMessage)request);
        if (linkedB2BUASession != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("B2BUA: Got BYE request: \n %s", request));
            }
            request.getSession().setAttribute("lastRequest", (Object)request);
            SipServletRequest clonedBye = linkedB2BUASession.createRequest("BYE");
            linkedB2BUASession.setAttribute("lastRequest", (Object)clonedBye);
            if (this.patchForNatB2BUASessions) {
                SipURI toInetUri = (SipURI)request.getSession().getAttribute("toInetURI");
                SipURI fromInetUri = (SipURI)request.getSession().getAttribute("fromInetURI");
                InetAddress byeRURI = null;
                try {
                    byeRURI = InetAddress.getByName(((SipURI)clonedBye.getRequestURI()).getHost());
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                boolean isBehindLB = false;
                String initialIpBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemoteAddr");
                String initialPortBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemotePort");
                if (initialIpBeforeLB != null) {
                    if (initialPortBeforeLB == null) {
                        initialPortBeforeLB = "5060";
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("We are behind load balancer, checking if the request URI needs to be patched");
                    }
                    isBehindLB = true;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("toInetUri: " + toInetUri + " fromInetUri: " + fromInetUri + " byeRURI: " + byeRURI + " initialIpBeforeLB: " + initialIpBeforeLB + " initialPortBeforeLB: " + initialPortBeforeLB);
                }
                if (toInetUri != null && byeRURI == null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Using the real To inet ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneBye request");
                    }
                    clonedBye.setRequestURI((URI)toInetUri);
                } else if (toInetUri != null && (byeRURI.isSiteLocalAddress() || byeRURI.isAnyLocalAddress() || byeRURI.isLoopbackAddress())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Using the real To inet ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneBye request");
                    }
                    clonedBye.setRequestURI((URI)toInetUri);
                } else if (fromInetUri != null && (byeRURI.isSiteLocalAddress() || byeRURI.isAnyLocalAddress() || byeRURI.isLoopbackAddress())) {
                    if (isBehindLB) {
                        boolean patchRURI = this.isLBPatchRURI(clonedBye, initialIpBeforeLB, initialPortBeforeLB);
                        if (patchRURI) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("We are behind load balancer, but Using the real ip address of the sip client " + fromInetUri.toString() + " as a request uri of the CloneBye request");
                            }
                            clonedBye.setRequestURI((URI)fromInetUri);
                        }
                    } else {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Using the real From inet ip  address of the sip client " + fromInetUri.toString() + " as a request uri of the CloneBye request");
                        }
                        clonedBye.setRequestURI((URI)fromInetUri);
                    }
                } else if (toInetUri == null && (byeRURI.isSiteLocalAddress() || byeRURI.isAnyLocalAddress() || byeRURI.isLoopbackAddress())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Public IP toInetUri from SipSession is null, will check LB headers from last Response");
                    }
                    if (isBehindLB) {
                        String realIP = initialIpBeforeLB + ":" + initialPortBeforeLB;
                        SipURI uri = this.sipFactory.createSipURI(null, realIP);
                        boolean patchRURI = this.isLBPatchRURI(clonedBye, initialIpBeforeLB, initialPortBeforeLB);
                        if (patchRURI) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("We are behind load balancer, will use: " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the cloned BYE message");
                            }
                            clonedBye.setRequestURI((URI)uri);
                        }
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("We are behind load balancer, will use Initial Remote Address " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the cloned BYE request");
                        }
                    } else if (this.logger.isInfoEnabled()) {
                        this.logger.info("LB Headers are also null");
                    }
                }
            }
            B2BUAHelper.updateCDR((SipServletMessage)request, (CallStateChanged.State)CallStateChanged.State.COMPLETED);
            SipServletResponse okay = request.createResponse(200);
            okay.send();
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("B2BUA: Will send out Cloned BYE request: \n %s", clonedBye));
            }
            clonedBye.send();
        } else {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            if (call != null) {
                call.tell((Object)request, self);
            }
        }
    }

    public void response(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletResponse response = (SipServletResponse)message;
        if (this.allowFallback) {
            this.checkErrorResponse(response);
        }
        SipApplicationSession application = response.getApplicationSession();
        if (B2BUAHelper.isB2BUASession((SipServletMessage)response)) {
            if (response.getStatus() == 407 || response.getStatus() == 401) {
                AuthInfo authInfo = this.sipFactory.createAuthInfo();
                String authHeader = response.getHeader("Proxy-Authenticate");
                if (authHeader == null) {
                    authHeader = response.getHeader("WWW-Authenticate");
                }
                String tempRealm = authHeader.substring(authHeader.indexOf("realm=\"") + "realm=\"".length());
                String realm = tempRealm.substring(0, tempRealm.indexOf("\""));
                authInfo.addAuthInfo(response.getStatus(), realm, this.activeProxyUsername, this.activeProxyPassword);
                SipServletRequest challengeRequest = response.getSession().createRequest(response.getRequest().getMethod());
                response.getSession().setAttribute("lastFinalResponse", (Object)response);
                challengeRequest.addAuthHeader(response, authInfo);
                SipServletRequest invite = response.getRequest();
                challengeRequest.setContent(invite.getContent(), invite.getContentType());
                invite = challengeRequest;
                challengeRequest.send();
            } else {
                B2BUAHelper.forwardResponse((SipServletResponse)response, (boolean)this.patchForNatB2BUASessions);
            }
        } else if (application.isValid()) {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            call.tell((Object)response, self);
        }
    }

    public ActorRef lookup(Object message) {
        GetCall getCall = (GetCall)message;
        String callPath = getCall.getIdentifier();
        UntypedActorContext context = this.getContext();
        return context.actorFor(callPath);
    }

    public void timeout(Object message) {
        ActorRef self = this.self();
        SipApplicationSessionEvent event = (SipApplicationSessionEvent)message;
        SipApplicationSession application = event.getApplicationSession();
        ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
        ReceiveTimeout$ timeout = ReceiveTimeout.getInstance();
        call.tell((Object)timeout, self);
    }

    public void checkErrorResponse(SipServletResponse response) {
        int status;
        if (!response.isBranchResponse() && response.getRequest().getMethod().equalsIgnoreCase("INVITE") && response.getRequest().isInitial() && (status = response.getStatus()) != 401 && status != 407 && status != 404 && status > 400) {
            int failures = this.numberOfFailedCalls.incrementAndGet();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("A total number of " + failures + " failures have now been counted.");
            }
            if (failures >= this.maxNumberOfFailedCalls) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Max number of failed calls has been reached trying to switch over proxy.");
                    this.logger.info("Current proxy: " + this.getActiveProxy().get("ActiveProxy"));
                }
                this.switchProxy();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Switched to proxy: " + this.getActiveProxy().get("ActiveProxy"));
                }
                this.numberOfFailedCalls.set(0);
            }
        }
    }

    public Map<String, String> getActiveProxy() {
        ConcurrentHashMap<String, String> activeProxyMap = new ConcurrentHashMap<String, String>();
        activeProxyMap.put("ActiveProxy", this.activeProxy);
        return activeProxyMap;
    }

    public Map<String, String> switchProxy() {
        if (this.activeProxy.equalsIgnoreCase(this.primaryProxyUri)) {
            this.activeProxy = this.fallBackProxyUri;
            this.activeProxyUsername = this.fallBackProxyUsername;
            this.activeProxyPassword = this.fallBackProxyPassword;
            this.useFallbackProxy.set(true);
        } else if (this.allowFallbackToPrimary) {
            this.activeProxy = this.primaryProxyUri;
            this.activeProxyUsername = this.primaryProxyUsername;
            this.activeProxyPassword = this.primaryProxyPassword;
            this.useFallbackProxy.set(false);
        }
        Notification notification = this.notification(1, 14110, "Max number of failed calls has been reached! Outbound proxy switched");
        NotificationsDao notifications = this.storage.getNotificationsDao();
        notifications.addNotification(notification);
        return this.getActiveProxy();
    }

    public Map<String, String> getProxies(Object message) {
        ConcurrentHashMap<String, String> proxies = new ConcurrentHashMap<String, String>();
        proxies.put("ActiveProxy", this.activeProxy);
        proxies.put("UsingFallBackProxy", this.useFallbackProxy.toString());
        proxies.put("AllowFallbackToPrimary", String.valueOf(this.allowFallbackToPrimary));
        proxies.put("PrimaryProxy", this.primaryProxyUri);
        proxies.put("FallbackProxy", this.fallBackProxyUri);
        return proxies;
    }

    private Notification notification(int log, int error, String message) {
        String version = this.configuration.subset("runtime-settings").getString("api-version");
        Sid accountId = null;
        accountId = this.createCallRequest != null ? this.createCallRequest.accountId() : (this.switchProxyRequest != null ? this.switchProxyRequest.getSid() : new Sid("ACae6e420f425248d6a26948c17a9e2acf"));
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(accountId);
        builder.setApiVersion(version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        java.net.URI info = java.net.URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        try {
            builder.setRequestUrl(new java.net.URI(""));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        builder.setRequestMethod("");
        builder.setRequestVariables("");
        buffer = new StringBuilder();
        buffer.append("/").append(version).append("/Accounts/");
        buffer.append(accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        java.net.URI uri = java.net.URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    private SipURI outboundInterface(String transport) {
        SipURI result = null;
        List uris = (List)this.context.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String interfaceTransport = uri.getTransportParam();
            if (!transport.equalsIgnoreCase(interfaceTransport)) continue;
            result = uri;
        }
        return result;
    }
}

