/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.mscontrol.api.MediaServerControllerFactory;
import org.restcomm.connect.telephony.Conference;
import org.restcomm.connect.telephony.CreateConferenceException;
import org.restcomm.connect.telephony.api.ConferenceCenterResponse;
import org.restcomm.connect.telephony.api.ConferenceStateChanged;
import org.restcomm.connect.telephony.api.CreateConference;
import org.restcomm.connect.telephony.api.DestroyConference;
import org.restcomm.connect.telephony.api.StartConference;

public final class ConferenceCenter
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final MediaServerControllerFactory factory;
    private final Map<String, ActorRef> conferences;
    private final Map<String, List<ActorRef>> initializing;
    private final DaoManager storage;

    public ConferenceCenter(MediaServerControllerFactory factory, DaoManager storage) {
        this.factory = factory;
        this.conferences = new HashMap<String, ActorRef>();
        this.initializing = new HashMap<String, List<ActorRef>>();
        this.storage = storage;
    }

    private ActorRef getConference(final String name) {
        return this.getContext().actorOf(new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Conference(name, ConferenceCenter.this.factory.provideConferenceController(), ConferenceCenter.this.storage);
            }
        }));
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef sender = this.sender();
        if (CreateConference.class.equals(klass)) {
            this.create(message, sender);
        } else if (ConferenceStateChanged.class.equals(klass)) {
            this.notify(message, sender);
        } else if (DestroyConference.class.equals(klass)) {
            this.destroy(message);
        }
    }

    private void destroy(Object message) {
        DestroyConference request = (DestroyConference)message;
        String name = request.name();
        ActorRef conference = this.conferences.remove(name);
        UntypedActorContext context = this.getContext();
        if (conference != null) {
            context.stop(conference);
        }
    }

    private void notify(Object message, ActorRef sender) {
        List<ActorRef> observers;
        ActorRef conference;
        ConferenceStateChanged update = (ConferenceStateChanged)message;
        String name = update.name();
        ActorRef self = this.self();
        ConferenceCenterResponse response = null;
        if (this.isRunning(update.state())) {
            if (!this.conferences.containsKey(name)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Conference " + name + " started successfully");
                }
                this.conferences.put(name, sender);
                response = new ConferenceCenterResponse(sender);
            }
        } else if (ConferenceStateChanged.State.COMPLETED.equals((Object)update.state())) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Conference " + name + " completed without issues");
            }
            conference = this.conferences.remove(update.name());
            this.context().stop(conference);
        } else if (ConferenceStateChanged.State.FAILED.equals((Object)update.state())) {
            if (this.conferences.containsKey(name)) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Conference " + name + " completed with errors");
                }
                conference = this.conferences.remove(update.name());
                this.context().stop(conference);
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Conference " + name + " failed to initialize");
                }
                StringBuilder buffer = new StringBuilder();
                buffer.append("The conference room ").append(name).append(" failed to initialize.");
                CreateConferenceException exception = new CreateConferenceException(buffer.toString());
                response = new ConferenceCenterResponse((Throwable)exception);
            }
        }
        if ((observers = this.initializing.remove(name)) != null) {
            for (ActorRef observer : observers) {
                observer.tell((Object)response, self);
            }
            observers.clear();
        }
    }

    private boolean isRunning(ConferenceStateChanged.State state) {
        return ConferenceStateChanged.State.RUNNING_MODERATOR_ABSENT.equals((Object)state) || ConferenceStateChanged.State.RUNNING_MODERATOR_PRESENT.equals((Object)state);
    }

    private void create(Object message, ActorRef sender) {
        CreateConference request = (CreateConference)message;
        String name = request.name();
        ActorRef self = this.self();
        ActorRef conference = this.conferences.get(name);
        if (conference != null && !conference.isTerminated()) {
            sender.tell((Object)new ConferenceCenterResponse(conference), self);
            return;
        }
        List<ActorRef> observers = this.initializing.get(name);
        if (observers != null) {
            observers.add(sender);
        } else {
            observers = new ArrayList<ActorRef>();
            observers.add(sender);
            conference = this.getConference(name);
            conference.tell((Object)new Observe(self), self);
            conference.tell((Object)new StartConference(request.initialitingCallSid()), self);
            this.initializing.put(name, observers);
        }
    }
}

