/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony.proxy;

import akka.actor.ActorContext;
import akka.actor.ActorSystem;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.joda.time.DateTime;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.GatewaysDao;
import org.restcomm.connect.dao.entities.Gateway;
import org.restcomm.connect.telephony.api.RegisterGateway;
import scala.concurrent.duration.Duration;

public final class ProxyManager
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private static final int ttl = 1800;
    private final ServletContext servletContext;
    private final SipFactory factory;
    private final DaoManager storage;
    private final String address;

    public ProxyManager(ServletContext servletContext, SipFactory factory, DaoManager storage, String address) {
        this.servletContext = servletContext;
        this.factory = factory;
        this.storage = storage;
        this.address = address;
        ActorContext context = this.context();
        context.setReceiveTimeout((Duration)Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        this.registerFirstTime();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Proxy Manager started.");
        }
    }

    private void authenticate(Object message) {
        SipServletResponse response = (SipServletResponse)message;
        SipApplicationSession application = response.getApplicationSession();
        Gateway gateway = (Gateway)application.getAttribute(Gateway.class.getName());
        int status = response.getStatus();
        AuthInfo authentication = this.factory.createAuthInfo();
        String realm = (String)response.getChallengeRealms().next();
        String user = gateway.getUserName();
        String password = gateway.getPassword();
        authentication.addAuthInfo(status, realm, user, password);
        this.register(gateway, authentication, response);
    }

    private Address contact(Gateway gateway, int expires) throws ServletParseException {
        SipURI outboundInterface = null;
        outboundInterface = this.address != null && !this.address.isEmpty() ? (this.address.contains(":") ? this.factory.createSipURI(null, this.address) : this.outboundInterface(this.address, "udp")) : this.outboundInterface();
        if (outboundInterface == null) {
            outboundInterface = this.factory.createSipURI(null, this.address);
        }
        String user = gateway.getUserName();
        String host = outboundInterface.getHost();
        int port = outboundInterface.getPort();
        if (port == -1) {
            port = this.outboundInterface().getPort();
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("sip:").append(user).append("@").append(host).append(":").append(port);
        Address contact = this.factory.createAddress(buffer.toString());
        contact.setExpires(expires);
        return contact;
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof ReceiveTimeout) {
            this.refresh();
        } else if (message instanceof SipServletResponse) {
            SipServletResponse response = (SipServletResponse)message;
            int status = response.getStatus();
            switch (status) {
                case 401: 
                case 407: {
                    this.authenticate(message);
                }
                case 200: {
                    this.update(message);
                }
            }
        } else if (message instanceof RegisterGateway) {
            this.register(((RegisterGateway)message).getGateway());
        }
    }

    private SipURI outboundInterface() {
        ServletContext context = this.servletContext;
        SipURI result = null;
        List uris = (List)context.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String transport = uri.getTransportParam();
            if (!"udp".equalsIgnoreCase(transport)) continue;
            result = uri;
        }
        return result;
    }

    private SipURI outboundInterface(String address, String transport) {
        ServletContext context = this.servletContext;
        SipURI result = null;
        List uris = (List)context.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String interfaceAddress = uri.getHost();
            String interfaceTransport = uri.getTransportParam();
            if (!address.equalsIgnoreCase(interfaceAddress) || !transport.equalsIgnoreCase(interfaceTransport)) continue;
            result = uri;
        }
        return result;
    }

    private void registerFirstTime() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("First time registration for the gateways");
        }
        GatewaysDao gateways = this.storage.getGatewaysDao();
        List results = gateways.getGateways();
        for (Gateway result : results) {
            this.register(result);
        }
    }

    private void refresh() {
        GatewaysDao gateways = this.storage.getGatewaysDao();
        List results = gateways.getGateways();
        for (Gateway result : results) {
            DateTime lastUpdate = result.getDateUpdated();
            DateTime expires = lastUpdate.plusSeconds(result.getTimeToLive());
            if (!expires.isBeforeNow() && !expires.isEqualNow()) continue;
            this.register(result);
        }
    }

    private void register(Gateway gateway) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("About to register gateway: " + gateway.getFriendlyName());
        }
        this.register(gateway, null, null);
    }

    private void register(Gateway gateway, AuthInfo authentication, SipServletResponse response) {
        try {
            SipApplicationSession application = this.factory.createApplicationSession();
            application.setAttribute(Gateway.class.getName(), (Object)gateway);
            String user = gateway.getUserName();
            String proxy = gateway.getProxy();
            StringBuilder buffer = new StringBuilder();
            buffer.append("sip:").append(user).append("@").append(proxy);
            String aor = buffer.toString();
            int expires = gateway.getTimeToLive() > 0 && gateway.getTimeToLive() < 3600 ? gateway.getTimeToLive() : 1800;
            Address contact = this.contact(gateway, expires);
            SipServletRequest register = null;
            if (response != null) {
                String method = response.getRequest().getMethod();
                register = response.getSession().createRequest(method);
            } else {
                register = this.factory.createRequest(application, "REGISTER", contact.toString(), aor);
            }
            if (authentication != null && response != null) {
                register.addAuthHeader(response, authentication);
            }
            register.addAddressHeader("Contact", contact, false);
            SipURI uri = this.factory.createSipURI(null, proxy);
            register.pushRoute(uri);
            register.setRequestURI((URI)uri);
            SipSession session = register.getSession();
            session.setHandler("ProxyManager");
            register.send();
        }
        catch (Exception exception) {
            String name = gateway.getFriendlyName();
            this.logger.error((Throwable)exception, "Could not send a registration request to the proxy named " + name);
        }
    }

    private void update(Object message) {
        SipServletResponse response = (SipServletResponse)message;
        SipApplicationSession application = response.getApplicationSession();
        Gateway gateway = (Gateway)application.getAttribute(Gateway.class.getName());
        gateway = gateway.setTimeToLive(gateway.getTimeToLive());
        GatewaysDao gateways = this.storage.getGatewaysDao();
        gateways.updateGateway(gateway);
    }
}

