/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony.ua;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.util.DigestAuthentication;
import org.restcomm.connect.commons.util.HexadecimalUtils;
import org.restcomm.connect.dao.ClientsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.RegistrationsDao;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.dao.entities.Registration;
import org.restcomm.connect.monitoringservice.MonitoringService;
import org.restcomm.connect.telephony.CallManager;
import org.restcomm.connect.telephony.api.DestroyCall;
import org.restcomm.connect.telephony.api.GetCall;
import org.restcomm.connect.telephony.api.Hangup;
import org.restcomm.connect.telephony.api.UserRegistration;

public final class UserAgentManager
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private boolean authenticateUsers = true;
    private final SipFactory factory;
    private final DaoManager storage;
    private final ServletContext servletContext;
    private ActorRef monitoringService;
    private final int pingInterval;
    private final String instanceId;
    private ActorRef callManager;

    public UserAgentManager(Configuration configuration, SipFactory factory, DaoManager storage, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.monitoringService = (ActorRef)servletContext.getAttribute(MonitoringService.class.getName());
        Configuration runtime = configuration.subset("runtime-settings");
        this.authenticateUsers = runtime.getBoolean("authenticate");
        this.factory = factory;
        this.storage = storage;
        this.pingInterval = runtime.getInt("ping-interval", 60);
        this.logger.info("About to run firstTimeCleanup()");
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
        this.callManager = (ActorRef)servletContext.getAttribute(CallManager.class.getName());
        this.firstTimeCleanup();
    }

    private void firstTimeCleanup() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initial registration cleanup. Will check existing registrations in DB and cleanup appropriately");
        }
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        List results = registrations.getRegistrationsByInstanceId(this.instanceId);
        for (Registration result : results) {
            if (result.isWebRTC()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will remove WebRTC client: " + result.getLocation());
                }
                registrations.removeRegistration(result);
                this.monitoringService.tell((Object)new UserRegistration(result.getUserName(), result.getLocation(), Boolean.valueOf(false)), this.self());
                continue;
            }
            DateTime expires = result.getDateExpires();
            if (expires.isBeforeNow() || expires.isEqualNow()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Registration: " + result.getLocation() + " expired and will be removed now");
                }
                registrations.removeRegistration(result);
                this.monitoringService.tell((Object)new UserRegistration(result.getUserName(), result.getLocation(), Boolean.valueOf(false)), this.self());
                this.monitoringService.tell((Object)new GetCall(result.getLocation()), this.self());
                continue;
            }
            DateTime updated = result.getDateUpdated();
            Long pingIntervalMillis = new Long(this.pingInterval * 1000 * 3);
            if (DateTime.now().getMillis() - updated.getMillis() <= pingIntervalMillis) continue;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Registration: " + result.getLocation() + " didn't respond to OPTIONS and will be removed now");
            }
            registrations.removeRegistration(result);
            this.monitoringService.tell((Object)new UserRegistration(result.getUserName(), result.getLocation(), Boolean.valueOf(false)), this.self());
            this.monitoringService.tell((Object)new GetCall(result.getLocation()), this.self());
        }
        results = registrations.getRegistrationsByInstanceId(this.instanceId);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initial registration cleanup finished, starting Restcomm with " + results.size() + " registrations");
        }
    }

    private void clean() {
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        List results = registrations.getRegistrationsByInstanceId(this.instanceId);
        for (Registration result : results) {
            DateTime expires = result.getDateExpires();
            if (expires.isBeforeNow() || expires.isEqualNow()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Registration: " + result.getAddressOfRecord() + " expired and will be removed now");
                }
                registrations.removeRegistration(result);
                this.monitoringService.tell((Object)new UserRegistration(result.getUserName(), result.getLocation(), Boolean.valueOf(false)), this.self());
                continue;
            }
            DateTime updated = result.getDateUpdated();
            Long pingIntervalMillis = new Long(this.pingInterval * 1000 * 3);
            if (DateTime.now().getMillis() - updated.getMillis() <= pingIntervalMillis) continue;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Registration: " + result.getAddressOfRecord() + " didn't respond to OPTIONS and will be removed now");
            }
            registrations.removeRegistration(result);
            this.monitoringService.tell((Object)new UserRegistration(result.getUserName(), result.getLocation(), Boolean.valueOf(false)), this.self());
        }
    }

    private void disconnectActiveCalls(ActorRef call) {
        if (call != null && !call.isTerminated()) {
            call.tell((Object)new Hangup("Registration_Removed"), this.self());
            this.callManager.tell((Object)new DestroyCall(call), this.self());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Disconnected call: " + call.path() + " , after removed registration");
            }
        }
    }

    private String header(String nonce, String realm, String scheme) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(scheme).append(" ");
        buffer.append("realm=\"").append(realm).append("\", ");
        buffer.append("nonce=\"").append(nonce).append("\"");
        return buffer.toString();
    }

    private void authenticate(Object message) throws IOException {
        SipServletRequest request = (SipServletRequest)message;
        SipServletResponse response = request.createResponse(407);
        String nonce = this.nonce();
        SipURI uri = (SipURI)request.getTo().getURI();
        String realm = uri.getHost();
        String header = this.header(nonce, realm, "Digest");
        response.addHeader("Proxy-Authenticate", header);
        response.send();
    }

    private void keepAlive() throws Exception {
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        List results = registrations.getRegistrationsByInstanceId(this.instanceId);
        if (results != null && results.size() > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Registrations for InstanceId: " + this.instanceId + " , returned " + results.size() + " registrations");
            }
            for (Registration result : results) {
                String to = result.getLocation();
                this.ping(to);
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registrations for InstanceId: " + this.instanceId + " , returned no registrations");
        }
    }

    private String nonce() {
        byte[] uuid = UUID.randomUUID().toString().getBytes();
        char[] hex = HexadecimalUtils.toHex((byte[])uuid);
        return new String(hex).substring(0, 31);
    }

    public void onReceive(Object message) throws Exception {
        if (message instanceof ReceiveTimeout) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Timeout received, ping interval: " + this.pingInterval + " , will clean up registrations and send keep alive");
            }
            this.clean();
            this.keepAlive();
        } else if (message instanceof SipServletRequest) {
            SipServletRequest request = (SipServletRequest)message;
            String method = request.getMethod();
            if ("REGISTER".equalsIgnoreCase(method)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("REGISTER request received: " + request.toString());
                }
                if (this.authenticateUsers) {
                    String authorization = request.getHeader("Proxy-Authorization");
                    if (authorization != null) {
                        if (this.permitted(authorization, method)) {
                            this.register(message);
                        } else {
                            SipServletResponse response = ((SipServletRequest)message).createResponse(403);
                            response.send();
                        }
                    } else {
                        this.authenticate(message);
                    }
                } else {
                    this.register(message);
                }
            }
        } else if (message instanceof SipServletResponse) {
            SipServletResponse response = (SipServletResponse)message;
            if (response.getStatus() > 400 && response.getMethod().equalsIgnoreCase("OPTIONS")) {
                this.removeRegistration((SipServletMessage)response);
            } else {
                this.pong(message);
            }
        } else if (message instanceof ActorRef) {
            this.disconnectActiveCalls((ActorRef)message);
        }
    }

    private void removeRegistration(SipServletMessage sipServletMessage) {
        RegistrationsDao regDao;
        List registrations;
        String user = ((SipURI)sipServletMessage.getTo().getURI()).getUser();
        String host = ((SipURI)sipServletMessage.getTo().getURI()).getHost();
        String port = String.valueOf(((SipURI)sipServletMessage.getTo().getURI()).getPort());
        String transport = ((SipURI)sipServletMessage.getTo().getURI()).getTransportParam();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Error response for the OPTIONS to: " + sipServletMessage.getFrom().toString() + " will remove registration");
        }
        if ((registrations = (regDao = this.storage.getRegistrationsDao()).getRegistrations(user)) != null) {
            Iterator iter = registrations.iterator();
            SipURI regLocation = null;
            while (iter.hasNext()) {
                Registration reg = (Registration)iter.next();
                try {
                    regLocation = (SipURI)this.factory.createURI(reg.getLocation());
                }
                catch (ServletParseException e) {
                    // empty catch block
                }
                if (regLocation == null || !reg.getAddressOfRecord().equalsIgnoreCase(regLocation.toString()) && !reg.getLocation().equalsIgnoreCase(regLocation.toString())) continue;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Registration: " + reg.getLocation() + " failed to response to OPTIONS and will be removed");
                }
                regDao.removeRegistration(reg);
                this.monitoringService.tell((Object)new UserRegistration(reg.getUserName(), reg.getLocation(), Boolean.valueOf(false)), this.self());
                this.monitoringService.tell((Object)new GetCall(reg.getLocation()), this.self());
            }
        }
    }

    private void patch(SipURI uri, String address, int port) throws UnknownHostException {
        uri.setHost(address);
        uri.setPort(port);
    }

    private boolean permitted(String authorization, String method) {
        Map<String, String> map = this.toMap(authorization);
        String user = map.get("username");
        String algorithm = map.get("algorithm");
        String realm = map.get("realm");
        String uri = map.get("uri");
        String nonce = map.get("nonce");
        String nc = map.get("nc");
        String cnonce = map.get("cnonce");
        String qop = map.get("qop");
        String response = map.get("response");
        ClientsDao clients = this.storage.getClientsDao();
        Client client = clients.getClient(user);
        if (client != null && 1 == client.getStatus()) {
            String password = client.getPassword();
            String result = DigestAuthentication.response((String)algorithm, (String)user, (String)realm, (String)password, (String)nonce, (String)nc, (String)cnonce, (String)method, (String)uri, null, (String)qop);
            return result.equals(response);
        }
        return false;
    }

    private void ping(String to) throws ServletException {
        SipApplicationSession application = this.factory.createApplicationSession();
        String toTransport = ((SipURI)this.factory.createURI(to)).getTransportParam();
        if (toTransport == null) {
            toTransport = "udp";
        }
        SipURI outboundInterface = this.outboundInterface(toTransport);
        StringBuilder buffer = new StringBuilder();
        buffer.append("sip:restcomm").append("@").append(outboundInterface.getHost());
        String from = buffer.toString();
        SipServletRequest ping = this.factory.createRequest(application, "OPTIONS", from, to);
        SipURI uri = (SipURI)this.factory.createURI(to);
        ping.pushRoute(uri);
        ping.setRequestURI((URI)uri);
        SipSession session = ping.getSession();
        session.setHandler("UserAgentManager");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("About to send OPTIONS keepalive to: " + to);
        }
        try {
            ping.send();
        }
        catch (IOException e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("There was an exception trying to ping client: " + to + " , will remove registration. Exception: " + e);
            }
            this.removeRegistration((SipServletMessage)ping);
        }
    }

    private void pong(Object message) {
        SipServletResponse response = (SipServletResponse)message;
        if (response.getApplicationSession().isValid()) {
            response.getApplicationSession().invalidate();
        }
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        Registration registration = registrations.getRegistration(((SipURI)response.getTo().getURI()).getUser());
        registration = registration.updated();
        registrations.updateRegistration(registration);
    }

    private SipURI outboundInterface(String toTransport) {
        SipURI result = null;
        List uris = (List)this.servletContext.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String transport = uri.getTransportParam();
            if (toTransport == null || !toTransport.equalsIgnoreCase(transport)) continue;
            result = uri;
        }
        return result;
    }

    private void register(Object message) throws Exception {
        String transport;
        SipServletRequest request = (SipServletRequest)message;
        Address contact = request.getAddressHeader("Contact");
        int ttl = contact.getExpires();
        if (ttl == -1) {
            String expires = request.getHeader("Expires");
            ttl = expires != null ? Integer.parseInt(expires) : 3600;
        }
        if (ttl > 3600) {
            ttl = 3600;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Register request received for contact: " + contact + ", and ttl: " + ttl);
        }
        String name = contact.getDisplayName();
        String ua = request.getHeader("User-Agent");
        SipURI to = (SipURI)request.getTo().getURI();
        String aor = to.toString();
        String user = to.getUser();
        SipURI uri = (SipURI)contact.getURI();
        String ip = request.getInitialRemoteAddr();
        int port = request.getInitialRemotePort();
        String string = transport = uri.getTransportParam() == null ? request.getParameter("transport") : uri.getTransportParam();
        if (transport == null && !request.getInitialTransport().equalsIgnoreCase("udp")) {
            transport = request.getInitialTransport();
        }
        boolean isLBPresent = false;
        String initialIpBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemoteAddr");
        String initialPortBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemotePort");
        if (initialIpBeforeLB != null && !initialIpBeforeLB.isEmpty() && initialPortBeforeLB != null && !initialPortBeforeLB.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Client in front of LB. Patching URI: " + uri.toString() + " with IP: " + initialIpBeforeLB + " and PORT: " + initialPortBeforeLB + " for USER: " + user);
            }
            this.patch(uri, initialIpBeforeLB, Integer.valueOf(initialPortBeforeLB));
            isLBPresent = true;
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Patching URI: " + uri.toString() + " with IP: " + ip + " and PORT: " + port + " for USER: " + user);
            }
            this.patch(uri, ip, port);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("sip:").append(user).append("@").append(uri.getHost()).append(":").append(uri.getPort());
        if (transport != null) {
            buffer.append(";transport=").append(transport);
        }
        String address = buffer.toString();
        SipServletResponse response = request.createResponse(200);
        Sid sid = Sid.generate((Sid.Type)Sid.Type.REGISTRATION);
        DateTime now = DateTime.now();
        if (name == null) {
            name = user;
        }
        if (ua == null) {
            ua = "GenericUA";
        }
        boolean webRTC = this.isWebRTC(transport, ua);
        Registration registration = new Registration(sid, this.instanceId, now, now, aor, name, user, ua, ttl, address, webRTC, isLBPresent);
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        if (ttl == 0) {
            registrations.removeRegistration(registration);
            response.setHeader("Expires", "0");
            this.monitoringService.tell((Object)new UserRegistration(user, address, Boolean.valueOf(false)), this.self());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The user agent manager unregistered " + user + " at address " + address + ":" + port);
            }
        } else {
            this.monitoringService.tell((Object)new UserRegistration(user, address, Boolean.valueOf(true)), this.self());
            if (registrations.hasRegistration(registration)) {
                registrations.updateRegistration(registration);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("The user agent manager updated " + user + " at address " + address + ":" + port);
                }
            } else {
                registrations.addRegistration(registration);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("The user agent manager registered " + user + " at address " + address + ":" + port);
                }
            }
            response.setHeader("Contact", this.contact(uri, ttl));
        }
        response.send();
        try {
            if (request != null) {
                if (request.getApplicationSession() != null) {
                    if (request.getApplicationSession().isValid()) {
                        try {
                            request.getApplicationSession().setInvalidateWhenReady(true);
                        }
                        catch (IllegalStateException exception) {
                            this.logger.error("Exception while trying to setInvalidateWhenReady(true) for application session, exception: " + exception);
                        }
                    }
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info("After sent response: " + response.toString() + " for Register request, application session is NULL!");
                }
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info("After sent response: " + response.toString() + " for Register request, request is NULL!");
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while trying to setInvalidateWhenReady(true) after sent response to register : " + response.toString() + " exception: " + e);
        }
    }

    private boolean isWebRTC(String transport, String userAgent) {
        return "ws".equalsIgnoreCase(transport) || "wss".equalsIgnoreCase(transport) || userAgent.toLowerCase().contains("restcomm");
    }

    private String contact(SipURI uri, int expires) {
        Address contact = this.factory.createAddress((URI)uri);
        contact.setExpires(expires);
        return contact.toString();
    }

    private Map<String, String> toMap(String header) {
        String[] tokens;
        HashMap<String, String> map = new HashMap<String, String>();
        int endOfScheme = header.indexOf(" ");
        map.put("scheme", header.substring(0, endOfScheme).trim());
        for (String token : tokens = header.substring(endOfScheme + 1).split(",")) {
            String[] values = token.trim().split("=", 2);
            map.put(values[0].toLowerCase(), values[1].replace("\"", ""));
        }
        return map;
    }
}

