/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.mscontrol.api.messages.CreateMediaSession;
import org.restcomm.connect.mscontrol.api.messages.JoinCall;
import org.restcomm.connect.mscontrol.api.messages.JoinComplete;
import org.restcomm.connect.mscontrol.api.messages.Leave;
import org.restcomm.connect.mscontrol.api.messages.MediaServerControllerStateChanged;
import org.restcomm.connect.mscontrol.api.messages.StartRecording;
import org.restcomm.connect.mscontrol.api.messages.Stop;
import org.restcomm.connect.telephony.api.BridgeStateChanged;
import org.restcomm.connect.telephony.api.JoinCalls;
import org.restcomm.connect.telephony.api.StartBridge;
import org.restcomm.connect.telephony.api.StopBridge;

public class Bridge
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State initializing;
    private final State ready;
    private final State bridging;
    private final State halfBridged;
    private final State bridged;
    private final State stopping;
    private final State failed;
    private final State complete;
    private final ActorRef mscontroller;
    private ActorRef inboundCall;
    private ActorRef outboundCall;
    private final List<ActorRef> observers;

    public Bridge(ActorRef mscontroller) {
        ActorRef source = this.self();
        this.mscontroller = mscontroller;
        this.uninitialized = new State("uninitialized", null, null);
        this.initializing = new State("initializing", (Action)new Initializing(source), null);
        this.ready = new State("ready", (Action)new Ready(source), null);
        this.bridging = new State("bridging", (Action)new Bridging(source), null);
        this.halfBridged = new State("half bridged", (Action)new HalfBridged(source), null);
        this.bridged = new State("bridged", (Action)new Bridged(source), null);
        this.stopping = new State("stopping", (Action)new Stopping(source), null);
        this.failed = new State("failed", (Action)new Failed(source), null);
        this.complete = new State("complete", (Action)new Complete(source), null);
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.initializing));
        transitions.add(new Transition(this.initializing, this.failed));
        transitions.add(new Transition(this.initializing, this.ready));
        transitions.add(new Transition(this.ready, this.bridging));
        transitions.add(new Transition(this.ready, this.stopping));
        transitions.add(new Transition(this.bridging, this.halfBridged));
        transitions.add(new Transition(this.bridging, this.stopping));
        transitions.add(new Transition(this.halfBridged, this.stopping));
        transitions.add(new Transition(this.halfBridged, this.bridged));
        transitions.add(new Transition(this.bridged, this.stopping));
        transitions.add(new Transition(this.stopping, this.failed));
        transitions.add(new Transition(this.stopping, this.complete));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.observers = new ArrayList<ActorRef>(3);
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    private void broadcast(Object message) {
        if (!this.observers.isEmpty()) {
            ActorRef self = this.self();
            for (ActorRef observer : this.observers) {
                observer.tell(message, self);
            }
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        State state = this.fsm.state();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("********** Bridge " + self.path() + " State: \"" + state.toString());
            this.logger.info("********** Bridge " + self.path() + " Processing: \"" + klass.getName() + " Sender: " + sender.path());
        }
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (StartBridge.class.equals(klass)) {
            this.onStartBridge((StartBridge)message, self, sender);
        } else if (JoinCalls.class.equals(klass)) {
            this.onJoinCalls((JoinCalls)message, self, sender);
        } else if (JoinComplete.class.equals(klass)) {
            this.onJoinComplete((JoinComplete)message, self, sender);
        } else if (MediaServerControllerStateChanged.class.equals(klass)) {
            this.onMediaServerControllerStateChanged((MediaServerControllerStateChanged)message, self, sender);
        } else if (StopBridge.class.equals(klass)) {
            this.onStopBridge((StopBridge)message, self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecording((StartRecording)message, self, sender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObserve(Observe message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            List<ActorRef> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
                observer.tell((Object)new Observing(self), self);
            }
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private void onStartBridge(StartBridge message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.fsm.transition((Object)message, this.initializing);
        }
    }

    private void onJoinCalls(JoinCalls message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.ready)) {
            this.inboundCall = message.getInboundCall();
            this.outboundCall = message.getOutboundCall();
            this.fsm.transition((Object)message, this.bridging);
        }
    }

    private void onJoinComplete(JoinComplete message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.bridging)) {
            this.fsm.transition((Object)message, this.halfBridged);
        } else if (this.is(this.halfBridged)) {
            this.fsm.transition((Object)message, this.bridged);
        }
    }

    private void onMediaServerControllerStateChanged(MediaServerControllerStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        MediaServerControllerStateChanged.MediaServerControllerState state = message.getState();
        switch (state) {
            case ACTIVE: {
                if (!this.is(this.initializing)) break;
                this.fsm.transition((Object)message, this.ready);
                break;
            }
            case INACTIVE: {
                if (!this.is(this.stopping)) break;
                this.fsm.transition((Object)message, this.complete);
                break;
            }
            case FAILED: {
                if (!this.is(this.initializing)) break;
                this.fsm.transition((Object)message, this.failed);
                break;
            }
        }
    }

    private void onStopBridge(StopBridge message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.ready) || this.is(this.bridging) || this.is(this.halfBridged) || this.is(this.bridged)) {
            this.fsm.transition((Object)message, this.stopping);
        }
    }

    private void onStartRecording(StartRecording message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.bridged)) {
            this.mscontroller.tell((Object)message, sender);
        }
    }

    private class Failed
    extends AbstractAction {
        public Failed(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            BridgeStateChanged notification = new BridgeStateChanged(BridgeStateChanged.BridgeState.FAILED);
            Bridge.this.broadcast(notification);
            Bridge.this.observers.clear();
        }
    }

    private class Complete
    extends AbstractAction {
        public Complete(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            BridgeStateChanged notification = new BridgeStateChanged(BridgeStateChanged.BridgeState.INACTIVE);
            Bridge.this.broadcast(notification);
            Bridge.this.observers.clear();
        }
    }

    private class Stopping
    extends AbstractAction {
        public Stopping(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            boolean liveCallModification = ((StopBridge)message).isLiveCallModification();
            if (!liveCallModification) {
                if (Bridge.this.logger.isInfoEnabled()) {
                    Bridge.this.logger.info("Stopping the Bridge, will ask calls to leave the bridge");
                }
                if (Bridge.this.inboundCall != null) {
                    Bridge.this.inboundCall.tell((Object)new Leave(), this.source);
                    Bridge.this.inboundCall = null;
                }
                if (Bridge.this.outboundCall != null) {
                    Bridge.this.outboundCall.tell((Object)new Leave(), this.source);
                    Bridge.this.outboundCall = null;
                }
            } else if (Bridge.this.logger.isInfoEnabled()) {
                Bridge.this.logger.info("Stopping the Bridge, will NOT ask calls to leave the bridge because liveCallModification: " + liveCallModification);
            }
            Bridge.this.mscontroller.tell((Object)new Stop(), this.source);
        }
    }

    private class Bridged
    extends AbstractAction {
        public Bridged(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            BridgeStateChanged notification = new BridgeStateChanged(BridgeStateChanged.BridgeState.BRIDGED);
            Bridge.this.broadcast(notification);
        }
    }

    private class HalfBridged
    extends AbstractAction {
        public HalfBridged(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            BridgeStateChanged notification = new BridgeStateChanged(BridgeStateChanged.BridgeState.HALF_BRIDGED);
            Bridge.this.broadcast(notification);
            JoinCall join = new JoinCall(Bridge.this.outboundCall, ConnectionMode.SendRecv);
            Bridge.this.mscontroller.tell((Object)join, this.source);
        }
    }

    private class Bridging
    extends AbstractAction {
        public Bridging(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            JoinCall join = new JoinCall(Bridge.this.inboundCall, ConnectionMode.SendRecv);
            Bridge.this.mscontroller.tell((Object)join, this.source);
        }
    }

    private class Ready
    extends AbstractAction {
        public Ready(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            BridgeStateChanged notification = new BridgeStateChanged(BridgeStateChanged.BridgeState.READY);
            Bridge.this.broadcast(notification);
        }
    }

    private class Initializing
    extends AbstractAction {
        public Initializing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Observe observe = new Observe(this.source);
            Bridge.this.mscontroller.tell((Object)observe, this.source);
            CreateMediaSession createMediaSession = new CreateMediaSession();
            Bridge.this.mscontroller.tell((Object)createMediaSession, this.source);
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

