/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.mscontrol.api.MediaServerControllerFactory;
import org.restcomm.connect.telephony.Bridge;
import org.restcomm.connect.telephony.api.BridgeManagerResponse;
import org.restcomm.connect.telephony.api.BridgeStateChanged;
import org.restcomm.connect.telephony.api.CreateBridge;

public class BridgeManager
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final MediaServerControllerFactory factory;
    private final ActorSystem system;

    public BridgeManager(MediaServerControllerFactory factory) {
        this.factory = factory;
        this.system = this.context().system();
    }

    private ActorRef createBridge() {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Bridge(BridgeManager.this.factory.provideBridgeController());
            }
        });
        return this.system.actorOf(props);
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (CreateBridge.class.equals(klass)) {
            this.onCreateBridge((CreateBridge)message, self, sender);
        } else if (BridgeStateChanged.class.equals(klass)) {
            this.onBridgeStateChanged((BridgeStateChanged)message, self, sender);
        }
    }

    private void onCreateBridge(CreateBridge message, ActorRef self, ActorRef sender) {
        ActorRef bridge = this.createBridge();
        bridge.tell((Object)new Observe(self), self);
        BridgeManagerResponse response = new BridgeManagerResponse(bridge);
        sender.tell((Object)response, self);
    }

    private void onBridgeStateChanged(BridgeStateChanged message, ActorRef self, ActorRef sender) {
        switch (message.getState()) {
            case INACTIVE: 
            case FAILED: {
                this.context().stop(sender);
                break;
            }
        }
    }
}

