/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.UntypedActor;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.mobicents.servlet.restcomm.mscontrol.messages.MediaServerConferenceControllerStateChanged;
import org.restcomm.connect.commons.annotations.concurrency.Immutable;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.fsm.Action;
import org.restcomm.connect.commons.fsm.FiniteStateMachine;
import org.restcomm.connect.commons.fsm.State;
import org.restcomm.connect.commons.fsm.Transition;
import org.restcomm.connect.commons.patterns.Observe;
import org.restcomm.connect.commons.patterns.Observing;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.ConferenceDetailRecordsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.entities.ConferenceDetailRecord;
import org.restcomm.connect.mscontrol.api.messages.CreateMediaSession;
import org.restcomm.connect.mscontrol.api.messages.JoinCall;
import org.restcomm.connect.mscontrol.api.messages.JoinComplete;
import org.restcomm.connect.mscontrol.api.messages.Leave;
import org.restcomm.connect.mscontrol.api.messages.Left;
import org.restcomm.connect.mscontrol.api.messages.MediaServerControllerStateChanged;
import org.restcomm.connect.mscontrol.api.messages.Play;
import org.restcomm.connect.mscontrol.api.messages.StartRecording;
import org.restcomm.connect.mscontrol.api.messages.Stop;
import org.restcomm.connect.mscontrol.api.messages.StopMediaGroup;
import org.restcomm.connect.mscontrol.api.messages.StopRecording;
import org.restcomm.connect.telephony.api.AddParticipant;
import org.restcomm.connect.telephony.api.ConferenceInfo;
import org.restcomm.connect.telephony.api.ConferenceModeratorPresent;
import org.restcomm.connect.telephony.api.ConferenceResponse;
import org.restcomm.connect.telephony.api.ConferenceStateChanged;
import org.restcomm.connect.telephony.api.GetConferenceInfo;
import org.restcomm.connect.telephony.api.RemoveParticipant;
import org.restcomm.connect.telephony.api.StartConference;
import org.restcomm.connect.telephony.api.StopConference;

@Immutable
public final class Conference
extends UntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private final FiniteStateMachine fsm;
    private final State uninitialized;
    private final State initializing;
    private final State waiting;
    private final State running;
    private final State evicting;
    private final State stopping;
    private final State stopped;
    private final State failed;
    private final String name;
    private final String accountSid;
    private final String friendlyName;
    private Sid sid;
    private final List<ActorRef> calls;
    private final List<ActorRef> observers;
    private boolean moderatorPresent = false;
    private final ActorRef mscontroller;
    private final DaoManager storage;
    private int globalNoOfParticipants;
    private ConferenceStateChanged.State waitingState;

    public Conference(String name, ActorRef msController, DaoManager storage) {
        ActorRef source = this.self();
        this.uninitialized = new State("uninitialized", null, null);
        this.initializing = new State("initializing", (Action)new Initializing(source));
        this.waiting = new State("waiting", (Action)new Waiting(source));
        this.running = new State("running", (Action)new Running(source));
        this.evicting = new State("evicting", (Action)new Evicting(source));
        this.stopping = new State("stopping", (Action)new Stopping(source));
        this.stopped = new State("stopped", (Action)new Stopped(source));
        this.failed = new State("failed", (Action)new Failed(source));
        HashSet<Transition> transitions = new HashSet<Transition>();
        transitions.add(new Transition(this.uninitialized, this.initializing));
        transitions.add(new Transition(this.initializing, this.waiting));
        transitions.add(new Transition(this.initializing, this.stopping));
        transitions.add(new Transition(this.initializing, this.failed));
        transitions.add(new Transition(this.waiting, this.running));
        transitions.add(new Transition(this.waiting, this.evicting));
        transitions.add(new Transition(this.waiting, this.stopping));
        transitions.add(new Transition(this.running, this.evicting));
        transitions.add(new Transition(this.running, this.stopping));
        transitions.add(new Transition(this.evicting, this.stopping));
        transitions.add(new Transition(this.stopping, this.stopped));
        transitions.add(new Transition(this.stopping, this.failed));
        this.fsm = new FiniteStateMachine(this.uninitialized, transitions);
        this.name = name;
        String[] cnfNameAndAccount = name.split(":");
        this.accountSid = cnfNameAndAccount[0];
        this.friendlyName = cnfNameAndAccount[1];
        this.storage = storage;
        this.mscontroller = msController;
        this.calls = new ArrayList<ActorRef>();
        this.observers = new ArrayList<ActorRef>();
    }

    private boolean is(State state) {
        return this.fsm.state().equals((Object)state);
    }

    private boolean isRunning() {
        return this.is(this.waiting) || this.is(this.running);
    }

    private void broadcast(Object message) {
        if (!this.observers.isEmpty()) {
            ActorRef self = this.self();
            for (ActorRef observer : this.observers) {
                if (!observer.isTerminated()) {
                    observer.tell(message, self);
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Conference broadcase, Observer is terminated: " + observer.path());
            }
        }
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef sender = this.sender();
        ActorRef self = this.self();
        State state = this.fsm.state();
        if (this.logger.isInfoEnabled()) {
            this.logger.info(" ********** Conference " + this.self().path() + " Current State: " + state.toString());
            this.logger.info(" ********** Conference " + this.self().path() + " Processing Message: " + klass.getName());
        }
        if (Observe.class.equals(klass)) {
            this.onObserve((Observe)message, self, sender);
        } else if (StopObserving.class.equals(klass)) {
            this.onStopObserving((StopObserving)message, self, sender);
        } else if (GetConferenceInfo.class.equals(klass)) {
            this.onGetConferenceInfo(self, sender);
        } else if (StartConference.class.equals(klass)) {
            this.onStartConference((StartConference)message, self, sender);
        } else if (StopConference.class.equals(klass)) {
            this.onStopConference((StopConference)message, self, sender);
        } else if (ConferenceModeratorPresent.class.equals(klass)) {
            this.onConferenceModeratorPresent((ConferenceModeratorPresent)message, self, sender);
        } else if (AddParticipant.class.equals(klass)) {
            this.onAddParticipant((AddParticipant)message, self, sender);
        } else if (RemoveParticipant.class.equals(klass)) {
            this.onRemoveParticipant((RemoveParticipant)message, self, sender);
        } else if (Left.class.equals(klass)) {
            this.onLeft((Left)message, self, sender);
        } else if (JoinComplete.class.equals(klass)) {
            this.onJoinComplete((JoinComplete)message, self, sender);
        } else if (MediaServerConferenceControllerStateChanged.class.equals(klass)) {
            this.onMediaServerControllerStateChanged((MediaServerConferenceControllerStateChanged)message, self, sender);
        } else if (Play.class.equals(klass)) {
            this.onPlay((Play)message, self, sender);
        } else if (StartRecording.class.equals(klass)) {
            this.onStartRecording((StartRecording)message, self, sender);
        } else if (StopRecording.class.equals(klass)) {
            this.onStopRecording((StopRecording)message, self, sender);
        }
    }

    private void onObserve(Observe message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.add(observer);
            observer.tell((Object)new Observing(self), self);
        }
    }

    private void onStopObserving(StopObserving message, ActorRef self, ActorRef sender) {
        ActorRef observer = message.observer();
        if (observer != null) {
            this.observers.remove(observer);
        }
    }

    private void onGetConferenceInfo(ActorRef self, ActorRef sender) throws Exception {
        sender.tell((Object)new ConferenceResponse((Object)this.createConferenceInfo()), self);
    }

    private ConferenceInfo createConferenceInfo() throws Exception {
        ConferenceInfo information = null;
        int globalNoOfParticipants = this.getGlobalNoOfParticipants();
        information = this.is(this.waiting) ? new ConferenceInfo(this.sid, this.calls, this.waitingState, this.name, this.moderatorPresent, globalNoOfParticipants) : (this.is(this.running) ? new ConferenceInfo(this.sid, this.calls, ConferenceStateChanged.State.RUNNING_MODERATOR_PRESENT, this.name, this.moderatorPresent, globalNoOfParticipants) : (this.is(this.stopped) ? new ConferenceInfo(this.sid, this.calls, ConferenceStateChanged.State.COMPLETED, this.name, this.moderatorPresent, globalNoOfParticipants) : new ConferenceInfo(this.sid, this.calls, null, this.name, this.moderatorPresent, globalNoOfParticipants)));
        return information;
    }

    private void onStartConference(StartConference message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.uninitialized)) {
            this.fsm.transition((Object)message, this.initializing);
        }
    }

    private void onStopConference(StopConference message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.initializing)) {
            this.fsm.transition((Object)message, this.stopped);
        } else if (this.is(this.waiting) || this.is(this.running)) {
            this.fsm.transition((Object)message, this.evicting);
        }
    }

    private void onConferenceModeratorPresent(ConferenceModeratorPresent message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.waiting)) {
            this.fsm.transition((Object)message, this.running);
        }
    }

    private void onAddParticipant(AddParticipant message, ActorRef self, ActorRef sender) {
        if (this.isRunning()) {
            JoinCall joinCall = new JoinCall(message.call(), ConnectionMode.Confrnce, this.sid);
            this.mscontroller.tell((Object)joinCall, self);
        }
    }

    private void onRemoveParticipant(RemoveParticipant message, ActorRef self, ActorRef sender) throws Exception {
        if (this.isRunning()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Received RemoveParticipants for Call: " + message.call().path());
            }
            ActorRef call = message.call();
            Leave leave = new Leave();
            call.tell((Object)leave, self);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received RemoveParticipants for Call: " + message.call().path() + " but the state is: " + this.fsm.state().toString());
        }
    }

    private void onLeft(Left message, ActorRef self, ActorRef sender) throws Exception {
        if (this.is(this.running) || this.is(this.waiting) || this.is(this.evicting)) {
            boolean removed = this.calls.remove(sender);
            int participantsNr = this.calls.size();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("################################## Conference " + this.name + " has " + participantsNr + " participants");
            }
            ConferenceResponse conferenceResponse = new ConferenceResponse((Object)message);
            this.broadcast(conferenceResponse);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Call left conference room and notification sent to observers.");
            }
            if (removed && this.calls.isEmpty()) {
                this.fsm.transition((Object)message, this.stopping);
            }
        }
    }

    private void onMediaServerControllerStateChanged(MediaServerConferenceControllerStateChanged message, ActorRef self, ActorRef sender) throws Exception {
        MediaServerControllerStateChanged.MediaServerControllerState state = message.getState();
        switch (state) {
            case ACTIVE: {
                if (!this.is(this.initializing)) break;
                this.fsm.transition((Object)message, this.waiting);
                break;
            }
            case INACTIVE: {
                if (!this.is(this.stopping)) break;
                this.fsm.transition((Object)message, this.stopped);
                break;
            }
            case FAILED: {
                if (!this.is(this.initializing)) break;
                this.fsm.transition((Object)message, this.failed);
                break;
            }
        }
    }

    private void onJoinComplete(JoinComplete message, ActorRef self, ActorRef sender) throws Exception {
        this.mscontroller.tell((Object)message, sender);
        this.calls.add(sender);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Conference name: " + this.name + ", path: " + this.self().path() + ", received JoinComplete from Call: " + sender.path() + ", number of participants currently: " + this.calls.size() + ", will send conference info to observers");
        }
        if (this.observers != null && this.observers.size() > 0) {
            Iterator<ActorRef> iter = this.observers.iterator();
            ConferenceInfo ci = this.createConferenceInfo();
            sender.tell((Object)new ConferenceResponse((Object)ci), this.self());
            while (iter.hasNext()) {
                ActorRef observer = iter.next();
                observer.tell((Object)new ConferenceResponse((Object)ci), this.self());
                observer.tell((Object)message, this.self());
            }
        }
    }

    private void onPlay(Play message, ActorRef self, ActorRef sender) {
        if (this.isRunning()) {
            this.moderatorPresent = message.isConfModeratorPresent();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Received Play message for conference: " + this.name + " , number of local participants: " + this.calls.size() + " globalNoOfParticipants: " + this.globalNoOfParticipants + ", isRunning: true, isModeratorPresent: " + this.moderatorPresent + " iterations: " + message.iterations());
            }
            this.mscontroller.tell((Object)message, sender);
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("Play will not be processed for conference: " + this.name + " , number of local participants: " + this.calls.size() + " globalNoOfParticipants: " + this.globalNoOfParticipants + " , isRunning: false, isModeratorPresent: " + this.moderatorPresent + " iterations: " + message.iterations());
        }
    }

    private void onStartRecording(StartRecording message, ActorRef self, ActorRef sender) {
        if (this.isRunning()) {
            this.mscontroller.tell((Object)message, sender);
        }
    }

    private void onStopRecording(StopRecording message, ActorRef self, ActorRef sender) {
        if (this.isRunning()) {
            this.mscontroller.tell((Object)message, sender);
        }
    }

    private int getGlobalNoOfParticipants() throws Exception {
        if (this.sid == null) {
            this.globalNoOfParticipants = this.calls.size();
        } else {
            CallDetailRecordsDao dao = this.storage.getCallDetailRecordsDao();
            this.globalNoOfParticipants = dao.getTotalRunningCallDetailRecordsByConferenceSid(this.sid);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("sid: " + this.sid + "globalNoOfParticipants: " + this.globalNoOfParticipants);
        }
        return this.globalNoOfParticipants;
    }

    private void updateConferenceStatus(ConferenceStateChanged.State state) {
        if (this.sid != null) {
            ConferenceDetailRecordsDao dao = this.storage.getConferenceDetailRecordsDao();
            ConferenceDetailRecord cdr = dao.getConferenceDetailRecord(this.sid);
            cdr = cdr.setStatus(state.name());
            dao.updateConferenceDetailRecordStatus(cdr);
        }
    }

    private final class Failed
    extends FinalizingAction {
        public Failed(ActorRef source) {
            super(source, ConferenceStateChanged.State.FAILED);
        }
    }

    private final class Stopped
    extends FinalizingAction {
        public Stopped(ActorRef source) {
            super(source, ConferenceStateChanged.State.COMPLETED);
        }
    }

    private abstract class FinalizingAction
    extends AbstractAction {
        protected final ConferenceStateChanged.State finalState;

        public FinalizingAction(ActorRef source, ConferenceStateChanged.State state) {
            super(source);
            this.finalState = state;
        }

        public void execute(Object message) throws Exception {
            Conference.this.broadcast(new ConferenceStateChanged(Conference.this.name, this.finalState));
            Conference.this.observers.clear();
        }
    }

    private class Stopping
    extends AbstractAction {
        public Stopping(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            Conference.this.mscontroller.tell((Object)new Stop(), this.source);
        }
    }

    private class Evicting
    extends AbstractAction {
        public Evicting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            for (ActorRef call : Conference.this.calls) {
                Leave leave = new Leave();
                call.tell((Object)leave, this.source);
            }
        }
    }

    private final class Running
    extends AbstractAction {
        public Running(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            ConferenceModeratorPresent msg = (ConferenceModeratorPresent)message;
            Conference.this.mscontroller.tell((Object)new StopMediaGroup(msg.beep()), this.source);
            Conference.this.updateConferenceStatus(ConferenceStateChanged.State.RUNNING_MODERATOR_PRESENT);
            Conference.this.broadcast(new ConferenceStateChanged(Conference.this.name, ConferenceStateChanged.State.RUNNING_MODERATOR_PRESENT));
        }
    }

    private final class Waiting
    extends AbstractAction {
        public Waiting(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            MediaServerConferenceControllerStateChanged mediaServerConferenceControllerStateChanged = (MediaServerConferenceControllerStateChanged)message;
            Conference.this.sid = mediaServerConferenceControllerStateChanged.conferenceSid();
            String stateStr = mediaServerConferenceControllerStateChanged.conferenceState();
            Conference.this.waitingState = ConferenceStateChanged.translateState((String)stateStr, (ConferenceStateChanged.State)ConferenceStateChanged.State.RUNNING_MODERATOR_ABSENT);
            Conference.this.moderatorPresent = mediaServerConferenceControllerStateChanged.moderatorPresent();
            if (Conference.this.logger.isInfoEnabled()) {
                Conference.this.logger.info("################################## Conference " + Conference.this.name + " has sid: " + Conference.this.sid + " stateStr: " + stateStr + " initial state: " + Conference.this.waitingState);
            }
            Conference.this.broadcast(new ConferenceStateChanged(Conference.this.name, Conference.this.waitingState));
        }
    }

    private class Initializing
    extends AbstractAction {
        public Initializing(ActorRef source) {
            super(source);
        }

        public void execute(Object message) throws Exception {
            StartConference startConference = (StartConference)message;
            Observe observe = new Observe(this.source);
            Conference.this.mscontroller.tell((Object)observe, this.source);
            ConferenceInfo information = Conference.this.createConferenceInfo();
            CreateMediaSession createMediaSession = new CreateMediaSession(startConference.callSid(), information.name());
            Conference.this.mscontroller.tell((Object)createMediaSession, this.source);
        }
    }

    private abstract class AbstractAction
    implements Action {
        protected final ActorRef source;

        public AbstractAction(ActorRef source) {
            this.source = source;
        }
    }
}

