/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony.ua;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.telephony.ua.UserAgentManager;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;

public final class UserAgentManagerProxy
extends SipServlet
implements SipServletListener {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(UserAgentManagerProxy.class);
    private ActorSystem system;
    private ActorRef manager;
    private ServletContext servletContext;
    private int pingInterval;
    private Configuration configuration;

    public void destroy() {
        logger.info((Object)"About to destroy UserAgentManager");
        if (this.system != null) {
            this.system.stop(this.manager);
        }
    }

    protected void doRequest(SipServletRequest request) throws ServletException, IOException {
        this.manager.tell((Object)request, null);
    }

    protected void doSuccessResponse(SipServletResponse response) throws ServletException, IOException {
        this.manager.tell((Object)response, null);
    }

    protected void doErrorResponse(SipServletResponse response) throws ServletException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("response: \n" + response.toString() + "\n"));
        }
        this.manager.tell((Object)response, null);
    }

    private ActorRef manager(final Configuration configuration, final SipFactory factory, final DaoManager storage) {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new UserAgentManager(configuration, factory, storage, UserAgentManagerProxy.this.servletContext);
            }
        });
        return this.system.actorOf(props);
    }

    public void servletInitialized(SipServletContextEvent event) {
        if (event.getSipServlet().getClass().equals(UserAgentManagerProxy.class)) {
            this.servletContext = event.getServletContext();
            this.configuration = (Configuration)this.servletContext.getAttribute(Configuration.class.getName());
            SipFactory factory = (SipFactory)this.servletContext.getAttribute("javax.servlet.sip.SipFactory");
            DaoManager storage = (DaoManager)this.servletContext.getAttribute(DaoManager.class.getName());
            this.system = (ActorSystem)this.servletContext.getAttribute(ActorSystem.class.getName());
            logger.info((Object)"About to create new UserAgentManager");
            this.manager = this.manager(this.configuration, factory, storage);
            this.pingInterval = this.configuration.subset("runtime-settings").getInt("ping-interval", 60);
            this.system.scheduler().schedule(Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS), Duration.create((long)this.pingInterval, (TimeUnit)TimeUnit.SECONDS), this.manager, (Object)ReceiveTimeout.getInstance(), (ExecutionContext)this.system.dispatcher());
        }
    }
}

