/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.ReceiveTimeout;
import akka.actor.ReceiveTimeout$;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorContext;
import akka.actor.UntypedActorFactory;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import akka.pattern.Patterns;
import akka.util.Timeout;
import com.google.i18n.phonenumbers.NumberParseException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.sdp.SdpParseException;
import javax.servlet.ServletContext;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TelURL;
import javax.servlet.sip.URI;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.configuration.sets.RcmlserverConfigurationSet;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.faulttolerance.RestcommUntypedActor;
import org.restcomm.connect.commons.patterns.StopObserving;
import org.restcomm.connect.commons.push.PushNotificationServerHelper;
import org.restcomm.connect.commons.telephony.CreateCallType;
import org.restcomm.connect.commons.telephony.ProxyRule;
import org.restcomm.connect.commons.util.DNSUtils;
import org.restcomm.connect.commons.util.SdpUtils;
import org.restcomm.connect.commons.util.UriUtils;
import org.restcomm.connect.dao.AccountsDao;
import org.restcomm.connect.dao.ApplicationsDao;
import org.restcomm.connect.dao.CallDetailRecordsDao;
import org.restcomm.connect.dao.ClientsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.NotificationsDao;
import org.restcomm.connect.dao.RegistrationsDao;
import org.restcomm.connect.dao.common.OrganizationUtil;
import org.restcomm.connect.dao.entities.Account;
import org.restcomm.connect.dao.entities.Application;
import org.restcomm.connect.dao.entities.CallDetailRecord;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.dao.entities.IncomingPhoneNumber;
import org.restcomm.connect.dao.entities.MostOptimalNumberResponse;
import org.restcomm.connect.dao.entities.Notification;
import org.restcomm.connect.dao.entities.Organization;
import org.restcomm.connect.dao.entities.Registration;
import org.restcomm.connect.extension.api.ExtensionType;
import org.restcomm.connect.extension.api.IExtensionCreateCallRequest;
import org.restcomm.connect.extension.api.IExtensionRequest;
import org.restcomm.connect.extension.api.RestcommExtensionException;
import org.restcomm.connect.extension.api.RestcommExtensionGeneric;
import org.restcomm.connect.extension.controller.ExtensionController;
import org.restcomm.connect.http.client.rcmlserver.resolver.RcmlserverResolver;
import org.restcomm.connect.interpreter.StartInterpreter;
import org.restcomm.connect.interpreter.StopInterpreter;
import org.restcomm.connect.interpreter.VoiceInterpreter;
import org.restcomm.connect.interpreter.VoiceInterpreterParams;
import org.restcomm.connect.monitoringservice.MonitoringService;
import org.restcomm.connect.mscontrol.api.MediaServerControllerFactory;
import org.restcomm.connect.telephony.Call;
import org.restcomm.connect.telephony.api.CallInfo;
import org.restcomm.connect.telephony.api.CallManagerResponse;
import org.restcomm.connect.telephony.api.CallResponse;
import org.restcomm.connect.telephony.api.CallStateChanged;
import org.restcomm.connect.telephony.api.CreateCall;
import org.restcomm.connect.telephony.api.DestroyCall;
import org.restcomm.connect.telephony.api.ExecuteCallScript;
import org.restcomm.connect.telephony.api.GetActiveProxy;
import org.restcomm.connect.telephony.api.GetCall;
import org.restcomm.connect.telephony.api.GetCallInfo;
import org.restcomm.connect.telephony.api.GetCallObservers;
import org.restcomm.connect.telephony.api.GetProxies;
import org.restcomm.connect.telephony.api.GetRelatedCall;
import org.restcomm.connect.telephony.api.Hangup;
import org.restcomm.connect.telephony.api.InitializeOutbound;
import org.restcomm.connect.telephony.api.SwitchProxy;
import org.restcomm.connect.telephony.api.UpdateCallScript;
import org.restcomm.connect.telephony.api.util.B2BUAHelper;
import org.restcomm.connect.telephony.api.util.CallControlHelper;
import scala.concurrent.Await;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;

public final class CallManager
extends RestcommUntypedActor {
    static final int ERROR_NOTIFICATION = 0;
    static final int WARNING_NOTIFICATION = 1;
    static final Pattern PATTERN = Pattern.compile("[\\*#0-9]{1,12}");
    static final String EMAIL_SENDER = "restcomm@restcomm.org";
    static final String EMAIL_SUBJECT = "RestComm Error Notification - Attention Required";
    static final int DEFAUL_IMS_PROXY_PORT = -1;
    private final ActorSystem system;
    private final Configuration configuration;
    private final ServletContext context;
    private final MediaServerControllerFactory msControllerFactory;
    private final ActorRef conferences;
    private final ActorRef bridges;
    private final ActorRef sms;
    private final SipFactory sipFactory;
    private final DaoManager storage;
    private final ActorRef monitoring;
    private boolean useTo;
    private boolean authenticateUsers;
    private AtomicInteger numberOfFailedCalls;
    private AtomicBoolean useFallbackProxy;
    private boolean allowFallback;
    private boolean allowFallbackToPrimary;
    private int maxNumberOfFailedCalls;
    private String primaryProxyUri;
    private String primaryProxyUsername;
    private String primaryProxyPassword;
    private String fallBackProxyUri;
    private String fallBackProxyUsername;
    private String fallBackProxyPassword;
    private String activeProxy;
    private String activeProxyUsername;
    private String activeProxyPassword;
    private String mediaExternalIp;
    private String myHostIp;
    private String proxyIp;
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private SwitchProxy switchProxyRequest;
    private boolean patchForNatB2BUASessions;
    List<RestcommExtensionGeneric> extensions;
    private boolean actAsImsUa;
    private String imsProxyAddress;
    private int imsProxyPort;
    private String imsDomain;
    private String imsAccount;
    private boolean actAsProxyOut;
    private List<ProxyRule> proxyOutRules;
    private boolean isActAsProxyOutUseFromHeader;
    private final PushNotificationServerHelper pushNotificationServerHelper;

    private void sendNotification(Sid accountId, String errMessage, int errCode, String errType, boolean createNotification) {
        NotificationsDao notifications = this.storage.getNotificationsDao();
        if (errType == "warning") {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(errMessage);
            }
            if (createNotification) {
                Notification notification = this.notification(accountId, 0, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "error") {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(errMessage);
            }
            if (createNotification) {
                Notification notification = this.notification(accountId, 0, errCode, errMessage);
                notifications.addNotification(notification);
            }
        } else if (errType == "info" && this.logger.isDebugEnabled()) {
            this.logger.debug(errMessage);
        }
    }

    public CallManager(Configuration configuration, ServletContext context, MediaServerControllerFactory msControllerFactory, ActorRef conferences, ActorRef bridges, ActorRef sms, SipFactory factory, DaoManager storage) {
        this.system = this.context().system();
        this.configuration = configuration;
        this.context = context;
        this.msControllerFactory = msControllerFactory;
        this.conferences = conferences;
        this.bridges = bridges;
        this.sms = sms;
        this.sipFactory = factory;
        this.storage = storage;
        Configuration runtime = configuration.subset("runtime-settings");
        Configuration outboundProxyConfig = runtime.subset("outbound-proxy");
        SipURI outboundIntf = this.outboundInterface("udp");
        if (outboundIntf != null) {
            this.myHostIp = outboundIntf.getHost().toString();
        } else {
            String errMsg = "SipURI outboundIntf is null";
            this.sendNotification(null, errMsg, 14001, "error", false);
            if (context == null) {
                errMsg = "SipServlet context is null";
            }
            this.sendNotification(null, errMsg, 14002, "error", false);
        }
        Configuration mediaConf = configuration.subset("media-server-manager");
        this.mediaExternalIp = mediaConf.getString("mgcp-server.external-address");
        this.proxyIp = runtime.subset("telestax-proxy").getString("uri").replaceAll("http://", "").replaceAll(":2080", "");
        if (this.mediaExternalIp == null || this.mediaExternalIp.isEmpty()) {
            this.mediaExternalIp = this.myHostIp;
        }
        if (this.proxyIp == null || this.proxyIp.isEmpty()) {
            this.proxyIp = this.myHostIp;
        }
        this.useTo = runtime.getBoolean("use-to");
        this.authenticateUsers = runtime.getBoolean("authenticate");
        this.primaryProxyUri = outboundProxyConfig.getString("outbound-proxy-uri");
        this.primaryProxyUsername = outboundProxyConfig.getString("outbound-proxy-user");
        this.primaryProxyPassword = outboundProxyConfig.getString("outbound-proxy-password");
        this.fallBackProxyUri = outboundProxyConfig.getString("fallback-outbound-proxy-uri");
        this.fallBackProxyUsername = outboundProxyConfig.getString("fallback-outbound-proxy-user");
        this.fallBackProxyPassword = outboundProxyConfig.getString("fallback-outbound-proxy-password");
        this.activeProxy = this.primaryProxyUri;
        this.activeProxyUsername = this.primaryProxyUsername;
        this.activeProxyPassword = this.primaryProxyPassword;
        this.numberOfFailedCalls = new AtomicInteger();
        this.numberOfFailedCalls.set(0);
        this.useFallbackProxy = new AtomicBoolean();
        this.useFallbackProxy.set(false);
        this.allowFallback = outboundProxyConfig.getBoolean("allow-fallback", false);
        this.maxNumberOfFailedCalls = outboundProxyConfig.getInt("max-failed-calls", 20);
        this.allowFallbackToPrimary = outboundProxyConfig.getBoolean("allow-fallback-to-primary", false);
        this.patchForNatB2BUASessions = runtime.getBoolean("patch-for-nat-b2bua-sessions", true);
        this.monitoring = (ActorRef)context.getAttribute(MonitoringService.class.getName());
        this.extensions = ExtensionController.getInstance().getExtensions(ExtensionType.CallManager);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("CallManager extensions: " + (this.extensions != null ? Integer.valueOf(this.extensions.size()) : "0"));
        }
        if (!runtime.subset("ims-authentication").isEmpty()) {
            Configuration imsAuthentication = runtime.subset("ims-authentication");
            this.actAsImsUa = imsAuthentication.getBoolean("act-as-ims-ua");
            if (this.actAsImsUa) {
                this.imsProxyAddress = imsAuthentication.getString("proxy-address");
                this.imsProxyPort = imsAuthentication.getInt("proxy-port");
                if (this.imsProxyPort == 0) {
                    this.imsProxyPort = -1;
                }
                this.imsDomain = imsAuthentication.getString("domain");
                this.imsAccount = imsAuthentication.getString("account");
                if (this.actAsImsUa && (this.imsProxyAddress == null || this.imsProxyAddress.isEmpty() || this.imsDomain == null || this.imsDomain.isEmpty())) {
                    this.logger.warning("ims proxy-address or domain is not configured");
                }
                boolean bl = this.actAsImsUa = this.actAsImsUa && this.imsProxyAddress != null && !this.imsProxyAddress.isEmpty() && this.imsDomain != null && !this.imsDomain.isEmpty();
            }
        }
        if (!runtime.subset("acting-as-proxy").isEmpty() && !runtime.subset("acting-as-proxy").subset("proxy-rules").isEmpty()) {
            Configuration proxyConfiguration = runtime.subset("acting-as-proxy");
            Configuration proxyOutRulesConf = proxyConfiguration.subset("proxy-rules");
            this.actAsProxyOut = proxyConfiguration.getBoolean("enabled", false);
            if (this.actAsProxyOut) {
                this.isActAsProxyOutUseFromHeader = proxyConfiguration.getBoolean("use-from-header", true);
                this.proxyOutRules = new ArrayList<ProxyRule>();
                List rulesList = ((HierarchicalConfiguration)proxyOutRulesConf).configurationsAt("rule");
                for (HierarchicalConfiguration rule : rulesList) {
                    String fromHost = rule.getString("from-uri");
                    String toHost = rule.getString("to-uri");
                    String username = rule.getString("proxy-to-username");
                    String password = rule.getString("proxy-to-password");
                    ProxyRule proxyRule = new ProxyRule(fromHost, toHost, username, password);
                    this.proxyOutRules.add(proxyRule);
                }
                if (this.logger.isInfoEnabled()) {
                    String msg = String.format("`ActAsProxy` feature is enabled with %d rules.", this.proxyOutRules.size());
                    this.logger.info(msg);
                }
                this.actAsProxyOut = this.actAsProxyOut && this.proxyOutRules != null && !this.proxyOutRules.isEmpty();
            }
        }
        this.pushNotificationServerHelper = new PushNotificationServerHelper(this.system, configuration);
        this.firstTimeCleanup();
    }

    private void firstTimeCleanup() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initial CallManager cleanup. Will check running state calls in DB and update state of the calls.");
        }
        String instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
        Sid sid = new Sid(instanceId);
        CallDetailRecordsDao callDetailRecordsDao = this.storage.getCallDetailRecordsDao();
        callDetailRecordsDao.updateInCompleteCallDetailRecordsToCompletedByInstanceId(sid);
        List results = callDetailRecordsDao.getInCompleteCallDetailRecordsByInstanceId(sid);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("There are: " + results.size() + " calls in progress after cleanup.");
        }
    }

    private ActorRef call(final CreateCall request) {
        Props props = null;
        props = request == null ? new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Call(CallManager.this.sipFactory, CallManager.this.msControllerFactory, CallManager.this.configuration, null, null, null, null);
            }
        }) : new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new Call(CallManager.this.sipFactory, CallManager.this.msControllerFactory, CallManager.this.configuration, request.statusCallback(), request.statusCallbackMethod(), request.statusCallbackEvent(), request.getOutboundProxyHeaders());
            }
        });
        return this.getContext().actorOf(props);
    }

    private boolean check(Object message) throws IOException {
        SipServletRequest request = (SipServletRequest)message;
        String content = null;
        if (request.getRawContent() != null) {
            content = new String(request.getRawContent());
        }
        if (content == null && request.getContentLength() == 0 || !"application/sdp".equals(request.getContentType()) && !content.contains("application/sdp")) {
            SipServletResponse response = request.createResponse(400);
            response.send();
            return false;
        }
        return true;
    }

    private void destroy(Object message) throws Exception {
        UntypedActorContext context = this.getContext();
        DestroyCall request = (DestroyCall)message;
        ActorRef call = request.call();
        if (call != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("About to destroy call: " + request.call().path() + ", call isTerminated(): " + this.sender().isTerminated() + ", sender: " + this.sender());
            }
            this.getContext().stop(call);
        }
    }

    private void invite(Object message) throws IOException, NumberParseException, ServletParseException {
        ActorRef self = this.self();
        final SipServletRequest request = (SipServletRequest)message;
        if (!request.isInitial()) {
            SipApplicationSession appSession = request.getApplicationSession();
            ActorRef call = null;
            if (appSession.getAttribute(Call.class.getName()) != null) {
                call = (ActorRef)appSession.getAttribute(Call.class.getName());
            }
            if (call != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("For In-Dialog INVITE dispatched to Call actor: " + call.path());
                }
                call.tell((Object)request, self);
                return;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("No call actor found will respond 200OK for In-dialog INVITE: " + request.getRequestURI().toString());
            }
            SipServletResponse okay = request.createResponse(200);
            okay.send();
            return;
        }
        if (this.actAsImsUa) {
            boolean isFromIms = this.isFromIms(request);
            if (!isFromIms) {
                String user = request.getHeader("X-RestComm-Ims-User");
                String pass = request.getHeader("X-RestComm-Ims-Password");
                request.removeHeader("X-RestComm-Ims-User");
                request.removeHeader("X-RestComm-Ims-Password");
                this.imsProxyThroughMediaServer(request, null, request.getTo().getURI(), user, pass, isFromIms);
                return;
            }
            this.imsProxyThroughMediaServer(request, null, request.getTo().getURI(), "", "", isFromIms);
            return;
        }
        AccountsDao accounts = this.storage.getAccountsDao();
        ApplicationsDao applications = this.storage.getApplicationsDao();
        SipURI fromUri = (SipURI)request.getFrom().getURI();
        Sid sourceOrganizationSid = OrganizationUtil.getOrganizationSidBySipURIHost((DaoManager)this.storage, (SipURI)fromUri);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sourceOrganizationSid: " + sourceOrganizationSid + " fromUri: " + fromUri);
        }
        if (sourceOrganizationSid == null && this.logger.isInfoEnabled()) {
            this.logger.info("Null Organization, call is probably coming from a provider: fromUri: " + fromUri);
        }
        String fromUser = fromUri.getUser();
        ClientsDao clients = this.storage.getClientsDao();
        final Client client = clients.getClient(fromUser, sourceOrganizationSid);
        if (client != null) {
            if (!this.authenticateUsers || CallControlHelper.checkAuthentication((SipServletRequest)request, (DaoManager)this.storage, (Sid)sourceOrganizationSid)) {
                if (this.redirectToClientVoiceApp(self, request, accounts, applications, client)) {
                    return;
                }
            } else {
                return;
            }
        }
        String toUser = CallControlHelper.getUserSipId((SipServletRequest)request, (boolean)this.useTo);
        String ruri = ((SipURI)request.getRequestURI()).getHost();
        final String toHost = ((SipURI)request.getTo().getURI()).getHost();
        String toHostIpAddress = DNSUtils.getByName((String)toHost).getHostAddress();
        String toPort = String.valueOf(((SipURI)request.getTo().getURI()).getPort()).equalsIgnoreCase("-1") ? "5060" : String.valueOf(((SipURI)request.getTo().getURI()).getHost());
        String transport = ((SipURI)request.getTo().getURI()).getTransportParam() == null ? "udp" : ((SipURI)request.getTo().getURI()).getTransportParam();
        SipURI outboundIntf = this.outboundInterface(transport);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ToUser: " + toUser);
            this.logger.info("ToHost: " + toHost);
            this.logger.info("ruri: " + ruri);
            this.logger.info("myHostIp: " + this.myHostIp);
            this.logger.info("mediaExternalIp: " + this.mediaExternalIp);
            this.logger.info("proxyIp: " + this.proxyIp);
        }
        Sid toOrganizationSid = OrganizationUtil.getOrganizationSidBySipURIHost((DaoManager)this.storage, (SipURI)((SipURI)request.getTo().getURI()));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("toOrganizationSid: " + toOrganizationSid + " toUri: " + (SipURI)request.getTo().getURI());
        }
        final Client toClient = clients.getClient(toUser, toOrganizationSid);
        if (client != null) {
            if (toClient != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Client is not null: " + client.getLogin() + " will try to proxy to client: " + toClient);
                }
                ExtensionController ec = ExtensionController.getInstance();
                CreateCall er = new CreateCall(fromUser, toUser, "", "", false, 0, CreateCallType.CLIENT, client.getAccountSid(), null, null, null, null);
                ec.executePreOutboundAction((IExtensionRequest)er, this.extensions);
                if (er.isAllowed()) {
                    long delay = this.pushNotificationServerHelper.sendPushNotificationIfNeeded(toClient.getPushClientIdentity());
                    this.system.scheduler().scheduleOnce(Duration.create((long)delay, (TimeUnit)TimeUnit.MILLISECONDS), new Runnable((IExtensionCreateCallRequest)er){
                        final /* synthetic */ IExtensionCreateCallRequest val$er;
                        {
                            this.val$er = iExtensionCreateCallRequest;
                        }

                        @Override
                        public void run() {
                            try {
                                if (B2BUAHelper.redirectToB2BUA((SipServletRequest)request, (Client)client, (Client)toClient, (DaoManager)CallManager.this.storage, (SipFactory)CallManager.this.sipFactory, (boolean)CallManager.this.patchForNatB2BUASessions)) {
                                    if (CallManager.this.logger.isInfoEnabled()) {
                                        CallManager.this.logger.info("Call to CLIENT.  myHostIp: " + CallManager.this.myHostIp + " mediaExternalIp: " + CallManager.this.mediaExternalIp + " toHost: " + toHost + " fromClient: " + client.getUri() + " toClient: " + toClient.getUri());
                                    }
                                } else {
                                    String errMsg = "Cannot Connect to Client: " + toClient.getFriendlyName() + " : Make sure the Client exist or is registered with Restcomm";
                                    CallManager.this.sendNotification(client.getAccountSid(), errMsg, 11001, "warning", true);
                                    SipServletResponse resp = request.createResponse(404, "Cannot complete P2P call");
                                    resp.send();
                                }
                                ExtensionController.getInstance().executePostOutboundAction((IExtensionRequest)this.val$er, CallManager.this.extensions);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }, (ExecutionContext)this.system.dispatcher());
                } else {
                    String errMsg;
                    if (this.logger.isDebugEnabled()) {
                        errMsg = "Client not Allowed to make this outbound call";
                        this.logger.debug("Client not Allowed to make this outbound call");
                    }
                    errMsg = "Cannot Connect to Client: " + toClient.getFriendlyName() + " : Make sure the Client exist or is registered with Restcomm";
                    this.sendNotification(client.getAccountSid(), errMsg, 11001, "warning", true);
                    SipServletResponse resp = request.createResponse(403, "Call not allowed");
                    resp.send();
                }
                ec.executePostOutboundAction((IExtensionRequest)er, this.extensions);
                return;
            }
            if (this.redirectToHostedVoiceApp(self, request, accounts, applications, toUser, client.getAccountSid(), sourceOrganizationSid)) {
                return;
            }
            String errMsg = "A Restcomm Client is trying to call a Number/DID that is not registered with Restcomm";
            this.sendNotification(client.getAccountSid(), errMsg, 11002, "info", true);
            ExtensionController ec = ExtensionController.getInstance();
            CreateCall er = new CreateCall(fromUser, toUser, "", "", false, 0, CreateCallType.PSTN, client.getAccountSid(), null, null, null, null);
            ec.executePreOutboundAction((IExtensionRequest)er, this.extensions);
            if (er.isAllowed()) {
                if (this.actAsProxyOut) {
                    this.processRequestAndProxyOut(request, client, toUser);
                } else if (this.isWebRTC(request)) {
                    this.proxyThroughMediaServerAsNumber(request, client, toUser);
                } else {
                    String proxyURI = this.activeProxy;
                    String proxyUsername = this.activeProxyUsername;
                    String proxyPassword = this.activeProxyPassword;
                    SipURI from = null;
                    SipURI to = null;
                    boolean callToSipUri = false;
                    if (er.getOutboundProxy() != null && !er.getOutboundProxy().isEmpty()) {
                        proxyURI = er.getOutboundProxy();
                    }
                    if (er.getOutboundProxyUsername() != null && !er.getOutboundProxyUsername().isEmpty()) {
                        proxyUsername = er.getOutboundProxyUsername();
                    }
                    if (er.getOutboundProxyPassword() != null && !er.getOutboundProxyPassword().isEmpty()) {
                        proxyUsername = er.getOutboundProxyPassword();
                    }
                    if (proxyURI != null && !proxyURI.isEmpty()) {
                        this.addHeadersToMessage(request, er.getOutboundProxyHeaders());
                        this.proxyOut(request, client, toUser, toHost, toHostIpAddress, toPort, outboundIntf, proxyURI, proxyUsername, proxyPassword, from, to, callToSipUri);
                    } else {
                        errMsg = "Restcomm tried to proxy this call to an outbound party but it seems the outbound proxy is not configured.";
                        this.sendNotification(client.getAccountSid(), errMsg, 11004, "warning", true);
                    }
                }
            } else {
                SipServletResponse response = request.createResponse(403, "Call request not allowed");
                response.send();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Call request not allowed: " + er.toString());
                }
            }
            ec.executePostOutboundAction((IExtensionRequest)er, this.extensions);
            return;
        }
        if (toClient != null) {
            this.proxyDialClientThroughMediaServer(request, toClient, toClient.getLogin());
            return;
        }
        if (this.redirectToHostedVoiceApp(self, request, accounts, applications, toUser, null, sourceOrganizationSid)) {
            return;
        }
        if (this.actAsProxyOut) {
            this.processRequestAndProxyOut(request, client, toUser);
            return;
        }
        SipServletResponse response = request.createResponse(404);
        response.send();
        String errMsg = "Restcomm cannot process this call because the destination number " + toUser + "cannot be found or there is application attached to that";
        this.sendNotification(null, errMsg, 11005, "error", true);
    }

    private void addHeadersToMessage(SipServletRequest message, Map<String, ArrayList<String>> headers) {
        if (headers != null) {
            for (Map.Entry<String, ArrayList<String>> entry : headers.entrySet()) {
                String headerName;
                block13: {
                    headerName = entry.getKey();
                    StringBuilder sb = new StringBuilder();
                    if (entry.getValue() instanceof ArrayList) {
                        for (String pair : entry.getValue()) {
                            sb.append(";").append(pair);
                        }
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("headerName=" + headerName + " headerVal=" + message.getHeader(headerName) + " concatValue=" + sb.toString());
                    }
                    if (!headerName.equalsIgnoreCase("Request-URI")) {
                        try {
                            String headerVal = message.getHeader(headerName);
                            if (headerVal != null && !headerVal.isEmpty()) {
                                message.setHeader(headerName, headerVal + sb.toString());
                                break block13;
                            }
                            message.addHeader(headerName, sb.toString());
                        }
                        catch (IllegalArgumentException iae) {
                            if (this.logger.isErrorEnabled()) {
                                this.logger.error("Exception while setting message header: " + iae.getMessage());
                            }
                            break block13;
                        }
                    }
                    URI reqURI = message.getRequestURI();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ReqURI=" + reqURI.toString() + " msgReqURI=" + message.getRequestURI());
                    }
                    for (String keyValPair : entry.getValue()) {
                        String parName = "";
                        String parVal = "";
                        int equalsPos = keyValPair.indexOf("=");
                        parName = keyValPair.substring(0, equalsPos);
                        parVal = keyValPair.substring(equalsPos + 1);
                        reqURI.setParameter(parName, parVal);
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("ReqURI pars =" + parName + "=" + parVal + " equalsPos=" + equalsPos + " keyValPair=" + keyValPair);
                    }
                    message.setRequestURI(reqURI);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("ReqURI=" + reqURI.toString() + " msgReqURI=" + message.getRequestURI());
                    }
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("headerName=" + headerName + " headerVal=" + message.getHeader(headerName));
            }
        }
    }

    private boolean proxyOut(SipServletRequest request, Client client, String toUser, String toHost, String toHostIpAddress, String toPort, SipURI outboundIntf, String proxyURI, String proxyUsername, String proxyPassword, SipURI from, SipURI to, boolean callToSipUri) throws UnknownHostException {
        Configuration runtime = this.configuration.subset("runtime-settings");
        boolean useLocalAddressAtFromHeader = runtime.getBoolean("use-local-address", false);
        boolean outboudproxyUserAtFromHeader = runtime.subset("outbound-proxy").getBoolean("outboudproxy-user-at-from-header", true);
        String fromHost = ((SipURI)request.getFrom().getURI()).getHost();
        String fromHostIpAddress = DNSUtils.getByName((String)fromHost).getHostAddress();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("fromHost: " + fromHost + "fromHostIP: " + fromHostIpAddress + "myHostIp: " + this.myHostIp + " mediaExternalIp: " + this.mediaExternalIp + " toHost: " + toHost + " toHostIP: " + toHostIpAddress + " proxyUri: " + proxyURI);
        }
        if (this.myHostIp.equalsIgnoreCase(toHost) || this.mediaExternalIp.equalsIgnoreCase(toHost) || this.myHostIp.equalsIgnoreCase(toHostIpAddress) || this.mediaExternalIp.equalsIgnoreCase(toHostIpAddress) || fromHost.equalsIgnoreCase(toHost) || fromHost.equalsIgnoreCase(toHostIpAddress) || fromHostIpAddress.equalsIgnoreCase(toHost) || fromHostIpAddress.equalsIgnoreCase(toHostIpAddress)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Call to NUMBER.  myHostIp: " + this.myHostIp + " mediaExternalIp: " + this.mediaExternalIp + " toHost: " + toHost + " proxyUri: " + proxyURI);
            }
            try {
                from = useLocalAddressAtFromHeader ? (outboudproxyUserAtFromHeader ? this.sipFactory.createSipURI(proxyUsername, this.mediaExternalIp + ":" + outboundIntf.getPort()) : this.sipFactory.createSipURI(((SipURI)request.getFrom().getURI()).getUser(), this.mediaExternalIp + ":" + outboundIntf.getPort())) : (outboudproxyUserAtFromHeader ? this.sipFactory.createSipURI(proxyUsername, proxyURI) : this.sipFactory.createSipURI(((SipURI)request.getFrom().getURI()).getUser(), proxyURI));
                to = this.sipFactory.createSipURI(((SipURI)request.getTo().getURI()).getUser(), proxyURI);
            }
            catch (Exception exception) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Exception: " + exception);
                }
            }
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Call to SIP URI. myHostIp: " + this.myHostIp + " mediaExternalIp: " + this.mediaExternalIp + " toHost: " + toHost + " proxyUri: " + proxyURI);
            }
            from = this.sipFactory.createSipURI(((SipURI)request.getFrom().getURI()).getUser(), outboundIntf.getHost() + ":" + outboundIntf.getPort());
            to = this.sipFactory.createSipURI(toUser, toHost + ":" + toPort);
            callToSipUri = true;
        }
        return B2BUAHelper.redirectToB2BUA((SipServletRequest)request, (Client)client, (SipURI)from, (SipURI)to, (String)proxyUsername, (String)proxyPassword, (DaoManager)this.storage, (SipFactory)this.sipFactory, (boolean)callToSipUri, (boolean)this.patchForNatB2BUASessions);
    }

    private boolean isWebRTC(SipServletRequest request) {
        String transport = request.getTransport();
        String userAgent = request.getHeader("User-Agent");
        if (userAgent != null && !userAgent.isEmpty() && userAgent.equalsIgnoreCase("wss-sipunit")) {
            return true;
        }
        if (!request.getInitialTransport().equalsIgnoreCase(transport) && ("ws".equalsIgnoreCase(transport = request.getInitialTransport()) || "wss".equalsIgnoreCase(transport))) {
            return true;
        }
        try {
            if (SdpUtils.isWebRTCSDP((String)request.getContentType(), (byte[])request.getRawContent())) {
                return true;
            }
        }
        catch (SdpParseException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return false;
    }

    private void processRequestAndProxyOut(SipServletRequest request, Client client, String destNumber) {
        String requestFromHost = null;
        ProxyRule matchedProxyRule = null;
        SipURI fromUri = null;
        try {
            fromUri = this.isActAsProxyOutUseFromHeader ? (SipURI)request.getFrom().getURI() : (SipURI)request.getAddressHeader("Contact").getURI();
        }
        catch (ServletParseException e) {
            this.logger.error("Problem while trying to process an `ActAsProxy` request, " + (Object)((Object)e));
        }
        requestFromHost = fromUri.getHost() + ":" + fromUri.getPort();
        for (ProxyRule proxyRule : this.proxyOutRules) {
            if (requestFromHost == null || !requestFromHost.equalsIgnoreCase(proxyRule.getFromUri())) continue;
            matchedProxyRule = proxyRule;
            break;
        }
        if (matchedProxyRule != null) {
            String sipUri = String.format("sip:%s@%s", destNumber, matchedProxyRule.getToUri());
            String rcml = matchedProxyRule.getUsername() != null && !matchedProxyRule.getUsername().isEmpty() && matchedProxyRule.getPassword() != null && !matchedProxyRule.getPassword().isEmpty() ? String.format("<Response><Dial><Sip username=\"%s\" password=\"%s\">%s</Sip></Dial></Response>", matchedProxyRule.getUsername(), matchedProxyRule.getPassword(), sipUri) : String.format("<Response><Dial><Sip>%s</Sip></Dial></Response>", sipUri);
            VoiceInterpreterParams.Builder builder = new VoiceInterpreterParams.Builder();
            builder.setConfiguration(this.configuration);
            builder.setStorage(this.storage);
            builder.setCallManager(this.self());
            builder.setConferenceCenter(this.conferences);
            builder.setBridgeManager(this.bridges);
            builder.setSmsService(this.sms);
            Sid accountSid = null;
            String apiVersion = null;
            if (client != null) {
                accountSid = client.getAccountSid();
                apiVersion = client.getApiVersion();
            } else {
                accountSid = new Sid("ACae6e420f425248d6a26948c17a9e2acf");
                apiVersion = RestcommConfiguration.getInstance().getMain().getApiVersion();
            }
            builder.setAccount(accountSid);
            builder.setVersion(apiVersion);
            Account account = this.storage.getAccountsDao().getAccount(accountSid);
            builder.setEmailAddress(account.getEmailAddress());
            builder.setRcml(rcml);
            builder.setMonitoring(this.monitoring);
            Props props = VoiceInterpreter.props((VoiceInterpreterParams)builder.build());
            ActorRef interpreter = this.getContext().actorOf(props);
            ActorRef call = this.call(null);
            SipApplicationSession application = request.getApplicationSession();
            application.setAttribute(Call.class.getName(), (Object)call);
            call.tell((Object)request, this.self());
            interpreter.tell((Object)new StartInterpreter(call), this.self());
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("No rule matched for the `ActAsProxy` feature");
        }
    }

    private void proxyThroughMediaServerAsNumber(SipServletRequest request, Client client, String destNumber) {
        String rcml = "<Response><Dial>" + destNumber + "</Dial></Response>";
        VoiceInterpreterParams.Builder builder = new VoiceInterpreterParams.Builder();
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(this.self());
        builder.setConferenceCenter(this.conferences);
        builder.setBridgeManager(this.bridges);
        builder.setSmsService(this.sms);
        builder.setAccount(client.getAccountSid());
        builder.setVersion(client.getApiVersion());
        Account account = this.storage.getAccountsDao().getAccount(client.getAccountSid());
        builder.setEmailAddress(account.getEmailAddress());
        builder.setRcml(rcml);
        builder.setMonitoring(this.monitoring);
        Props props = VoiceInterpreter.props((VoiceInterpreterParams)builder.build());
        ActorRef interpreter = this.getContext().actorOf(props);
        ActorRef call = this.call(null);
        SipApplicationSession application = request.getApplicationSession();
        application.setAttribute(Call.class.getName(), (Object)call);
        call.tell((Object)request, this.self());
        interpreter.tell((Object)new StartInterpreter(call), this.self());
    }

    private void proxyDialClientThroughMediaServer(SipServletRequest request, Client client, String destNumber) {
        String rcml = "<Response><Dial><Client>" + destNumber + "</Client></Dial></Response>";
        VoiceInterpreterParams.Builder builder = new VoiceInterpreterParams.Builder();
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(this.self());
        builder.setConferenceCenter(this.conferences);
        builder.setBridgeManager(this.bridges);
        builder.setSmsService(this.sms);
        builder.setAccount(client.getAccountSid());
        builder.setVersion(client.getApiVersion());
        Account account = this.storage.getAccountsDao().getAccount(client.getAccountSid());
        builder.setEmailAddress(account.getEmailAddress());
        builder.setRcml(rcml);
        builder.setMonitoring(this.monitoring);
        Props props = VoiceInterpreter.props((VoiceInterpreterParams)builder.build());
        ActorRef interpreter = this.getContext().actorOf(props);
        ActorRef call = this.call(null);
        SipApplicationSession application = request.getApplicationSession();
        application.setAttribute(Call.class.getName(), (Object)call);
        call.tell((Object)request, this.self());
        interpreter.tell((Object)new StartInterpreter(call), this.self());
    }

    private void info(SipServletRequest request) throws IOException {
        ActorRef self = this.self();
        SipApplicationSession application = request.getApplicationSession();
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession((SipServletMessage)request);
        if (linkedB2BUASession != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("B2BUA: Got INFO request: \n %s", request));
            }
            request.getSession().setAttribute("lastRequest", (Object)request);
            SipServletRequest clonedInfo = linkedB2BUASession.createRequest("INFO");
            linkedB2BUASession.setAttribute("lastRequest", (Object)clonedInfo);
            SipURI toInetUri = (SipURI)request.getSession().getAttribute("toInetURI");
            SipURI fromInetUri = (SipURI)request.getSession().getAttribute("fromInetURI");
            InetAddress infoRURI = null;
            try {
                infoRURI = DNSUtils.getByName((String)((SipURI)clonedInfo.getRequestURI()).getHost());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            if (this.patchForNatB2BUASessions) {
                if (toInetUri != null && infoRURI == null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneBye request");
                    }
                    clonedInfo.setRequestURI((URI)toInetUri);
                } else if (toInetUri != null && (infoRURI.isSiteLocalAddress() || infoRURI.isAnyLocalAddress() || infoRURI.isLoopbackAddress())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneInfo request");
                    }
                    clonedInfo.setRequestURI((URI)toInetUri);
                } else if (fromInetUri != null && (infoRURI.isSiteLocalAddress() || infoRURI.isAnyLocalAddress() || infoRURI.isLoopbackAddress())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Using the real ip address of the sip client " + fromInetUri.toString() + " as a request uri of the CloneInfo request");
                    }
                    clonedInfo.setRequestURI((URI)fromInetUri);
                }
            }
            clonedInfo.send();
        } else {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            call.tell((Object)request, self);
        }
    }

    private void transfer(SipServletRequest request) throws Exception {
        String transferor = ((SipURI)request.getAddressHeader("Contact").getURI()).getUser();
        String transferee = ((SipURI)request.getAddressHeader("To").getURI()).getUser();
        String transferTarget = ((SipURI)request.getAddressHeader("Refer-To").getURI()).getUser();
        CallDetailRecord cdr = null;
        CallDetailRecordsDao dao = this.storage.getCallDetailRecordsDao();
        SipServletResponse servletResponse = null;
        SipApplicationSession appSession = request.getApplicationSession();
        ActorRef transferorActor = (ActorRef)appSession.getAttribute(Call.class.getName());
        if (transferorActor == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Transferor Call Actor is null, cannot proceed with SIP Refer");
            }
            servletResponse = request.createResponse(404);
            servletResponse.setHeader("Reason", "SIP REFER should be sent in dialog");
            servletResponse.setHeader("Event", "refer");
            servletResponse.send();
            return;
        }
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        Future infoFuture = Patterns.ask((ActorRef)transferorActor, (Object)new GetCallInfo(), (Timeout)expires);
        CallResponse infoResponse = (CallResponse)Await.result((Awaitable)infoFuture, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        CallInfo callInfo = (CallInfo)infoResponse.get();
        if (callInfo != null && callInfo.state().equals((Object)CallStateChanged.State.IN_PROGRESS)) {
            try {
                if (callInfo.direction().equalsIgnoreCase("inbound")) {
                    cdr = dao.getCallDetailRecord(callInfo.sid());
                }
                cdr = dao.getCallDetailRecord(dao.getCallDetailRecord(callInfo.sid()).getParentCallSid());
            }
            catch (Exception e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Problem while trying to get the CDR of the call");
                }
                servletResponse = request.createResponse(500);
                servletResponse.setHeader("Reason", "SIP Refer problem during execution");
                servletResponse.setHeader("Event", "refer");
                servletResponse.send();
                return;
            }
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("CallInfo is null or call state not in-progress. Cannot proceed to call transfer");
            }
            servletResponse = request.createResponse(404);
            servletResponse.setHeader("Reason", "SIP Refer pre-conditions failed, call info is null or call not in progress");
            servletResponse.setHeader("Event", "refer");
            servletResponse.send();
            return;
        }
        String phone = cdr.getTo();
        MostOptimalNumberResponse mostOptimalNumber = OrganizationUtil.getMostOptimalIncomingPhoneNumber((DaoManager)this.storage, (SipServletRequest)request, (String)phone, (Sid)this.storage.getAccountsDao().getAccount(cdr.getAccountSid()).getOrganizationSid());
        IncomingPhoneNumber number = mostOptimalNumber.number();
        if (number == null || number.getReferUrl() == null && number.getReferApplicationSid() == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Refer URL or Refer Applicatio for incoming phone number is null, cannot proceed with SIP Refer");
            }
            servletResponse = request.createResponse(404);
            servletResponse.setHeader("Reason", "SIP Refer failed. Set Refer URL or Refer application for incoming phone number");
            servletResponse.setHeader("Event", "refer");
            servletResponse.send();
            return;
        }
        Future future = Patterns.ask((ActorRef)transferorActor, (Object)new GetCallObservers(), (Timeout)expires);
        CallResponse response = (CallResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        List callObservers = (List)response.get();
        ActorRef existingInterpreter = (ActorRef)callObservers.iterator().next();
        future = Patterns.ask((ActorRef)existingInterpreter, (Object)new GetRelatedCall(transferorActor), (Timeout)expires);
        Object answer = Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        ActorRef transfereeActor = null;
        if (!(answer instanceof ActorRef)) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Transferee is not a Call actor, probably call is on conference");
            }
            servletResponse = request.createResponse(404);
            servletResponse.setHeader("Reason", "SIP Refer failed. Transferee is not a Call actor, probably this is a conference");
            servletResponse.setHeader("Event", "refer");
            servletResponse.send();
            transferorActor.tell((Object)new Hangup(), null);
            return;
        }
        transfereeActor = (ActorRef)answer;
        servletResponse = request.createResponse(202);
        servletResponse.setHeader("Event", "refer");
        servletResponse.send();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("About to start Call Transfer");
            this.logger.info("Transferor Call path: " + transferorActor.path());
            if (transfereeActor != null) {
                this.logger.info("Transferee Call path: " + transfereeActor.path());
            }
            this.logger.info("Will tell Call actors to stop observing existing Interpreters");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Call Transfer account: " + cdr.getAccountSid() + ", new RCML url: " + number.getReferUrl());
        }
        transferorActor.tell((Object)new StopObserving(), this.self());
        if (transfereeActor != null) {
            transfereeActor.tell((Object)new StopObserving(), this.self());
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Existing observers removed from Calls actors");
            this.logger.info("Existing Interpreter path: " + existingInterpreter.path() + " will be stopped");
        }
        existingInterpreter.tell((Object)new StopInterpreter(true), null);
        VoiceInterpreterParams.Builder builder = new VoiceInterpreterParams.Builder();
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(this.self());
        builder.setConferenceCenter(this.conferences);
        builder.setBridgeManager(this.bridges);
        builder.setSmsService(this.sms);
        builder.setAccount(cdr.getAccountSid());
        builder.setVersion(cdr.getApiVersion());
        if (number.getReferApplicationSid() != null) {
            Application application = this.storage.getApplicationsDao().getApplication(number.getReferApplicationSid());
            RcmlserverConfigurationSet rcmlserverConfig = RestcommConfiguration.getInstance().getRcmlserver();
            RcmlserverResolver resolver = RcmlserverResolver.getInstance((String)rcmlserverConfig.getBaseUrl(), (String)rcmlserverConfig.getApiPath());
            builder.setUrl(UriUtils.resolve((java.net.URI)resolver.resolveRelative(application.getRcmlUrl())));
        } else {
            builder.setUrl(UriUtils.resolve((java.net.URI)number.getReferUrl()));
        }
        builder.setMethod(number.getReferMethod() != null && number.getReferMethod().length() > 0 ? number.getReferMethod() : "POST");
        builder.setReferTarget(transferTarget);
        builder.setTransferor(transferor);
        builder.setTransferee(transferee);
        builder.setFallbackUrl(null);
        builder.setFallbackMethod("POST");
        builder.setStatusCallback(null);
        builder.setStatusCallbackMethod("POST");
        builder.setMonitoring(this.monitoring);
        Props props = VoiceInterpreter.props((VoiceInterpreterParams)builder.build());
        ActorRef interpreter = this.getContext().actorOf(props);
        this.system.scheduler().scheduleOnce(Duration.create((long)500L, (TimeUnit)TimeUnit.MILLISECONDS), interpreter, (Object)new StartInterpreter(transfereeActor), (ExecutionContext)this.system.dispatcher());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("New Intepreter for transfereeActor call leg: " + interpreter.path() + " started");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("will hangup transferorActor: " + transferorActor.path());
        }
        transferorActor.tell((Object)new Hangup(), null);
    }

    private boolean redirectToHostedVoiceApp(ActorRef self, SipServletRequest request, AccountsDao accounts, ApplicationsDao applications, String phone, Sid fromClientAccountSid, Sid sourceOrganizationSid) {
        boolean isFoundHostedApp = false;
        boolean failCall = false;
        IncomingPhoneNumber number = null;
        try {
            MostOptimalNumberResponse mostOptimalNumber = OrganizationUtil.getMostOptimalIncomingPhoneNumber((DaoManager)this.storage, (SipServletRequest)request, (String)phone, (Sid)sourceOrganizationSid);
            number = mostOptimalNumber.number();
            failCall = mostOptimalNumber.isRelevant();
            if (failCall) {
                SipServletResponse response = request.createResponse(404);
                response.send();
                String sourceDomainName = this.storage.getOrganizationsDao().getOrganization(sourceOrganizationSid).getDomainName();
                String errMsg = String.format("provided number %s does not belong to your domain %s.", phone, sourceDomainName);
                this.logger.warning(errMsg + " Requiested URI was: " + request.getRequestURI());
                this.sendNotification(fromClientAccountSid, errMsg, 11005, "error", true);
                return true;
            }
            if (number != null) {
                VoiceInterpreterParams.Builder builder = new VoiceInterpreterParams.Builder();
                builder.setConfiguration(this.configuration);
                builder.setStorage(this.storage);
                builder.setCallManager(self);
                builder.setConferenceCenter(this.conferences);
                builder.setBridgeManager(this.bridges);
                builder.setSmsService(this.sms);
                Sid accSid = fromClientAccountSid == null ? number.getAccountSid() : fromClientAccountSid;
                builder.setAccount(accSid);
                builder.setPhone(number.getAccountSid());
                builder.setVersion(number.getApiVersion());
                Account account = accounts.getAccount(accSid);
                builder.setEmailAddress(account.getEmailAddress());
                Sid sid = number.getVoiceApplicationSid();
                if (sid != null) {
                    Application application = applications.getApplication(sid);
                    RcmlserverConfigurationSet rcmlserverConfig = RestcommConfiguration.getInstance().getRcmlserver();
                    RcmlserverResolver rcmlserverResolver = RcmlserverResolver.getInstance((String)rcmlserverConfig.getBaseUrl(), (String)rcmlserverConfig.getApiPath());
                    builder.setUrl(UriUtils.resolve((java.net.URI)rcmlserverResolver.resolveRelative(application.getRcmlUrl())));
                } else {
                    builder.setUrl(UriUtils.resolve((java.net.URI)number.getVoiceUrl()));
                }
                String voiceMethod = number.getVoiceMethod();
                if (voiceMethod == null || voiceMethod.isEmpty()) {
                    builder.setMethod("POST");
                } else {
                    builder.setMethod(voiceMethod);
                }
                java.net.URI uri = number.getVoiceFallbackUrl();
                if (uri != null) {
                    builder.setFallbackUrl(UriUtils.resolve((java.net.URI)uri));
                } else {
                    builder.setFallbackUrl(null);
                }
                builder.setFallbackMethod(number.getVoiceFallbackMethod());
                builder.setStatusCallback(number.getStatusCallback());
                builder.setStatusCallbackMethod(number.getStatusCallbackMethod());
                builder.setMonitoring(this.monitoring);
                Props props = VoiceInterpreter.props((VoiceInterpreterParams)builder.build());
                ActorRef interpreter = this.getContext().actorOf(props);
                ActorRef call = this.call(null);
                SipApplicationSession application = request.getApplicationSession();
                application.setAttribute(Call.class.getName(), (Object)call);
                call.tell((Object)request, self);
                interpreter.tell((Object)new StartInterpreter(call), self);
                isFoundHostedApp = true;
            }
        }
        catch (Exception notANumber) {
            String errMsg = number != null ? "The number " + number.getPhoneNumber() + " does not have a Restcomm hosted application attached" : "The number does not exist" + notANumber;
            this.sendNotification(fromClientAccountSid, errMsg, 11007, "error", false);
            this.logger.warning(errMsg, (Object)notANumber);
            isFoundHostedApp = false;
        }
        return isFoundHostedApp;
    }

    private boolean redirectToClientVoiceApp(ActorRef self, SipServletRequest request, AccountsDao accounts, ApplicationsDao applications, Client client) {
        boolean isClientManaged;
        Sid applicationSid = client.getVoiceApplicationSid();
        java.net.URI clientAppVoiceUrl = null;
        if (applicationSid != null) {
            Application application = applications.getApplication(applicationSid);
            RcmlserverConfigurationSet rcmlserverConfig = RestcommConfiguration.getInstance().getRcmlserver();
            RcmlserverResolver resolver = RcmlserverResolver.getInstance((String)rcmlserverConfig.getBaseUrl(), (String)rcmlserverConfig.getApiPath());
            clientAppVoiceUrl = UriUtils.resolve((java.net.URI)resolver.resolveRelative(application.getRcmlUrl()));
        }
        if (clientAppVoiceUrl == null) {
            clientAppVoiceUrl = client.getVoiceUrl();
        }
        boolean bl = isClientManaged = applicationSid != null && !applicationSid.toString().isEmpty() && !applicationSid.toString().equals("") || clientAppVoiceUrl != null && !clientAppVoiceUrl.toString().isEmpty() && !clientAppVoiceUrl.toString().equals("");
        if (isClientManaged) {
            VoiceInterpreterParams.Builder builder = new VoiceInterpreterParams.Builder();
            builder.setConfiguration(this.configuration);
            builder.setStorage(this.storage);
            builder.setCallManager(self);
            builder.setConferenceCenter(this.conferences);
            builder.setBridgeManager(this.bridges);
            builder.setSmsService(this.sms);
            builder.setAccount(client.getAccountSid());
            builder.setVersion(client.getApiVersion());
            Account account = accounts.getAccount(client.getAccountSid());
            builder.setEmailAddress(account.getEmailAddress());
            Sid sid = client.getVoiceApplicationSid();
            builder.setUrl(clientAppVoiceUrl);
            builder.setMethod(client.getVoiceMethod());
            java.net.URI uri = client.getVoiceFallbackUrl();
            if (uri != null) {
                builder.setFallbackUrl(UriUtils.resolve((java.net.URI)uri));
            } else {
                builder.setFallbackUrl(null);
            }
            builder.setFallbackMethod(client.getVoiceFallbackMethod());
            builder.setMonitoring(this.monitoring);
            Props props = VoiceInterpreter.props((VoiceInterpreterParams)builder.build());
            ActorRef interpreter = this.getContext().actorOf(props);
            ActorRef call = this.call(null);
            SipApplicationSession application = request.getApplicationSession();
            application.setAttribute(Call.class.getName(), (Object)call);
            call.tell((Object)request, self);
            interpreter.tell((Object)new StartInterpreter(call), self);
        }
        return isClientManaged;
    }

    private void pong(Object message) throws IOException {
        SipServletRequest request = (SipServletRequest)message;
        SipServletResponse response = request.createResponse(200);
        response.send();
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef self = this.self();
        ActorRef sender = this.sender();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("######### CallManager new message received, message instanceof : " + klass + " from sender : " + sender.getClass());
        }
        if (message instanceof SipServletRequest) {
            SipServletRequest request = (SipServletRequest)message;
            String method = request.getMethod();
            if (request != null) {
                if ("INVITE".equals(method)) {
                    if (this.check(request)) {
                        this.invite(request);
                    }
                } else if ("OPTIONS".equals(method)) {
                    this.pong(request);
                } else if ("ACK".equals(method)) {
                    this.ack(request);
                } else if ("CANCEL".equals(method)) {
                    this.cancel(request);
                } else if ("BYE".equals(method)) {
                    this.bye(request);
                } else if ("INFO".equals(method)) {
                    this.info(request);
                } else if ("REFER".equals(method)) {
                    this.transfer(request);
                }
            }
        } else if (CreateCall.class.equals(klass)) {
            this.outbound(message, sender);
        } else if (ExecuteCallScript.class.equals(klass)) {
            this.execute(message);
        } else if (UpdateCallScript.class.equals(klass)) {
            try {
                this.update(message);
            }
            catch (Exception exception) {
                sender.tell((Object)new CallManagerResponse((Throwable)exception), self);
            }
        } else if (DestroyCall.class.equals(klass)) {
            this.destroy(message);
        } else if (message instanceof SipServletResponse) {
            this.response(message);
        } else if (message instanceof SipApplicationSessionEvent) {
            this.timeout(message);
        } else if (GetCall.class.equals(klass)) {
            sender.tell((Object)this.lookup(message), self);
        } else if (GetActiveProxy.class.equals(klass)) {
            sender.tell(this.getActiveProxy(), self);
        } else if (SwitchProxy.class.equals(klass)) {
            this.switchProxyRequest = (SwitchProxy)message;
            sender.tell(this.switchProxy(), self);
        } else if (GetProxies.class.equals(klass)) {
            sender.tell(this.getProxies(message), self);
        }
    }

    private void ack(SipServletRequest request) throws IOException {
        SipServletResponse response = B2BUAHelper.getLinkedResponse((SipServletMessage)request);
        if (response != null) {
            SipServletRequest ack = response.createAck();
            if (this.patchForNatB2BUASessions) {
                SipURI toInetUri;
                InetAddress ackRURI = null;
                try {
                    ackRURI = DNSUtils.getByName((String)((SipURI)ack.getRequestURI()).getHost());
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                boolean isBehindLB = false;
                String initialIpBeforeLB = response.getHeader("X-Sip-Balancer-InitialRemoteAddr");
                String initialPortBeforeLB = response.getHeader("X-Sip-Balancer-InitialRemotePort");
                if (initialIpBeforeLB != null) {
                    if (initialPortBeforeLB == null) {
                        initialPortBeforeLB = "5060";
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("We are behind load balancer, checking if the request URI needs to be patched");
                    }
                    isBehindLB = true;
                }
                if ((toInetUri = (SipURI)request.getSession().getAttribute("toInetURI")) != null && ackRURI == null) {
                    if (isBehindLB) {
                        boolean patchRURI = this.isLBPatchRURI(ack, initialIpBeforeLB, initialPortBeforeLB);
                        if (patchRURI) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("We are behind load balancer, but Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the ACK request");
                            }
                            ack.setRequestURI((URI)toInetUri);
                        } else {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("removing the toInetUri to avoid the other subsequent requests using it " + toInetUri.toString());
                            }
                            request.getSession().removeAttribute("toInetURI");
                        }
                    } else {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the ACK request");
                        }
                        ack.setRequestURI((URI)toInetUri);
                    }
                } else if (toInetUri != null && (ackRURI.isSiteLocalAddress() || ackRURI.isAnyLocalAddress() || ackRURI.isLoopbackAddress())) {
                    if (isBehindLB) {
                        boolean patchRURI = this.isLBPatchRURI(ack, initialIpBeforeLB, initialPortBeforeLB);
                        if (patchRURI) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("We are behind load balancer, but Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the ACK request");
                            }
                            ack.setRequestURI((URI)toInetUri);
                        } else {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("removing the toInetUri to avoid the other subsequent requests using it " + toInetUri.toString());
                            }
                            request.getSession().removeAttribute("toInetURI");
                        }
                    } else {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Using the real ip address of the sip client " + toInetUri.toString() + " as a request uri of the ACK request");
                        }
                        ack.setRequestURI((URI)toInetUri);
                    }
                } else if (toInetUri == null && (ackRURI.isSiteLocalAddress() || ackRURI.isAnyLocalAddress() || ackRURI.isLoopbackAddress())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Public IP toInetUri from SipSession is null, will check LB headers from last Response");
                    }
                    if (isBehindLB) {
                        String realIP = initialIpBeforeLB + ":" + initialPortBeforeLB;
                        SipURI uri = this.sipFactory.createSipURI(null, realIP);
                        boolean patchRURI = this.isLBPatchRURI(ack, initialIpBeforeLB, initialPortBeforeLB);
                        if (patchRURI) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("We are behind load balancer, will use Initial Remote Address " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the ACK request");
                            }
                            ack.setRequestURI((URI)uri);
                        }
                    } else if (this.logger.isInfoEnabled()) {
                        this.logger.info("LB Headers are also null");
                    }
                }
            }
            ack.send();
            SipApplicationSession sipApplicationSession = request.getApplicationSession();
            sipApplicationSession.setExpires(60);
        } else {
            ActorRef call;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Linked Response couldn't be found for ACK request");
            }
            if ((call = (ActorRef)request.getApplicationSession().getAttribute(Call.class.getName())) != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will send ACK to call actor: " + call.path());
                }
                call.tell((Object)request, this.self());
            }
        }
    }

    private boolean isLBPatchRURI(SipServletRequest request, String initialIpBeforeLB, String initialPortBeforeLB) {
        try {
            ListIterator routes = request.getAddressHeaders("Route");
            while (routes.hasNext()) {
                SipURI route = (SipURI)((Address)routes.next()).getURI();
                String routeHost = route.getHost();
                int routePort = route.getPort();
                if (routePort < 0) {
                    routePort = 5060;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Checking if route " + routeHost + ":" + routePort + " is matching ip and port before LB " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the " + request.getMethod() + " request");
                }
                if (!routeHost.equalsIgnoreCase(initialIpBeforeLB) || routePort != Integer.parseInt(initialPortBeforeLB)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("route " + route + " is matching ip and port before LB " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the " + request.getMethod() + " request, so not patching the Request-URI");
                }
                return false;
            }
        }
        catch (ServletParseException e) {
            this.logger.error("Impossible to parse the route set from the request " + request, (Object)e);
        }
        return true;
    }

    private void execute(Object message) {
        ExecuteCallScript request = (ExecuteCallScript)message;
        ActorRef self = this.self();
        VoiceInterpreterParams.Builder builder = new VoiceInterpreterParams.Builder();
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(self);
        builder.setConferenceCenter(this.conferences);
        builder.setBridgeManager(this.bridges);
        builder.setSmsService(this.sms);
        builder.setAccount(request.account());
        builder.setVersion(request.version());
        builder.setUrl(request.url());
        builder.setMethod(request.method());
        builder.setFallbackUrl(request.fallbackUrl());
        builder.setFallbackMethod(request.fallbackMethod());
        builder.setMonitoring(this.monitoring);
        Props props = VoiceInterpreter.props((VoiceInterpreterParams)builder.build());
        ActorRef interpreter = this.getContext().actorOf(props);
        interpreter.tell((Object)new StartInterpreter(request.call()), self);
    }

    private void update(Object message) throws Exception {
        UpdateCallScript request = (UpdateCallScript)message;
        ActorRef self = this.self();
        ActorRef call = request.call();
        Boolean moveConnectedCallLeg = request.moveConnecteCallLeg();
        Timeout expires = new Timeout(Duration.create((long)60L, (TimeUnit)TimeUnit.SECONDS));
        Future future = Patterns.ask((ActorRef)call, (Object)new GetCallObservers(), (Timeout)expires);
        CallResponse response = (CallResponse)Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        List callObservers = (List)response.get();
        ActorRef existingInterpreter = (ActorRef)callObservers.iterator().next();
        future = Patterns.ask((ActorRef)existingInterpreter, (Object)new GetRelatedCall(call), (Timeout)expires);
        Object answer = Await.result((Awaitable)future, (Duration)Duration.create((long)10L, (TimeUnit)TimeUnit.SECONDS));
        ActorRef relatedCall = null;
        List listOfRelatedCalls = null;
        if (answer instanceof ActorRef) {
            relatedCall = (ActorRef)answer;
        } else if (answer instanceof List) {
            listOfRelatedCalls = (List)answer;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("About to start Live Call Modification, moveConnectedCallLeg: " + moveConnectedCallLeg);
            this.logger.info("Initial Call path: " + call.path());
            if (relatedCall != null) {
                this.logger.info("Related Call path: " + relatedCall.path());
            }
            if (listOfRelatedCalls != null) {
                this.logger.info("List of related calls received, size of the list: " + listOfRelatedCalls.size());
            }
            this.logger.info("Will tell Call actors to stop observing existing Interpreters");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("LCM account: " + request.account() + ", moveConnectedCallLeg: " + moveConnectedCallLeg + ", new RCML url: " + request.url());
        }
        call.tell((Object)new StopObserving(), this.self());
        if (relatedCall != null) {
            relatedCall.tell((Object)new StopObserving(), this.self());
        }
        if (listOfRelatedCalls != null) {
            for (ActorRef branch : listOfRelatedCalls) {
                branch.tell((Object)new StopObserving(), this.self());
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Existing observers removed from Calls actors");
            this.logger.info("Existing Interpreter path: " + existingInterpreter.path() + " will be stopped");
        }
        existingInterpreter.tell((Object)new StopInterpreter(true), null);
        VoiceInterpreterParams.Builder builder = new VoiceInterpreterParams.Builder();
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(self);
        builder.setConferenceCenter(this.conferences);
        builder.setBridgeManager(this.bridges);
        builder.setSmsService(this.sms);
        builder.setAccount(request.account());
        builder.setVersion(request.version());
        builder.setUrl(request.url());
        builder.setMethod(request.method());
        builder.setFallbackUrl(request.fallbackUrl());
        builder.setFallbackMethod(request.fallbackMethod());
        builder.setStatusCallback(request.callback());
        builder.setStatusCallbackMethod(request.callbackMethod());
        builder.setMonitoring(this.monitoring);
        Props props = VoiceInterpreter.props((VoiceInterpreterParams)builder.build());
        ActorRef interpreter = this.getContext().actorOf(props);
        this.system.scheduler().scheduleOnce(Duration.create((long)500L, (TimeUnit)TimeUnit.MILLISECONDS), interpreter, (Object)new StartInterpreter(request.call()), (ExecutionContext)this.system.dispatcher());
        if (this.logger.isInfoEnabled()) {
            this.logger.info("New Intepreter for first call leg: " + interpreter.path() + " started");
        }
        if (relatedCall != null && listOfRelatedCalls == null) {
            if (moveConnectedCallLeg.booleanValue()) {
                ActorRef relatedInterpreter = this.getContext().actorOf(props);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("About to redirect related Call :" + relatedCall.path() + " with 200ms delay to related interpreter: " + relatedInterpreter.path());
                }
                this.system.scheduler().scheduleOnce(Duration.create((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS), relatedInterpreter, (Object)new StartInterpreter(relatedCall), (ExecutionContext)this.system.dispatcher());
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("New Intepreter for Second call leg: " + relatedInterpreter.path() + " started");
                }
            } else {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("moveConnectedCallLeg is: " + moveConnectedCallLeg + " so will hangup relatedCall: " + relatedCall.path());
                }
                relatedCall.tell((Object)new Hangup(), null);
            }
        }
        if (listOfRelatedCalls != null) {
            for (ActorRef branch : listOfRelatedCalls) {
                branch.tell((Object)new Hangup(), null);
            }
            if (this.logger.isInfoEnabled()) {
                String msg = String.format("LiveCallModification request while dial forking, terminated %d calls", listOfRelatedCalls.size());
                this.logger.info(msg);
            }
        }
    }

    private void outbound(Object message, final ActorRef sender) throws ServletParseException {
        final CreateCall request = (CreateCall)message;
        ExtensionController ec = ExtensionController.getInstance();
        ec.executePreOutboundAction((IExtensionRequest)request, this.extensions);
        switch (request.type()) {
            case CLIENT: {
                if (request.isAllowed()) {
                    ClientsDao clients = this.storage.getClientsDao();
                    Client client = clients.getClient(request.to().replaceFirst("client:", ""), this.storage.getAccountsDao().getAccount(request.accountId()).getOrganizationSid());
                    if (client != null) {
                        long delay = this.pushNotificationServerHelper.sendPushNotificationIfNeeded(client.getPushClientIdentity());
                        this.system.scheduler().scheduleOnce(Duration.create((long)delay, (TimeUnit)TimeUnit.MILLISECONDS), new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    CallManager.this.outboundToClient(request, sender);
                                    ExtensionController.getInstance().executePostOutboundAction((IExtensionRequest)request, CallManager.this.extensions);
                                }
                                catch (ServletParseException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }, (ExecutionContext)this.system.dispatcher());
                    } else {
                        String errMsg = "The SIP Client " + request.to() + " is not registered or does not exist";
                        this.logger.warning(errMsg);
                        this.sendNotification(request.accountId(), errMsg, 11008, "error", true);
                        sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), request), this.self());
                    }
                } else {
                    String errMsg = "Not Allowed to make this outbound call";
                    this.logger.warning("Not Allowed to make this outbound call");
                    sender.tell((Object)new CallManagerResponse((Throwable)new RestcommExtensionException("Not Allowed to make this outbound call"), request), this.self());
                }
                ec.executePostOutboundAction((IExtensionRequest)request, this.extensions);
                break;
            }
            case PSTN: {
                if (request.isAllowed()) {
                    this.outboundToPstn(request, sender);
                } else {
                    String errMsg = "Not Allowed to make this outbound call";
                    this.logger.warning("Not Allowed to make this outbound call");
                    sender.tell((Object)new CallManagerResponse((Throwable)new RestcommExtensionException("Not Allowed to make this outbound call"), request), this.self());
                }
                ec.executePostOutboundAction((IExtensionRequest)request, this.extensions);
                break;
            }
            case SIP: {
                if (this.actAsImsUa) {
                    this.outboundToIms(request, sender);
                } else if (request.isAllowed()) {
                    this.outboundToSip(request, sender);
                } else {
                    String errMsg = "Not Allowed to make this outbound call";
                    this.logger.warning("Not Allowed to make this outbound call");
                    sender.tell((Object)new CallManagerResponse((Throwable)new RestcommExtensionException("Not Allowed to make this outbound call"), request), this.self());
                }
                ec.executePostOutboundAction((IExtensionRequest)request, this.extensions);
            }
        }
    }

    private void outboundToClient(CreateCall request, ActorRef sender) throws ServletParseException {
        SipURI outboundIntf = null;
        SipURI from = null;
        SipURI to = null;
        boolean webRTC = false;
        boolean isLBPresent = false;
        RegistrationsDao registrationsDao = this.storage.getRegistrationsDao();
        String client = request.to().replaceFirst("client:", "");
        CopyOnWriteArrayList<Registration> registrationToDial = new CopyOnWriteArrayList<Registration>();
        Sid organizationSid = this.storage.getAccountsDao().getAccount(request.accountId()).getOrganizationSid();
        List registrations = registrationsDao.getRegistrations(client, organizationSid);
        if (registrations != null && registrations.size() > 0) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Preparing call for client: " + client + ". There are " + registrations.size() + " registrations at the database for this client");
            }
            for (Registration registration : registrations) {
                if (registration.isWebRTC()) {
                    if (registration.isLBPresent()) {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("WebRTC registration behind LB. Will add WebRTC registration: " + registration.getLocation() + " to the list to be dialed for client: " + client);
                        }
                        registrationToDial.add(registration);
                        continue;
                    }
                    if (registration.getInstanceId() != null && !registration.getInstanceId().equals(RestcommConfiguration.getInstance().getMain().getInstanceId())) {
                        this.logger.warning("Cannot create call for user agent: " + registration.getLocation() + " since this is a webrtc client registered in another Restcomm instance.");
                        continue;
                    }
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Will add WebRTC registration: " + registration.getLocation() + " to the list to be dialed for client: " + client);
                    }
                    registrationToDial.add(registration);
                    continue;
                }
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will add registration: " + registration.getLocation() + " to the list to be dialed for client: " + client);
                }
                registrationToDial.add(registration);
            }
        } else {
            String errMsg = "The SIP Client " + request.to() + " is not registered or does not exist";
            this.logger.warning(errMsg);
            this.sendNotification(request.accountId(), errMsg, 11008, "error", true);
            sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), request), this.self());
            return;
        }
        if (registrationToDial.size() > 0) {
            if (this.logger.isInfoEnabled() && registrationToDial.size() > 1) {
                this.logger.info("Preparing call for client: " + client + ", after WebRTC check, Restcomm have to dial :" + registrationToDial.size() + " registrations");
            }
            CopyOnWriteArrayList<ActorRef> calls = new CopyOnWriteArrayList<ActorRef>();
            for (Registration registration : registrationToDial) {
                String transport;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will proceed to create call for client: " + registration.getLocation() + " registration instanceId: " + registration.getInstanceId() + " own InstanceId: " + RestcommConfiguration.getInstance().getMain().getInstanceId());
                }
                if (registration.getLocation().contains("transport")) {
                    transport = registration.getLocation().split(";")[1].replace("transport=", "");
                    outboundIntf = this.outboundInterface(transport);
                } else {
                    transport = "udp";
                    outboundIntf = this.outboundInterface(transport);
                }
                if (outboundIntf == null) {
                    String errMsg = "The outbound interface for transport: " + transport + " is NULL, something is wrong with container, cannot proceed to call client " + request.to();
                    this.logger.error(errMsg);
                    this.sendNotification(request.accountId(), errMsg, 11008, "error", true);
                    sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), request), this.self());
                    return;
                }
                if (request.from() != null && request.from().contains("@")) {
                    String[] f = request.from().split("@");
                    from = this.sipFactory.createSipURI(f[0], f[1]);
                } else if (request.from() != null) {
                    if (outboundIntf != null) {
                        from = this.sipFactory.createSipURI(request.from(), this.mediaExternalIp + ":" + outboundIntf.getPort());
                    } else {
                        this.logger.error("Outbound interface is null, cannot create From header to be used to Dial client: " + client);
                    }
                } else {
                    from = outboundIntf;
                }
                String location = registration.getLocation();
                to = (SipURI)this.sipFactory.createURI(location);
                webRTC = registration.isWebRTC();
                if (from == null || to == null) {
                    String errMsg = "From and/or To are null, we cannot proceed to the outbound call to: " + request.to();
                    this.logger.warning(errMsg);
                    sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), request), this.self());
                    continue;
                }
                calls.add(this.createOutbound(request, from, to, webRTC));
            }
            if (calls.size() > 0) {
                sender.tell((Object)new CallManagerResponse(calls), this.self());
            }
        } else {
            String errMsg = "The SIP Client " + request.to() + " is not registered or does not exist";
            this.logger.warning(errMsg);
            this.sendNotification(request.accountId(), errMsg, 11008, "error", true);
            sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), request), this.self());
        }
    }

    private void outboundToPstn(CreateCall request, ActorRef sender) throws ServletParseException {
        String proxyUsername;
        String uri = request.getOutboundProxy() != null && !request.getOutboundProxy().isEmpty() ? request.getOutboundProxy() : this.activeProxy;
        SipURI outboundIntf = null;
        SipURI from = null;
        SipURI to = null;
        Configuration runtime = this.configuration.subset("runtime-settings");
        boolean useLocalAddressAtFromHeader = runtime.getBoolean("use-local-address", false);
        String string = proxyUsername = request.username() != null ? request.username() : this.activeProxyUsername;
        if (uri != null) {
            try {
                to = this.sipFactory.createSipURI(request.to(), uri);
                String transport = to.getTransportParam() != null ? to.getTransportParam() : "udp";
                outboundIntf = this.outboundInterface(transport);
                boolean outboudproxyUserAtFromHeader = runtime.subset("outbound-proxy").getBoolean("outboudproxy-user-at-from-header");
                from = request.from() != null && request.from().contains("@") ? (SipURI)this.sipFactory.createURI(request.from()) : (useLocalAddressAtFromHeader ? this.sipFactory.createSipURI(request.from(), this.mediaExternalIp + ":" + outboundIntf.getPort()) : (outboudproxyUserAtFromHeader ? this.sipFactory.createSipURI(proxyUsername, uri) : this.sipFactory.createSipURI(request.from(), uri)));
                if (from.getUser() == null || from.getUser() == "") {
                    from = uri != null ? this.sipFactory.createSipURI(request.from(), uri) : (SipURI)this.sipFactory.createURI(request.from());
                }
            }
            catch (Exception exception) {
                sender.tell((Object)new CallManagerResponse((Throwable)exception, request), this.self());
            }
            if (from == null || to == null) {
                String errMsg = "From and/or To are null, we cannot proceed to the outbound call to: " + request.to();
                this.logger.warning(errMsg);
                sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), request), this.self());
            } else {
                sender.tell((Object)new CallManagerResponse((Object)this.createOutbound(request, from, to, false)), this.self());
            }
        } else {
            String errMsg = "Cannot create call to: " + request.to() + ". The Active Outbound Proxy is null. Please check configuration";
            this.logger.warning(errMsg);
            this.sendNotification(request.accountId(), errMsg, 11008, "error", true);
            sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), request), this.self());
        }
    }

    private void outboundToSip(CreateCall request, ActorRef sender) throws ServletParseException {
        SipURI to;
        SipURI from;
        SipURI outboundIntf;
        block13: {
            String uri = request.getOutboundProxy() != null && !request.getOutboundProxy().isEmpty() ? request.getOutboundProxy() : "";
            outboundIntf = null;
            from = null;
            to = (SipURI)this.sipFactory.createURI(request.to());
            try {
                if (!uri.isEmpty()) {
                    SipURI outboundProxyURI = this.sipFactory.createSipURI(null, uri);
                    to.setHost(outboundProxyURI.getHost());
                    if (outboundProxyURI.getPort() != -1) {
                        to.setPort(outboundProxyURI.getPort());
                    }
                    Iterator params = outboundProxyURI.getParameterNames();
                    while (params.hasNext()) {
                        String param = (String)params.next();
                        to.setParameter(param, outboundProxyURI.getParameter(param));
                    }
                }
            }
            catch (Exception e) {
                if (!this.logger.isDebugEnabled()) break block13;
                this.logger.debug("Exception: outboundProxy is " + uri + " " + e.getMessage());
            }
        }
        String transport = to.getTransportParam() != null ? to.getTransportParam() : "udp";
        outboundIntf = this.outboundInterface(transport);
        if (request.from() == null) {
            from = this.outboundInterface(transport);
        } else if (request.from() != null && request.from().contains("@")) {
            from = (SipURI)this.sipFactory.createURI(request.from());
        } else if (request.accountId() != null) {
            Organization fromOrganization = this.storage.getOrganizationsDao().getOrganization(this.storage.getAccountsDao().getAccount(request.accountId()).getOrganizationSid());
            from = this.sipFactory.createSipURI(request.from(), fromOrganization.getDomainName());
        } else {
            from = this.sipFactory.createSipURI(request.from(), outboundIntf.getHost() + ":" + outboundIntf.getPort());
        }
        if (from == null || to == null) {
            String errMsg = "From and/or To are null, we cannot proceed to the outbound call to: " + request.to();
            this.logger.warning(errMsg);
            sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), request), this.self());
        } else {
            sender.tell((Object)new CallManagerResponse((Object)this.createOutbound(request, from, to, false)), this.self());
        }
    }

    private ActorRef createOutbound(CreateCall request, SipURI from, SipURI to, boolean webRTC) {
        Configuration runtime = this.configuration.subset("runtime-settings");
        String proxyUsername = request.username() != null ? request.username() : this.activeProxyUsername;
        String proxyPassword = request.password() != null ? request.password() : this.activeProxyPassword;
        ActorRef call = this.call(request);
        ActorRef self = this.self();
        boolean userAtDisplayedName = runtime.subset("outbound-proxy").getBoolean("user-at-displayed-name");
        InitializeOutbound init = request.from() != null && !request.from().contains("@") && userAtDisplayedName ? new InitializeOutbound(request.from(), from, to, proxyUsername, proxyPassword, (long)request.timeout(), request.isFromApi(), runtime.getString("api-version"), request.accountId(), request.type(), this.storage, webRTC, request.mediaAttributes()) : new InitializeOutbound(null, from, to, proxyUsername, proxyPassword, (long)request.timeout(), request.isFromApi(), runtime.getString("api-version"), request.accountId(), request.type(), this.storage, webRTC, request.mediaAttributes());
        if (request.parentCallSid() != null) {
            init.setParentCallSid(request.parentCallSid());
        }
        call.tell((Object)init, self);
        return call;
    }

    public void cancel(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletRequest request = (SipServletRequest)message;
        SipApplicationSession application = request.getApplicationSession();
        SipServletRequest originalRequest = B2BUAHelper.getLinkedRequest((SipServletMessage)request);
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession((SipServletMessage)request);
        if (originalRequest != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("B2BUA: Got CANCEL request: \n %s", request));
            }
            request.getSession().setAttribute("lastRequest", (Object)request);
            String sessionState = linkedB2BUASession.getState().name();
            SipServletResponse lastFinalResponse = (SipServletResponse)originalRequest.getSession().getAttribute("lastFinalResponse");
            if ((sessionState == SipSession.State.INITIAL.name() || sessionState == SipSession.State.EARLY.name()) && (lastFinalResponse == null || lastFinalResponse.getStatus() != 401 && lastFinalResponse.getStatus() != 407)) {
                SipServletRequest clonedCancel = originalRequest.createCancel();
                linkedB2BUASession.setAttribute("lastRequest", (Object)clonedCancel);
                clonedCancel.send();
            } else {
                SipServletRequest clonedBye = linkedB2BUASession.createRequest("BYE");
                linkedB2BUASession.setAttribute("lastRequest", (Object)clonedBye);
                clonedBye.send();
            }
        } else {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            if (call != null) {
                call.tell((Object)request, self);
            }
        }
    }

    public void bye(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletRequest request = (SipServletRequest)message;
        SipApplicationSession application = request.getApplicationSession();
        SipSession linkedB2BUASession = B2BUAHelper.getLinkedSession((SipServletMessage)request);
        if (linkedB2BUASession != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("B2BUA: Got BYE request: \n %s", request));
            }
            request.getSession().setAttribute("lastRequest", (Object)request);
            SipServletRequest clonedBye = linkedB2BUASession.createRequest("BYE");
            linkedB2BUASession.setAttribute("lastRequest", (Object)clonedBye);
            if (this.patchForNatB2BUASessions) {
                SipURI toInetUri = (SipURI)request.getSession().getAttribute("toInetURI");
                SipURI fromInetUri = (SipURI)request.getSession().getAttribute("fromInetURI");
                InetAddress byeRURI = null;
                try {
                    byeRURI = DNSUtils.getByName((String)((SipURI)clonedBye.getRequestURI()).getHost());
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
                boolean isBehindLB = false;
                String initialIpBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemoteAddr");
                String initialPortBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemotePort");
                if (initialIpBeforeLB != null) {
                    if (initialPortBeforeLB == null) {
                        initialPortBeforeLB = "5060";
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("We are behind load balancer, checking if the request URI needs to be patched");
                    }
                    isBehindLB = true;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("toInetUri: " + toInetUri + " fromInetUri: " + fromInetUri + " byeRURI: " + byeRURI + " initialIpBeforeLB: " + initialIpBeforeLB + " initialPortBeforeLB: " + initialPortBeforeLB);
                }
                if (toInetUri != null && byeRURI == null) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Using the real To inet ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneBye request");
                    }
                    clonedBye.setRequestURI((URI)toInetUri);
                } else if (toInetUri != null && (byeRURI.isSiteLocalAddress() || byeRURI.isAnyLocalAddress() || byeRURI.isLoopbackAddress())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Using the real To inet ip address of the sip client " + toInetUri.toString() + " as a request uri of the CloneBye request");
                    }
                    clonedBye.setRequestURI((URI)toInetUri);
                } else if (fromInetUri != null && (byeRURI.isSiteLocalAddress() || byeRURI.isAnyLocalAddress() || byeRURI.isLoopbackAddress())) {
                    if (isBehindLB) {
                        boolean patchRURI = this.isLBPatchRURI(clonedBye, initialIpBeforeLB, initialPortBeforeLB);
                        if (patchRURI) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("We are behind load balancer, but Using the real ip address of the sip client " + fromInetUri.toString() + " as a request uri of the CloneBye request");
                            }
                            clonedBye.setRequestURI((URI)fromInetUri);
                        }
                    } else {
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Using the real From inet ip  address of the sip client " + fromInetUri.toString() + " as a request uri of the CloneBye request");
                        }
                        clonedBye.setRequestURI((URI)fromInetUri);
                    }
                } else if (toInetUri == null && (byeRURI.isSiteLocalAddress() || byeRURI.isAnyLocalAddress() || byeRURI.isLoopbackAddress())) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Public IP toInetUri from SipSession is null, will check LB headers from last Response");
                    }
                    if (isBehindLB) {
                        String realIP = initialIpBeforeLB + ":" + initialPortBeforeLB;
                        SipURI uri = this.sipFactory.createSipURI(null, realIP);
                        boolean patchRURI = this.isLBPatchRURI(clonedBye, initialIpBeforeLB, initialPortBeforeLB);
                        if (patchRURI) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("We are behind load balancer, will use: " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the cloned BYE message");
                            }
                            clonedBye.setRequestURI((URI)uri);
                        }
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("We are behind load balancer, will use Initial Remote Address " + initialIpBeforeLB + ":" + initialPortBeforeLB + " for the cloned BYE request");
                        }
                    } else if (this.logger.isInfoEnabled()) {
                        this.logger.info("LB Headers are also null");
                    }
                }
            }
            B2BUAHelper.updateCDR((SipServletMessage)request, (CallStateChanged.State)CallStateChanged.State.COMPLETED);
            SipServletResponse okay = request.createResponse(200);
            okay.send();
            if (this.logger.isInfoEnabled()) {
                this.logger.info(String.format("B2BUA: Will send out Cloned BYE request: \n %s", clonedBye));
            }
            clonedBye.send();
        } else {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            if (call != null) {
                call.tell((Object)request, self);
            }
        }
    }

    public void response(Object message) throws IOException {
        ActorRef self = this.self();
        SipServletResponse response = (SipServletResponse)message;
        if (this.allowFallback) {
            this.checkErrorResponse(response);
        }
        SipApplicationSession application = response.getApplicationSession();
        if (B2BUAHelper.isB2BUASession((SipServletMessage)response)) {
            if (response.getStatus() == 407 || response.getStatus() == 401) {
                AuthInfo authInfo = this.sipFactory.createAuthInfo();
                String authHeader = response.getHeader("Proxy-Authenticate");
                if (authHeader == null) {
                    authHeader = response.getHeader("WWW-Authenticate");
                }
                String tempRealm = authHeader.substring(authHeader.indexOf("realm=\"") + "realm=\"".length());
                String realm = tempRealm.substring(0, tempRealm.indexOf("\""));
                authInfo.addAuthInfo(response.getStatus(), realm, this.activeProxyUsername, this.activeProxyPassword);
                SipServletRequest challengeRequest = response.getSession().createRequest(response.getRequest().getMethod());
                response.getSession().setAttribute("lastFinalResponse", (Object)response);
                challengeRequest.addAuthHeader(response, authInfo);
                SipServletRequest invite = response.getRequest();
                challengeRequest.setContent(invite.getContent(), invite.getContentType());
                invite = challengeRequest;
                challengeRequest.send();
            } else {
                B2BUAHelper.forwardResponse((SipServletResponse)response, (boolean)this.patchForNatB2BUASessions);
            }
        } else if (application.isValid()) {
            ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
            call.tell((Object)response, self);
        }
    }

    public ActorRef lookup(Object message) {
        GetCall getCall = (GetCall)message;
        String callPath = getCall.getIdentifier();
        UntypedActorContext context = this.getContext();
        ActorRef call = null;
        if (callPath != null) {
            try {
                call = context.actorFor(callPath);
            }
            catch (Exception e) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Problem during call lookup, callPath: " + callPath);
                }
                return null;
            }
        } else if (this.logger.isInfoEnabled()) {
            this.logger.info("CallPath is null, call lookup cannot be executed");
        }
        return call;
    }

    public void timeout(Object message) {
        ActorRef self = this.self();
        SipApplicationSessionEvent event = (SipApplicationSessionEvent)message;
        SipApplicationSession application = event.getApplicationSession();
        ActorRef call = (ActorRef)application.getAttribute(Call.class.getName());
        ReceiveTimeout$ timeout = ReceiveTimeout.getInstance();
        call.tell((Object)timeout, self);
    }

    public void checkErrorResponse(SipServletResponse response) {
        int status;
        if (!response.isBranchResponse() && response.getRequest().getMethod().equalsIgnoreCase("INVITE") && response.getRequest().isInitial() && (status = response.getStatus()) != 401 && status != 407 && status != 404 && status > 400) {
            int failures = this.numberOfFailedCalls.incrementAndGet();
            if (this.logger.isInfoEnabled()) {
                this.logger.info("A total number of " + failures + " failures have now been counted.");
            }
            if (failures >= this.maxNumberOfFailedCalls) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Max number of failed calls has been reached trying to switch over proxy.");
                    this.logger.info("Current proxy: " + this.getActiveProxy().get("ActiveProxy"));
                }
                this.switchProxy();
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Switched to proxy: " + this.getActiveProxy().get("ActiveProxy"));
                }
                this.numberOfFailedCalls.set(0);
            }
        }
    }

    public Map<String, String> getActiveProxy() {
        ConcurrentHashMap<String, String> activeProxyMap = new ConcurrentHashMap<String, String>();
        activeProxyMap.put("ActiveProxy", this.activeProxy);
        return activeProxyMap;
    }

    public Map<String, String> switchProxy() {
        if (this.activeProxy.equalsIgnoreCase(this.primaryProxyUri)) {
            this.activeProxy = this.fallBackProxyUri;
            this.activeProxyUsername = this.fallBackProxyUsername;
            this.activeProxyPassword = this.fallBackProxyPassword;
            this.useFallbackProxy.set(true);
        } else if (this.allowFallbackToPrimary) {
            this.activeProxy = this.primaryProxyUri;
            this.activeProxyUsername = this.primaryProxyUsername;
            this.activeProxyPassword = this.primaryProxyPassword;
            this.useFallbackProxy.set(false);
        }
        Notification notification = this.notification(null, 1, 14110, "Max number of failed calls has been reached! Outbound proxy switched");
        NotificationsDao notifications = this.storage.getNotificationsDao();
        notifications.addNotification(notification);
        return this.getActiveProxy();
    }

    public Map<String, String> getProxies(Object message) {
        ConcurrentHashMap<String, String> proxies = new ConcurrentHashMap<String, String>();
        proxies.put("ActiveProxy", this.activeProxy);
        proxies.put("UsingFallBackProxy", this.useFallbackProxy.toString());
        proxies.put("AllowFallbackToPrimary", String.valueOf(this.allowFallbackToPrimary));
        proxies.put("PrimaryProxy", this.primaryProxyUri);
        proxies.put("FallbackProxy", this.fallBackProxyUri);
        return proxies;
    }

    private Notification notification(Sid accountId, int log, int error, String message) {
        String version = this.configuration.subset("runtime-settings").getString("api-version");
        if (accountId == null) {
            accountId = this.switchProxyRequest != null ? this.switchProxyRequest.getSid() : new Sid("ACae6e420f425248d6a26948c17a9e2acf");
        }
        Notification.Builder builder = Notification.builder();
        Sid sid = Sid.generate((Sid.Type)Sid.Type.NOTIFICATION);
        builder.setSid(sid);
        builder.setAccountSid(accountId);
        builder.setApiVersion(version);
        builder.setLog(log);
        builder.setErrorCode(error);
        String base = this.configuration.subset("runtime-settings").getString("error-dictionary-uri");
        StringBuilder buffer = new StringBuilder();
        buffer.append(base);
        if (!base.endsWith("/")) {
            buffer.append("/");
        }
        buffer.append(error).append(".html");
        java.net.URI info = java.net.URI.create(buffer.toString());
        builder.setMoreInfo(info);
        builder.setMessageText(message);
        DateTime now = DateTime.now();
        builder.setMessageDate(now);
        try {
            builder.setRequestUrl(new java.net.URI(""));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        builder.setRequestMethod("");
        builder.setRequestVariables("");
        buffer = new StringBuilder();
        buffer.append("/").append(version).append("/Accounts/");
        buffer.append(accountId.toString()).append("/Notifications/");
        buffer.append(sid.toString());
        java.net.URI uri = java.net.URI.create(buffer.toString());
        builder.setUri(uri);
        return builder.build();
    }

    private SipURI outboundInterface(String transport) {
        SipURI result = null;
        List uris = (List)this.context.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String interfaceTransport = uri.getTransportParam();
            if (!transport.equalsIgnoreCase(interfaceTransport)) continue;
            result = uri;
        }
        return result;
    }

    private boolean isFromIms(SipServletRequest request) throws ServletParseException {
        SipURI uri = (SipURI)request.getRequestURI();
        return uri.getUser() == null;
    }

    private Registration findRegistration(URI regUri) {
        List registrations;
        if (regUri == null) {
            return null;
        }
        String formattedNumber = null;
        formattedNumber = regUri.isSipURI() ? ((SipURI)regUri).getUser().replaceFirst("\\+", "") : ((TelURL)regUri).getPhoneNumber().replaceFirst("\\+", "");
        if (this.logger.isInfoEnabled()) {
            this.logger.info("looking for registrations for number: " + formattedNumber);
        }
        RegistrationsDao registrationsDao = this.storage.getRegistrationsDao();
        Sid orgSid = OrganizationUtil.getOrganizationSidBySipURIHost((DaoManager)this.storage, (SipURI)((SipURI)regUri));
        if (orgSid == null) {
            this.logger.error("Null Organization: regUri: " + regUri);
        }
        if ((registrations = registrationsDao.getRegistrations(formattedNumber, orgSid)) == null || registrations.size() == 0) {
            return null;
        }
        return (Registration)registrations.get(0);
    }

    private void imsProxyThroughMediaServer(SipServletRequest request, Client client, URI destUri, String user, String password, boolean isFromIms) throws IOException {
        URI srcUri = request.getFrom().getURI();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("imsProxyThroughMediaServer, isFromIms: " + isFromIms + ", destUri: " + destUri + ", srcUri: " + srcUri);
        }
        Configuration runtime = this.configuration.subset("runtime-settings");
        String destNumber = destUri.toString();
        String rcml = "<Response><Dial>" + destNumber + "</Dial></Response>";
        URI regUri = null;
        regUri = isFromIms ? destUri : srcUri;
        Registration reg = this.findRegistration(regUri);
        if (reg == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("registrations not found");
            }
            SipServletResponse response = request.createResponse(404);
            response.send();
            String errMsg = "Call cannot be processed because the registration: " + regUri.toString() + "cannot be found";
            this.sendNotification(null, errMsg, 11005, "error", true);
            return;
        }
        if (isFromIms) {
            rcml = "<Response><Dial><Client>" + reg.getUserName() + "</Client></Dial></Response>";
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("rcml: " + rcml);
        }
        VoiceInterpreterParams.Builder builder = new VoiceInterpreterParams.Builder();
        builder.setConfiguration(this.configuration);
        builder.setStorage(this.storage);
        builder.setCallManager(this.self());
        builder.setConferenceCenter(this.conferences);
        builder.setBridgeManager(this.bridges);
        builder.setSmsService(this.sms);
        builder.setAccount(Sid.generate((Sid.Type)Sid.Type.ACCOUNT, (String)this.imsAccount));
        builder.setVersion(runtime.getString("api-version"));
        builder.setRcml(rcml);
        builder.setMonitoring(this.monitoring);
        builder.setAsImsUa(this.actAsImsUa);
        if (this.actAsImsUa) {
            builder.setImsUaLogin(user);
            builder.setImsUaPassword(password);
        }
        Props props = VoiceInterpreter.props((VoiceInterpreterParams)builder.build());
        ActorRef interpreter = this.getContext().actorOf(props);
        ActorRef call = this.call(null);
        SipApplicationSession application = request.getApplicationSession();
        application.setAttribute(Call.class.getName(), (Object)call);
        call.tell((Object)request, this.self());
        interpreter.tell((Object)new StartInterpreter(call), this.self());
    }

    private void outboundToIms(CreateCall request, ActorRef sender) throws ServletParseException {
        SipURI from;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("outboundToIms: " + request);
        }
        SipURI to = (SipURI)this.sipFactory.createURI(request.to());
        if (request.from() == null) {
            from = this.sipFactory.createSipURI(null, this.imsDomain);
        } else if (request.from() != null && request.from().contains("@")) {
            String[] f = request.from().split("@");
            from = this.sipFactory.createSipURI(f[0], f[1]);
        } else {
            from = this.sipFactory.createSipURI(request.from(), this.imsDomain);
        }
        if (from == null || to == null) {
            String errMsg = "From and/or To are null, we cannot proceed to the outbound call to: " + request.to();
            this.logger.error(errMsg);
            sender.tell((Object)new CallManagerResponse((Throwable)new NullPointerException(errMsg), request), this.self());
        } else {
            ActorRef call = this.call(request);
            ActorRef self = this.self();
            Configuration runtime = this.configuration.subset("runtime-settings");
            if (this.logger.isInfoEnabled()) {
                this.logger.info("outboundToIms: from: " + from + ", to: " + to);
            }
            String proxyUsername = request.username() != null ? request.username() : this.activeProxyUsername;
            String proxyPassword = request.password() != null ? request.password() : this.activeProxyPassword;
            boolean isToWebRTC = false;
            Registration toReg = this.findRegistration((URI)to);
            if (toReg != null) {
                isToWebRTC = toReg.isWebRTC();
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("outboundToIms: isToWebRTC: " + isToWebRTC);
            }
            InitializeOutbound init = new InitializeOutbound(request.from(), from, to, proxyUsername, proxyPassword, (long)request.timeout(), request.isFromApi(), runtime.getString("api-version"), request.accountId(), request.type(), this.storage, isToWebRTC, true, this.imsProxyAddress, this.imsProxyPort, request.mediaAttributes());
            if (request.parentCallSid() != null) {
                init.setParentCallSid(request.parentCallSid());
            }
            call.tell((Object)init, self);
            sender.tell((Object)new CallManagerResponse((Object)call), this.self());
        }
    }
}

