/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.actor.UntypedActor;
import akka.actor.UntypedActorFactory;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletContextEvent;
import javax.servlet.sip.SipServletListener;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.mscontrol.api.MediaServerControllerFactory;
import org.restcomm.connect.sms.SmsService;
import org.restcomm.connect.telephony.BridgeManager;
import org.restcomm.connect.telephony.CallManager;
import org.restcomm.connect.telephony.ConferenceCenter;
import org.restcomm.connect.ussd.telephony.UssdCallManager;

public final class CallManagerProxy
extends SipServlet
implements SipServletListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(CallManagerProxy.class);
    private boolean sendTryingForInitalRequests = false;
    private ActorSystem system;
    private ActorRef manager;
    private ActorRef ussdManager;
    private ServletContext context;
    private Configuration configuration;

    public void destroy() {
        if (this.system != null) {
            this.system.shutdown();
            this.system.awaitTermination();
        }
    }

    protected void doRequest(SipServletRequest request) throws ServletException, IOException {
        if (this.isUssdMessage((SipServletMessage)request)) {
            this.ussdManager.tell((Object)request, null);
        } else {
            if (request.isInitial() && this.sendTryingForInitalRequests) {
                SipServletResponse resp = request.createResponse(100);
                resp.send();
            }
            this.manager.tell((Object)request, null);
        }
    }

    protected void doResponse(SipServletResponse response) throws ServletException, IOException {
        if (response.getMethod().equals("BYE") && response.getStatus() >= 200) {
            SipSession sipSession = response.getSession();
            SipApplicationSession sipApplicationSession = response.getApplicationSession();
            if (sipSession.isValid()) {
                sipSession.setInvalidateWhenReady(true);
            }
            if (sipApplicationSession.isValid()) {
                sipApplicationSession.setInvalidateWhenReady(true);
            }
            return;
        }
        if (this.isUssdMessage((SipServletMessage)response)) {
            this.ussdManager.tell((Object)response, null);
        } else {
            this.manager.tell((Object)response, null);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    private ActorRef manager(final Configuration configuration, final ServletContext context, final MediaServerControllerFactory msControllerfactory, final ActorRef conferences, final ActorRef bridges, final ActorRef sms, final SipFactory factory, final DaoManager storage) {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new CallManager(configuration, context, msControllerfactory, conferences, bridges, sms, factory, storage);
            }
        });
        return this.system.actorOf(props);
    }

    private ActorRef ussdManager(final Configuration configuration, final ServletContext context, final SipFactory factory, final DaoManager storage) {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new UssdCallManager(configuration, context, factory, storage);
            }
        });
        return this.system.actorOf(props);
    }

    private ActorRef conferences(final MediaServerControllerFactory factory, final DaoManager storage) {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new ConferenceCenter(factory, storage);
            }
        });
        return this.system.actorOf(props);
    }

    private ActorRef bridges(final MediaServerControllerFactory factory) {
        Props props = new Props(new UntypedActorFactory(){
            private static final long serialVersionUID = 1L;

            public UntypedActor create() throws Exception {
                return new BridgeManager(factory);
            }
        });
        return this.system.actorOf(props);
    }

    private boolean isUssdMessage(SipServletMessage message) {
        Boolean isUssd = false;
        String contentType = null;
        try {
            contentType = message.getContentType();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (contentType != null) {
            isUssd = contentType.equalsIgnoreCase("application/vnd.3gpp.ussd+xml");
        } else if (message.getApplicationSession().getAttribute("UssdCall") != null) {
            isUssd = true;
        }
        return isUssd;
    }

    public void servletInitialized(SipServletContextEvent event) {
        if (event.getSipServlet().getClass().equals(CallManagerProxy.class)) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"CallManagerProxy sip servlet initialized. Will proceed to create CallManager and UssdManager");
            }
            this.context = event.getServletContext();
            this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
            this.sendTryingForInitalRequests = Boolean.parseBoolean(this.configuration.subset("runtime-settings").getString("send-trying-for-initial-requests", "false"));
            this.system = (ActorSystem)this.context.getAttribute(ActorSystem.class.getName());
            DaoManager storage = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
            MediaServerControllerFactory mscontrolFactory = (MediaServerControllerFactory)this.context.getAttribute(MediaServerControllerFactory.class.getName());
            SipFactory factory = (SipFactory)this.context.getAttribute("javax.servlet.sip.SipFactory");
            ActorRef conferences = this.conferences(mscontrolFactory, storage);
            ActorRef bridges = this.bridges(mscontrolFactory);
            ActorRef sms = (ActorRef)this.context.getAttribute(SmsService.class.getName());
            this.manager = this.manager(this.configuration, this.context, mscontrolFactory, conferences, bridges, sms, factory, storage);
            this.ussdManager = this.ussdManager(this.configuration, this.context, factory, storage);
            this.context.setAttribute(CallManager.class.getName(), (Object)this.manager);
            this.context.setAttribute(UssdCallManager.class.getName(), (Object)this.ussdManager);
        }
    }
}

