/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.telephony.ua;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ReceiveTimeout;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.restcomm.connect.commons.configuration.RestcommConfiguration;
import org.restcomm.connect.commons.dao.Sid;
import org.restcomm.connect.commons.faulttolerance.RestcommUntypedActor;
import org.restcomm.connect.commons.util.DigestAuthentication;
import org.restcomm.connect.commons.util.HexadecimalUtils;
import org.restcomm.connect.dao.ClientsDao;
import org.restcomm.connect.dao.DaoManager;
import org.restcomm.connect.dao.RegistrationsDao;
import org.restcomm.connect.dao.common.OrganizationUtil;
import org.restcomm.connect.dao.entities.Client;
import org.restcomm.connect.dao.entities.Registration;
import org.restcomm.connect.monitoringservice.MonitoringService;
import org.restcomm.connect.telephony.api.GetCall;
import org.restcomm.connect.telephony.api.Hangup;
import org.restcomm.connect.telephony.api.UserRegistration;

public final class UserAgentManager
extends RestcommUntypedActor {
    private static final int DEFAUL_IMS_PROXY_PORT = -1;
    private static final String REGISTER = "REGISTER";
    private static final String REQ_PARAMETER = "Req";
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private boolean authenticateUsers = true;
    private final SipFactory factory;
    private final DaoManager storage;
    private final ServletContext servletContext;
    private ActorRef monitoringService;
    private final int pingInterval;
    private final String instanceId;
    private boolean actAsImsUa;
    private String imsProxyAddress;
    private int imsProxyPort;
    private String imsDomain;

    public UserAgentManager(Configuration configuration, SipFactory factory, DaoManager storage, ServletContext servletContext) {
        this.servletContext = servletContext;
        this.monitoringService = (ActorRef)servletContext.getAttribute(MonitoringService.class.getName());
        Configuration runtime = configuration.subset("runtime-settings");
        this.authenticateUsers = runtime.getBoolean("authenticate");
        this.factory = factory;
        this.storage = storage;
        this.pingInterval = runtime.getInt("ping-interval", 60);
        this.logger.info("About to run firstTimeCleanup()");
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
        if (!runtime.subset("ims-authentication").isEmpty()) {
            Configuration imsAuthentication = runtime.subset("ims-authentication");
            this.actAsImsUa = imsAuthentication.getBoolean("act-as-ims-ua");
            if (this.actAsImsUa) {
                this.imsProxyAddress = imsAuthentication.getString("proxy-address");
                this.imsProxyPort = imsAuthentication.getInt("proxy-port");
                if (this.imsProxyPort == 0) {
                    this.imsProxyPort = -1;
                }
                this.imsDomain = imsAuthentication.getString("domain");
                if (this.actAsImsUa && (this.imsProxyAddress == null || this.imsProxyAddress.isEmpty() || this.imsDomain == null || this.imsDomain.isEmpty())) {
                    this.logger.warning("ims proxy-address or domain is not configured");
                }
                this.actAsImsUa = this.actAsImsUa && this.imsProxyAddress != null && !this.imsProxyAddress.isEmpty() && this.imsDomain != null && !this.imsDomain.isEmpty();
            }
        }
        this.firstTimeCleanup();
    }

    private void firstTimeCleanup() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initial registration cleanup. Will check existing registrations in DB and cleanup appropriately");
        }
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        List results = registrations.getRegistrationsByInstanceId(this.instanceId);
        for (Registration result : results) {
            if (result.isWebRTC()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will remove WebRTC client: " + result.getLocation());
                }
                registrations.removeRegistration(result);
                this.monitoringService.tell((Object)new UserRegistration(result.getUserName(), result.getLocation(), Boolean.valueOf(false), result.getOrganizationSid()), this.self());
                continue;
            }
            DateTime expires = result.getDateExpires();
            if (expires.isBeforeNow() || expires.isEqualNow()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Registration: " + result.getLocation() + " expired and will be removed now");
                }
                registrations.removeRegistration(result);
                this.monitoringService.tell((Object)new UserRegistration(result.getUserName(), result.getLocation(), Boolean.valueOf(false), result.getOrganizationSid()), this.self());
                this.monitoringService.tell((Object)new GetCall(result.getLocation()), this.self());
                continue;
            }
            DateTime updated = result.getDateUpdated();
            Long pingIntervalMillis = new Long(this.pingInterval * 1000 * 3);
            if (DateTime.now().getMillis() - updated.getMillis() <= pingIntervalMillis) continue;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Registration: " + result.getLocation() + " didn't respond to OPTIONS and will be removed now");
            }
            registrations.removeRegistration(result);
            this.monitoringService.tell((Object)new UserRegistration(result.getUserName(), result.getLocation(), Boolean.valueOf(false), result.getOrganizationSid()), this.self());
            this.monitoringService.tell((Object)new GetCall(result.getLocation()), this.self());
        }
        results = registrations.getRegistrationsByInstanceId(this.instanceId);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Initial registration cleanup finished, starting Restcomm with " + results.size() + " registrations");
        }
    }

    private void clean() throws ServletException {
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        List results = registrations.getRegistrationsByInstanceId(this.instanceId);
        for (Registration result : results) {
            DateTime expires = result.getDateExpires();
            if (expires.isBeforeNow() || expires.isEqualNow()) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Registration: " + result.getAddressOfRecord() + " expired. Will ping again.");
                }
                try {
                    this.ping(result.getLocation());
                }
                catch (ServletParseException spe) {
                    this.logger.warning("Bad Parameters: " + result.getLocation());
                    registrations.removeRegistration(result);
                }
                continue;
            }
            DateTime updated = result.getDateUpdated();
            Long pingIntervalMillis = new Long(this.pingInterval * 1000 * 3);
            if (DateTime.now().getMillis() - updated.getMillis() <= pingIntervalMillis) continue;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Registration: " + result.getAddressOfRecord() + " didn't respond to OPTIONS. Will ping again.");
            }
            try {
                this.ping(result.getLocation());
            }
            catch (ServletParseException spe) {
                this.logger.warning("Bad Parameters: " + result.getLocation());
                registrations.removeRegistration(result);
            }
        }
    }

    private void disconnectActiveCalls(ActorRef call) {
        if (call != null && !call.isTerminated()) {
            call.tell((Object)new Hangup("Registration_Removed"), this.self());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Disconnected call: " + call.path() + " , after registration removed");
            }
        }
    }

    private String header(String nonce, String realm, String scheme) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(scheme).append(" ");
        buffer.append("realm=\"").append(realm).append("\", ");
        buffer.append("nonce=\"").append(nonce).append("\"");
        return buffer.toString();
    }

    private void authenticate(Object message) throws IOException {
        SipServletRequest request = (SipServletRequest)message;
        SipServletResponse response = request.createResponse(407);
        String nonce = this.nonce();
        SipURI uri = (SipURI)request.getTo().getURI();
        String realm = uri.getHost();
        String header = this.header(nonce, realm, "Digest");
        response.addHeader("Proxy-Authenticate", header);
        response.send();
    }

    private void keepAlive() throws Exception {
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        List results = registrations.getRegistrationsByInstanceId(this.instanceId);
        if (results != null && results.size() > 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Registrations for InstanceId: " + this.instanceId + " , returned " + results.size() + " registrations");
            }
            for (Registration result : results) {
                String to = result.getLocation();
                try {
                    this.ping(to);
                }
                catch (ServletParseException spe) {
                    this.logger.warning("Bad Parameters: " + to);
                    registrations.removeRegistration(result);
                }
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug("Registrations for InstanceId: " + this.instanceId + " , returned no registrations");
        }
    }

    private String nonce() {
        byte[] uuid = UUID.randomUUID().toString().getBytes();
        char[] hex = HexadecimalUtils.toHex((byte[])uuid);
        return new String(hex).substring(0, 31);
    }

    public void onReceive(Object message) throws Exception {
        Class<?> klass = message.getClass();
        ActorRef sender = this.sender();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("UserAgentManager Processing Message: \"" + klass.getName() + " sender : " + sender.getClass() + " self is terminated: " + this.self().isTerminated());
        }
        if (message instanceof ReceiveTimeout) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Timeout received, ping interval: " + this.pingInterval + " , will clean up registrations and send keep alive");
            }
            this.clean();
            this.keepAlive();
        } else if (message instanceof SipServletRequest) {
            SipServletRequest request = (SipServletRequest)message;
            String method = request.getMethod();
            if (REGISTER.equalsIgnoreCase(method)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("REGISTER request received: " + request.toString());
                }
                if (this.actAsImsUa) {
                    this.proxyRequestToIms(request);
                } else if (this.authenticateUsers) {
                    String authorization = request.getHeader("Proxy-Authorization");
                    if (authorization != null) {
                        if (this.permitted(authorization, method, (SipURI)request.getFrom().getURI())) {
                            this.register(message);
                        } else {
                            SipServletResponse response = ((SipServletRequest)message).createResponse(403);
                            response.send();
                        }
                    } else {
                        this.authenticate(message);
                    }
                } else {
                    this.register(message);
                }
            }
        } else if (message instanceof SipServletResponse) {
            SipServletResponse response = (SipServletResponse)message;
            if (response.getStatus() > 400 && response.getMethod().equalsIgnoreCase("OPTIONS")) {
                this.removeRegistration((SipServletMessage)response);
            } else if (this.actAsImsUa && response.getMethod().equalsIgnoreCase(REGISTER)) {
                this.proxyResponseFromIms(message, response);
            } else {
                this.pong(message);
            }
        } else if (message instanceof ActorRef) {
            this.disconnectActiveCalls((ActorRef)message);
        }
    }

    private void removeRegistration(SipServletMessage sipServletMessage) throws ServletParseException {
        this.removeRegistration(sipServletMessage, false);
    }

    private void removeRegistration(SipServletMessage sipServletMessage, boolean locationInContact) throws ServletParseException {
        SipURI location;
        String user = ((SipURI)sipServletMessage.getTo().getURI()).getUser();
        SipURI sipURI = location = locationInContact ? (SipURI)sipServletMessage.getAddressHeader("Contact").getURI() : (SipURI)sipServletMessage.getTo().getURI();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Error response for the OPTIONS to: " + location + " will remove registration");
        }
        RegistrationsDao regDao = this.storage.getRegistrationsDao();
        List registrations = regDao.getRegistrationsByLocation(user, "%" + location.getHost() + ":" + location.getPort());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Resultant registrations of given criteria, that will be removed are:" + registrations);
        }
        if (registrations != null) {
            Iterator iter = registrations.iterator();
            SipURI regLocation = null;
            while (iter.hasNext()) {
                Registration reg = (Registration)iter.next();
                try {
                    regLocation = (SipURI)this.factory.createURI(reg.getLocation());
                }
                catch (ServletParseException e) {
                    // empty catch block
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("regLocation: " + regLocation + " reg.getAddressOfRecord(): " + reg.getAddressOfRecord() + " reg.getLocation(): " + reg.getLocation() + ", reg.getDateExpires(): " + reg.getDateExpires() + ", reg.getDateUpdated(): " + reg.getDateUpdated() + ", location: " + location + ", reg.getLocation().contains(location): " + reg.getLocation().contains(location.toString()));
                    if (reg.getDateExpires().isBeforeNow() || reg.getDateExpires().isEqualNow()) {
                        this.logger.debug("Registration: " + reg.getAddressOfRecord() + " expired");
                    }
                }
                String locationStored = this.getLocationWithoutParameters(regLocation);
                String locationToTest = this.getLocationWithoutParameters(location);
                if (locationStored != null && locationStored.equalsIgnoreCase(locationToTest)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Registration: " + reg.getLocation() + " failed to response to OPTIONS and will be removed");
                    }
                    regDao.removeRegistration(reg);
                    this.monitoringService.tell((Object)new UserRegistration(reg.getUserName(), reg.getLocation(), Boolean.valueOf(false), reg.getOrganizationSid()), this.self());
                    this.monitoringService.tell((Object)new GetCall(reg.getLocation()), this.self());
                    continue;
                }
                if (!this.logger.isDebugEnabled()) continue;
                String msg = String.format("Registration DID NOT removed. SIP Message location: %s, registration location (in DB) %s.", locationToTest, reg.getLocation());
                this.logger.debug(msg);
            }
        }
    }

    private String getLocationWithoutParameters(SipURI location) {
        String result = null;
        result = "sip:" + location.getUser() + "@" + location.getHost() + ":" + location.getPort();
        return result;
    }

    private void patch(SipURI uri, String address, int port) throws UnknownHostException {
        uri.setHost(address);
        uri.setPort(port);
    }

    private boolean permitted(String authorization, String method, SipURI sipURI) {
        Map<String, String> map = this.toMap(authorization);
        String user = map.get("username").trim();
        String algorithm = map.get("algorithm");
        String realm = map.get("realm");
        String uri = map.get("uri");
        String nonce = map.get("nonce");
        String nc = map.get("nc");
        String cnonce = map.get("cnonce");
        String qop = map.get("qop");
        String response = map.get("response");
        ClientsDao clients = this.storage.getClientsDao();
        Client client = clients.getClient(user, OrganizationUtil.getOrganizationSidBySipURIHost((DaoManager)this.storage, (SipURI)sipURI));
        if (client != null && 1 == client.getStatus()) {
            String password = client.getPassword();
            String result = DigestAuthentication.response((String)algorithm, (String)user, (String)realm, (String)password, (String)nonce, (String)nc, (String)cnonce, (String)method, (String)uri, null, (String)qop);
            return result.equals(response);
        }
        return false;
    }

    private void ping(String to) throws ServletException {
        SipApplicationSession application = this.factory.createApplicationSession();
        String toTransport = ((SipURI)this.factory.createURI(to)).getTransportParam();
        if (toTransport == null) {
            toTransport = "udp";
        }
        SipURI outboundInterface = this.outboundInterface(toTransport);
        StringBuilder buffer = new StringBuilder();
        buffer.append("sip:restcomm").append("@").append(outboundInterface.getHost());
        String from = buffer.toString();
        SipServletRequest ping = this.factory.createRequest(application, "OPTIONS", from, to);
        SipURI uri = (SipURI)this.factory.createURI(to);
        ping.pushRoute(uri);
        ping.setRequestURI((URI)uri);
        SipSession session = ping.getSession();
        session.setHandler("UserAgentManager");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("About to send OPTIONS keepalive to: " + to);
        }
        try {
            ping.send();
        }
        catch (IOException e) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("There was a problem while trying to ping client: " + to + " , will remove registration. " + e.getMessage());
            }
            this.removeRegistration((SipServletMessage)ping);
        }
    }

    private void pong(Object message) {
        SipServletResponse response;
        block6: {
            response = (SipServletResponse)message;
            if (response.getApplicationSession().isValid()) {
                try {
                    response.getApplicationSession().setInvalidateWhenReady(true);
                }
                catch (IllegalStateException ise) {
                    if (!this.logger.isDebugEnabled()) break block6;
                    this.logger.debug("The session was already invalidated, nothing to do");
                }
            }
        }
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        SipURI toUri = (SipURI)response.getTo().getURI();
        String location = "%" + toUri.getHost() + ":" + toUri.getPort();
        List registrationList = registrations.getRegistrationsByLocation(toUri.getUser(), location);
        if (registrationList != null && !registrationList.isEmpty()) {
            Registration registration = ((Registration)registrationList.get(0)).updated();
            registrations.updateRegistration(registration);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("UAM pong: Could not find any registration for %s Location %s", toUri.getUser(), location));
        }
    }

    private SipURI outboundInterface(String toTransport) {
        SipURI result = null;
        List uris = (List)this.servletContext.getAttribute("javax.servlet.sip.outboundInterfaces");
        for (SipURI uri : uris) {
            String transport = uri.getTransportParam();
            if (toTransport == null || !toTransport.equalsIgnoreCase(transport)) continue;
            result = uri;
        }
        return result;
    }

    private void register(Object message) throws Exception {
        String transport;
        SipServletRequest request = (SipServletRequest)message;
        Address contact = request.getAddressHeader("Contact");
        int ttl = contact.getExpires();
        if (ttl == -1) {
            String expires = request.getHeader("Expires");
            ttl = expires != null ? Integer.parseInt(expires) : 3600;
        }
        if (ttl > 3600) {
            ttl = 3600;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Register request received for contact: " + contact + ", and ttl: " + ttl);
        }
        String name = contact.getDisplayName();
        String ua = request.getHeader("User-Agent");
        SipURI to = (SipURI)request.getTo().getURI();
        String aor = to.toString();
        String user = to.getUser().trim();
        SipURI uri = (SipURI)contact.getURI();
        String ip = request.getInitialRemoteAddr();
        int port = request.getInitialRemotePort();
        String string = transport = uri.getTransportParam() == null ? request.getParameter("transport") : uri.getTransportParam();
        if (((SipURI)request.getRequestURI()).isSecure()) {
            transport = "tls";
        }
        if (transport == null && !request.getInitialTransport().equalsIgnoreCase("udp")) {
            transport = request.getInitialTransport();
        }
        boolean isLBPresent = false;
        String initialIpBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemoteAddr");
        String initialPortBeforeLB = request.getHeader("X-Sip-Balancer-InitialRemotePort");
        if (initialIpBeforeLB != null && !initialIpBeforeLB.isEmpty() && initialPortBeforeLB != null && !initialPortBeforeLB.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Client in front of LB. Patching URI: " + uri.toString() + " with IP: " + initialIpBeforeLB + " and PORT: " + initialPortBeforeLB + " for USER: " + user);
            }
            this.patch(uri, initialIpBeforeLB, Integer.valueOf(initialPortBeforeLB));
            isLBPresent = true;
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Patching URI: " + uri.toString() + " with IP: " + ip + " and PORT: " + port + " for USER: " + user);
            }
            this.patch(uri, ip, port);
        }
        String address = this.createAddress(request);
        SipServletResponse response = request.createResponse(200);
        Sid sid = Sid.generate((Sid.Type)Sid.Type.REGISTRATION);
        DateTime now = DateTime.now();
        if (name == null) {
            name = user;
        }
        if (ua == null) {
            ua = "GenericUA";
        }
        boolean webRTC = this.isWebRTC(transport, ua);
        Sid organizationSid = OrganizationUtil.getOrganizationSidBySipURIHost((DaoManager)this.storage, (SipURI)to);
        Registration registration = new Registration(sid, this.instanceId, now, now, aor, name, user, ua, ttl, address, webRTC, isLBPresent, organizationSid);
        RegistrationsDao registrations = this.storage.getRegistrationsDao();
        if (ttl == 0) {
            registrations.removeRegistration(registration);
            response.setHeader("Expires", "0");
            this.monitoringService.tell((Object)new UserRegistration(user, address, Boolean.valueOf(false), organizationSid), this.self());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("The user agent manager unregistered " + user + " at address " + address + ":" + port);
            }
        } else {
            this.monitoringService.tell((Object)new UserRegistration(user, address, Boolean.valueOf(true), organizationSid), this.self());
            if (registrations.hasRegistration(registration)) {
                registrations.updateRegistration(registration);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("The user agent manager updated " + user + " at address " + address + ":" + port);
                }
            } else {
                registrations.addRegistration(registration);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("The user agent manager registered " + user + " at address " + address + ":" + port);
                }
            }
            response.setHeader("Contact", this.contact(uri, ttl));
        }
        response.send();
        try {
            if (request != null) {
                if (request.getApplicationSession() != null) {
                    if (request.getApplicationSession().isValid()) {
                        try {
                            request.getApplicationSession().setInvalidateWhenReady(true);
                        }
                        catch (IllegalStateException exception) {
                            this.logger.warning("Illegal State: while trying to setInvalidateWhenReady(true) for application session, message: " + exception.getMessage());
                        }
                    }
                } else if (this.logger.isInfoEnabled()) {
                    this.logger.info("After sent response: " + response.toString() + " for Register request, application session is NULL!");
                }
            } else if (this.logger.isInfoEnabled()) {
                this.logger.info("After sent response: " + response.toString() + " for Register request, request is NULL!");
            }
        }
        catch (Exception e) {
            this.logger.error("Exception while trying to setInvalidateWhenReady(true) after sent response to register : " + response.toString() + " exception: " + e);
        }
    }

    private String createAddress(SipServletRequest request) throws ServletParseException {
        String transport;
        Address contact = request.getAddressHeader("Contact");
        SipURI uri = (SipURI)contact.getURI();
        SipURI to = (SipURI)request.getTo().getURI();
        String user = to.getUser().trim();
        String string = transport = uri.getTransportParam() == null ? request.getParameter("transport") : uri.getTransportParam();
        if (((SipURI)request.getRequestURI()).isSecure()) {
            transport = "tls";
        }
        if (transport == null && !request.getInitialTransport().equalsIgnoreCase("udp")) {
            transport = request.getInitialTransport();
        }
        StringBuffer buffer = new StringBuffer();
        if (((SipURI)request.getRequestURI()).isSecure()) {
            buffer.append("sips:");
        } else {
            buffer.append("sip:");
        }
        buffer.append(this.normalize(user)).append("@").append(uri.getHost()).append(":").append(uri.getPort());
        if (transport != null) {
            buffer.append(";transport=").append(transport);
        }
        Iterator extraParameterNames = uri.getParameterNames();
        while (extraParameterNames.hasNext()) {
            String paramName = (String)extraParameterNames.next();
            if (paramName.equalsIgnoreCase("transport")) continue;
            String paramValue = uri.getParameter(paramName);
            buffer.append(";");
            buffer.append(paramName);
            buffer.append("=");
            buffer.append(paramValue);
        }
        return buffer.toString();
    }

    private boolean isWebRTC(String transport, String userAgent) {
        return "ws".equalsIgnoreCase(transport) || "wss".equalsIgnoreCase(transport) || userAgent.toLowerCase().contains("restcomm");
    }

    private String contact(SipURI uri, int expires) {
        Address contact = this.factory.createAddress((URI)uri);
        contact.setExpires(expires);
        return contact.toString();
    }

    private Map<String, String> toMap(String header) {
        String[] tokens;
        HashMap<String, String> map = new HashMap<String, String>();
        int endOfScheme = header.indexOf(" ");
        map.put("scheme", header.substring(0, endOfScheme).trim());
        for (String token : tokens = header.substring(endOfScheme + 1).split(",")) {
            String[] values = token.trim().split("=", 2);
            map.put(values[0].toLowerCase(), values[1].replace("\"", ""));
        }
        return map;
    }

    private void proxyResponseFromIms(Object message, SipServletResponse response) throws ServletParseException, IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("REGISTER IMS Response received: " + message);
        }
        SipServletRequest incomingRequest = (SipServletRequest)response.getApplicationSession().getAttribute(REQ_PARAMETER);
        String wwwAuthenticate = response.getHeader("WWW-Authenticate");
        Address contact = incomingRequest.getAddressHeader("Contact");
        SipURI uri = (SipURI)contact.getURI();
        String ip = incomingRequest.getInitialRemoteAddr();
        int port = incomingRequest.getInitialRemotePort();
        String ua = incomingRequest.getHeader("User-Agent");
        String name = contact.getDisplayName();
        SipURI to = (SipURI)incomingRequest.getTo().getURI();
        String aor = to.toString();
        String user = to.getUser();
        boolean isLBPresent = false;
        String initialIpBeforeLB = incomingRequest.getHeader("X-Sip-Balancer-InitialRemoteAddr");
        String initialPortBeforeLB = incomingRequest.getHeader("X-Sip-Balancer-InitialRemotePort");
        if (initialIpBeforeLB != null && !initialIpBeforeLB.isEmpty() && initialPortBeforeLB != null && !initialPortBeforeLB.isEmpty()) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Client in front of LB. Patching URI: " + uri.toString() + " with IP: " + initialIpBeforeLB + " and PORT: " + initialPortBeforeLB + " for USER: " + user);
            }
            this.patch(uri, initialIpBeforeLB, Integer.valueOf(initialPortBeforeLB));
            isLBPresent = true;
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Patching URI: " + uri.toString() + " with IP: " + ip + " and PORT: " + port + " for USER: " + user);
            }
            this.patch(uri, ip, port);
        }
        SipServletResponse incomingLegResposne = incomingRequest.createResponse(response.getStatus(), response.getReasonPhrase());
        if (wwwAuthenticate != null) {
            incomingLegResposne.addHeader("WWW-Authenticate", wwwAuthenticate);
        }
        int ttl = 3600;
        Address imsContact = response.getAddressHeader("Contact");
        if (imsContact != null) {
            ttl = imsContact.getExpires();
            if (ttl == -1) {
                String expires = response.getRequest().getHeader("Expires");
                ttl = expires != null ? Integer.parseInt(expires) : 3600;
            }
            SipURI sipURI = (SipURI)contact.getURI();
            String newContact = this.contact(sipURI, ttl);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("ttl: " + ttl);
                this.logger.info("new contact: " + newContact);
            }
            incomingLegResposne.setHeader("Contact", newContact);
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("outgoing leg state: " + response.getSession().getState());
            this.logger.info("incoming leg state: " + incomingLegResposne.getSession().getState());
        }
        if (response.getStatus() >= 400 && response.getStatus() != 401 && response.getStatus() != 407) {
            this.removeRegistration((SipServletMessage)incomingRequest, true);
        } else if (response.getStatus() == 200) {
            String transport;
            String string = transport = uri.getTransportParam() == null ? incomingRequest.getParameter("transport") : uri.getTransportParam();
            if (transport == null && !incomingRequest.getInitialTransport().equalsIgnoreCase("udp")) {
                transport = incomingRequest.getInitialTransport();
            }
            Sid sid = Sid.generate((Sid.Type)Sid.Type.REGISTRATION);
            DateTime now = DateTime.now();
            StringBuffer buffer = new StringBuffer();
            buffer.append("sip:").append(this.normalize(user)).append("@").append(uri.getHost()).append(":").append(uri.getPort());
            if (transport != null) {
                buffer.append(";transport=").append(transport);
            }
            String address = buffer.toString();
            if (name == null) {
                name = user;
            }
            if (ua == null) {
                ua = "GenericUA";
            }
            boolean webRTC = this.isWebRTC(transport, ua);
            Sid organizationSid = OrganizationUtil.getOrganizationSidBySipURIHost((DaoManager)this.storage, (SipURI)to);
            Registration registration = new Registration(sid, RestcommConfiguration.getInstance().getMain().getInstanceId(), now, now, aor, name, user, ua, ttl, address, webRTC, isLBPresent, organizationSid);
            RegistrationsDao registrations = this.storage.getRegistrationsDao();
            if (ttl == 0) {
                registrations.removeRegistration(registration);
                incomingLegResposne.setHeader("Expires", "0");
                this.monitoringService.tell((Object)new UserRegistration(user, address, Boolean.valueOf(false), organizationSid), this.self());
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("The user agent manager unregistered " + user + " at address " + address + ":" + port);
                }
            } else {
                this.monitoringService.tell((Object)new UserRegistration(user, address, Boolean.valueOf(true), organizationSid), this.self());
                if (registrations.hasRegistration(registration)) {
                    registrations.updateRegistration(registration);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("The user agent manager updated " + user + " at address " + address + ":" + port);
                    }
                } else {
                    registrations.addRegistration(registration);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("The user agent manager registered " + user + " at address " + address + ":" + port);
                    }
                }
            }
        }
        incomingLegResposne.send();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("REGISTER IMS Response sent: " + incomingLegResposne);
        }
    }

    private String normalize(String user) {
        if (user != null && user.contains("@")) {
            user = user.replaceAll("@", "%40");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Normalized User = " + user);
        }
        return user;
    }

    private void proxyRequestToIms(SipServletRequest request) throws ServletParseException, IOException {
        SipServletRequest outgoingRequest = this.factory.createRequest(request, true);
        Parameterable via = outgoingRequest.getParameterableHeader("Via");
        if (via == null) {
            this.seltLocalContact(outgoingRequest);
        } else {
            String[] strings = via.getValue().trim().split(" ");
            if (strings.length != 2) {
                this.seltLocalContact(outgoingRequest);
            } else {
                outgoingRequest.removeHeader("Contact");
                String addressFromVia = strings[1].trim();
                Address address = this.factory.createAddress("sip:" + addressFromVia);
                outgoingRequest.setAddressHeader("Contact", address);
            }
        }
        request.getApplicationSession().setAttribute(REQ_PARAMETER, (Object)request);
        SipURI routeToRegistrar = this.factory.createSipURI(null, this.imsProxyAddress);
        routeToRegistrar.setLrParam(true);
        routeToRegistrar.setPort(this.imsProxyPort);
        outgoingRequest.pushRoute(routeToRegistrar);
        SipURI requestUri = this.factory.createSipURI(null, this.imsDomain);
        outgoingRequest.setRequestURI((URI)requestUri);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Sending to ims proxy: " + outgoingRequest);
        }
        outgoingRequest.send();
    }

    private void seltLocalContact(SipServletRequest outgoingRequest) throws ServletParseException {
        Address contact = outgoingRequest.getAddressHeader("Contact");
        SipURI sipURI = (SipURI)contact.getURI();
        sipURI.setPort(outgoingRequest.getLocalPort());
        sipURI.setHost(outgoingRequest.getLocalAddr());
    }

    public void postStop() {
        block4: {
            try {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("UserAgentManager actor at postStop, path: " + this.self().path() + ", isTerminated: " + this.self().isTerminated() + ", sender: " + this.sender());
                    if (this.storage != null) {
                        this.logger.info("Number of current Registrations:" + this.storage.getRegistrationsDao().getRegistrations().size());
                    }
                }
            }
            catch (Exception exception) {
                if (!this.logger.isInfoEnabled()) break block4;
                this.logger.info("Exception during UserAgentManager postStop");
            }
        }
        super.postStop();
    }
}

