/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.connect.tts.voicerss;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.event.Logging;
import akka.event.LoggingAdapter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.restcomm.connect.commons.cache.HashGenerator;
import org.restcomm.connect.commons.faulttolerance.RestcommUntypedActor;
import org.restcomm.connect.tts.api.GetSpeechSynthesizerInfo;
import org.restcomm.connect.tts.api.SpeechSynthesizerException;
import org.restcomm.connect.tts.api.SpeechSynthesizerInfo;
import org.restcomm.connect.tts.api.SpeechSynthesizerRequest;
import org.restcomm.connect.tts.api.SpeechSynthesizerResponse;

public final class VoiceRSSSpeechSynthesizer
extends RestcommUntypedActor {
    private final LoggingAdapter logger = Logging.getLogger((ActorSystem)this.getContext().system(), (Object)((Object)this));
    private static final List<NameValuePair> parameters = new ArrayList<NameValuePair>();
    private final URI service;
    private final Map<String, String> men;

    public VoiceRSSSpeechSynthesizer(Configuration configuration) {
        String apiKey = configuration.getString("apikey");
        BasicNameValuePair apiNameValuePair = new BasicNameValuePair("key", apiKey);
        if (!parameters.contains(apiNameValuePair)) {
            parameters.add((NameValuePair)apiNameValuePair);
        }
        this.service = URI.create(configuration.getString("service-root"));
        this.men = new HashMap<String, String>();
        this.load(configuration);
    }

    private SpeechSynthesizerInfo info() {
        return new SpeechSynthesizerInfo(this.men.keySet());
    }

    private void load(Configuration configuration) throws RuntimeException {
        this.men.put("ca", configuration.getString("languages.catalan"));
        this.men.put("zh-cn", configuration.getString("languages.chinese-china"));
        this.men.put("zh-hk", configuration.getString("languages.chinese-hongkong"));
        this.men.put("zh-tw", configuration.getString("languages.chinese-taiwan"));
        this.men.put("da", configuration.getString("languages.danish"));
        this.men.put("nl", configuration.getString("languages.dutch"));
        this.men.put("en-au", configuration.getString("languages.english-australia"));
        this.men.put("en-ca", configuration.getString("languages.english-canada"));
        this.men.put("en-gb", configuration.getString("languages.english-greatbritain"));
        this.men.put("en-in", configuration.getString("languages.english-india"));
        this.men.put("en", configuration.getString("languages.english-us"));
        this.men.put("fi", configuration.getString("languages.finish"));
        this.men.put("fr-ca", configuration.getString("languages.french-canada"));
        this.men.put("fr", configuration.getString("languages.french-france"));
        this.men.put("de", configuration.getString("languages.german"));
        this.men.put("it", configuration.getString("languages.italina"));
        this.men.put("ja", configuration.getString("languages.japanese"));
        this.men.put("ko", configuration.getString("languages.korean"));
        this.men.put("nb", configuration.getString("languages.norwegian"));
        this.men.put("pl", configuration.getString("languages.polish"));
        this.men.put("pt-br", configuration.getString("languages.portuguese-brasil"));
        this.men.put("pt", configuration.getString("languages.portuguese-portugal"));
        this.men.put("ru", configuration.getString("languages.russian"));
        this.men.put("es-mx", configuration.getString("languages.spanish-mexico"));
        this.men.put("es", configuration.getString("languages.spanish-spain"));
        this.men.put("sv", configuration.getString("languages.swedish"));
    }

    public void onReceive(Object message) throws Exception {
        block6: {
            Class<?> klass = message.getClass();
            ActorRef self = this.self();
            ActorRef sender = this.sender();
            if (SpeechSynthesizerRequest.class.equals(klass)) {
                try {
                    URI uri = this.synthesize(message);
                    if (sender != null) {
                        sender.tell((Object)new SpeechSynthesizerResponse((Object)uri), self);
                    }
                    break block6;
                }
                catch (Exception exception) {
                    this.logger.error("There was an exception while trying to synthesize message: " + exception);
                    if (sender != null) {
                        sender.tell((Object)new SpeechSynthesizerResponse((Throwable)exception), self);
                    }
                    break block6;
                }
            }
            if (GetSpeechSynthesizerInfo.class.equals(klass)) {
                sender.tell((Object)new SpeechSynthesizerResponse((Object)this.info()), self);
            }
        }
    }

    private String getLanguage(String language) {
        String languageCode = this.men.get(language);
        return languageCode;
    }

    private URI synthesize(Object message) throws IOException, SpeechSynthesizerException {
        SpeechSynthesizerRequest request = (SpeechSynthesizerRequest)message;
        String gender = request.gender();
        String language = request.language();
        String text = request.text();
        if (language == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("There is no suitable speaker to synthesize " + request.language());
            }
            throw new IllegalArgumentException("There is no suitable language to synthesize " + request.language());
        }
        String hash = HashGenerator.hashMessage((String)gender, (String)language, (String)text);
        ArrayList<Object> query = new ArrayList<Object>();
        query.addAll(parameters);
        query.add(new BasicNameValuePair("hl", this.getLanguage(language)));
        query.add(new BasicNameValuePair("src", text));
        HttpPost post = new HttpPost(this.service);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(query, "UTF-8");
        post.setEntity((HttpEntity)entity);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpResponse response = client.execute((HttpUriRequest)post);
        StatusLine line = response.getStatusLine();
        int status = line.getStatusCode();
        if (status == 200) {
            int len;
            Header[] contentType = response.getHeaders("Content-Type");
            if (contentType[0].getValue().startsWith("text")) {
                StringBuilder buffer = new StringBuilder();
                String error = EntityUtils.toString((HttpEntity)response.getEntity());
                this.logger.error("VoiceRSSSpeechSynthesizer error: " + error);
                buffer.append(error);
                throw new SpeechSynthesizerException(buffer.toString());
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("VoiceRSSSpeechSynthesizer success!");
            }
            InputStream is = response.getEntity().getContent();
            File file = new File(System.getProperty("java.io.tmpdir") + File.separator + hash + ".wav");
            FileOutputStream ostream = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) > 0) {
                ((OutputStream)ostream).write(buffer, 0, len);
            }
            ((OutputStream)ostream).close();
            is.close();
            return file.toURI();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("VoiceRSSSpeechSynthesizer error, status code: " + line.getStatusCode() + " reason phrase: " + line.getReasonPhrase());
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(line.getStatusCode()).append(" ").append(line.getReasonPhrase());
        throw new SpeechSynthesizerException(buffer.toString());
    }

    static {
        parameters.add((NameValuePair)new BasicNameValuePair("c", "WAV"));
        parameters.add((NameValuePair)new BasicNameValuePair("f", "8khz_16bit_mono"));
    }
}

