/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.examples;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import java.util.function.Consumer;
import java.util.function.Function;
import org.restheart.examples.FormRequest;
import org.restheart.exchange.JsonResponse;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.Service;
import org.restheart.utils.GsonUtils;

@RegisterPlugin(name="formHandler", description="handle a form post using FormDataParser")
public class FormHandler
implements Service<FormRequest, JsonResponse> {
    public void handle(FormRequest req, JsonResponse res) {
        switch (req.getMethod()) {
            case POST: {
                GsonUtils.ObjectBuilder out = GsonUtils.object();
                FormData formData = (FormData)req.getContent();
                formData.forEach(field -> out.put(field, formData.getFirst(field).getValue()));
                res.setContent(out);
                break;
            }
            case OPTIONS: {
                this.handleOptions(req);
                break;
            }
            default: {
                res.setStatusCode(405);
            }
        }
    }

    public Consumer<HttpServerExchange> requestInitializer() {
        return e -> FormRequest.init(e);
    }

    public Consumer<HttpServerExchange> responseInitializer() {
        return e -> JsonResponse.init((HttpServerExchange)e);
    }

    public Function<HttpServerExchange, FormRequest> request() {
        return e -> FormRequest.of(e);
    }

    public Function<HttpServerExchange, JsonResponse> response() {
        return e -> JsonResponse.of((HttpServerExchange)e);
    }
}

