/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.examples;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import java.io.IOException;
import org.restheart.exchange.ServiceRequest;

class FormRequest
extends ServiceRequest<FormData> {
    private static FormParserFactory builder = FormParserFactory.builder().build();

    private FormRequest(HttpServerExchange exchange) {
        super(exchange);
    }

    public static FormRequest init(HttpServerExchange exchange) {
        FormRequest ret = new FormRequest(exchange);
        try {
            ret.injectContent();
        }
        catch (Throwable ieo) {
            ret.setInError(true);
        }
        return ret;
    }

    public static FormRequest of(HttpServerExchange exchange) {
        return (FormRequest)FormRequest.of((HttpServerExchange)exchange, FormRequest.class);
    }

    public void injectContent() throws IOException {
        FormDataParser parser = builder.createParser(this.getExchange());
        if (parser == null) {
            throw new IOException("Not a form.");
        }
        this.setContent(parser.parseBlocking());
    }
}

