/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.examples;

import org.bson.BsonValue;
import org.bson.json.JsonMode;
import org.restheart.examples.ContactPostReply;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.MongoInterceptor;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.utils.BsonUtils;
import org.restheart.utils.LambdaUtils;

@RegisterPlugin(name="bsonToProtobuf", description="Transforms the BSON response to protobuf", interceptPoint=InterceptPoint.RESPONSE, requiresContent=true)
public class BsonToProtobuf
implements MongoInterceptor {
    public void handle(MongoRequest request, MongoResponse response) throws Exception {
        String id = BsonUtils.toJson((BsonValue)response.getDbOperationResult().getNewId(), (JsonMode)JsonMode.RELAXED);
        ContactPostReply.Builder builder = ContactPostReply.newBuilder().setId(id);
        response.setCustomSender(() -> {
            try {
                response.getExchange().getResponseSender().send(builder.build().toByteString().toStringUtf8());
            }
            catch (Throwable t) {
                LambdaUtils.throwsSneakyException((Throwable)t);
            }
        });
    }

    public boolean resolve(MongoRequest request, MongoResponse response) {
        return request.isPost() && "/proto".equals(request.getPath()) && response.getDbOperationResult() != null && response.getDbOperationResult().getNewId() != null;
    }
}

