/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.examples;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.undertow.server.HttpServerExchange;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.examples.ContactPostRequest;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.ServiceRequest;
import org.restheart.exchange.ServiceResponse;
import org.restheart.exchange.UninitializedRequest;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.WildcardInterceptor;
import org.restheart.utils.BsonUtils;
import org.restheart.utils.MongoServiceAttachments;

@RegisterPlugin(name="protobufToBson", description="Transforms the protobuf request to BSON", interceptPoint=InterceptPoint.REQUEST_BEFORE_EXCHANGE_INIT, requiresContent=true)
public class ProtobufToBson
implements WildcardInterceptor {
    public void handle(ServiceRequest<?> request, ServiceResponse<?> response) throws Exception {
        UninitializedRequest uninitializedRequest = (UninitializedRequest)request;
        uninitializedRequest.setCustomRequestInitializer(e -> {
            try {
                ContactPostRequest protobufReq = ContactPostRequest.parseFrom(uninitializedRequest.getRawContent());
                MongoServiceAttachments.attachBsonContent((HttpServerExchange)request.getExchange(), (BsonValue)this.decode((AbstractMessage)protobufReq));
            }
            catch (Throwable ex) {
                MongoRequest r = MongoRequest.init((HttpServerExchange)e, (String)"/proto", (String)"/restheart/contacts");
                r.setInError(true);
            }
            MongoRequest.init((HttpServerExchange)e, (String)"/proto", (String)"/restheart/contacts");
        });
    }

    public boolean resolve(ServiceRequest<?> request, ServiceResponse<?> response) {
        return request instanceof UninitializedRequest && request.isPost() && "application/protobuf".equals(request.getContentType()) && "/proto".equals(request.getPath());
    }

    private BsonDocument decode(AbstractMessage message) throws InvalidProtocolBufferException {
        String json = JsonFormat.printer().print((MessageOrBuilder)message);
        return BsonUtils.parse((String)json).asDocument();
    }
}

