/*
 * Decompiled with CFR 0.152.
 */
package org.restheart;

import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger LOGGER = LoggerFactory.getLogger(Version.class);
    private final String version = Version.class.getPackage().getImplementationVersion() == null ? null : Version.class.getPackage().getImplementationVersion();
    private final Instant buildTime = this.extractBuildTime();

    public static Version getInstance() {
        return VersionHolder.INSTANCE;
    }

    private Version() {
    }

    public String getVersion() {
        return this.version;
    }

    public Instant getBuildTime() {
        return this.buildTime;
    }

    private Instant extractBuildTime() {
        Set<Map.Entry<Object, Object>> MANIFEST_ENTRIES = Version.findManifestInfo();
        return MANIFEST_ENTRIES == null ? Instant.now() : MANIFEST_ENTRIES.stream().filter(e -> e.getKey().toString().equals("Build-Time")).map(e -> (String)e.getValue()).filter(d -> d != null).map(d -> {
            try {
                return Instant.parse(d);
            }
            catch (Throwable t) {
                return Instant.now();
            }
        }).findFirst().orElse(Instant.now());
    }

    private static Set<Map.Entry<Object, Object>> findManifestInfo() {
        Set<Map.Entry<Object, Object>> result = null;
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL manifestUrl = resources.nextElement();
                Manifest manifest = new Manifest(manifestUrl.openStream());
                Attributes mainAttributes = manifest.getMainAttributes();
                String implementationTitle = mainAttributes.getValue("Implementation-Title");
                if (implementationTitle == null || !implementationTitle.toLowerCase().startsWith("restheart")) continue;
                result = mainAttributes.entrySet();
                break;
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
        return result;
    }

    private static class VersionHolder {
        private static final Version INSTANCE = new Version();

        private VersionHolder() {
        }
    }
}

