/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.cache;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.restheart.cache.Cache;
import org.restheart.cache.LoadingCache;
import org.restheart.cache.impl.CaffeineCache;
import org.restheart.cache.impl.CaffeineLoadingCache;
import org.restheart.cache.impl.HashMapLoadingCache;

public class CacheFactory {
    public static <K, V> LoadingCache<K, V> createLocalLoadingCache(long size, Cache.EXPIRE_POLICY expirePolicy, long ttl, Function<K, V> loader) {
        return new CaffeineLoadingCache<K, V>(size, expirePolicy, ttl, loader);
    }

    public static <K, V> LoadingCache<K, V> createHashMapLoadingCache(Function<K, V> loader) {
        return new HashMapLoadingCache<K, V>(loader);
    }

    public static <K, V> Cache<K, V> createLocalCache(long size, Cache.EXPIRE_POLICY expirePolicy, long ttl) {
        return new CaffeineCache(size, expirePolicy, ttl);
    }

    public static <K, V> Cache<K, V> createLocalCache(long size, Cache.EXPIRE_POLICY expirePolicy, long ttl, Consumer<Map.Entry<K, Optional<V>>> remover) {
        return new CaffeineCache<K, V>(size, expirePolicy, ttl, remover);
    }

    private CacheFactory() {
    }
}

