/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.cache.impl;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.restheart.cache.Cache;

public class CaffeineCache<K, V>
implements Cache<K, V> {
    private final com.github.benmanes.caffeine.cache.Cache<K, Optional<V>> wrapped;

    public CaffeineCache(long size, Cache.EXPIRE_POLICY expirePolicy, long ttl) {
        Caffeine builder = Caffeine.newBuilder();
        builder.maximumSize(size);
        if (ttl > 0L && expirePolicy == Cache.EXPIRE_POLICY.AFTER_WRITE) {
            builder.expireAfterWrite(ttl, TimeUnit.MILLISECONDS);
        } else if (ttl > 0L && expirePolicy == Cache.EXPIRE_POLICY.AFTER_READ) {
            builder.expireAfterAccess(ttl, TimeUnit.MILLISECONDS);
        }
        this.wrapped = builder.build();
    }

    public CaffeineCache(long size, Cache.EXPIRE_POLICY expirePolicy, long ttl, Consumer<Map.Entry<K, Optional<V>>> remover) {
        Caffeine builder = Caffeine.newBuilder();
        builder.maximumSize(size);
        if (ttl > 0L && expirePolicy == Cache.EXPIRE_POLICY.AFTER_WRITE) {
            builder.expireAfterWrite(ttl, TimeUnit.MILLISECONDS);
        } else if (ttl > 0L && expirePolicy == Cache.EXPIRE_POLICY.AFTER_READ) {
            builder.expireAfterAccess(ttl, TimeUnit.MILLISECONDS);
        }
        this.wrapped = builder.removalListener((k, v, cause) -> remover.accept(new AbstractMap.SimpleEntry<Object, Optional>(k, (Optional)v))).build();
    }

    @Override
    public Optional<V> get(K key) {
        return (Optional)this.wrapped.getIfPresent(key);
    }

    @Override
    public synchronized Optional<V> remove(K key) {
        Optional ret = (Optional)this.wrapped.getIfPresent(key);
        this.wrapped.invalidate(key);
        return ret;
    }

    @Override
    public void put(K key, V value) {
        this.wrapped.put(key, Optional.ofNullable(value));
    }

    @Override
    public void invalidate(K key) {
        this.wrapped.invalidate(key);
    }

    @Override
    public void invalidateAll() {
        this.wrapped.invalidateAll();
    }

    @Override
    public Map<K, Optional<V>> asMap() {
        return this.wrapped.asMap();
    }

    @Override
    public void cleanUp() {
        this.wrapped.cleanUp();
    }
}

