/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.cache.impl;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.restheart.cache.Cache;
import org.restheart.cache.LoadingCache;

public class CaffeineLoadingCache<K, V>
implements LoadingCache<K, V> {
    private final com.github.benmanes.caffeine.cache.LoadingCache<K, Optional<V>> wrapped;

    public CaffeineLoadingCache(long size, Cache.EXPIRE_POLICY expirePolicy, long ttl, final Function<K, V> loader) {
        Caffeine builder = Caffeine.newBuilder();
        builder.maximumSize(size);
        if (ttl > 0L && expirePolicy == Cache.EXPIRE_POLICY.AFTER_WRITE) {
            builder.expireAfterWrite(ttl, TimeUnit.MILLISECONDS);
        } else if (ttl > 0L && expirePolicy == Cache.EXPIRE_POLICY.AFTER_READ) {
            builder.expireAfterAccess(ttl, TimeUnit.MILLISECONDS);
        }
        this.wrapped = builder.build(new CacheLoader<K, Optional<V>>(){

            public Optional<V> load(K key) throws Exception {
                return Optional.ofNullable(loader.apply(key));
            }

            public Map<? extends K, ? extends Optional<V>> loadAll(Set<? extends K> keys) throws Exception {
                HashMap ret = new HashMap();
                keys.stream().forEachOrdered(key -> ret.put(key, Optional.ofNullable(loader.apply(key))));
                return ret;
            }
        });
    }

    @Override
    public Optional<V> get(K key) {
        return (Optional)this.wrapped.getIfPresent(key);
    }

    @Override
    public synchronized Optional<V> remove(K key) {
        Optional ret = (Optional)this.wrapped.getIfPresent(key);
        this.wrapped.invalidate(key);
        return ret;
    }

    @Override
    public Optional<V> getLoading(K key) {
        return (Optional)this.wrapped.get(key);
    }

    @Override
    public void put(K key, V value) {
        this.wrapped.put(key, Optional.ofNullable(value));
    }

    @Override
    public void invalidate(K key) {
        this.wrapped.invalidate(key);
    }

    @Override
    public void invalidateAll() {
        this.wrapped.invalidateAll();
    }

    @Override
    public Map<K, Optional<V>> asMap() {
        return this.wrapped.asMap();
    }

    @Override
    public void cleanUp() {
        this.wrapped.cleanUp();
    }
}

