/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.cache.impl;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.restheart.cache.LoadingCache;

public class HashMapLoadingCache<K, V>
implements LoadingCache<K, V> {
    private final HashMap<K, Optional<V>> wrapped = Maps.newHashMap();
    private final Function<K, V> loader;

    public HashMapLoadingCache(Function<K, V> loader) {
        this.loader = loader;
    }

    @Override
    public Optional<V> get(K key) {
        return this.wrapped.get(key);
    }

    @Override
    public Optional<V> remove(K key) {
        return this.wrapped.remove(key);
    }

    @Override
    public Optional<V> getLoading(K key) {
        if (this.wrapped.containsKey(key)) {
            return this.get(key);
        }
        Optional<V> value = Optional.ofNullable(this.loader.apply(key));
        this.wrapped.put(key, value);
        return value;
    }

    @Override
    public void put(K key, V value) {
        this.wrapped.put(key, Optional.ofNullable(value));
    }

    @Override
    public void invalidate(K key) {
        this.wrapped.remove(key);
    }

    @Override
    public void invalidateAll() {
        this.wrapped.clear();
    }

    @Override
    public Map<K, Optional<V>> asMap() {
        return this.wrapped;
    }

    @Override
    public void cleanUp() {
    }
}

