/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.configuration;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mongodb.ConnectionString;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.jxpath.JXPathContext;
import org.restheart.configuration.ConfigurationException;
import org.restheart.configuration.CoreModule;
import org.restheart.configuration.Listener;
import org.restheart.configuration.Logging;
import org.restheart.configuration.ProxiedResource;
import org.restheart.configuration.StaticResource;
import org.restheart.configuration.TLSListener;
import org.restheart.configuration.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class Configuration {
    private static final String LOG_PATTERN = "\t{} -> {}";
    private static final String MASK = "**********";
    private static final String LOCALHOST = "localhost";
    public static final String VERSION = Configuration.class.getPackage().getImplementationVersion() == null ? "unknown, not packaged" : Configuration.class.getPackage().getImplementationVersion();
    static final Logger LOGGER = LoggerFactory.getLogger(Configuration.class);
    public static final String DEFAULT_ROUTE = "0.0.0.0";
    private static Path PATH = null;
    private static final Listener DEFAULT_HTTP_LISTENER = new Listener(true, "localhost", 8080);
    private static final TLSListener DEFAULT_HTTPS_LISTENER = new TLSListener(false, "localhost", 4443, null, null, null);
    private static final Listener DEFAULT_AJP_LISTENER = new Listener(false, "localhost", 8009);
    public static final String CONNECTION_OPTIONS_KEY = "connection-options";
    private final Listener httpListener;
    private final Listener ajpListener;
    private final TLSListener httpsListener;
    private final List<ProxiedResource> proxies;
    private final List<StaticResource> staticResources;
    private final CoreModule coreModule;
    private final Logging logging;
    private final Map<String, Object> connectionOptions;
    private final Map<String, Object> conf;

    private Configuration(Map<String, Object> conf, Path confFilePath, boolean silent) throws ConfigurationException {
        PATH = confFilePath;
        this.conf = conf;
        this.coreModule = CoreModule.build(conf, silent);
        this.httpListener = Utils.findOrDefault(conf, "http-listener", null, true) != null ? new Listener(conf, "http-listener", DEFAULT_HTTP_LISTENER, silent) : DEFAULT_HTTP_LISTENER;
        this.httpsListener = Utils.findOrDefault(conf, "https-listener", null, true) != null ? new TLSListener(conf, "https-listener", DEFAULT_HTTPS_LISTENER, silent) : DEFAULT_HTTPS_LISTENER;
        this.ajpListener = Utils.findOrDefault(conf, "ajp-listener", null, true) != null ? new Listener(conf, "ajp-listener", DEFAULT_AJP_LISTENER, silent) : DEFAULT_AJP_LISTENER;
        this.proxies = ProxiedResource.build(conf, silent);
        this.staticResources = StaticResource.build(conf, silent);
        this.logging = Logging.build(conf, silent);
        this.connectionOptions = Utils.asMap(conf, CONNECTION_OPTIONS_KEY, null, silent);
    }

    public String toString() {
        DumperOptions dumpOpts = new DumperOptions();
        dumpOpts.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumpOpts.setPrettyFlow(true);
        dumpOpts.setIndent(2);
        dumpOpts.setCanonical(false);
        dumpOpts.setExplicitStart(true);
        StringWriter sw = new StringWriter();
        new Yaml(dumpOpts).dump(this.conf, (Writer)sw);
        return sw.toString();
    }

    public <V> V getOrDefault(String key, V defaultValue) {
        return Utils.getOrDefault(this, key, defaultValue, true);
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.conf);
    }

    public CoreModule coreModule() {
        return this.coreModule;
    }

    public List<ProxiedResource> getProxies() {
        return Collections.unmodifiableList(this.proxies);
    }

    public List<StaticResource> getStaticResources() {
        return Collections.unmodifiableList(this.staticResources);
    }

    public Listener httpListener() {
        return this.httpListener;
    }

    public TLSListener httpsListener() {
        return this.httpsListener;
    }

    public Listener ajpListener() {
        return this.ajpListener;
    }

    public Level getLogLevel() {
        String logbackConfigurationFile = System.getProperty("logback.configurationFile");
        if (logbackConfigurationFile != null && !logbackConfigurationFile.isEmpty()) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            ch.qos.logback.classic.Logger logger = loggerContext.getLogger("org.restheart");
            return logger.getLevel();
        }
        return this.logging.logLevel();
    }

    public Logging logging() {
        return this.logging;
    }

    public Map<String, Object> getConnectionOptions() {
        return Collections.unmodifiableMap(this.connectionOptions);
    }

    public static Path getPath() {
        return PATH;
    }

    private static String fromJsonToRho(Reader jsonReader) throws JsonParseException {
        Gson gson = new GsonBuilder().setLenient().create();
        JsonObject _json = (JsonObject)gson.fromJson(jsonReader, JsonObject.class);
        if (_json == null || !_json.isJsonObject()) {
            throw new JsonParseException("json is not an object");
        }
        JsonObject obj = _json.getAsJsonObject();
        return obj.entrySet().stream().map(e -> (String)e.getKey() + "->" + ((JsonElement)e.getValue()).toString()).collect(Collectors.joining(";"));
    }

    private static String fromYmlToRho(Reader yml) throws JsonParseException {
        Map _yml = (Map)new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(yml);
        if (_yml == null) {
            throw new JsonParseException("json is not an object");
        }
        Gson gson = new GsonBuilder().serializeNulls().create();
        return _yml.entrySet().stream().map(e -> (String)e.getKey() + "->" + gson.toJson(e.getValue())).collect(Collectors.joining(";"));
    }

    private static Map<String, Object> overrideConfiguration(Map<String, Object> confMap, List<Utils.RhOverride> overrides, boolean silent) {
        JXPathContext ctx = JXPathContext.newContext(confMap);
        ctx.setLenient(true);
        overrides.stream().forEachOrdered(o -> {
            if (!silent) {
                Object patt17415$temp;
                Object patt15656$temp = o.value();
                if (patt15656$temp instanceof HashMap) {
                    HashMap mapValue = (HashMap)patt15656$temp;
                    HashMap maskedValue = new HashMap();
                    mapValue.keySet().stream().filter(k -> k instanceof String).map(k -> (String)k).forEach(k -> {
                        if (k.contains("password") || k.contains("pwd") || k.contains("secret") || k.contains("key")) {
                            maskedValue.put(k, MASK);
                        } else if (k.contains("connection-string")) {
                            try {
                                String svalue = mapValue.get(k).toString();
                                ConnectionString cs = new ConnectionString(svalue);
                                char[] _pwd = cs.getPassword();
                                if (_pwd != null) {
                                    String pwd = new String(_pwd);
                                    maskedValue.put(k, svalue.replaceFirst(pwd, MASK));
                                }
                            }
                            catch (Throwable t) {
                                maskedValue.put(k, mapValue);
                            }
                        }
                    });
                    LOGGER.info(LOG_PATTERN, (Object)o.path(), maskedValue);
                } else if (o.path().contains("password") || o.path().contains("pwd") || o.path().contains("secret") || o.path().contains("key")) {
                    LOGGER.info(LOG_PATTERN, (Object)o.path(), (Object)MASK);
                } else if (o.path().endsWith("connection-string") && (patt17415$temp = o.value()) instanceof String) {
                    String svalue = (String)patt17415$temp;
                    try {
                        ConnectionString cs = new ConnectionString(svalue);
                        char[] _pwd = cs.getPassword();
                        if (_pwd != null) {
                            String pwd = new String(_pwd);
                            LOGGER.info(LOG_PATTERN, (Object)o.path(), (Object)svalue.replaceFirst(pwd, MASK));
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.info(LOG_PATTERN, (Object)o.path(), o.value());
                    }
                } else {
                    LOGGER.info(LOG_PATTERN, (Object)o.path(), o.value());
                }
            }
            if (!o.path().startsWith("/")) {
                LOGGER.error("Wrong configuration override {}, path must start with /", (Object)o.raw());
            } else {
                try {
                    Configuration.createPathAndSetValue(ctx, o.path(), o.value());
                }
                catch (Throwable ise) {
                    LOGGER.error("Wrong configuration override {}, {}", (Object)o.raw(), (Object)ise.getMessage());
                }
            }
        });
        return confMap;
    }

    private static void createPathAndSetValue(JXPathContext ctx, String path, Object value) {
        Configuration.createParents(ctx, path);
        ctx.createPathAndSetValue(path, value);
    }

    private static void createParents(JXPathContext ctx, String path) {
        boolean array;
        String parentPath = path.substring(0, path.lastIndexOf("/"));
        if (!parentPath.equals("")) {
            Configuration.createParents(ctx, parentPath);
        }
        if (array = path.strip().endsWith("]")) {
            String arrayPath = path.substring(0, path.lastIndexOf("["));
            if (ctx.getValue(arrayPath) == null) {
                ctx.createPathAndSetValue(arrayPath, new ArrayList());
            }
        } else if (ctx.getValue(path) == null) {
            ctx.createPathAndSetValue(path, (Object)Maps.newLinkedHashMap());
        }
    }

    public class Builder {
        private Builder() {
        }

        public static Configuration build(boolean standaloneConfiguration, boolean silent) {
            return Builder.build(null, null, standaloneConfiguration, silent);
        }

        public static Configuration build(Path confFilePath, Path confOverridesFilePath, boolean standaloneConfiguration, boolean silent) throws ConfigurationException {
            Configuration configuration;
            if (confFilePath == null) {
                Configuration configuration2;
                String defaultConfFilePath = standaloneConfiguration ? "/restheart-default-config-no-mongodb.yml" : "/restheart-default-config.yml";
                InputStream stream = Configuration.class.getResourceAsStream(defaultConfFilePath);
                InputStreamReader confReader = new InputStreamReader(stream);
                try {
                    configuration2 = Builder.build(confReader, null, confOverridesFilePath, silent);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            confReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ieo) {
                        throw new ConfigurationException("Error reading default configuration file", ieo);
                    }
                }
                confReader.close();
                return configuration2;
            }
            BufferedReader confReader = new BufferedReader(new FileReader(confFilePath.toFile()));
            try {
                configuration = Builder.build(confReader, confFilePath, confOverridesFilePath, silent);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        confReader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException ex) {
                    throw new ConfigurationException("Configuration file not found: " + confFilePath, ex, false);
                }
                catch (IOException ieo) {
                    throw new ConfigurationException("Error reading configuration file " + confFilePath, ieo);
                }
            }
            confReader.close();
            return configuration;
        }

        private static Configuration build(Reader confReader, Path confFilePath, Path confOverridesFilePath, boolean silent) throws ConfigurationException {
            Map<String, Object> confMap = (Map<String, Object>)new Yaml((BaseConstructor)new SafeConstructor(new LoaderOptions())).load(confReader);
            if (confOverridesFilePath != null) {
                try {
                    String overrides;
                    if (confOverridesFilePath.toString().toLowerCase().endsWith(".yml") || confOverridesFilePath.toString().toLowerCase().endsWith(".yaml")) {
                        try {
                            overrides = Configuration.fromYmlToRho(Files.newBufferedReader(confOverridesFilePath));
                        }
                        catch (JsonParseException jpe) {
                            throw new ConfigurationException("Wrong configuration override YML file: " + jpe.getLocalizedMessage(), jpe, false);
                        }
                    } else if (confOverridesFilePath.toString().toLowerCase().endsWith(".json") || confOverridesFilePath.toString().toLowerCase().endsWith(".jsonc")) {
                        try {
                            overrides = Configuration.fromJsonToRho(Files.newBufferedReader(confOverridesFilePath));
                        }
                        catch (JsonParseException jpe) {
                            throw new ConfigurationException("Wrong configuration override JSON file: " + jpe.getLocalizedMessage(), jpe, false);
                        }
                    } else if (confOverridesFilePath.toString().toLowerCase().endsWith(".conf")) {
                        overrides = Files.readAllLines(confOverridesFilePath).stream().filter(row -> !row.strip().startsWith("#")).collect(Collectors.joining());
                    } else {
                        throw new ConfigurationException("Configuration override file must have .json, .jsonc, .yml, .yaml or .conf extension: " + confOverridesFilePath);
                    }
                    if (!silent) {
                        LOGGER.info("Overriding configuration from file: {}", (Object)confOverridesFilePath);
                    }
                    confMap = Configuration.overrideConfiguration(confMap, Utils.overrides(overrides, true, silent), silent);
                }
                catch (IOException ioe) {
                    throw new ConfigurationException("Configuration override file not found: " + confOverridesFilePath, ioe, false);
                }
            }
            if (System.getenv().containsKey("RHO")) {
                if (!silent) {
                    LOGGER.info("Overriding configuration from environment variable RHO");
                }
                confMap = Configuration.overrideConfiguration(confMap, Utils.overrides(System.getenv().get("RHO"), true, silent), silent);
            }
            return new Configuration(confMap, confFilePath, silent);
        }
    }
}

