/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.configuration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.restheart.configuration.Utils;

public record CoreModule(String name, String pluginsDirectory, List<String> pluginsPackages, boolean pluginsScanningVerbose, String baseUrl, int ioThreads, int workerThreads, int requestsLimit, int bufferSize, boolean directBuffers, boolean forceGzipEncoding, boolean allowUnescapedCharsInUrl) {
    public static final String CORE_KEY = "core";
    public static final String INSTANCE_NAME_KEY = "name";
    public static final String PLUGINS_DIRECTORY_PATH_KEY = "plugins-directory";
    public static final String PLUGINS_PACKAGES_KEY = "plugins-packages";
    public static final String PLUGINS_SCANNING_VERBOSE_KEY = "plugins-scanning-verbose";
    public static final String BASE_URL_KEY = "base-url";
    public static final String IO_THREADS_KEY = "io-threads";
    public static final String WORKER_THREADS_KEY = "worker-threads";
    public static final String REQUESTS_LIMIT_KEY = "requests-limit";
    public static final String BUFFER_SIZE_KEY = "buffer-size";
    public static final String DIRECT_BUFFERS_KEY = "direct-buffers";
    public static final String FORCE_GZIP_ENCODING_KEY = "force-gzip-encoding";
    public static final String ALLOW_UNESCAPED_CHARS_IN_ULR_KEY = "allow-unescaped-characters-in-url";
    private static final CoreModule DEFAULT_CORE_MODULE = new CoreModule("default", "plugins", new ArrayList<String>(), false, null, 0, -1, 1000, 16364, true, false, true);

    public CoreModule(Map<String, Object> conf, boolean silent) {
        this(Utils.getOrDefault(conf, INSTANCE_NAME_KEY, DEFAULT_CORE_MODULE.name(), silent), Utils.getOrDefault(conf, PLUGINS_DIRECTORY_PATH_KEY, DEFAULT_CORE_MODULE.pluginsDirectory(), silent), Utils.getOrDefault(conf, PLUGINS_PACKAGES_KEY, DEFAULT_CORE_MODULE.pluginsPackages(), true), Utils.getOrDefault(conf, PLUGINS_SCANNING_VERBOSE_KEY, Boolean.valueOf(false), true), Utils.getOrDefault(conf, BASE_URL_KEY, DEFAULT_CORE_MODULE.baseUrl(), true), Utils.getOrDefault(conf, IO_THREADS_KEY, Integer.valueOf(DEFAULT_CORE_MODULE.ioThreads()), silent), Utils.getOrDefault(conf, WORKER_THREADS_KEY, Integer.valueOf(DEFAULT_CORE_MODULE.workerThreads()), silent), Utils.getOrDefault(conf, REQUESTS_LIMIT_KEY, Integer.valueOf(DEFAULT_CORE_MODULE.requestsLimit()), silent), Utils.getOrDefault(conf, BUFFER_SIZE_KEY, Integer.valueOf(DEFAULT_CORE_MODULE.bufferSize()), silent), Utils.getOrDefault(conf, DIRECT_BUFFERS_KEY, Boolean.valueOf(DEFAULT_CORE_MODULE.directBuffers()), silent), Utils.getOrDefault(conf, FORCE_GZIP_ENCODING_KEY, Boolean.valueOf(DEFAULT_CORE_MODULE.forceGzipEncoding()), true), Utils.getOrDefault(conf, ALLOW_UNESCAPED_CHARS_IN_ULR_KEY, Boolean.valueOf(DEFAULT_CORE_MODULE.allowUnescapedCharsInUrl()), true));
    }

    public static CoreModule build(Map<String, Object> conf, boolean silent) {
        Map<String, Object> core = Utils.asMap(conf, CORE_KEY, null, silent);
        if (core != null) {
            return new CoreModule(core, silent);
        }
        return DEFAULT_CORE_MODULE;
    }
}

